/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.exportimport.data.handler;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerChoice;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.exportimport.data.handler.JournalArticleStagedModelDataHandler;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFeed;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalFeedLocalService;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.util.JournalContent;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet"}, service={PortletDataHandler.class})
public class JournalPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "journal";
    public static final String SCHEMA_VERSION = "1.0.2";
    private static final Log _log = LogFactoryUtil.getLog(JournalPortletDataHandler.class);
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMTemplateLocalService _ddmTemplateLocalService;
    private JournalArticleLocalService _journalArticleLocalService;
    private JournalArticleStagedModelDataHandler _journalArticleStagedModelDataHandler;
    private JournalContent _journalContent;
    private JournalFeedLocalService _journalFeedLocalService;
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference
    private Portal _portal;

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public String getServiceName() {
        return "com.liferay.journal";
    }

    public boolean isPublishToLiveByDefault() {
        try {
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)CompanyThreadLocal.getCompanyId());
            return journalServiceConfiguration.publishToLiveByDefaultEnabled();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return true;
        }
    }

    public boolean isSupportsDataStrategyMirrorWithOverwriting() {
        return false;
    }

    @Activate
    protected void activate() {
        this.setDataLocalized(true);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(DDMStructure.class, JournalArticle.class), new StagedModelType(DDMTemplate.class, DDMStructure.class), new StagedModelType(JournalArticle.class), new StagedModelType(JournalArticle.class, DDMStructure.class), new StagedModelType(JournalFeed.class), new StagedModelType(JournalFolder.class)});
        String[] referencedContentBehaviorOptions = new String[]{"include-always", "include-if-modified"};
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "web-content", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "referenced-content", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerChoice(NAMESPACE, "referenced-content-behavior", 1, referencedContentBehaviorOptions)}), new PortletDataHandlerBoolean(NAMESPACE, "version-history", this._isVersionHistoryByDefaultEnabled())}, JournalArticle.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "structures", true, false, null, DDMStructure.class.getName(), JournalArticle.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "templates", true, false, null, DDMTemplate.class.getName(), DDMStructure.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "feeds", true, false, null, JournalFeed.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "folders", true, false, null, JournalFolder.class.getName())});
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(JournalPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        this._journalArticleLocalService.deleteArticles(portletDataContext.getScopeGroupId());
        this._journalFolderLocalService.deleteFolders(portletDataContext.getGroupId());
        this._ddmTemplateLocalService.deleteTemplates(portletDataContext.getScopeGroupId(), this._portal.getClassNameId(DDMStructure.class));
        this._ddmStructureLocalService.deleteStructures(portletDataContext.getScopeGroupId(), this._portal.getClassNameId(JournalArticle.class));
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortletPermissions("com.liferay.journal");
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        if (this.isPortletDataAll(portletDataContext) || portletDataContext.getBooleanParameter(NAMESPACE, "feeds")) {
            ExportActionableDynamicQuery feedActionableDynamicQuery = this._journalFeedLocalService.getExportActionableDynamicQuery(portletDataContext);
            feedActionableDynamicQuery.performActions();
        }
        if (this.isPortletDataAll(portletDataContext) || portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            ExportActionableDynamicQuery folderActionableDynamicQuery = this._journalFolderLocalService.getExportActionableDynamicQuery(portletDataContext);
            folderActionableDynamicQuery.performActions();
        }
        if (this.isPortletDataAll(portletDataContext) || portletDataContext.getBooleanParameter(NAMESPACE, "structures")) {
            ActionableDynamicQuery ddmStructureActionableDynamicQuery = this.getDDMStructureActionableDynamicQuery(portletDataContext);
            ddmStructureActionableDynamicQuery.performActions();
            ActionableDynamicQuery ddmStructureDefaultValueActionableDynamicQuery = this.getDDMStructureDefaultValuesActionableDynamicQuery(portletDataContext);
            ddmStructureDefaultValueActionableDynamicQuery.performActions();
        }
        if (this.isPortletDataAll(portletDataContext) || portletDataContext.getBooleanParameter(NAMESPACE, "templates")) {
            ActionableDynamicQuery ddmTemplateActionableDynamicQuery = this.getDDMTemplateActionableDynamicQuery(portletDataContext);
            ddmTemplateActionableDynamicQuery.performActions();
        }
        if (this.isPortletDataAll(portletDataContext) || portletDataContext.getBooleanParameter(NAMESPACE, "web-content")) {
            ActionableDynamicQuery articleActionableDynamicQuery = this.getArticleActionableDynamicQuery(portletDataContext);
            articleActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.journal");
        if (this.isPortletDataAll(portletDataContext) || portletDataContext.getBooleanParameter(NAMESPACE, "feeds")) {
            Element feedsElement = portletDataContext.getImportDataGroupElement(JournalFeed.class);
            List feedElements = feedsElement.elements();
            for (Element feedElement : feedElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)feedElement);
            }
        }
        if (this.isPortletDataAll(portletDataContext) || portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            Element foldersElement = portletDataContext.getImportDataGroupElement(JournalFolder.class);
            List folderElements = foldersElement.elements();
            for (Element folderElement : folderElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)folderElement);
            }
        }
        Element articlesElement = portletDataContext.getImportDataGroupElement(JournalArticle.class);
        List articleElements = articlesElement.elements();
        if (this.isPortletDataAll(portletDataContext) || portletDataContext.getBooleanParameter(NAMESPACE, "structures")) {
            Element ddmStructuresElement = portletDataContext.getImportDataGroupElement(DDMStructure.class);
            List ddmStructureElements = ddmStructuresElement.elements();
            for (Element ddmStructureElement : ddmStructureElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmStructureElement);
            }
            for (Element articleElement : articleElements) {
                String className = articleElement.attributeValue("class-name");
                if (!Validator.isNotNull((String)className) || !className.equals(DDMStructure.class.getName())) continue;
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)articleElement);
            }
        }
        if (this.isPortletDataAll(portletDataContext) || portletDataContext.getBooleanParameter(NAMESPACE, "templates")) {
            Element ddmTemplatesElement = portletDataContext.getImportDataGroupElement(DDMTemplate.class);
            List ddmTemplateElements = ddmTemplatesElement.elements();
            for (Element ddmTemplateElement : ddmTemplateElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmTemplateElement);
            }
        }
        if (this.isPortletDataAll(portletDataContext) || portletDataContext.getBooleanParameter(NAMESPACE, "web-content")) {
            for (Element articleElement : articleElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)articleElement);
            }
            this._journalContent.clearCache();
        }
        return portletPreferences;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ActionableDynamicQuery articleActionableDynamicQuery = this.getArticleActionableDynamicQuery(portletDataContext);
        articleActionableDynamicQuery.performCount();
        ActionableDynamicQuery ddmStructureActionableDynamicQuery = this.getDDMStructureActionableDynamicQuery(portletDataContext);
        ddmStructureActionableDynamicQuery.performCount();
        ActionableDynamicQuery ddmTemplateActionableDynamicQuery = this.getDDMTemplateActionableDynamicQuery(portletDataContext);
        ddmTemplateActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery feedActionableDynamicQuery = this._journalFeedLocalService.getExportActionableDynamicQuery(portletDataContext);
        feedActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery folderActionableDynamicQuery = this._journalFolderLocalService.getExportActionableDynamicQuery(portletDataContext);
        folderActionableDynamicQuery.performCount();
    }

    protected ActionableDynamicQuery getArticleActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._journalArticleLocalService.getExportActionableDynamicQuery(portletDataContext);
        final ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                addCriteriaMethod.addCriteria(dynamicQuery);
                if (portletDataContext.getBooleanParameter(JournalPortletDataHandler.NAMESPACE, "version-history")) {
                    return;
                }
                Class<?> clazz = this.getClass();
                DynamicQuery versionArticleDynamicQuery = DynamicQueryFactoryUtil.forClass(JournalArticle.class, (String)"versionArticle", (ClassLoader)clazz.getClassLoader());
                versionArticleDynamicQuery.setProjection(ProjectionFactoryUtil.alias((Projection)ProjectionFactoryUtil.max((String)"versionArticle.version"), (String)"versionArticle.version"));
                versionArticleDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"this.resourcePrimKey", (String)"versionArticle.resourcePrimKey"));
                Property workflowStatusProperty = PropertyFactoryUtil.forName((String)"status");
                versionArticleDynamicQuery.add(workflowStatusProperty.in(JournalPortletDataHandler.this._journalArticleStagedModelDataHandler.getExportableStatuses()));
                Property versionProperty = PropertyFactoryUtil.forName((String)"version");
                dynamicQuery.add(versionProperty.eq(versionArticleDynamicQuery));
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(JournalArticle.class.getName()));
        return exportActionableDynamicQuery;
    }

    protected ActionableDynamicQuery getDDMStructureActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._ddmStructureLocalService.getExportActionableDynamicQuery(portletDataContext);
        final ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                addCriteriaMethod.addCriteria(dynamicQuery);
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                long classNameId = JournalPortletDataHandler.this._portal.getClassNameId(JournalArticle.class);
                dynamicQuery.add(classNameIdProperty.eq((Object)classNameId));
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(DDMStructure.class.getName(), JournalArticle.class.getName()));
        return exportActionableDynamicQuery;
    }

    protected ActionableDynamicQuery getDDMStructureDefaultValuesActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._journalArticleLocalService.getExportActionableDynamicQuery(portletDataContext);
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(JournalArticle.class.getName(), DDMStructure.class.getName()));
        return exportActionableDynamicQuery;
    }

    protected ActionableDynamicQuery getDDMTemplateActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._ddmTemplateLocalService.getExportActionableDynamicQuery(portletDataContext);
        final ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                addCriteriaMethod.addCriteria(dynamicQuery);
                Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
                Property classPKProperty = PropertyFactoryUtil.forName((String)"classPK");
                disjunction.add(classPKProperty.eq((Object)0L));
                DynamicQuery ddmStructureDynamicQuery = JournalPortletDataHandler.this._ddmStructureLocalService.dynamicQuery();
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                long ddmStructureClassNameId = JournalPortletDataHandler.this._portal.getClassNameId(DDMStructure.class);
                dynamicQuery.add(classNameIdProperty.eq((Object)ddmStructureClassNameId));
                long articleClassNameId = JournalPortletDataHandler.this._portal.getClassNameId(JournalArticle.class);
                ddmStructureDynamicQuery.add(classNameIdProperty.eq((Object)articleClassNameId));
                ddmStructureDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"structureId"));
                disjunction.add(classPKProperty.in(ddmStructureDynamicQuery));
                dynamicQuery.add((Criterion)disjunction);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(DDMTemplate.class.getName(), DDMStructure.class.getName()));
        return exportActionableDynamicQuery;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleStagedModelDataHandler(JournalArticleStagedModelDataHandler journalArticleStagedModelDataHandler) {
        this._journalArticleStagedModelDataHandler = journalArticleStagedModelDataHandler;
    }

    @Reference(unbind="-")
    protected void setJournalContent(JournalContent journalContent) {
        this._journalContent = journalContent;
    }

    @Reference(unbind="-")
    protected void setJournalFeedLocalService(JournalFeedLocalService journalFeedLocalService) {
        this._journalFeedLocalService = journalFeedLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalFolderLocalService(JournalFolderLocalService journalFolderLocalService) {
        this._journalFolderLocalService = journalFolderLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    private boolean _isVersionHistoryByDefaultEnabled() {
        try {
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)CompanyThreadLocal.getCompanyId());
            return journalServiceConfiguration.versionHistoryByDefaultEnabled();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return true;
        }
    }
}

