/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.content.processor;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.content.processor.base.BaseTextExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.portal.kernel.exception.BulkException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={ExportImportContentProcessor.class, JournalArticleExportImportContentProcessor.class})
public class JournalArticleExportImportContentProcessor
extends BaseTextExportImportContentProcessor {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleExportImportContentProcessor.class);
    private static final Pattern _htmlCommentRegexPattern = Pattern.compile("\\<!--([\\s\\S]*)--\\>");
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        if (Validator.isXml((String)content)) {
            content = this.replaceExportJournalArticleReferences(portletDataContext, stagedModel, content, exportReferencedContent);
        }
        return super.replaceExportContentReferences(portletDataContext, stagedModel, content, exportReferencedContent, escapeContent);
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        content = this.replaceImportJournalArticleReferences(portletDataContext, stagedModel, content);
        if (Validator.isXml((String)(content = super.replaceImportContentReferences(portletDataContext, stagedModel, content)))) {
            content = this.replaceImportImageFileEntryIds(portletDataContext, content);
        }
        return content;
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        content = this._excludeHTMLComments(content);
        this.validateJournalArticleReferences(groupId, content);
        try {
            super.validateContentReferences(groupId, content);
        }
        catch (NoSuchFileEntryException | NoSuchLayoutException e) {
            if (ExportImportThreadLocal.isImportInProcess()) {
                if (_log.isDebugEnabled()) {
                    StringBundler sb = new StringBundler(8);
                    sb.append("An invalid ");
                    String type = "page";
                    if (e instanceof NoSuchFileEntryException) {
                        type = "file entry";
                    }
                    sb.append(type);
                    sb.append(" was detected during import when validating ");
                    sb.append("the content below. This is not an error; it ");
                    sb.append("typically means the ");
                    sb.append(type);
                    sb.append(" was deleted.\n");
                    sb.append(content);
                    _log.debug((Object)sb.toString());
                }
                return;
            }
            throw e;
        }
    }

    protected String replaceExportDLReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent) throws Exception {
        Group group = this._groupLocalService.getGroup(portletDataContext.getGroupId());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isStaged() && !group.isStagedRemotely() && !group.isStagedPortlet("com_liferay_document_library_web_portlet_DLPortlet") && ExportImportThreadLocal.isStagingInProcess()) {
            return content;
        }
        StringBuilder sb = new StringBuilder(content);
        String contextPath = this._portal.getPathContext();
        String[] patterns = new String[]{contextPath.concat("/c/document_library/get_file?"), contextPath.concat("/documents/"), contextPath.concat("/image/image_gallery?")};
        int beginPos = -1;
        int endPos = content.length();
        while ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) != -1) {
            block12: {
                Map dlReferenceParameters = this.getDLReferenceParameters(portletDataContext.getScopeGroupId(), content, beginPos + contextPath.length(), endPos);
                FileEntry fileEntry = this.getFileEntry(dlReferenceParameters);
                if (fileEntry == null) {
                    endPos = beginPos - 1;
                    continue;
                }
                endPos = MapUtil.getInteger((Map)dlReferenceParameters, (String)"endPos");
                try {
                    if (this._isAlwaysIncludeReference(portletDataContext, (StagedModel)fileEntry) && exportReferencedContent && !fileEntry.isInTrash()) {
                        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)fileEntry, (String)"dependency");
                    } else {
                        Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
                        String referenceType = "dependency";
                        if (fileEntry.isInTrash()) {
                            referenceType = "disposable_dependency";
                        }
                        portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)fileEntry, referenceType, true);
                    }
                    String path = ExportImportPathUtil.getModelPath((StagedModel)fileEntry);
                    StringBundler exportedReferenceSB = new StringBundler(6);
                    exportedReferenceSB.append("[$dl-reference=");
                    exportedReferenceSB.append(path);
                    exportedReferenceSB.append("$]");
                    if (fileEntry.isInTrash()) {
                        String originalReference = sb.substring(beginPos, endPos);
                        exportedReferenceSB.append("[#dl-reference=");
                        exportedReferenceSB.append(originalReference);
                        exportedReferenceSB.append("#]");
                    }
                    sb.replace(beginPos, endPos, exportedReferenceSB.toString());
                    int deleteTimestampParametersOffset = beginPos;
                    if (fileEntry.isInTrash()) {
                        deleteTimestampParametersOffset = sb.indexOf("[#dl-reference=", beginPos);
                    }
                    this.deleteTimestampParameters(sb, deleteTimestampParametersOffset);
                }
                catch (Exception e) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)e, (Throwable)e);
                    }
                    if (!_log.isWarnEnabled()) break block12;
                    StringBundler exceptionSB = new StringBundler(6);
                    exceptionSB.append("Unable to process file entry ");
                    exceptionSB.append(fileEntry.getFileEntryId());
                    exceptionSB.append(" for staged model ");
                    exceptionSB.append(stagedModel.getModelClassName());
                    exceptionSB.append(" with primary key ");
                    exceptionSB.append((Object)stagedModel.getPrimaryKeyObj());
                    _log.warn((Object)exceptionSB.toString());
                }
            }
            endPos = beginPos - 1;
        }
        return sb.toString();
    }

    protected String replaceExportJournalArticleReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent) throws Exception {
        Group group = this._groupLocalService.fetchGroup(portletDataContext.getGroupId());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isStaged() && !group.isStagedRemotely() && !group.isStagedPortlet("com_liferay_journal_web_portlet_JournalPortlet")) {
            return content;
        }
        Document document = SAXReaderUtil.read((String)content);
        XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='ddm-journal-article']");
        List ddmJournalArticleNodes = xPath.selectNodes((Object)document);
        for (Node ddmJournalArticleNode : ddmJournalArticleNodes) {
            Element ddmJournalArticleElement = (Element)ddmJournalArticleNode;
            List dynamicContentElements = ddmJournalArticleElement.elements("dynamic-content");
            for (Element dynamicContentElement : dynamicContentElements) {
                String jsonData = dynamicContentElement.getStringValue();
                if (jsonData.equals("")) continue;
                JSONObject jsonObject = this._jsonFactory.createJSONObject(jsonData);
                long classPK = GetterUtil.getLong((Object)jsonObject.get("classPK"));
                JournalArticle journalArticle = this._journalArticleLocalService.fetchLatestArticle(classPK);
                if (journalArticle == null) {
                    if (!_log.isInfoEnabled()) continue;
                    StringBundler messageSB = new StringBundler(7);
                    messageSB.append("Staged model with class name ");
                    messageSB.append(stagedModel.getModelClassName());
                    messageSB.append(" and primary key ");
                    messageSB.append((Object)stagedModel.getPrimaryKeyObj());
                    messageSB.append(" references missing journal ");
                    messageSB.append("article with class primary key ");
                    messageSB.append(classPK);
                    _log.info((Object)messageSB.toString());
                    continue;
                }
                String journalArticleReference = "[$journal-article-reference=" + journalArticle.getPrimaryKey() + "$]";
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Replacing ", jsonData, " with ", journalArticleReference}));
                }
                dynamicContentElement.clearContent();
                dynamicContentElement.addCDATA(journalArticleReference);
                if (exportReferencedContent) {
                    try {
                        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)journalArticle, (String)"dependency");
                    }
                    catch (Exception e) {
                        if (!_log.isDebugEnabled()) continue;
                        StringBundler messageSB = new StringBundler(10);
                        messageSB.append("Staged model with class name ");
                        messageSB.append(stagedModel.getModelClassName());
                        messageSB.append(" and primary key ");
                        messageSB.append((Object)stagedModel.getPrimaryKeyObj());
                        messageSB.append(" references journal article ");
                        messageSB.append("with class primary key ");
                        messageSB.append(classPK);
                        messageSB.append(" that could not be exported ");
                        messageSB.append("due to ");
                        messageSB.append((Object)e);
                        String errorMessage = messageSB.toString();
                        if (Validator.isNotNull((String)e.getMessage())) {
                            errorMessage = StringBundler.concat((String[])new String[]{errorMessage, ": ", e.getMessage()});
                        }
                        _log.debug((Object)errorMessage, (Throwable)e);
                    }
                    continue;
                }
                Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
                portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)journalArticle, "dependency", true);
            }
        }
        return document.asXML();
    }

    protected String replaceImportImageFileEntryIds(PortletDataContext portletDataContext, String content) throws Exception {
        Map dlFileEntryIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntry.class);
        if (MapUtil.isNotEmpty((Map)dlFileEntryIds)) {
            Document contentDocument = SAXReaderUtil.read((String)content);
            contentDocument = contentDocument.clone();
            for (Map.Entry entry : dlFileEntryIds.entrySet()) {
                StringBuffer sb = new StringBuffer(4);
                sb.append("//dynamic-element[@type='image']");
                sb.append("/dynamic-content[@fileEntryId='");
                sb.append(entry.getKey());
                sb.append("']");
                XPath xPath = SAXReaderUtil.createXPath((String)sb.toString());
                List imageNodes = xPath.selectNodes((Object)contentDocument);
                for (Node imageNode : imageNodes) {
                    Element imageElement = (Element)imageNode;
                    List attributes = imageElement.attributes();
                    for (Attribute attribute : attributes) {
                        if (!StringUtil.equals((String)attribute.getName(), (String)"fileEntryId")) continue;
                        attribute.setValue(String.valueOf(entry.getValue()));
                    }
                }
            }
            content = contentDocument.formattedString();
        }
        return content;
    }

    protected String replaceImportJournalArticleReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        List referenceElements = portletDataContext.getReferenceElements(stagedModel, JournalArticle.class);
        for (Element referenceElement : referenceElements) {
            long classPK = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
            Map articlePrimaryKeys = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".primaryKey");
            long articlePrimaryKey = MapUtil.getLong((Map)articlePrimaryKeys, (long)classPK, (long)classPK);
            JournalArticle journalArticle = this._journalArticleLocalService.fetchJournalArticle(articlePrimaryKey);
            if (journalArticle == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to get journal article with primary key " + articlePrimaryKey));
                }
                throw new NoSuchArticleException("No JournalArticle exists with the key {id= " + articlePrimaryKey + "}");
            }
            String journalArticleReference = "[$journal-article-reference=" + classPK + "$]";
            JSONObject jsonObject = this._jsonFactory.createJSONObject();
            jsonObject.put("className", JournalArticle.class.getName());
            jsonObject.put("classPK", journalArticle.getResourcePrimKey());
            jsonObject.put("title", journalArticle.getTitle(journalArticle.getDefaultLanguageId()));
            jsonObject.put("titleMap", (Object)journalArticle.getTitleMap());
            content = StringUtil.replace((String)content, (String)journalArticleReference, (String)jsonObject.toString());
        }
        return content;
    }

    protected void validateJournalArticleReferences(long groupId, String content) throws PortalException {
        ArrayList<NoSuchArticleException> throwables;
        block10: {
            throwables = new ArrayList<NoSuchArticleException>();
            try {
                Document document = SAXReaderUtil.read((String)content);
                XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='ddm-journal-article']");
                List ddmJournalArticleNodes = xPath.selectNodes((Object)document);
                for (Node ddmJournalArticleNode : ddmJournalArticleNodes) {
                    Element ddmJournalArticleElement = (Element)ddmJournalArticleNode;
                    List dynamicContentElements = ddmJournalArticleElement.elements("dynamic-content");
                    for (Element dynamicContentElement : dynamicContentElements) {
                        long classPK;
                        JournalArticle journalArticle;
                        String json = dynamicContentElement.getStringValue();
                        if (Validator.isNull((String)json)) {
                            if (!_log.isDebugEnabled()) continue;
                            _log.debug((Object)"No journal article reference is specified");
                            continue;
                        }
                        JSONObject jsonObject = null;
                        try {
                            jsonObject = this._jsonFactory.createJSONObject(json);
                        }
                        catch (JSONException jsone) {
                            _log.debug((Object)jsone, (Throwable)jsone);
                            continue;
                        }
                        if (!jsonObject.has("classPK") || (journalArticle = this._journalArticleLocalService.fetchLatestArticle(classPK = GetterUtil.getLong((Object)jsonObject.get("classPK")))) != null) continue;
                        if (ExportImportThreadLocal.isImportInProcess()) {
                            if (_log.isDebugEnabled()) {
                                StringBundler sb = new StringBundler(7);
                                sb.append("An invalid web content article ");
                                sb.append("was detected during import when ");
                                sb.append("validating the content below. ");
                                sb.append("This is not an error; it ");
                                sb.append("typically means the web content ");
                                sb.append("article was deleted.\n");
                                sb.append(content);
                                _log.debug((Object)sb.toString());
                            }
                            return;
                        }
                        NoSuchArticleException throwable = new NoSuchArticleException(StringBundler.concat((String[])new String[]{"No JournalArticle exists with the key ", "{resourcePrimKey=", String.valueOf(classPK), "}"}));
                        throwables.add(throwable);
                    }
                }
            }
            catch (DocumentException de) {
                if (!_log.isDebugEnabled()) break block10;
                _log.debug((Object)("Invalid content:\n" + content));
            }
        }
        if (!throwables.isEmpty()) {
            throw new PortalException((Throwable)new BulkException("Unable to validate journal article references", throwables));
        }
    }

    private String _excludeHTMLComments(String content) {
        Matcher matcher = _htmlCommentRegexPattern.matcher(content);
        while (matcher.find()) {
            content = matcher.replaceAll("");
            matcher = _htmlCommentRegexPattern.matcher(content);
        }
        return content;
    }

    private boolean _isAlwaysIncludeReference(PortletDataContext portletDataContext, StagedModel referenceStagedModel) {
        Map parameterMap = portletDataContext.getParameterMap();
        Object[] referencedContentBehaviorArray = (String[])parameterMap.get(PortletDataHandlerControl.getNamespacedControlName((String)"journal", (String)"referenced-content-behavior"));
        Object referencedContentBehavior = "include-if-modified";
        if (!ArrayUtil.isEmpty((Object[])referencedContentBehaviorArray)) {
            referencedContentBehavior = referencedContentBehaviorArray[0];
        }
        return ((String)referencedContentBehavior).equals("include-always") || ((String)referencedContentBehavior).equals("include-if-modified") && portletDataContext.isWithinDateRange(referenceStagedModel.getModifiedDate());
    }
}

