/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.servlet.filter;

import com.liferay.journal.model.JournalArticleImage;
import com.liferay.journal.service.JournalArticleImageLocalService;
import com.liferay.journal.service.permission.JournalArticlePermission;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"servlet-context-name=", "servlet-filter-name=Journal Article Image Filter", "url-pattern=/image/journal/article/*"}, service={Filter.class})
public class JournalArticleImageFilter
extends BaseFilter {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleImageFilter.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private Http _http;
    @Reference
    private JournalArticleImageLocalService _journalArticleImageLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    protected Log getLog() {
        return _log;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        JournalArticleImage journalArticleImage;
        long imageId = ParamUtil.getLong((HttpServletRequest)request, (String)"img_id");
        if (imageId > 0L && (journalArticleImage = this._journalArticleImageLocalService.fetchJournalArticleImage(imageId)) != null) {
            User user = this._getUser(request);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            try {
                JournalArticlePermission.check(permissionChecker, journalArticleImage.getGroupId(), journalArticleImage.getArticleId(), "VIEW");
            }
            catch (PrincipalException pe) {
                this._processPrincipalException(pe, user, request, response);
                return;
            }
        }
        this.processFilter(JournalArticleImageFilter.class.getName(), request, response, filterChain);
    }

    private User _getUser(HttpServletRequest request) throws Exception {
        User user;
        HttpSession session = request.getSession();
        if (PortalSessionThreadLocal.getHttpSession() == null) {
            PortalSessionThreadLocal.setHttpSession((HttpSession)session);
        }
        if ((user = this._portal.getUser(request)) != null) {
            return user;
        }
        String userIdString = (String)session.getAttribute("j_username");
        String password = (String)session.getAttribute("j_password");
        if (userIdString != null && password != null) {
            long userId = GetterUtil.getLong((String)userIdString);
            user = this._userLocalService.getUser(userId);
        } else {
            long companyId = this._portal.getCompanyId(request);
            Company company = this._companyLocalService.getCompany(companyId);
            user = company.getDefaultUser();
        }
        return user;
    }

    private void _processPrincipalException(Throwable t, User user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!user.isDefaultUser()) {
            this._portal.sendError(401, (Exception)t, request, response);
            return;
        }
        String redirect = this._portal.getPathMain() + "/portal/login";
        String currentURL = this._portal.getCurrentURL(request);
        redirect = this._http.addParameter(redirect, "redirect", currentURL);
        response.sendRedirect(redirect);
    }
}

