/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v0_0_7;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class UpgradeJournalArticleDates
extends UpgradeProcess {
    private static final String _CLASS_NAME_JOURNAL_ARTICLE = "com.liferay.journal.model.JournalArticle";

    protected void doUpgrade() throws Exception {
        this._updateCreateDate();
        this._updateModifiedDate();
    }

    private void _updateCreateDate() throws SQLException {
        StringBundler sb = new StringBundler(3);
        sb.append("select resourcePrimKey, min(createDate) from ");
        sb.append("JournalArticle group by resourcePrimKey having count(*) > ");
        sb.append("1");
        try (Statement s = this.connection.createStatement();
             PreparedStatement ps = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set createDate = ? where resourcePrimKey = ?");
             ResultSet rs = s.executeQuery(sb.toString());){
            while (rs.next()) {
                long resourcePrimKey = rs.getLong(1);
                Timestamp createDate = rs.getTimestamp(2);
                ps.setTimestamp(1, createDate);
                ps.setLong(2, resourcePrimKey);
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    private void _updateModifiedDate() throws SQLException {
        StringBundler sb = new StringBundler(11);
        sb.append("select classPK, version, AssetEntry.modifiedDate from ");
        sb.append("AssetEntry, (select modifiedDate, ");
        sb.append("JournalArticle.resourcePrimKey, version from ");
        sb.append("JournalArticle, (select resourcePrimKey, max(version) as ");
        sb.append("maxVersion from JournalArticle where status = ? group by ");
        sb.append("resourcePrimKey) LatestVersion where ");
        sb.append("JournalArticle.resourcePrimKey = ");
        sb.append("LatestVersion.resourcePrimKey and version = maxVersion) ");
        sb.append("JournalArticle where classNameId = ? and classPK = ");
        sb.append("JournalArticle.resourcePrimKey and ");
        sb.append("AssetEntry.modifiedDate != JournalArticle.modifiedDate");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set modifiedDate = ? where resourcePrimKey = ? and version = ?");){
            ps1.setInt(1, 0);
            ps1.setLong(2, PortalUtil.getClassNameId((String)_CLASS_NAME_JOURNAL_ARTICLE));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long resourcePrimKey = rs.getLong(1);
                    Double latestVersion = rs.getDouble(2);
                    Timestamp assetModifiedDate = rs.getTimestamp(3);
                    ps2.setTimestamp(1, assetModifiedDate);
                    ps2.setLong(2, resourcePrimKey);
                    ps2.setDouble(3, latestVersion);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }
}

