/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.model.impl;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.model.impl.JournalArticleBaseImpl;
import com.liferay.journal.model.impl.JournalFolderImpl;
import com.liferay.journal.service.JournalArticleImageLocalServiceUtil;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.journal.service.JournalArticleResourceLocalServiceUtil;
import com.liferay.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.journal.transformer.JournalTransformerListenerRegistryUtil;
import com.liferay.journal.transformer.LocaleTransformerListener;
import com.liferay.journal.util.impl.JournalUtil;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;

public class JournalArticleImpl
extends JournalArticleBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleImpl.class);
    private String _defaultLanguageId;
    private Document _document;
    private String _smallImageType;

    public static String getContentByLocale(Document document, String languageId) {
        return JournalArticleImpl.getContentByLocale(document, languageId, null);
    }

    public static String getContentByLocale(Document document, String languageId, Map<String, String> tokens) {
        TransformerListener transformerListener = JournalTransformerListenerRegistryUtil.getTransformerListener(LocaleTransformerListener.class.getName());
        if (transformerListener != null) {
            document = transformerListener.onXml(document.clone(), languageId, tokens);
        }
        return document.asXML();
    }

    @Deprecated
    public static String getContentByLocale(String content, boolean templateDriven, String languageId) {
        try {
            return JournalArticleImpl.getContentByLocale(SAXReaderUtil.read((String)content), languageId);
        }
        catch (DocumentException de) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)de, (Throwable)de);
            }
            return content;
        }
    }

    public String buildTreePath() throws PortalException {
        if (this.getFolderId() == 0L) {
            return "/";
        }
        JournalFolder folder = this.getFolder();
        return folder.buildTreePath();
    }

    public long getArticleImageId(String elInstanceId, String elName, String languageId) {
        return JournalArticleImageLocalServiceUtil.getArticleImageId((long)this.getGroupId(), (String)this.getArticleId(), (double)this.getVersion(), (String)elInstanceId, (String)elName, (String)languageId);
    }

    public String getArticleImageURL(ThemeDisplay themeDisplay) {
        if (!this.isSmallImage()) {
            return null;
        }
        if (Validator.isNotNull((String)this.getSmallImageURL())) {
            return this.getSmallImageURL();
        }
        return StringBundler.concat((String[])new String[]{themeDisplay.getPathImage(), "/journal/article?img_id=", String.valueOf(this.getSmallImageId()), "&t=", WebServerServletTokenUtil.getToken((long)this.getSmallImageId())});
    }

    public JournalArticleResource getArticleResource() throws PortalException {
        return JournalArticleResourceLocalServiceUtil.getArticleResource((long)this.getResourcePrimKey());
    }

    public String getArticleResourceUuid() throws PortalException {
        JournalArticleResource articleResource = this.getArticleResource();
        return articleResource.getUuid();
    }

    @Override
    public String[] getAvailableLanguageIds() {
        TreeSet<String> availableLanguageIds = new TreeSet<String>();
        for (String availableLanguageId : super.getAvailableLanguageIds()) {
            availableLanguageIds.add(availableLanguageId);
        }
        Document document = this.getDocument();
        if (document != null) {
            for (String availableLanguageId : LocalizationUtil.getAvailableLanguageIds((Document)document)) {
                availableLanguageIds.add(availableLanguageId);
            }
        }
        return availableLanguageIds.toArray(new String[0]);
    }

    public String getContentByLocale(String languageId) {
        HashMap<String, String> tokens;
        block2: {
            tokens = new HashMap<String, String>();
            try {
                DDMStructure ddmStructure = this.getDDMStructure();
                tokens.put("ddm_structure_id", String.valueOf(ddmStructure.getStructureId()));
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        return JournalArticleImpl.getContentByLocale(this.getDocument(), languageId, tokens);
    }

    public DDMStructure getDDMStructure() throws PortalException {
        return DDMStructureLocalServiceUtil.fetchStructure((long)PortalUtil.getSiteGroupId((long)this.getGroupId()), (long)ClassNameLocalServiceUtil.getClassNameId(JournalArticle.class), (String)this.getDDMStructureKey(), (boolean)true);
    }

    public DDMTemplate getDDMTemplate() throws PortalException {
        return DDMTemplateLocalServiceUtil.fetchTemplate((long)PortalUtil.getSiteGroupId((long)this.getGroupId()), (long)ClassNameLocalServiceUtil.getClassNameId(JournalArticle.class), (String)this.getDDMTemplateKey(), (boolean)true);
    }

    @Override
    public String getDefaultLanguageId() {
        if (this._defaultLanguageId == null) {
            this._defaultLanguageId = super.getDefaultLanguageId();
            if (Validator.isNull((String)this._defaultLanguageId)) {
                this._defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            }
        }
        return this._defaultLanguageId;
    }

    @Override
    public Document getDocument() {
        block3: {
            if (this._document == null) {
                try {
                    this._document = SAXReaderUtil.read((String)this.getContent());
                }
                catch (DocumentException de) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)de, (Throwable)de);
                }
            }
        }
        return this._document;
    }

    public JournalFolder getFolder() throws PortalException {
        if (this.getFolderId() <= 0L) {
            return new JournalFolderImpl();
        }
        return JournalFolderLocalServiceUtil.getFolder((long)this.getFolderId());
    }

    public Layout getLayout() {
        String layoutUuid = this.getLayoutUuid();
        if (Validator.isNull((String)layoutUuid)) {
            return null;
        }
        return JournalUtil.getArticleLayout(layoutUuid, this.getGroupId());
    }

    public String getSmallImageType() throws PortalException {
        if (this._smallImageType == null && this.isSmallImage()) {
            Image smallImage = ImageLocalServiceUtil.getImage((long)this.getSmallImageId());
            this._smallImageType = smallImage.getType();
        }
        return this._smallImageType;
    }

    @Override
    public StagedModelType getStagedModelType() {
        return new StagedModelType(JournalArticle.class);
    }

    @Deprecated
    public String getStructureId() {
        return this.getDDMStructureKey();
    }

    @Deprecated
    public String getTemplateId() {
        return this.getDDMTemplateKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Locale, String> getTitleMap() {
        Locale defaultLocale = LocaleThreadLocal.getDefaultLocale();
        try {
            Locale articleDefaultLocale = LocaleUtil.fromLanguageId((String)this.getDefaultLanguageId());
            LocaleThreadLocal.setDefaultLocale((Locale)articleDefaultLocale);
            Map<Locale, String> map = super.getTitleMap();
            return map;
        }
        finally {
            LocaleThreadLocal.setDefaultLocale((Locale)defaultLocale);
        }
    }

    @Override
    public long getTrashEntryClassPK() {
        return this.getResourcePrimKey();
    }

    public boolean hasApprovedVersion() {
        JournalArticle article = JournalArticleLocalServiceUtil.fetchLatestArticle((long)this.getGroupId(), (String)this.getArticleId(), (int)0);
        return article != null;
    }

    @Deprecated
    public boolean isTemplateDriven() {
        return true;
    }

    @Override
    public void prepareLocalizedFieldsForImport(Locale defaultImportLocale) throws LocaleException {
        super.prepareLocalizedFieldsForImport(defaultImportLocale);
        String content = "";
        try {
            content = JournalUtil.prepareLocalizedContentForImport(this.getContent(), defaultImportLocale);
        }
        catch (Exception e) {
            throw new LocaleException(4, (Throwable)e);
        }
        this.setContent(content);
    }

    @Override
    public void setContent(String content) {
        super.setContent(content);
        this._document = null;
    }

    @Override
    public void setDefaultLanguageId(String defaultLanguageId) {
        this._defaultLanguageId = defaultLanguageId;
    }

    @Override
    public void setDocument(Document document) {
        this._document = document;
    }

    public void setSmallImageType(String smallImageType) {
        this._smallImageType = smallImageType;
    }

    @Deprecated
    public void setStructureId(String ddmStructureKey) {
        this.setDDMStructureKey(ddmStructureKey);
    }

    @Deprecated
    public void setTemplateId(String ddmTemplateKey) {
        this.setDDMTemplateKey(ddmTemplateKey);
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this._defaultLanguageId = null;
    }
}

