/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.search;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalContentSearch;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.service.JournalContentSearchLocalService;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.HitsOpenSearchImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.OpenSearch;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={OpenSearch.class})
public class JournalOpenSearchImpl
extends HitsOpenSearchImpl {
    public static final String TITLE = "Liferay Journal Search: ";
    private AssetEntryLocalService _assetEntryLocalService;
    private GroupLocalService _groupLocalService;
    private JournalArticleService _journalArticleService;
    private JournalContentSearchLocalService _journalContentSearchLocalService;
    private LayoutLocalService _layoutLocalService;
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public Indexer<JournalArticle> getIndexer() {
        return IndexerRegistryUtil.getIndexer(JournalArticle.class);
    }

    public String getSearchPath() {
        return "";
    }

    public String getTitle(String keywords) {
        return TITLE + keywords;
    }

    protected String getLayoutURL(ThemeDisplay themeDisplay, String articleId) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        List contentSearches = this._journalContentSearchLocalService.getArticleContentSearches(articleId);
        for (JournalContentSearch contentSearch : contentSearches) {
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)contentSearch.getGroupId(), (boolean)contentSearch.isPrivateLayout(), (long)contentSearch.getLayoutId(), (String)"VIEW") || contentSearch.isPrivateLayout() && !this._groupLocalService.hasUserGroup(themeDisplay.getUserId(), contentSearch.getGroupId())) continue;
            Layout hitLayout = this._layoutLocalService.getLayout(contentSearch.getGroupId(), contentSearch.isPrivateLayout(), contentSearch.getLayoutId());
            return this._portal.getLayoutURL(hitLayout, themeDisplay);
        }
        return null;
    }

    protected String getURL(ThemeDisplay themeDisplay, long groupId, Document result, PortletURL portletURL) throws Exception {
        String articleId = result.get("articleId");
        JournalArticle article = this._journalArticleService.getArticle(groupId, articleId);
        if (Validator.isNotNull((String)article.getLayoutUuid())) {
            String groupFriendlyURL = this._portal.getGroupFriendlyURL(this._layoutSetLocalService.getLayoutSet(article.getGroupId(), false), themeDisplay);
            return groupFriendlyURL.concat("/-/").concat(article.getUrlTitle());
        }
        Layout layout = themeDisplay.getLayout();
        List hitLayoutIds = this._journalContentSearchLocalService.getLayoutIds(layout.getGroupId(), layout.isPrivateLayout(), articleId);
        for (Long hitLayoutId : hitLayoutIds) {
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)hitLayoutId, (String)"VIEW")) continue;
            Layout hitLayout = this._layoutLocalService.getLayout(layout.getGroupId(), layout.isPrivateLayout(), hitLayoutId.longValue());
            return this._portal.getLayoutURL(hitLayout, themeDisplay);
        }
        String layoutURL = this.getLayoutURL(themeDisplay, articleId);
        if (layoutURL != null) {
            return layoutURL;
        }
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
        if (assetEntry == null) {
            return null;
        }
        portletURL.setParameter("assetEntryId", String.valueOf(assetEntry.getEntryId()));
        portletURL.setParameter("groupId", String.valueOf(groupId));
        portletURL.setParameter("articleId", articleId);
        return portletURL.toString();
    }

    @Reference(unbind="-")
    protected void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleService(JournalArticleService journalArticleService) {
        this._journalArticleService = journalArticleService;
    }

    @Reference(unbind="-")
    protected void setJournalContentSearchLocalService(JournalContentSearchLocalService journalContentSearchLocalService) {
        this._journalContentSearchLocalService = journalContentSearchLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetLocalService(LayoutSetLocalService layoutSetLocalService) {
        this._layoutSetLocalService = layoutSetLocalService;
    }
}

