/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.impl;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.exception.NoSuchTemplateException;
import com.liferay.dynamic.data.mapping.exception.StorageFieldNameException;
import com.liferay.dynamic.data.mapping.exception.StorageFieldRequiredException;
import com.liferay.dynamic.data.mapping.exception.StructureDefinitionException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMXML;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeUtil;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.content.processor.ExportImportContentProcessorRegistryUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.journal.configuration.JournalGroupServiceConfiguration;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.configuration.JournalServiceConfigurationValues;
import com.liferay.journal.exception.ArticleContentException;
import com.liferay.journal.exception.ArticleExpirationDateException;
import com.liferay.journal.exception.ArticleIdException;
import com.liferay.journal.exception.ArticleReviewDateException;
import com.liferay.journal.exception.ArticleSmallImageNameException;
import com.liferay.journal.exception.ArticleSmallImageSizeException;
import com.liferay.journal.exception.ArticleTitleException;
import com.liferay.journal.exception.ArticleVersionException;
import com.liferay.journal.exception.DuplicateArticleIdException;
import com.liferay.journal.exception.InvalidDDMStructureException;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.exception.RequiredArticleLocalizationException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleConstants;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.model.impl.JournalArticleDisplayImpl;
import com.liferay.journal.service.base.JournalArticleLocalServiceBaseImpl;
import com.liferay.journal.util.JournalConverter;
import com.liferay.journal.util.comparator.ArticleIDComparator;
import com.liferay.journal.util.comparator.ArticleVersionComparator;
import com.liferay.journal.util.impl.JournalUtil;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.comment.CommentManagerUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.diff.DiffHtmlUtil;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupSubscriptionCheckSubscriptionSender;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.exception.TrashEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.trash.kernel.model.TrashVersion;
import com.liferay.trash.kernel.util.TrashUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public class JournalArticleLocalServiceImpl
extends JournalArticleLocalServiceBaseImpl {
    @ServiceReference(type=ConfigurationProvider.class)
    protected ConfigurationProvider configurationProvider;
    @ServiceReference(type=DDMStorageLinkLocalService.class)
    protected DDMStorageLinkLocalService ddmStorageLinkLocalService;
    @ServiceReference(type=DDMStructureLocalService.class)
    protected DDMStructureLocalService ddmStructureLocalService;
    @ServiceReference(type=DDMTemplateLinkLocalService.class)
    protected DDMTemplateLinkLocalService ddmTemplateLinkLocalService;
    @ServiceReference(type=DDMTemplateLocalService.class)
    protected DDMTemplateLocalService ddmTemplateLocalService;
    @Deprecated
    @ServiceReference(type=DDMXML.class)
    protected DDMXML ddmXML;
    @ServiceReference(type=JournalConverter.class)
    protected JournalConverter journalConverter;
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleLocalServiceImpl.class);
    private Date _previousCheckDate;

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle addArticle(long userId, long groupId, long folderId, long classNameId, long classPK, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, boolean validateReferences, ServiceContext serviceContext) throws PortalException {
        return this.journalArticleLocalService.addArticle(userId, groupId, folderId, classNameId, classPK, articleId, autoArticleId, version, titleMap, descriptionMap, content, ddmStructureKey, ddmTemplateKey, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, smallImageFile, images, articleURL, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle addArticle(long userId, long groupId, long folderId, long classNameId, long classPK, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        boolean validate;
        User user = this.userLocalService.getUser(userId);
        articleId = StringUtil.toUpperCase((String)articleId.trim());
        Date displayDate = null;
        Date expirationDate = null;
        Date reviewDate = null;
        if (classNameId == 0L) {
            displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), null);
            if (!neverExpire) {
                expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), ArticleExpirationDateException.class);
            }
            if (!neverReview) {
                reviewDate = PortalUtil.getDate((int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (TimeZone)user.getTimeZone(), ArticleReviewDateException.class);
            }
        }
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Date now = new Date();
        boolean bl = validate = !ExportImportThreadLocal.isImportInProcess();
        if (validate) {
            this.validateDDMStructureId(groupId, folderId, ddmStructureKey);
        }
        if (autoArticleId) {
            articleId = String.valueOf(this.counterLocalService.increment());
        }
        if (validate) {
            this.validate(user.getCompanyId(), groupId, classNameId, articleId, autoArticleId, version, titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
            this.validateReferences(groupId, ddmStructureKey, ddmTemplateKey, layoutUuid, smallImage, smallImageURL, smallImageBytes, 0L, content);
        }
        serviceContext.setAttribute("articleId", (Serializable)((Object)articleId));
        long id = this.counterLocalService.increment();
        String articleResourceUuid = GetterUtil.getString((Object)serviceContext.getAttribute("articleResourceUuid"));
        long resourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(articleResourceUuid, groupId, articleId);
        JournalArticle article = this.journalArticlePersistence.create(id);
        Locale locale = this.getArticleDefaultLocale(content);
        String title = titleMap.get(locale);
        content = this.format(user, groupId, articleId, version, false, content, images);
        article.setUuid(serviceContext.getUuid());
        article.setResourcePrimKey(resourcePrimKey);
        article.setGroupId(groupId);
        article.setCompanyId(user.getCompanyId());
        article.setUserId(user.getUserId());
        article.setUserName(user.getFullName());
        article.setFolderId(folderId);
        article.setClassNameId(classNameId);
        article.setClassPK(classPK);
        article.setTreePath(article.buildTreePath());
        article.setArticleId(articleId);
        article.setVersion(version);
        article.setTitleMap(titleMap, locale);
        article.setUrlTitle(this.getUniqueUrlTitle(id, groupId, articleId, title, null, serviceContext));
        article.setDescriptionMap(descriptionMap, locale);
        article.setContent(content);
        article.setDDMStructureKey(ddmStructureKey);
        article.setDDMTemplateKey(ddmTemplateKey);
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        article.setSmallImageId(this.counterLocalService.increment());
        article.setSmallImageURL(smallImageURL);
        if (expirationDate == null || expirationDate.after(now)) {
            article.setStatus(2);
        } else {
            article.setStatus(3);
        }
        article.setStatusByUserId(userId);
        article.setStatusDate(serviceContext.getModifiedDate(now));
        article.setExpandoBridgeAttributes(serviceContext);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addArticleResources(article, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addArticleResources(article, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        this.saveImages(smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        if (this.classNameLocalService.getClassNameId(DDMStructure.class) == classNameId) {
            this.updateDDMStructurePredefinedValues(classPK, content, serviceContext);
        } else {
            this.updateDDMLinks(id, groupId, ddmStructureKey, ddmTemplateKey, true);
        }
        articleURL = this.buildArticleURL(articleURL, groupId, folderId, articleId);
        serviceContext.setAttribute("articleURL", (Serializable)((Object)articleURL));
        this.sendEmail(article, articleURL, "requested", serviceContext);
        if (classNameId == 0L) {
            this.startWorkflowInstance(userId, article, serviceContext);
        } else {
            this.updateStatus(userId, article, 0, null, serviceContext, new HashMap<String, Serializable>());
        }
        return this.journalArticlePersistence.findByPrimaryKey(article.getId());
    }

    public JournalArticle addArticle(long userId, long groupId, long folderId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Calendar calendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        int displayDateMonth = calendar.get(2);
        int displayDateDay = calendar.get(5);
        int displayDateYear = calendar.get(1);
        int displayDateHour = calendar.get(11);
        int displayDateMinute = calendar.get(12);
        return this.journalArticleLocalService.addArticle(userId, groupId, folderId, 0L, 0L, "", true, 1.0, titleMap, descriptionMap, content, ddmStructureKey, ddmTemplateKey, null, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, serviceContext);
    }

    public void addArticleResources(JournalArticle article, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(article.getCompanyId(), article.getGroupId(), article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addArticleResources(JournalArticle article, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(article.getCompanyId(), article.getGroupId(), article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), groupPermissions, guestPermissions);
    }

    public void addArticleResources(long groupId, String articleId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        this.addArticleResources(article, addGroupPermissions, addGuestPermissions);
    }

    public void addArticleResources(long groupId, String articleId, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        this.addArticleResources(article, groupPermissions, guestPermissions);
    }

    public JournalArticle checkArticleResourcePrimKey(long groupId, String articleId, double version) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (article.getResourcePrimKey() > 0L) {
            return article;
        }
        long resourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, articleId);
        article.setResourcePrimKey(resourcePrimKey);
        return (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
    }

    public void checkArticles() throws PortalException {
        Date now = new Date();
        this.checkArticlesByExpirationDate(now);
        this.checkArticlesByReviewDate(now);
        this.checkArticlesByDisplayDate(now);
        this._previousCheckDate = now;
    }

    public void checkNewLine(long groupId, String articleId, double version) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        String content = GetterUtil.getString((String)article.getContent());
        if (content.contains("\\n")) {
            content = StringUtil.replace((String)content, (String[])new String[]{"\\n", "\\r"}, (String[])new String[]{"\n", "\r"});
            article.setContent(content);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    public void checkStructure(long groupId, String articleId, double version) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        this.checkStructure(article);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle copyArticle(long userId, long groupId, String oldArticleId, String newArticleId, boolean autoArticleId, double version) throws PortalException {
        Image image;
        User user = this.userLocalService.getUser(userId);
        oldArticleId = StringUtil.toUpperCase((String)StringUtil.trim((String)oldArticleId));
        newArticleId = StringUtil.toUpperCase((String)StringUtil.trim((String)newArticleId));
        JournalArticle oldArticle = this.journalArticlePersistence.findByG_A_V(groupId, oldArticleId, version);
        if (autoArticleId) {
            newArticleId = String.valueOf(this.counterLocalService.increment());
        } else {
            this.validate(newArticleId);
            if (this.journalArticlePersistence.countByG_A(groupId, newArticleId) > 0) {
                StringBundler sb = new StringBundler(5);
                sb.append("{groupId=");
                sb.append(groupId);
                sb.append(", articleId=");
                sb.append(newArticleId);
                sb.append("}");
                throw new DuplicateArticleIdException(sb.toString());
            }
        }
        long id = this.counterLocalService.increment();
        long resourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, newArticleId);
        JournalArticle newArticle = this.journalArticlePersistence.create(id);
        newArticle.setResourcePrimKey(resourcePrimKey);
        newArticle.setGroupId(groupId);
        newArticle.setCompanyId(user.getCompanyId());
        newArticle.setUserId(user.getUserId());
        newArticle.setUserName(user.getFullName());
        Date modifiedDate = new Date();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null) {
            modifiedDate = serviceContext.getModifiedDate(modifiedDate);
        }
        newArticle.setModifiedDate(modifiedDate);
        newArticle.setFolderId(oldArticle.getFolderId());
        newArticle.setTreePath(oldArticle.getTreePath());
        newArticle.setArticleId(newArticleId);
        newArticle.setVersion(1.0);
        newArticle.setTitle(oldArticle.getTitle());
        newArticle.setUrlTitle(this.getUniqueUrlTitle(id, groupId, newArticleId, oldArticle.getTitleCurrentValue()));
        newArticle.setDescription(oldArticle.getDescription());
        try {
            this.copyArticleImages(oldArticle, newArticle);
        }
        catch (Exception e) {
            newArticle.setContent(oldArticle.getContent());
        }
        newArticle.setDDMStructureKey(oldArticle.getDDMStructureKey());
        newArticle.setDDMTemplateKey(oldArticle.getDDMTemplateKey());
        newArticle.setLayoutUuid(oldArticle.getLayoutUuid());
        newArticle.setDisplayDate(oldArticle.getDisplayDate());
        newArticle.setExpirationDate(oldArticle.getExpirationDate());
        newArticle.setReviewDate(oldArticle.getReviewDate());
        newArticle.setIndexable(oldArticle.isIndexable());
        newArticle.setSmallImage(oldArticle.isSmallImage());
        newArticle.setSmallImageId(this.counterLocalService.increment());
        newArticle.setSmallImageURL(oldArticle.getSmallImageURL());
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)JournalArticle.class.getName());
        WorkflowDefinitionLink workflowDefinitionLink = workflowHandler.getWorkflowDefinitionLink(oldArticle.getCompanyId(), oldArticle.getGroupId(), oldArticle.getId());
        if (oldArticle.isPending() || workflowDefinitionLink != null) {
            newArticle.setStatus(2);
        } else {
            newArticle.setStatus(oldArticle.getStatus());
        }
        newArticle.setStatusByUserId(user.getUserId());
        newArticle.setStatusByUserName(user.getFullName());
        newArticle.setStatusDate(modifiedDate);
        ExpandoBridgeUtil.copyExpandoBridgeAttributes((ExpandoBridge)oldArticle.getExpandoBridge(), (ExpandoBridge)newArticle.getExpandoBridge());
        newArticle = (JournalArticle)this.journalArticlePersistence.update((BaseModel)newArticle);
        this.resourceLocalService.copyModelResources(oldArticle.getCompanyId(), JournalArticle.class.getName(), oldArticle.getResourcePrimKey(), resourcePrimKey);
        if (oldArticle.isSmallImage() && (image = this.imageLocalService.fetchImage(oldArticle.getSmallImageId())) != null) {
            byte[] smallImageBytes = image.getTextObj();
            this.imageLocalService.updateImage(newArticle.getSmallImageId(), smallImageBytes);
        }
        long[] assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        String[] assetTagNames = this.assetTagLocalService.getTagNames(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        AssetEntry oldAssetEntry = this.assetEntryLocalService.getEntry(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        List assetLinks = this.assetLinkLocalService.getDirectLinks(oldAssetEntry.getEntryId(), false);
        long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
        this.updateAsset(userId, newArticle, assetCategoryIds, assetTagNames, assetLinkEntryIds, oldAssetEntry.getPriority());
        this.updateDDMLinks(id, groupId, oldArticle.getDDMStructureKey(), oldArticle.getDDMTemplateKey(), true);
        return newArticle;
    }

    @SystemEvent(action=1, send=false, type=1)
    public JournalArticle deleteArticle(JournalArticle article) throws PortalException {
        return this.journalArticleLocalService.deleteArticle(article, "", null);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, send=false, type=1)
    public JournalArticle deleteArticle(JournalArticle article, String articleURL, ServiceContext serviceContext) throws PortalException {
        int articlesCount;
        TrashEntry trashEntry;
        JournalArticleResource articleResource = this.journalArticleResourceLocalService.fetchArticleResource(article.getGroupId(), article.getArticleId());
        if (article.isApproved() && this.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion(), 0)) {
            this.updatePreviousApprovedArticle(article);
        }
        if (article.isDraft() || article.isInTrash()) {
            this.assetEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getPrimaryKey());
        }
        if (serviceContext != null && Validator.isNotNull((String)articleURL) && !article.isApproved() && this.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion())) {
            articleURL = this.buildArticleURL(articleURL, article.getGroupId(), article.getFolderId(), article.getArticleId());
            this.sendEmail(article, articleURL, "denied", serviceContext);
        }
        String articleId = article.getArticleId();
        if (article.isInTrash()) {
            articleId = TrashUtil.getOriginalTitle((String)article.getArticleId());
        }
        this.journalArticleImageLocalService.deleteImages(article.getGroupId(), articleId, article.getVersion());
        if (article.getClassNameId() != this.classNameLocalService.getClassNameId(DDMStructure.class)) {
            this.ddmStorageLinkLocalService.deleteClassStorageLink(article.getId());
            this.ddmTemplateLinkLocalService.deleteTemplateLink(this.classNameLocalService.getClassNameId(JournalArticle.class), article.getId());
        }
        this.expandoRowLocalService.deleteRows(article.getId());
        if (article.isInTrash() && (trashEntry = article.getTrashEntry()) != null) {
            this.trashVersionLocalService.deleteTrashVersion(JournalArticle.class.getName(), article.getId());
        }
        if (!article.isDraft()) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(article.getCompanyId(), article.getGroupId(), JournalArticle.class.getName(), article.getId());
        }
        if ((articlesCount = this.journalArticlePersistence.countByG_A(article.getGroupId(), article.getArticleId())) == 1) {
            this.assetEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
            CommentManagerUtil.deleteDiscussion((String)JournalArticle.class.getName(), (long)article.getResourcePrimKey());
            this.journalContentSearchLocalService.deleteArticleContentSearches(article.getGroupId(), article.getArticleId());
            this.ratingsStatsLocalService.deleteStats(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.imageLocalService.deleteImage(article.getSmallImageId());
            this.trashEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.resourceLocalService.deleteResource(article.getCompanyId(), JournalArticle.class.getName(), 4, article.getResourcePrimKey());
            if (articleResource != null) {
                this.journalArticleResourceLocalService.deleteJournalArticleResource(articleResource);
            }
        }
        this.journalArticlePersistence.remove((BaseModel)article);
        if (articleResource != null) {
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
            extraDataJSONObject.put("uuid", article.getUuid());
            extraDataJSONObject.put("version", article.getVersion());
            this.systemEventLocalService.addSystemEvent(0L, article.getGroupId(), article.getModelClassName(), article.getPrimaryKey(), articleResource.getUuid(), null, 1, extraDataJSONObject.toString());
        }
        return article;
    }

    public JournalArticle deleteArticle(long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.deleteArticle(article, articleURL, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArticle(long groupId, String articleId, ServiceContext serviceContext) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        JournalArticleResource articleResource = this.journalArticleResourceLocalService.fetchArticleResource(groupId, articleId);
        try {
            List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
            for (JournalArticle article : articles) {
                this.journalArticleLocalService.deleteArticle(article, null, serviceContext);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        if (articleResource != null) {
            this.systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArticles(long groupId) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        ArrayList<JournalArticleResource> articleResources = new ArrayList<JournalArticleResource>();
        try {
            JournalArticleResource articleResource = null;
            for (JournalArticle article : this.journalArticlePersistence.findByGroupId(groupId)) {
                if (articleResource == null || articleResource.getPrimaryKey() != article.getResourcePrimKey()) {
                    articleResource = this.journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
                    articleResources.add(articleResource);
                }
                this.journalArticleLocalService.deleteArticle(article, null, null);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        for (JournalArticleResource articleResource : articleResources) {
            this.systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    public void deleteArticles(long groupId, long folderId) throws PortalException {
        this.deleteArticles(groupId, folderId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArticles(long groupId, long folderId, boolean includeTrashedEntries) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        ArrayList<JournalArticleResource> articleResources = new ArrayList<JournalArticleResource>();
        try {
            JournalArticleResource articleResource = null;
            for (JournalArticle article : this.journalArticlePersistence.findByG_F(groupId, folderId)) {
                if (articleResource == null || articleResource.getPrimaryKey() != article.getResourcePrimKey()) {
                    articleResource = this.journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
                    articleResources.add(articleResource);
                }
                if (includeTrashedEntries || !article.isInTrashExplicitly()) {
                    this.journalArticleLocalService.deleteArticle(article, null, null);
                    continue;
                }
                articleResources.remove(articleResource);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        for (JournalArticleResource articleResource : articleResources) {
            this.systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    public void deleteArticles(long groupId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, classNameId, classPK);
        for (JournalArticle article : articles) {
            this.journalArticleLocalService.deleteArticle(article, null, null);
        }
    }

    public void deleteLayoutArticleReferences(long groupId, String layoutUuid) {
        List articles = this.journalArticlePersistence.findByG_L(groupId, layoutUuid);
        for (JournalArticle article : articles) {
            article.setLayoutUuid("");
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle expireArticle(long userId, long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException {
        return this.updateStatus(userId, groupId, articleId, version, 3, articleURL, new HashMap<String, Serializable>(), serviceContext);
    }

    public void expireArticle(long userId, long groupId, String articleId, String articleURL, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        if (this.isExpireAllArticleVersions(user.getCompanyId())) {
            List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
            for (JournalArticle article : articles) {
                if (article.isExpired()) continue;
                this.journalArticleLocalService.expireArticle(userId, groupId, article.getArticleId(), article.getVersion(), articleURL, serviceContext);
            }
        } else {
            JournalArticle article = this.getLatestArticle(groupId, articleId, 0);
            this.journalArticleLocalService.expireArticle(userId, groupId, article.getArticleId(), article.getVersion(), articleURL, serviceContext);
        }
    }

    public JournalArticle fetchArticle(long groupId, String articleId) {
        JournalArticle article = this.fetchLatestArticle(groupId, articleId, 0);
        if (article != null) {
            return article;
        }
        return this.fetchLatestArticle(groupId, articleId, -1);
    }

    public JournalArticle fetchArticle(long groupId, String articleId, double version) {
        return this.journalArticlePersistence.fetchByG_A_V(groupId, articleId, version);
    }

    public JournalArticle fetchArticleByUrlTitle(long groupId, String urlTitle) {
        JournalArticle article = this.fetchLatestArticleByUrlTitle(groupId, urlTitle, 0);
        if (article != null) {
            return article;
        }
        return this.fetchLatestArticleByUrlTitle(groupId, urlTitle, -1);
    }

    public JournalArticle fetchDisplayArticle(long groupId, String articleId) {
        List articles = this.journalArticlePersistence.findByG_A_ST(groupId, articleId, 0);
        if (articles.isEmpty()) {
            return null;
        }
        Date now = new Date();
        for (JournalArticle article : articles) {
            Date displayDate = article.getDisplayDate();
            Date expirationDate = article.getExpirationDate();
            if (displayDate != null && !displayDate.before(now) || expirationDate != null && !expirationDate.after(now)) continue;
            return article;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey) {
        return this.fetchLatestArticle(resourcePrimKey, -1);
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey, int status) {
        return this.fetchLatestArticle(resourcePrimKey, status, true);
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey, int status, boolean preferApproved) {
        JournalArticle article = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                article = this.journalArticlePersistence.fetchByR_ST_First(resourcePrimKey, 0, (OrderByComparator)orderByComparator);
            }
            if (article == null) {
                article = this.journalArticlePersistence.fetchByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)orderByComparator);
            }
        } else {
            article = this.journalArticlePersistence.fetchByR_ST_First(resourcePrimKey, status, (OrderByComparator)orderByComparator);
        }
        return article;
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey, int[] statuses) {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        List articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, statuses, 0, 1, (OrderByComparator)orderByComparator);
        if (!articles.isEmpty()) {
            return (JournalArticle)articles.get(0);
        }
        return null;
    }

    public JournalArticle fetchLatestArticle(long groupId, String articleId, int status) {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            return this.journalArticlePersistence.fetchByG_A_NotST_First(groupId, articleId, 8, (OrderByComparator)orderByComparator);
        }
        if (JournalServiceConfigurationValues.FETCH_LATEST_ARTICLE_WITH_PAGINATION) {
            return this.journalArticlePersistence.fetchByG_A_ST_First(groupId, articleId, status, (OrderByComparator)orderByComparator);
        }
        List articles = this.journalArticlePersistence.findByG_A_ST(groupId, articleId, status);
        if (articles.isEmpty()) {
            return null;
        }
        return (JournalArticle)Collections.max(articles, orderByComparator);
    }

    public JournalArticle fetchLatestArticleByUrlTitle(long groupId, String urlTitle, int status) {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        String normalizedUrlTitle = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)urlTitle);
        int maxLength = ModelHintsUtil.getMaxLength((String)JournalArticle.class.getName(), (String)"urlTitle");
        String curUrlTitle = normalizedUrlTitle.substring(0, Math.min(maxLength, normalizedUrlTitle.length()));
        articles = status == -1 ? this.journalArticlePersistence.findByG_UT(groupId, curUrlTitle, 0, 1, (OrderByComparator)orderByComparator) : this.journalArticlePersistence.findByG_UT_ST(groupId, curUrlTitle, status, 0, 1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            return null;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle fetchLatestIndexableArticle(long resourcePrimKey) {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        int[] statuses = new int[]{0, 8};
        List articles = this.journalArticlePersistence.findByR_I_S(resourcePrimKey, true, statuses, 0, 1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            return null;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getArticle(long id) throws PortalException {
        return this.journalArticlePersistence.findByPrimaryKey(id);
    }

    public JournalArticle getArticle(long groupId, String articleId) throws PortalException {
        JournalArticle article = this.fetchLatestArticle(groupId, articleId, 0);
        if (article != null) {
            return article;
        }
        return this.getLatestArticle(groupId, articleId, -1);
    }

    public JournalArticle getArticle(long groupId, String articleId, double version) throws PortalException {
        return this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
    }

    public JournalArticle getArticle(long groupId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, classNameId, classPK);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException(StringBundler.concat((String[])new String[]{"No approved JournalArticle exists with the key {groupId=", String.valueOf(groupId), ", className=", className, ", classPK=", String.valueOf(classPK), "}"}));
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getArticleByUrlTitle(long groupId, String urlTitle) throws PortalException {
        JournalArticle article = this.fetchLatestArticleByUrlTitle(groupId, urlTitle, 0);
        if (article != null) {
            return article;
        }
        return this.getLatestArticleByUrlTitle(groupId, urlTitle, -1);
    }

    public String getArticleContent(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        if (articleDisplay == null) {
            return "";
        }
        return articleDisplay.getContent();
    }

    @Deprecated
    public String getArticleContent(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(article, ddmTemplateKey, viewMode, languageId, null, themeDisplay);
    }

    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String ddmTemplateKey, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(groupId, articleId, version, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        if (articleDisplay == null) {
            return "";
        }
        return articleDisplay.getContent();
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String ddmTemplateKey, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(groupId, articleId, version, viewMode, ddmTemplateKey, languageId, null, themeDisplay);
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(groupId, articleId, version, viewMode, null, languageId, null, themeDisplay);
    }

    public String getArticleContent(long groupId, String articleId, String viewMode, String ddmTemplateKey, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        return articleDisplay.getContent();
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, String viewMode, String ddmTemplateKey, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(groupId, articleId, viewMode, ddmTemplateKey, languageId, null, themeDisplay);
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(groupId, articleId, viewMode, null, languageId, null, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay, false);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        Date expirationDate;
        Date now = new Date();
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (article.isExpired() && (expirationDate = article.getExpirationDate()) != null && expirationDate.before(now)) {
            return null;
        }
        Date displayDate = article.getDisplayDate();
        if (displayDate != null && displayDate.after(now)) {
            return null;
        }
        return this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleDisplay(groupId, articleId, version, ddmTemplateKey, viewMode, languageId, 1, null, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleDisplay(groupId, articleId, null, viewMode, languageId, page, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getVersion(), ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getVersion(), ddmTemplateKey, viewMode, languageId, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleDisplay(groupId, articleId, null, viewMode, languageId, themeDisplay);
    }

    public List<JournalArticle> getArticles() {
        return this.journalArticlePersistence.findAll();
    }

    public List<JournalArticle> getArticles(long groupId) {
        return this.journalArticlePersistence.findByGroupId(groupId);
    }

    public List<JournalArticle> getArticles(long groupId, int start, int end) {
        return this.journalArticlePersistence.findByGroupId(groupId, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticlePersistence.findByGroupId(groupId, start, end, obc);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId) {
        return this.journalArticlePersistence.findByG_F(groupId, folderId);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int start, int end) {
        return this.journalArticlePersistence.findByG_F(groupId, folderId, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int status, int start, int end) {
        return this.journalArticlePersistence.findByG_F_ST(groupId, folderId, status, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        return this.journalArticlePersistence.findByG_F(groupId, folderId, start, end, orderByComparator);
    }

    public List<JournalArticle> getArticles(long groupId, String articleId) {
        return this.journalArticlePersistence.findByG_A(groupId, articleId);
    }

    public List<JournalArticle> getArticles(long groupId, String articleId, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        return this.journalArticlePersistence.findByG_A(groupId, articleId, start, end, orderByComparator);
    }

    public List<JournalArticle> getArticlesByResourcePrimKey(long resourcePrimKey) {
        return this.journalArticlePersistence.findByResourcePrimKey(resourcePrimKey);
    }

    public List<JournalArticle> getArticlesBySmallImageId(long smallImageId) {
        return this.journalArticlePersistence.findBySmallImageId(smallImageId);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, long classNameId, String ddmStructureKey, int status, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByG_C_S(groupId, classNameId, ddmStructureKey, queryDefinition);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, String ddmStructureKey, int status, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByG_C_S(groupId, 0L, ddmStructureKey, queryDefinition);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, String ddmStructureKey, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.getArticlesByStructureId(groupId, ddmStructureKey, -1, start, end, obc);
    }

    public int getArticlesCount(long groupId) {
        return this.journalArticlePersistence.countByGroupId(groupId);
    }

    public int getArticlesCount(long groupId, long folderId) {
        return this.journalArticlePersistence.countByG_F(groupId, folderId);
    }

    public int getArticlesCount(long groupId, long folderId, int status) {
        return this.journalArticlePersistence.countByG_F_ST(groupId, folderId, status);
    }

    public int getArticlesCount(long groupId, String articleId) {
        return this.journalArticlePersistence.countByG_A(groupId, articleId);
    }

    public List<JournalArticle> getCompanyArticles(long companyId, double version, int status, int start, int end) {
        if (status == -1) {
            return this.journalArticlePersistence.findByC_V(companyId, version, start, end, (OrderByComparator)new ArticleIDComparator(true));
        }
        return this.journalArticlePersistence.findByC_V_ST(companyId, version, status, start, end, (OrderByComparator)new ArticleIDComparator(true));
    }

    public List<JournalArticle> getCompanyArticles(long companyId, int status, int start, int end) {
        if (status == -1) {
            return this.journalArticlePersistence.findByCompanyId(companyId, start, end, (OrderByComparator)new ArticleIDComparator(true));
        }
        return this.journalArticlePersistence.findByC_ST(companyId, status, start, end, (OrderByComparator)new ArticleIDComparator(true));
    }

    public int getCompanyArticlesCount(long companyId, double version, int status, int start, int end) {
        if (status == -1) {
            return this.journalArticlePersistence.countByC_V(companyId, version);
        }
        return this.journalArticlePersistence.countByC_V_ST(companyId, version, status);
    }

    public int getCompanyArticlesCount(long companyId, int status) {
        if (status == -1) {
            return this.journalArticlePersistence.countByCompanyId(companyId);
        }
        return this.journalArticlePersistence.countByC_ST(companyId, status);
    }

    public JournalArticle getDisplayArticle(long groupId, String articleId) throws PortalException {
        JournalArticle article = this.fetchDisplayArticle(groupId, articleId);
        if (article == null) {
            throw new NoSuchArticleException(StringBundler.concat((String[])new String[]{"No approved JournalArticle exists with the key {groupId=", String.valueOf(groupId), ", articleId=", articleId, "}"}));
        }
        return article;
    }

    public JournalArticle getDisplayArticleByUrlTitle(long groupId, String urlTitle) throws PortalException {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        List articles = this.journalArticlePersistence.findByG_UT_ST(groupId, FriendlyURLNormalizerUtil.normalizeWithEncoding((String)urlTitle), 0, -1, -1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException(StringBundler.concat((String[])new String[]{"No JournalArticle exists with the key {groupId=", String.valueOf(groupId), ", urlTitle=", urlTitle, "}"}));
        }
        Date now = new Date();
        for (JournalArticle article : articles) {
            Date displayDate = article.getDisplayDate();
            Date expirationDate = article.getExpirationDate();
            if (displayDate == null || !displayDate.before(now) || expirationDate != null && !expirationDate.after(now)) continue;
            return article;
        }
        return (JournalArticle)articles.get(0);
    }

    public List<JournalArticle> getIndexableArticlesByDDMStructureKey(String[] ddmStructureKeys) {
        if (this.isReindexAllArticleVersions()) {
            return this.getStructureArticles(ddmStructureKeys);
        }
        QueryDefinition approvedQueryDefinition = new QueryDefinition(0, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        ArrayList<JournalArticle> articles = new ArrayList<JournalArticle>();
        articles.addAll(this.journalArticleFinder.findByG_C_S(0L, 0L, ddmStructureKeys, approvedQueryDefinition));
        QueryDefinition trashQueryDefinition = new QueryDefinition(8, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        articles.addAll(this.journalArticleFinder.findByG_C_S(0L, 0L, ddmStructureKeys, trashQueryDefinition));
        return articles;
    }

    public List<JournalArticle> getIndexableArticlesByResourcePrimKey(long resourcePrimKey) {
        return this.journalArticlePersistence.findByR_I(resourcePrimKey, true);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey) throws PortalException {
        return this.getLatestArticle(resourcePrimKey, -1);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey, int status) throws PortalException {
        return this.getLatestArticle(resourcePrimKey, status, true);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey, int status, boolean preferApproved) throws PortalException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, 0, 0, 1, (OrderByComparator)orderByComparator);
            }
            if (ListUtil.isEmpty(articles)) {
                articles = this.journalArticlePersistence.findByResourcePrimKey(resourcePrimKey, 0, 1, (OrderByComparator)orderByComparator);
            }
        } else {
            articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, status, 0, 1, (OrderByComparator)orderByComparator);
        }
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {resourcePrimKey=" + resourcePrimKey + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId) throws PortalException {
        return this.getLatestArticle(groupId, articleId, -1);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId, int status) throws PortalException {
        return this.getFirstArticle(groupId, articleId, status, (OrderByComparator<JournalArticle>)new ArticleVersionComparator());
    }

    public JournalArticle getLatestArticle(long groupId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, classNameId, classPK, 0, 1, (OrderByComparator)new ArticleVersionComparator());
        if (articles.isEmpty()) {
            throw new NoSuchArticleException(StringBundler.concat((String[])new String[]{"No JournalArticle exists with the key {groupId=", String.valueOf(groupId), ", className=", className, ", classPK =", String.valueOf(classPK), "}"}));
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticleByUrlTitle(long groupId, String urlTitle, int status) throws PortalException {
        JournalArticle article = this.fetchLatestArticleByUrlTitle(groupId, urlTitle, status);
        if (article == null) {
            throw new NoSuchArticleException(StringBundler.concat((String[])new String[]{"No JournalArticle exists with the key {groupId=", String.valueOf(groupId), ", urlTitle=", urlTitle, ", status=", String.valueOf(status), "}"}));
        }
        return article;
    }

    public double getLatestVersion(long groupId, String articleId) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        return article.getVersion();
    }

    public double getLatestVersion(long groupId, String articleId, int status) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId, status);
        return article.getVersion();
    }

    public List<JournalArticle> getNoAssetArticles() {
        return this.journalArticleFinder.findByNoAssets();
    }

    public List<JournalArticle> getNoPermissionArticles() {
        return this.journalArticleFinder.findByNoPermissions();
    }

    public int getNotInTrashArticlesCount(long groupId, long folderId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.journalArticleFinder.countByG_F(groupId, folderIds, queryDefinition);
    }

    public JournalArticle getOldestArticle(long groupId, String articleId) throws PortalException {
        return this.getOldestArticle(groupId, articleId, -1);
    }

    public JournalArticle getOldestArticle(long groupId, String articleId, int status) throws PortalException {
        return this.getFirstArticle(groupId, articleId, status, (OrderByComparator<JournalArticle>)new ArticleVersionComparator(true));
    }

    public JournalArticle getPreviousApprovedArticle(JournalArticle article) {
        List approvedArticles = this.journalArticlePersistence.findByG_A_ST(article.getGroupId(), article.getArticleId(), 0, 0, 2);
        if (approvedArticles.isEmpty() || approvedArticles.size() == 1 && article.getStatus() == 0) {
            return article;
        }
        JournalArticle previousApprovedArticle = (JournalArticle)approvedArticles.get(0);
        if (article.getStatus() == 0) {
            previousApprovedArticle = (JournalArticle)approvedArticles.get(1);
        }
        return previousApprovedArticle;
    }

    public List<JournalArticle> getStructureArticles(long groupId, String ddmStructureKey) {
        return this.journalArticlePersistence.findByG_DDMSK(groupId, ddmStructureKey);
    }

    public List<JournalArticle> getStructureArticles(long groupId, String ddmStructureKey, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticlePersistence.findByG_DDMSK(groupId, ddmStructureKey, start, end, obc);
    }

    public List<JournalArticle> getStructureArticles(String[] ddmStructureKeys) {
        return this.journalArticlePersistence.findByDDMStructureKey(ddmStructureKeys);
    }

    public int getStructureArticlesCount(long groupId, String ddmStructureKey) {
        return this.journalArticlePersistence.countByG_DDMSK(groupId, ddmStructureKey);
    }

    public List<JournalArticle> getTemplateArticles(long groupId, String ddmTemplateKey) {
        return this.journalArticlePersistence.findByG_DDMTK(groupId, ddmTemplateKey);
    }

    public List<JournalArticle> getTemplateArticles(long groupId, String ddmTemplateKey, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticlePersistence.findByG_DDMTK(groupId, ddmTemplateKey, start, end, obc);
    }

    public int getTemplateArticlesCount(long groupId, String ddmTemplateKey) {
        return this.journalArticlePersistence.countByG_DDMTK(groupId, ddmTemplateKey);
    }

    public String getUniqueUrlTitle(long groupId, String articleId, String urlTitle) throws PortalException {
        String curArticleId;
        urlTitle = urlTitle.replaceAll("^/+", "");
        String normalizedUrlTitle = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)urlTitle);
        int maxLength = ModelHintsUtil.getMaxLength((String)JournalArticle.class.getName(), (String)"urlTitle");
        String curUrlTitle = normalizedUrlTitle.substring(0, Math.min(maxLength, normalizedUrlTitle.length()));
        long i = this._countSimilarURLTitles(groupId, curUrlTitle);
        while ((curArticleId = this._fetchArticleIdByURLTitle(groupId, curUrlTitle)) != null && !articleId.equals(curArticleId)) {
            String suffix = "-" + i;
            String prefix = normalizedUrlTitle.substring(0, Math.min(maxLength - suffix.length(), normalizedUrlTitle.length()));
            curUrlTitle = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)(prefix + suffix));
            ++i;
        }
        return curUrlTitle;
    }

    public boolean hasArticle(long groupId, String articleId) {
        JournalArticle article = this.fetchArticle(groupId, articleId);
        return article != null;
    }

    public boolean isLatestVersion(long groupId, String articleId, double version) throws PortalException {
        return this.getLatestVersion(groupId, articleId) == version;
    }

    public boolean isLatestVersion(long groupId, String articleId, double version, int status) throws PortalException {
        return this.getLatestVersion(groupId, articleId, status) == version;
    }

    public boolean isListable(JournalArticle article) {
        return article != null && article.isIndexable();
    }

    public boolean isRenderable(JournalArticle article, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        try {
            this.getArticleDisplay(article, null, "view", article.getDefaultLanguageId(), 0, portletRequestModel, themeDisplay, true);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticle(long groupId, String articleId, long newFolderId) throws PortalException {
        return this.moveArticle(groupId, articleId, newFolderId, null);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticle(long groupId, String articleId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        JournalArticle latestArticle = this.getLatestArticle(groupId, articleId);
        this.validateDDMStructureId(groupId, newFolderId, latestArticle.getDDMStructureKey());
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId);
        for (JournalArticle article : articles) {
            if (serviceContext != null) {
                this.notifySubscribers(serviceContext.getUserId(), article, article.getUrlTitle(), "move_from", serviceContext);
            }
            article.setFolderId(newFolderId);
            article.setTreePath(article.buildTreePath());
            article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
            if (serviceContext == null) continue;
            this.notifySubscribers(serviceContext.getUserId(), article, article.getUrlTitle(), "move_to", serviceContext);
        }
        return this.getArticle(groupId, articleId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticleFromTrash(long userId, long groupId, JournalArticle article, long newFolderId, ServiceContext serviceContext) throws PortalException {
        if (!article.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (article.isInTrashExplicitly()) {
            this.restoreArticleFromTrash(userId, article);
        } else {
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(JournalArticle.class.getName(), article.getResourcePrimKey());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, article, status, null, serviceContext, new HashMap<String, Serializable>());
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
        }
        return this.moveArticle(groupId, article.getArticleId(), newFolderId, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticleToTrash(long userId, JournalArticle article) throws PortalException {
        if (article.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = article.getStatus();
        if (oldStatus == 1) {
            article.setStatus(2);
        }
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        List articleVersions = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
        articleVersions = ListUtil.sort((List)articleVersions, (Comparator)new ArticleVersionComparator());
        List<Object> articleVersionStatusOVPs = new ArrayList();
        if (articleVersions != null && !articleVersions.isEmpty()) {
            articleVersionStatusOVPs = this.getArticleVersionStatuses(articleVersions);
        }
        article = this.updateStatus(userId, article.getId(), 8, new HashMap<String, Serializable>(), new ServiceContext());
        JournalArticleResource articleResource = this.journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("title", article.getArticleId());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), articleResource.getUuid(), null, oldStatus, articleVersionStatusOVPs, typeSettingsProperties);
        String trashArticleId = TrashUtil.getTrashTitle((long)trashEntry.getEntryId());
        for (JournalArticle articleVersion : articleVersions) {
            articleVersion.setArticleId(trashArticleId);
            articleVersion.setStatus(8);
            this.journalArticlePersistence.update((BaseModel)articleVersion);
        }
        articleResource.setArticleId(trashArticleId);
        this.journalArticleResourcePersistence.update((BaseModel)articleResource);
        article.setArticleId(trashArticleId);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
        if (this.isArticleCommentsEnabled(article.getCompanyId())) {
            CommentManagerUtil.moveDiscussionToTrash((String)JournalArticle.class.getName(), (long)article.getResourcePrimKey());
        }
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", article.getTitle());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)article, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        if (oldStatus == 1) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(article.getCompanyId(), article.getGroupId(), JournalArticle.class.getName(), article.getId());
        }
        return article;
    }

    public JournalArticle moveArticleToTrash(long userId, long groupId, String articleId) throws PortalException {
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, 0, 1, (OrderByComparator)new ArticleVersionComparator());
        if (!articles.isEmpty()) {
            return this.journalArticleLocalService.moveArticleToTrash(userId, (JournalArticle)articles.get(0));
        }
        return null;
    }

    public void rebuildTree(long companyId) throws PortalException {
        this.journalFolderLocalService.rebuildTree(companyId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle removeArticleLocale(long groupId, String articleId, double version, String languageId) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (Objects.equals(languageId, article.getDefaultLanguageId())) {
            throw new RequiredArticleLocalizationException("Default article localization is required");
        }
        String title = article.getTitle();
        title = LocalizationUtil.removeLocalization((String)title, (String)"static-content", (String)languageId, (boolean)true);
        article.setTitle(title);
        String description = article.getDescription();
        description = LocalizationUtil.removeLocalization((String)description, (String)"static-content", (String)languageId, (boolean)true);
        article.setDescription(description);
        String content = article.getContent();
        com.liferay.portal.kernel.xml.Document document = article.getDocument();
        if (document != null) {
            content = JournalUtil.removeArticleLocale(document, content, languageId);
            article.setContent(content);
        }
        return (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle restoreArticleFromTrash(long userId, JournalArticle article) throws PortalException {
        if (!article.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        String trashArticleId = TrashUtil.getOriginalTitle((String)article.getArticleId());
        List articleVersions = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
        for (JournalArticle articleVersion : articleVersions) {
            articleVersion.setArticleId(trashArticleId);
            this.journalArticlePersistence.update((BaseModel)articleVersion);
        }
        article.setArticleId(trashArticleId);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        JournalArticleResource articleResource = this.journalArticleResourcePersistence.fetchByPrimaryKey(article.getResourcePrimKey());
        articleResource.setArticleId(trashArticleId);
        this.journalArticleResourcePersistence.update((BaseModel)articleResource);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(article.getGroupId());
        this.updateStatus(userId, article, trashEntry.getStatus(), null, serviceContext, new HashMap<String, Serializable>());
        List trashVersions = this.trashVersionLocalService.getVersions(trashEntry.getEntryId());
        boolean visible = false;
        for (TrashVersion trashVersion : trashVersions) {
            JournalArticle trashArticleVersion = this.journalArticlePersistence.findByPrimaryKey(trashVersion.getClassPK());
            trashArticleVersion.setStatus(trashVersion.getStatus());
            if (trashVersion.getStatus() == 0) {
                visible = true;
            }
            this.journalArticlePersistence.update((BaseModel)trashArticleVersion);
        }
        this.trashEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
        if (visible) {
            this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), true);
        }
        if (this.isArticleCommentsEnabled(article.getCompanyId())) {
            CommentManagerUtil.restoreDiscussionFromTrash((String)JournalArticle.class.getName(), (long)article.getResourcePrimKey());
        }
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", article.getTitle());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)article, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
        return article;
    }

    public List<JournalArticle> search(long groupId, List<Long> folderIds, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.journalArticleFinder.findByG_F(groupId, folderIds, queryDefinition);
    }

    public List<JournalArticle> search(long groupId, long folderId, int status, int start, int end) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.search(groupId, folderIds, status, start, end);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String keywords, Double version, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticleFinder.findByKeywords(companyId, groupId, folderIds, classNameId, keywords, version, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, status, reviewDate, start, end, obc);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, andOperator, queryDefinition);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String[] ddmStructureKeys, String[] ddmTemplateKeys, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKeys, ddmTemplateKeys, displayDateGT, displayDateLT, reviewDate, andOperator, queryDefinition);
    }

    public Hits search(long companyId, long groupId, List<Long> folderIds, long classNameId, String ddmStructureKey, String ddmTemplateKey, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        String articleId = null;
        String title = null;
        String description = null;
        String content = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            articleId = keywords;
            title = keywords;
            description = keywords;
            content = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.search(companyId, groupId, folderIds, classNameId, articleId, title, description, content, -1, ddmStructureKey, ddmTemplateKey, params, andOperator, start, end, sort);
    }

    public Hits search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, int status, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
            SearchContext searchContext = this.buildSearchContext(companyId, groupId, folderIds, classNameId, articleId, title, description, content, status, ddmStructureKey, ddmTemplateKey, params, andSearch, start, end, sort);
            return indexer.search(searchContext);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    @Deprecated
    public Hits search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, String type, String statusString, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        int status = GetterUtil.getInteger((String)statusString);
        return this.search(companyId, groupId, folderIds, classNameId, articleId, title, description, content, status, ddmStructureKey, ddmTemplateKey, params, andSearch, start, end, sort);
    }

    public Hits search(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)JournalArticle.class.getName());
        SearchContext searchContext = this.buildSearchContext(groupId, userId, creatorUserId, status, start, end);
        return indexer.search(searchContext);
    }

    public int searchCount(long groupId, List<Long> folderIds, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.journalArticleFinder.countByG_F(groupId, folderIds, queryDefinition);
    }

    public int searchCount(long groupId, long folderId, int status) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.searchCount(groupId, folderIds, status);
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String keywords, Double version, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate) {
        return this.journalArticleFinder.countByKeywords(companyId, groupId, folderIds, classNameId, keywords, version, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, status, reviewDate);
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) {
        return this.journalArticleFinder.countByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, andOperator, new QueryDefinition(status));
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String[] ddmStructureKeys, String[] ddmTemplateKeys, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) {
        return this.journalArticleFinder.countByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKeys, ddmTemplateKeys, displayDateGT, displayDateLT, reviewDate, andOperator, new QueryDefinition(status));
    }

    public BaseModelSearchResult<JournalArticle> searchJournalArticles(long companyId, long groupId, List<Long> folderIds, long classNameId, String ddmStructureKey, String ddmTemplateKey, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws PortalException {
        String articleId = null;
        String title = null;
        String description = null;
        String content = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            articleId = keywords;
            title = keywords;
            description = keywords;
            content = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.searchJournalArticles(companyId, groupId, folderIds, classNameId, articleId, title, description, content, -1, ddmStructureKey, ddmTemplateKey, params, andOperator, start, end, sort);
    }

    public BaseModelSearchResult<JournalArticle> searchJournalArticles(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, int status, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, folderIds, classNameId, articleId, title, description, content, status, ddmStructureKey, ddmTemplateKey, params, andSearch, start, end, sort);
        return this.searchJournalArticles(searchContext);
    }

    public BaseModelSearchResult<JournalArticle> searchJournalArticles(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(groupId, userId, creatorUserId, status, start, end);
        return this.searchJournalArticles(searchContext);
    }

    public void setTreePaths(final long folderId, final String treePath, final boolean reindex) throws PortalException {
        if (treePath == null) {
            throw new IllegalArgumentException("Tree path is null");
        }
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
                dynamicQuery.add(folderIdProperty.eq((Object)folderId));
                Property treePathProperty = PropertyFactoryUtil.forName((String)"treePath");
                dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)treePathProperty.isNull(), (Criterion)treePathProperty.ne((Object)treePath)));
            }
        });
        final Indexer indexer = IndexerRegistryUtil.getIndexer((String)JournalArticle.class.getName());
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<JournalArticle>(){

            public void performAction(JournalArticle article) throws PortalException {
                article.setTreePath(treePath);
                JournalArticleLocalServiceImpl.this.updateJournalArticle(article);
                if (!reindex) {
                    return;
                }
                indexableActionableDynamicQuery.setCompanyId(article.getCompanyId());
                Document document = indexer.getDocument((Object)article);
                indexableActionableDynamicQuery.addDocuments(new Document[]{document});
            }
        });
        indexableActionableDynamicQuery.performActions();
    }

    public void subscribeStructure(long groupId, long userId, long ddmStructureId) throws PortalException {
        this.subscriptionLocalService.addSubscription(userId, groupId, DDMStructure.class.getName(), ddmStructureId);
    }

    public void unsubscribeStructure(long groupId, long userId, long ddmStructureId) throws PortalException {
        this.subscriptionLocalService.deleteSubscription(userId, DDMStructure.class.getName(), ddmStructureId);
    }

    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String layoutUuid, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        Date displayDate = article.getDisplayDate();
        int displayDateMonth = 0;
        int displayDateDay = 0;
        int displayDateYear = 0;
        int displayDateHour = 0;
        int displayDateMinute = 0;
        if (displayDate != null) {
            Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            displayCal.setTime(displayDate);
            displayDateMonth = displayCal.get(2);
            displayDateDay = displayCal.get(5);
            displayDateYear = displayCal.get(1);
            displayDateHour = displayCal.get(10);
            displayDateMinute = displayCal.get(12);
            if (displayCal.get(9) == 1) {
                displayDateHour += 12;
            }
        }
        Date expirationDate = article.getExpirationDate();
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            expirationCal.setTime(expirationDate);
            expirationDateMonth = expirationCal.get(2);
            expirationDateDay = expirationCal.get(5);
            expirationDateYear = expirationCal.get(1);
            expirationDateHour = expirationCal.get(10);
            expirationDateMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationDateHour += 12;
            }
        }
        Date reviewDate = article.getReviewDate();
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        if (reviewDate != null) {
            Calendar reviewCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            reviewCal.setTime(reviewDate);
            reviewDateMonth = reviewCal.get(2);
            reviewDateDay = reviewCal.get(5);
            reviewDateYear = reviewCal.get(1);
            reviewDateHour = reviewCal.get(10);
            reviewDateMinute = reviewCal.get(12);
            neverReview = false;
            if (reviewCal.get(9) == 1) {
                reviewDateHour += 12;
            }
        }
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, titleMap, descriptionMap, content, article.getDDMStructureKey(), article.getDDMTemplateKey(), layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.isIndexable(), article.isSmallImage(), article.getSmallImageURL(), null, null, null, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, boolean validateReferences, ServiceContext serviceContext) throws PortalException {
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, titleMap, descriptionMap, content, ddmStructureKey, ddmTemplateKey, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, smallImageFile, images, articleURL, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        boolean validate;
        JournalArticle latestArticle;
        User user = this.userLocalService.getUser(userId);
        articleId = StringUtil.toUpperCase((String)articleId.trim());
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JournalArticle article = latestArticle = this.getLatestArticle(groupId, articleId, -1);
        boolean imported = ExportImportThreadLocal.isImportInProcess();
        double latestVersion = latestArticle.getVersion();
        boolean addNewVersion = false;
        if (imported) {
            article = this.getArticle(groupId, articleId, version);
        } else {
            if (version > 0.0 && version != latestVersion) {
                StringBundler sb = new StringBundler(4);
                sb.append("Version ");
                sb.append(version);
                sb.append(" is not the same as ");
                sb.append(latestVersion);
                throw new ArticleVersionException(sb.toString());
            }
            serviceContext.validateModifiedDate((AuditedModel)latestArticle, ArticleVersionException.class);
            if (latestArticle.isApproved() || latestArticle.isExpired() || latestArticle.isScheduled()) {
                addNewVersion = true;
                version = this.getNextVersion(article);
            }
        }
        Date displayDate = null;
        Date expirationDate = null;
        Date reviewDate = null;
        if (article.getClassNameId() == 0L) {
            displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), null);
            if (!neverExpire) {
                expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), ArticleExpirationDateException.class);
            }
            if (!neverReview) {
                reviewDate = PortalUtil.getDate((int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (TimeZone)user.getTimeZone(), ArticleReviewDateException.class);
            }
        }
        Date now = new Date();
        boolean expired = false;
        if (expirationDate != null && expirationDate.before(now)) {
            expired = true;
        }
        boolean bl = validate = !ExportImportThreadLocal.isImportInProcess();
        if (validate) {
            this.validate(user.getCompanyId(), groupId, latestArticle.getClassNameId(), titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
            this.validateReferences(groupId, ddmStructureKey, ddmTemplateKey, layoutUuid, smallImage, smallImageURL, smallImageBytes, latestArticle.getSmallImageId(), content);
        }
        if (addNewVersion) {
            long id = this.counterLocalService.increment();
            article = this.journalArticlePersistence.create(id);
            article.setResourcePrimKey(latestArticle.getResourcePrimKey());
            article.setGroupId(latestArticle.getGroupId());
            article.setCompanyId(latestArticle.getCompanyId());
            article.setUserId(user.getUserId());
            article.setUserName(user.getFullName());
            article.setCreateDate(latestArticle.getCreateDate());
            article.setModifiedDate(serviceContext.getModifiedDate(now));
            article.setClassNameId(latestArticle.getClassNameId());
            article.setClassPK(latestArticle.getClassPK());
            article.setArticleId(articleId);
            article.setVersion(version);
            article.setSmallImageId(latestArticle.getSmallImageId());
            article.setStatusByUserId(user.getUserId());
            article.setStatusByUserName(user.getFullName());
            article.setStatusDate(serviceContext.getModifiedDate(now));
        }
        Locale locale = this.getArticleDefaultLocale(content);
        String title = titleMap.get(locale);
        content = this.format(user, groupId, articleId, article.getVersion(), addNewVersion, content, images);
        article.setFolderId(folderId);
        article.setTreePath(article.buildTreePath());
        article.setTitleMap(titleMap, locale);
        article.setUrlTitle(this.getUniqueUrlTitle(article.getId(), groupId, article.getArticleId(), title, latestArticle.getUrlTitle(), serviceContext));
        article.setDescriptionMap(descriptionMap, locale);
        article.setContent(content);
        article.setDDMStructureKey(ddmStructureKey);
        article.setDDMTemplateKey(ddmTemplateKey);
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                article.setSmallImageId(this.counterLocalService.increment());
            }
        } else {
            article.setSmallImageId(0L);
        }
        article.setSmallImageURL(smallImageURL);
        if (latestArticle.isPending()) {
            article.setStatus(latestArticle.getStatus());
        } else if (!expired) {
            article.setStatus(2);
        } else {
            article.setStatus(3);
        }
        ExpandoBridgeUtil.setExpandoBridgeAttributes((ExpandoBridge)latestArticle.getExpandoBridge(), (ExpandoBridge)article.getExpandoBridge(), (ServiceContext)serviceContext);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        if (this.hasModifiedLatestApprovedVersion(groupId, articleId, version)) {
            this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        }
        if (this.classNameLocalService.getClassNameId(DDMStructure.class) == article.getClassNameId()) {
            this.updateDDMStructurePredefinedValues(article.getClassPK(), content, serviceContext);
        } else {
            this.updateDDMLinks(article.getId(), groupId, ddmStructureKey, ddmTemplateKey, addNewVersion);
        }
        this.saveImages(smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        if (expired && imported) {
            this.updateStatus(userId, article, article.getStatus(), articleURL, serviceContext, new HashMap<String, Serializable>());
        }
        if (serviceContext.getWorkflowAction() == 1) {
            articleURL = this.buildArticleURL(articleURL, groupId, folderId, articleId);
            serviceContext.setAttribute("articleURL", (Serializable)((Object)articleURL));
            this.sendEmail(article, articleURL, "requested", serviceContext);
            this.startWorkflowInstance(userId, article, serviceContext);
        }
        return this.journalArticlePersistence.findByPrimaryKey(article.getId());
    }

    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, String content, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, article.getTitleMap(), article.getDescriptionMap(), content, article.getLayoutUuid(), serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticleTranslation(long groupId, String articleId, double version, Locale locale, String title, String description, String content, Map<String, byte[]> images, ServiceContext serviceContext) throws PortalException {
        this.validateContent(content);
        JournalArticle oldArticle = this.getLatestArticle(groupId, articleId, -1);
        double oldVersion = oldArticle.getVersion();
        if (version > 0.0 && version != oldVersion) {
            StringBundler sb = new StringBundler(4);
            sb.append("Version ");
            sb.append(version);
            sb.append(" is not the same as ");
            sb.append(oldVersion);
            throw new ArticleVersionException(sb.toString());
        }
        boolean incrementVersion = false;
        if (oldArticle.isApproved() || oldArticle.isExpired()) {
            incrementVersion = true;
        }
        if (serviceContext != null) {
            serviceContext.validateModifiedDate((AuditedModel)oldArticle, ArticleVersionException.class);
        }
        JournalArticle article = null;
        User user = this.userLocalService.fetchUser(oldArticle.getUserId());
        if (user == null) {
            user = this.userLocalService.getDefaultUser(oldArticle.getCompanyId());
        }
        Locale defaultLocale = this.getArticleDefaultLocale(content);
        if (incrementVersion) {
            double newVersion = this.getNextVersion(oldArticle);
            long id = this.counterLocalService.increment();
            article = this.journalArticlePersistence.create(id);
            article.setResourcePrimKey(oldArticle.getResourcePrimKey());
            article.setGroupId(oldArticle.getGroupId());
            article.setCompanyId(oldArticle.getCompanyId());
            article.setUserId(oldArticle.getUserId());
            article.setUserName(user.getFullName());
            article.setCreateDate(oldArticle.getCreateDate());
            article.setFolderId(oldArticle.getFolderId());
            article.setClassNameId(oldArticle.getClassNameId());
            article.setClassPK(oldArticle.getClassPK());
            article.setArticleId(articleId);
            article.setVersion(newVersion);
            article.setTitleMap(oldArticle.getTitleMap(), defaultLocale);
            article.setUrlTitle(this.getUniqueUrlTitle(id, groupId, articleId, title, oldArticle.getUrlTitle(), serviceContext));
            article.setDescriptionMap(oldArticle.getDescriptionMap());
            article.setDDMStructureKey(oldArticle.getDDMStructureKey());
            article.setDDMTemplateKey(oldArticle.getDDMTemplateKey());
            article.setLayoutUuid(oldArticle.getLayoutUuid());
            article.setDisplayDate(oldArticle.getDisplayDate());
            article.setExpirationDate(oldArticle.getExpirationDate());
            article.setReviewDate(oldArticle.getReviewDate());
            article.setIndexable(oldArticle.isIndexable());
            article.setSmallImage(oldArticle.isSmallImage());
            article.setSmallImageId(oldArticle.getSmallImageId());
            if (article.getSmallImageId() == 0L) {
                article.setSmallImageId(this.counterLocalService.increment());
            }
            article.setSmallImageURL(oldArticle.getSmallImageURL());
            article.setStatus(2);
            article.setStatusDate(new Date());
            ExpandoBridgeUtil.copyExpandoBridgeAttributes((ExpandoBridge)oldArticle.getExpandoBridge(), (ExpandoBridge)article.getExpandoBridge());
            this.updateDDMLinks(id, groupId, oldArticle.getDDMStructureKey(), oldArticle.getDDMTemplateKey(), true);
        } else {
            article = oldArticle;
        }
        Map titleMap = article.getTitleMap();
        titleMap.put(locale, title);
        article.setTitleMap(titleMap, defaultLocale);
        Map descriptionMap = article.getDescriptionMap();
        descriptionMap.put(locale, description);
        article.setDescriptionMap(descriptionMap);
        content = this.format(user, groupId, articleId, article.getVersion(), !oldArticle.isDraft(), content, images);
        article.setContent(content);
        return (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
    }

    @Deprecated
    public void updateAsset(long userId, JournalArticle article, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        this.updateAsset(userId, article, assetCategoryIds, assetTagNames, assetLinkEntryIds, null);
    }

    public void updateAsset(long userId, JournalArticle article, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, Double priority) throws PortalException {
        boolean visible = article.isApproved();
        if (article.getClassNameId() != 0L) {
            visible = false;
        }
        boolean addDraftAssetEntry = this._addDraftAssetEntry(article);
        AssetEntry assetEntry = null;
        if (addDraftAssetEntry) {
            assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), article.getPrimaryKey(), article.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, this.isListable(article), false, null, null, null, article.getExpirationDate(), "text/html", article.getTitle(), article.getDescription(), article.getDescription(), null, article.getLayoutUuid(), 0, 0, priority);
        } else {
            JournalArticleResource journalArticleResource = this.journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
            Date publishDate = null;
            if (article.isApproved()) {
                publishDate = article.getDisplayDate();
            }
            assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), journalArticleResource.getResourcePrimKey(), journalArticleResource.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, this.isListable(article), visible, null, null, publishDate, article.getExpirationDate(), "text/html", article.getTitle(), article.getDescription(), article.getDescription(), null, article.getLayoutUuid(), 0, 0, priority);
        }
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateContent(long groupId, String articleId, double version, String content) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        User user = this.userLocalService.getUser(article.getUserId());
        content = this.format(user, groupId, articleId, version, false, content, new HashMap<String, byte[]>());
        article.setContent(content);
        return (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
    }

    public void updateDDMTemplateKey(long groupId, long classNameId, String oldDDMTemplateKey, String newDDMTemplateKey) {
        List articles = this.journalArticlePersistence.findByG_C_DDMTK(groupId, classNameId, oldDDMTemplateKey);
        for (JournalArticle article : articles) {
            article.setDDMTemplateKey(newDDMTemplateKey);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateStatus(long userId, JournalArticle article, int status, String articleURL, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        if (status == 0 && article.getClassNameId() == 0L && article.getDisplayDate() != null && now.before(article.getDisplayDate())) {
            status = 7;
        }
        int oldStatus = article.getStatus();
        Date modifiedDate = serviceContext.getModifiedDate(now);
        article.setModifiedDate(modifiedDate);
        Date expirationDate = article.getExpirationDate();
        if (status == 0 && expirationDate != null && expirationDate.before(now)) {
            article.setExpirationDate(null);
        }
        if (status == 3 && expirationDate == null) {
            article.setExpirationDate(now);
        }
        article.setStatus(status);
        article.setStatusByUserId(user.getUserId());
        article.setStatusByUserName(user.getFullName());
        article.setStatusDate(modifiedDate);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        if (this.isExpireAllArticleVersions(article.getCompanyId())) {
            this.setArticlesExpirationDate(article);
        }
        if (this.hasModifiedLatestApprovedVersion(article.getGroupId(), article.getArticleId(), article.getVersion())) {
            if (status == 0) {
                AssetEntry draftAssetEntry;
                this.updateUrlTitles(article.getGroupId(), article.getArticleId(), article.getUrlTitle());
                if (oldStatus != 0 && article.getVersion() != 1.0 && (draftAssetEntry = this.assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), article.getPrimaryKey())) != null) {
                    long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                    String[] assetTagNames = draftAssetEntry.getTagNames();
                    List assetLinks = this.assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0, false);
                    long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
                    AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), article.getResourcePrimKey(), article.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, this.isListable(article), false, null, null, null, null, "text/html", article.getTitle(), article.getDescription(), article.getDescription(), null, article.getLayoutUuid(), 0, 0, Double.valueOf(draftAssetEntry.getPriority()));
                    this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
                    this.assetEntryLocalService.deleteEntry(draftAssetEntry);
                }
                if (article.getClassNameId() == 0L) {
                    this.assetEntryLocalService.updateEntry(JournalArticle.class.getName(), article.getResourcePrimKey(), article.getDisplayDate(), article.getExpirationDate(), this.isListable(article), true);
                }
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
                extraDataJSONObject.put("title", article.getTitle());
                if (serviceContext.isCommandUpdate()) {
                    SocialActivityManagerUtil.addActivity((long)user.getUserId(), (ClassedModel)article, (int)2, (String)extraDataJSONObject.toString(), (long)0L);
                } else {
                    SocialActivityManagerUtil.addUniqueActivity((long)user.getUserId(), (ClassedModel)article, (int)1, (String)extraDataJSONObject.toString(), (long)0L);
                }
            } else if (oldStatus == 0) {
                this.updatePreviousApprovedArticle(article);
            }
        }
        if (article.getClassNameId() == 0L && oldStatus != 8 && status != 8) {
            if (oldStatus == 1 && (status == 0 || status == 4)) {
                String msg = "granted";
                if (status == 4) {
                    msg = "denied";
                }
                try {
                    articleURL = this.buildArticleURL(articleURL, article.getGroupId(), article.getFolderId(), article.getArticleId());
                    this.sendEmail(article, articleURL, msg, serviceContext);
                }
                catch (Exception e) {
                    _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to send email to notify the change of ", "status to ", msg, " for article ", String.valueOf(article.getId()), ": ", e.getMessage()}));
                }
            }
            String action = "update";
            if (article.equals(this.getOldestArticle(article.getGroupId(), article.getArticleId()))) {
                action = "add";
            }
            this.notifySubscribers(user.getUserId(), article, (String)((Object)workflowContext.get("url")), action, serviceContext);
        }
        return article;
    }

    public JournalArticle updateStatus(long userId, long classPK, int status, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.getArticle(classPK);
        return this.journalArticleLocalService.updateStatus(userId, article, status, null, serviceContext, workflowContext);
    }

    public JournalArticle updateStatus(long userId, long groupId, String articleId, double version, int status, String articleURL, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.updateStatus(userId, article, status, articleURL, serviceContext, workflowContext);
    }

    @Deprecated
    public void updateTemplateId(long groupId, long classNameId, String oldDDMTemplateKey, String newDDMTemplateKey) {
        this.updateDDMTemplateKey(groupId, classNameId, oldDDMTemplateKey, newDDMTemplateKey);
    }

    protected String buildArticleURL(String articleURL, long groupId, long folderId, String articleId) {
        String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        String namespace = PortalUtil.getPortletNamespace((String)portletId);
        articleURL = HttpUtil.addParameter((String)articleURL, (String)(namespace + "groupId"), (long)groupId);
        articleURL = HttpUtil.addParameter((String)articleURL, (String)(namespace + "folderId"), (long)folderId);
        articleURL = HttpUtil.addParameter((String)articleURL, (String)(namespace + "articleId"), (String)articleId);
        return articleURL;
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, int status, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andSearch);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("articleId", articleId);
        attributes.put("classNameId", classNameId);
        attributes.put("content", content);
        attributes.put("description", description);
        attributes.put("status", status);
        attributes.put("title", title);
        attributes.put("ddmStructureKey", ddmStructureKey);
        attributes.put("ddmTemplateKey", ddmTemplateKey);
        attributes.put("params", params);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setFolderIds(folderIds);
        searchContext.setGroupIds(new long[]{groupId});
        if (params != null) {
            searchContext.setIncludeDiscussions(GetterUtil.getBoolean((Object)params.get("includeDiscussions")));
            String keywords = (String)params.remove("keywords");
            if (Validator.isNotNull((String)keywords)) {
                searchContext.setKeywords(keywords);
            }
        }
        QueryConfig queryConfig = new QueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        searchContext.setQueryConfig(queryConfig);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    protected SearchContext buildSearchContext(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        searchContext.setAttribute("paginationType", (Serializable)((Object)"none"));
        if (creatorUserId > 0L) {
            searchContext.setAttribute("userId", (Serializable)((Object)String.valueOf(creatorUserId)));
        }
        Group group = this.groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setSorts(new Sort[]{new Sort("modified", true)});
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return searchContext;
    }

    protected void checkArticlesByCompanyIdAndExpirationDate(long companyId, Date expirationDate, Date nextExpirationDate) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.getIndexableActionableDynamicQuery();
        Indexer indexer = IndexerRegistryUtil.getIndexer(JournalArticle.class);
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            dynamicQuery.add(classNameIdProperty.eq((Object)0L));
            Property expirationDateProperty = PropertyFactoryUtil.forName((String)"expirationDate");
            dynamicQuery.add(expirationDateProperty.le((Object)nextExpirationDate));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.eq((Object)0));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(article -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Expiring article " + article.getId()));
            }
            if (this.isExpireAllArticleVersions(companyId)) {
                List currentArticles = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId(), -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
                for (JournalArticle currentArticle : currentArticles) {
                    if (currentArticle.getExpirationDate() == null || currentArticle.getVersion() > article.getVersion()) continue;
                    currentArticle.setExpirationDate(article.getExpirationDate());
                    currentArticle.setStatus(3);
                    this.journalArticlePersistence.update((BaseModel)currentArticle);
                }
            }
            article.setStatus(3);
            article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
            this.updatePreviousApprovedArticle((JournalArticle)article);
            if (indexer != null) {
                indexableActionableDynamicQuery.addDocuments(new Document[]{indexer.getDocument(article)});
            }
        });
        if (indexer != null) {
            indexableActionableDynamicQuery.setSearchEngineId(indexer.getSearchEngineId());
        }
        indexableActionableDynamicQuery.setTransactionConfig(DefaultActionableDynamicQuery.REQUIRES_NEW_TRANSACTION_CONFIG);
        indexableActionableDynamicQuery.performActions();
    }

    protected void checkArticlesByDisplayDate(Date displayDate) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Publishing articles with display date less than ", String.valueOf(displayDate), " and status ", String.valueOf(7)}));
        }
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property displayDateProperty = PropertyFactoryUtil.forName((String)"displayDate");
            dynamicQuery.add(displayDateProperty.lt((Object)displayDate));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.eq((Object)7));
        });
        actionableDynamicQuery.setPerformActionMethod(article -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Publishing article " + article.getId()));
            }
            long userId = PortalUtil.getValidUserId((long)article.getCompanyId(), (long)article.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
            String layoutFullURL = PortalUtil.getLayoutFullURL((long)article.getGroupId(), (String)portletId);
            serviceContext.setLayoutFullURL(layoutFullURL);
            serviceContext.setScopeGroupId(article.getGroupId());
            this.journalArticleLocalService.updateStatus(userId, article, 0, null, serviceContext, new HashMap());
        });
        actionableDynamicQuery.setTransactionConfig(DefaultActionableDynamicQuery.REQUIRES_NEW_TRANSACTION_CONFIG);
        actionableDynamicQuery.performActions();
    }

    protected void checkArticlesByExpirationDate(Date expirationDate) throws PortalException {
        long checkInterval = this.getArticleCheckInterval();
        Date nextExpirationDate = new Date(expirationDate.getTime() + checkInterval);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Expiring articles with expiration date less than or ", "equal to ", String.valueOf(nextExpirationDate), " and status ", String.valueOf(0)}));
        }
        for (Company company : this.companyLocalService.getCompanies(false)) {
            this.checkArticlesByCompanyIdAndExpirationDate(company.getCompanyId(), expirationDate, nextExpirationDate);
        }
        if (this._previousCheckDate == null) {
            this._previousCheckDate = new Date(expirationDate.getTime() - this.getArticleCheckInterval());
        }
    }

    protected void checkArticlesByReviewDate(Date reviewDate) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Sending review notification for articles with reviewDate ", "between ", String.valueOf(this._previousCheckDate), " and ", String.valueOf(reviewDate)}));
        }
        HashSet<Long> latestArticleIds = new HashSet<Long>();
        List articles = this.journalArticleFinder.findByReviewDate(0L, reviewDate, this._previousCheckDate);
        for (JournalArticle article : articles) {
            double version;
            String articleId;
            if (article.isInTrash()) continue;
            long groupId = article.getGroupId();
            if (!this.journalArticleLocalService.isLatestVersion(groupId, articleId = article.getArticleId(), version = article.getVersion())) {
                article = this.journalArticleLocalService.getLatestArticle(groupId, articleId);
            }
            if (!latestArticleIds.add(article.getPrimaryKey())) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Sending review notification for article " + article.getId()));
            }
            String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
            String articleURL = PortalUtil.getControlPanelFullURL((long)article.getGroupId(), (String)portletId, null);
            articleURL = this.buildArticleURL(articleURL, article.getGroupId(), article.getFolderId(), article.getArticleId());
            this.sendEmail(article, articleURL, "review", new ServiceContext());
        }
    }

    protected void checkStructure(com.liferay.portal.kernel.xml.Document contentDocument, DDMForm ddmForm) throws PortalException {
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            this.checkStructureField(ddmFormField, contentDocument.getRootElement());
        }
    }

    protected void checkStructure(JournalArticle article) throws PortalException {
        block2: {
            DDMStructure ddmStructure = article.getDDMStructure();
            try {
                this.checkStructure(article, ddmStructure);
            }
            catch (StructureDefinitionException sde) {
                if (!_log.isWarnEnabled()) break block2;
                StringBundler sb = new StringBundler(8);
                sb.append("Article {groupId=");
                sb.append(article.getGroupId());
                sb.append(", articleId=");
                sb.append(article.getArticleId());
                sb.append(", version=");
                sb.append(article.getVersion());
                sb.append("} has content that does not match its structure: ");
                sb.append(sde.getMessage());
                _log.warn((Object)sb.toString());
            }
        }
    }

    protected void checkStructure(JournalArticle article, DDMStructure ddmStructure) throws PortalException {
        this.checkStructure(article.getDocument(), ddmStructure.getDDMForm());
    }

    protected void checkStructureField(DDMFormField ddmFormField, Element contentElement) throws PortalException {
        String contentElementType;
        String fieldName = ddmFormField.getName();
        boolean hasField = false;
        for (Element childElement : contentElement.elements()) {
            if (!fieldName.equals(childElement.attributeValue("name", ""))) continue;
            hasField = true;
            for (DDMFormField childDDMFormField : ddmFormField.getNestedDDMFormFields()) {
                this.checkStructureField(childDDMFormField, childElement);
            }
        }
        if (!(hasField || (contentElementType = contentElement.attributeValue("type", "")).equals("list") || contentElementType.equals("multi-list"))) {
            throw new StructureDefinitionException(fieldName);
        }
    }

    protected void copyArticleImages(JournalArticle oldArticle, JournalArticle newArticle) throws Exception {
        com.liferay.portal.kernel.xml.Document contentDocument = oldArticle.getDocument();
        contentDocument = contentDocument.clone();
        XPath xPathSelector = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='image']");
        List imageNodes = xPathSelector.selectNodes((Object)contentDocument);
        for (Node imageNode : imageNodes) {
            Element imageEl = (Element)imageNode;
            String elInstanceId = imageEl.attributeValue("instance-id");
            String elName = imageEl.attributeValue("name");
            List dynamicContentEls = imageEl.elements("dynamic-content");
            for (Element dynamicContentEl : dynamicContentEls) {
                long imageId = GetterUtil.getLong((String)dynamicContentEl.attributeValue("id"));
                String languageId = "_" + dynamicContentEl.attributeValue("language-id");
                Image oldImage = this.imageLocalService.fetchImage(imageId);
                if (oldImage == null) continue;
                imageId = this.journalArticleImageLocalService.getArticleImageId(newArticle.getGroupId(), newArticle.getArticleId(), newArticle.getVersion(), elInstanceId, elName, languageId);
                this.imageLocalService.updateImage(imageId, oldImage.getTextObj());
                String imageTitle = dynamicContentEl.attributeValue("title");
                String elContent = StringBundler.concat((String[])new String[]{"/image/journal/article?img_id=", String.valueOf(imageId), "&t=", WebServerServletTokenUtil.getToken((long)imageId), "&fileName=", imageTitle});
                dynamicContentEl.setText(elContent);
                dynamicContentEl.addAttribute("id", String.valueOf(imageId));
            }
        }
        newArticle.setContent(contentDocument.formattedString());
    }

    @Deprecated
    protected Map<String, LocalizedValue> createFieldsValuesMap(Element parentElement) {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)parentElement.attributeValue("default-locale"));
        return this.createFieldsValuesMap(parentElement, defaultLocale);
    }

    protected Map<String, LocalizedValue> createFieldsValuesMap(Element parentElement, Locale defaultLocale) {
        HashMap<String, LocalizedValue> fieldsValuesMap = new HashMap<String, LocalizedValue>();
        List dynamicElementElements = parentElement.elements("dynamic-element");
        LocalizedValue fieldLocalizedValue = new LocalizedValue(defaultLocale);
        for (Element dynamicElementElement : dynamicElementElements) {
            String fieldName = dynamicElementElement.attributeValue("name", "");
            List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
            for (Element dynamicContentElement : dynamicContentElements) {
                String languageId = dynamicContentElement.attributeValue("language-id");
                String value = dynamicContentElement.getText();
                fieldLocalizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), value);
            }
            fieldsValuesMap.put(fieldName, fieldLocalizedValue);
            fieldsValuesMap.putAll(this.createFieldsValuesMap(dynamicElementElement, defaultLocale));
        }
        return fieldsValuesMap;
    }

    protected Map<String, LocalizedValue> createFieldsValuesMap(String content) {
        try {
            com.liferay.portal.kernel.xml.Document document = SAXReaderUtil.read((String)content);
            Element rootElement = document.getRootElement();
            Locale defaultLocale = LocaleUtil.fromLanguageId((String)rootElement.attributeValue("default-locale"));
            return this.createFieldsValuesMap(rootElement, defaultLocale);
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
    }

    protected JournalArticle fetchLatestLiveArticle(JournalArticle article) throws PortalException {
        Group group = this.groupLocalService.getGroup(article.getGroupId());
        long liveGroupId = group.getLiveGroupId();
        if (liveGroupId == 0L) {
            return null;
        }
        JournalArticleResource articleResource = this.journalArticleResourceLocalService.fetchJournalArticleResourceByUuidAndGroupId(article.getArticleResourceUuid(), liveGroupId);
        if (articleResource == null) {
            return null;
        }
        return this.journalArticleLocalService.fetchLatestArticle(articleResource.getResourcePrimKey(), -1, false);
    }

    protected void format(User user, long groupId, String articleId, double version, boolean incrementVersion, Element root, Map<String, byte[]> images) throws PortalException {
        for (Element element : root.elements()) {
            String elInstanceId = element.attributeValue("instance-id", "");
            String elType = element.attributeValue("type", "");
            if (elType.equals("document_library")) {
                this.formatDocumentLibrary(element);
            } else if (elType.equals("image")) {
                String elName = element.attributeValue("name", "");
                this.formatImage(groupId, articleId, version, incrementVersion, element, elInstanceId, elName, images);
            } else if (elType.equals("text_area") || elType.equals("text") || elType.equals("text_box")) {
                List dynamicContentElements = element.elements("dynamic-content");
                for (Element dynamicContentElement : dynamicContentElements) {
                    String dynamicContent = dynamicContentElement.getText();
                    if (!Validator.isNotNull((String)dynamicContent)) continue;
                    String contentType = "text/plain";
                    if (elType.equals("text_area")) {
                        contentType = "text/html";
                    }
                    dynamicContent = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)groupId, (long)user.getUserId(), (String)JournalArticle.class.getName(), (long)0L, (String)contentType, (String)dynamicContent);
                    dynamicContentElement.clearContent();
                    dynamicContentElement.addCDATA(dynamicContent);
                }
            }
            this.format(user, groupId, articleId, version, incrementVersion, element, images);
        }
    }

    protected String format(User user, long groupId, String articleId, double version, boolean incrementVersion, String content, Map<String, byte[]> images) throws PortalException {
        com.liferay.portal.kernel.xml.Document document = null;
        try {
            document = SAXReaderUtil.read((String)content);
            Element rootElement = document.getRootElement();
            this.format(user, groupId, articleId, version, incrementVersion, rootElement, images);
            content = XMLUtil.formatXML((com.liferay.portal.kernel.xml.Document)document);
        }
        catch (DocumentException de) {
            _log.error((Object)de, (Throwable)de);
        }
        return content;
    }

    protected void formatDocumentLibrary(Element dynamicElementElement) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        for (Element dynamicContentElement : dynamicElementElement.elements("dynamic-content")) {
            this.formatDocumentLibraryDynamicContent(dynamicContentElement);
        }
    }

    protected void formatDocumentLibraryDynamicContent(Element dynamicContentElement) throws PortalException {
        String value = dynamicContentElement.getText();
        if (Validator.isNull((String)value)) {
            return;
        }
        String previewURLPrefix = PortalUtil.getPathContext() + "/documents/";
        if (value.startsWith(previewURLPrefix)) {
            return;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)value);
        String data = jsonObject.getString("data");
        if (Validator.isNotNull((String)data)) {
            dynamicContentElement.clearContent();
            dynamicContentElement.addCDATA(data);
            return;
        }
        FileEntry fileEntry = null;
        String fileEntryId = jsonObject.getString("fileEntryId");
        if (Validator.isNotNull((String)fileEntryId)) {
            fileEntry = this.dlAppLocalService.getFileEntry(GetterUtil.getLong((String)fileEntryId));
        } else {
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            fileEntry = this.dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
        }
        boolean tempFile = jsonObject.getBoolean("tempFile");
        if (tempFile) {
            String fileEntryName = DLUtil.getUniqueFileName((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getFileName());
            fileEntry = this.dlAppLocalService.addFileEntry(fileEntry.getUserId(), fileEntry.getGroupId(), 0L, fileEntryName, fileEntry.getMimeType(), fileEntryName, "", "", fileEntry.getContentStream(), fileEntry.getSize(), new ServiceContext());
        }
        String previewURL = DLUtil.getPreviewURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)true);
        dynamicContentElement.clearContent();
        if (Validator.isNull((String)fileEntryId)) {
            dynamicContentElement.addAttribute("fileEntryId", String.valueOf(fileEntry.getFileEntryId()));
        }
        dynamicContentElement.addCDATA(previewURL);
    }

    protected void formatImage(long groupId, String articleId, double version, boolean incrementVersion, Element el, String elInstanceId, String elName, Map<String, byte[]> images) throws PortalException {
        List imageContents = el.elements("dynamic-content");
        for (Element dynamicContent : imageContents) {
            long defaultImageId;
            Image defaultImage;
            JSONObject jsonObject;
            String fileEntryId;
            String dynamicContentText;
            String elType;
            block20: {
                elType = dynamicContent.attributeValue("type", "");
                dynamicContentText = dynamicContent.getText();
                fileEntryId = dynamicContent.attributeValue("fileEntryId", "");
                jsonObject = JSONFactoryUtil.createJSONObject();
                if (Validator.isNull((String)fileEntryId) && Validator.isNotNull((String)dynamicContentText)) {
                    try {
                        jsonObject = JSONFactoryUtil.createJSONObject((String)dynamicContentText);
                        fileEntryId = jsonObject.getString("fileEntryId");
                    }
                    catch (JSONException jsone) {
                        if (!_log.isDebugEnabled()) break block20;
                        _log.debug((Object)"Unable to parse JSON", (Throwable)jsone);
                    }
                }
            }
            dynamicContent.addAttribute("fileEntryId", fileEntryId);
            if (elType.equals("document")) {
                if (ExportImportThreadLocal.isImportInProcess()) continue;
                this.formatDocumentLibraryDynamicContent(dynamicContent);
                continue;
            }
            String elLanguage = dynamicContent.attributeValue("language-id", "");
            if (!elLanguage.equals("")) {
                elLanguage = "_" + elLanguage;
            }
            long imageId = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, version, elInstanceId, elName, elLanguage);
            if (Validator.isNull((String)dynamicContentText) || dynamicContentText.equals("delete")) {
                dynamicContent.setText("");
                this.journalArticleImageLocalService.deleteArticleImage(imageId);
                String defaultElLanguage = "";
                if (Validator.isNull((String)elLanguage)) {
                    defaultElLanguage = "_" + LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
                }
                long defaultImageId2 = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, version, elInstanceId, elName, defaultElLanguage);
                this.journalArticleImageLocalService.deleteArticleImage(defaultImageId2);
                continue;
            }
            String imageTitle = dynamicContent.attributeValue("title");
            String elContent = StringBundler.concat((String[])new String[]{"/image/journal/article?img_id=", String.valueOf(imageId), "&t=", WebServerServletTokenUtil.getToken((long)imageId), "&fileName=", imageTitle});
            byte[] bytes = null;
            if (images != null) {
                bytes = images.get(StringBundler.concat((String[])new String[]{elInstanceId, "_", elName, elLanguage}));
            }
            if (ArrayUtil.isNotEmpty(bytes)) {
                dynamicContent.setText(elContent);
                dynamicContent.addAttribute("id", String.valueOf(imageId));
                this.imageLocalService.updateImage(imageId, bytes);
                continue;
            }
            if (version > 1.0 && incrementVersion) {
                long oldImageId = 0L;
                if (incrementVersion) {
                    oldImageId = GetterUtil.getLong((String)HttpUtil.getParameter((String)jsonObject.getString("data"), (String)"img_id", (boolean)false));
                }
                Image oldImage = null;
                if (oldImageId > 0L) {
                    oldImage = this.imageLocalService.getImage(oldImageId);
                }
                if (oldImage != null) {
                    dynamicContent.setText(elContent);
                    dynamicContent.addAttribute("id", String.valueOf(imageId));
                    bytes = oldImage.getTextObj();
                    this.imageLocalService.updateImage(imageId, bytes);
                    continue;
                }
                if (!dynamicContentText.equals("update")) continue;
                dynamicContent.setText("");
                continue;
            }
            Image image = this.imageLocalService.getImage(imageId);
            if (image != null) {
                dynamicContent.setText(elContent);
                dynamicContent.addAttribute("id", String.valueOf(imageId));
                continue;
            }
            if (dynamicContentText.equals("update")) {
                dynamicContent.setText("");
                continue;
            }
            long contentImageId = GetterUtil.getLong((String)HttpUtil.getParameter((String)dynamicContent.getText(), (String)"img_id"));
            if (contentImageId <= 0L) {
                contentImageId = GetterUtil.getLong((String)HttpUtil.getParameter((String)dynamicContent.getText(), (String)"img_id", (boolean)false));
            }
            if (contentImageId > 0L && (image = this.imageLocalService.getImage(contentImageId)) != null) {
                dynamicContent.addAttribute("id", String.valueOf(contentImageId));
                continue;
            }
            String defaultElLanguage = "";
            if (Validator.isNull((String)elLanguage)) {
                defaultElLanguage = "_" + LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            }
            if ((defaultImage = this.imageLocalService.getImage(defaultImageId = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, version, elInstanceId, elName, defaultElLanguage))) != null) {
                dynamicContent.setText(elContent);
                dynamicContent.addAttribute("id", String.valueOf(defaultImageId));
                bytes = defaultImage.getTextObj();
                this.imageLocalService.updateImage(defaultImageId, bytes);
                continue;
            }
            if (!Validator.isNotNull((String)elLanguage)) continue;
            dynamicContent.setText("");
        }
    }

    protected long getArticleCheckInterval() {
        try {
            long companyId = CompanyThreadLocal.getCompanyId();
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, companyId);
            return journalServiceConfiguration.checkInterval();
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    protected Locale getArticleDefaultLocale(String content) {
        String defaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)content);
        if (Validator.isNotNull((String)defaultLanguageId)) {
            return LocaleUtil.fromLanguageId((String)defaultLanguageId);
        }
        return LocaleUtil.getSiteDefault();
    }

    protected JournalArticleDisplay getArticleDisplay(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay, boolean propagateException) throws PortalException {
        String content = null;
        if (page < 1) {
            page = 1;
        }
        int numberOfPages = 1;
        boolean paginate = false;
        boolean pageFlow = false;
        boolean cacheable = true;
        Map<String, String> tokens = JournalUtil.getTokens(article.getGroupId(), portletRequestModel, themeDisplay);
        if (themeDisplay == null && portletRequestModel == null) {
            tokens.put("company_id", String.valueOf(article.getCompanyId()));
            Group companyGroup = this.groupLocalService.getCompanyGroup(article.getCompanyId());
            tokens.put("article_group_id", String.valueOf(article.getGroupId()));
            tokens.put("company_group_id", String.valueOf(companyGroup.getGroupId()));
            tokens.put("group_id", String.valueOf(article.getGroupId()));
        }
        tokens.put("class_name_id", String.valueOf(this.classNameLocalService.getClassNameId(DDMStructure.class)));
        tokens.put("article_resource_pk", String.valueOf(article.getResourcePrimKey()));
        DDMStructure ddmStructure = article.getDDMStructure();
        tokens.put("ddm_structure_key", String.valueOf(ddmStructure.getStructureKey()));
        tokens.put("ddm_structure_id", String.valueOf(ddmStructure.getStructureId()));
        tokens.put("structure_id", article.getDDMStructureKey());
        String defaultDDMTemplateKey = article.getDDMTemplateKey();
        if (Validator.isNull((String)ddmTemplateKey)) {
            ddmTemplateKey = defaultDDMTemplateKey;
        }
        com.liferay.portal.kernel.xml.Document document = article.getDocument();
        Element rootElement = (document = document.clone()).getRootElement();
        List pages = rootElement.elements("page");
        if (!pages.isEmpty()) {
            String[] values;
            pageFlow = true;
            String targetPage = null;
            Map parameters = portletRequestModel.getParameters();
            if (parameters != null && (values = (String[])parameters.get("targetPage")) != null && values.length > 0) {
                targetPage = values[0];
            }
            Element pageElement = null;
            if (Validator.isNotNull(targetPage)) {
                targetPage = HtmlUtil.escapeXPathAttribute(targetPage);
                XPath xPathSelector = SAXReaderUtil.createXPath((String)("/root/page[@id = " + targetPage + "]"));
                pageElement = (Element)xPathSelector.selectSingleNode((Object)document);
            }
            if (pageElement != null) {
                document = SAXReaderUtil.createDocument(pageElement);
                rootElement = document.getRootElement();
                numberOfPages = pages.size();
            } else {
                if (page > pages.size()) {
                    page = 1;
                }
                pageElement = (Element)pages.get(page - 1);
                document = SAXReaderUtil.createDocument((Element)pageElement);
                rootElement = document.getRootElement();
                numberOfPages = pages.size();
                paginate = true;
            }
        }
        JournalUtil.addAllReservedEls(rootElement, tokens, article, languageId, themeDisplay);
        try {
            JournalServiceConfiguration journalServiceConfiguration;
            String[] pieces;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Transforming ", article.getArticleId(), " ", String.valueOf(article.getVersion()), " ", languageId}));
            }
            DDMTemplate ddmTemplate = null;
            try {
                ddmTemplate = this.ddmTemplateLocalService.getTemplate(PortalUtil.getSiteGroupId((long)article.getGroupId()), this.classNameLocalService.getClassNameId(DDMStructure.class), ddmTemplateKey, true);
                Group companyGroup = this.groupLocalService.getCompanyGroup(article.getCompanyId());
                if (companyGroup.getGroupId() == ddmTemplate.getGroupId()) {
                    tokens.put("company_group_id", String.valueOf(companyGroup.getGroupId()));
                }
            }
            catch (NoSuchTemplateException nste) {
                if (!defaultDDMTemplateKey.equals(ddmTemplateKey)) {
                    ddmTemplate = this.ddmTemplateLocalService.getTemplate(PortalUtil.getSiteGroupId((long)article.getGroupId()), this.classNameLocalService.getClassNameId(DDMStructure.class), defaultDDMTemplateKey);
                }
                throw nste;
            }
            tokens.put("ddm_template_key", String.valueOf(ddmTemplate.getTemplateKey()));
            tokens.put("ddm_template_id", String.valueOf(ddmTemplate.getTemplateId()));
            tokens.put("template_id", ddmTemplateKey);
            String script = ddmTemplate.getScript();
            String langType = ddmTemplate.getLanguage();
            cacheable = ddmTemplate.isCacheable();
            content = JournalUtil.transform(themeDisplay, tokens, viewMode, languageId, document, portletRequestModel, script, langType, propagateException);
            if (!pageFlow && (pieces = StringUtil.split((String)content, (String)(journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, article.getCompanyId())).journalArticlePageBreakToken())).length > 1) {
                if (page > pieces.length) {
                    page = 1;
                }
                content = pieces[page - 1];
                numberOfPages = pieces.length;
                paginate = true;
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        return new JournalArticleDisplayImpl(article.getCompanyId(), article.getId(), article.getResourcePrimKey(), article.getGroupId(), article.getUserId(), article.getArticleId(), article.getVersion(), article.getTitle(languageId), article.getUrlTitle(), article.getDescription(languageId), article.getAvailableLanguageIds(), content, article.getDDMStructureKey(), ddmTemplateKey, article.isSmallImage(), article.getSmallImageId(), article.getSmallImageURL(), numberOfPages, page, paginate, cacheable);
    }

    protected List<ObjectValuePair<Long, Integer>> getArticleVersionStatuses(List<JournalArticle> articles) {
        ArrayList<ObjectValuePair<Long, Integer>> articleVersionStatusOVPs = new ArrayList<ObjectValuePair<Long, Integer>>(articles.size());
        for (JournalArticle article : articles) {
            int status = article.getStatus();
            if (status == 1) {
                status = 2;
            }
            ObjectValuePair articleVersionStatusOVP = new ObjectValuePair((Object)article.getId(), (Object)status);
            articleVersionStatusOVPs.add((ObjectValuePair<Long, Integer>)articleVersionStatusOVP);
        }
        return articleVersionStatusOVPs;
    }

    protected long getClassTypeId(JournalArticle article) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(JournalArticle.class);
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(article.getGroupId(), classNameId, article.getDDMStructureKey(), true);
        return ddmStructure.getStructureId();
    }

    protected JournalArticle getFirstArticle(long groupId, String articleId, int status, OrderByComparator<JournalArticle> orderByComparator) throws PortalException {
        if (status == -1) {
            return this.journalArticlePersistence.findByG_A_NotST_First(groupId, articleId, 8, orderByComparator);
        }
        return this.journalArticlePersistence.findByG_A_ST_First(groupId, articleId, status, orderByComparator);
    }

    protected JournalGroupServiceConfiguration getJournalGroupServiceConfiguration(long groupId) throws ConfigurationException {
        return (JournalGroupServiceConfiguration)this.configurationProvider.getConfiguration(JournalGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.journal"));
    }

    protected double getNextVersion(JournalArticle article) throws PortalException {
        double nextVersion = article.getVersion();
        JournalArticle latestLiveArticle = this.fetchLatestLiveArticle(article);
        if (latestLiveArticle != null && latestLiveArticle.getVersion() > nextVersion) {
            nextVersion = latestLiveArticle.getVersion();
        }
        return MathUtil.format((double)(nextVersion + 0.1), (int)1, (int)1);
    }

    protected String getUniqueUrlTitle(long id, long groupId, String articleId, String title) throws PortalException {
        String urlTitle = JournalUtil.getUrlTitle(id, title);
        return this.getUniqueUrlTitle(groupId, articleId, urlTitle);
    }

    protected String getUniqueUrlTitle(long id, long groupId, String articleId, String title, String oldUrlTitle, ServiceContext serviceContext) throws PortalException {
        String serviceContextUrlTitle = ParamUtil.getString((ServiceContext)serviceContext, (String)"urlTitle");
        String urlTitle = null;
        if (Validator.isNotNull((String)serviceContextUrlTitle)) {
            urlTitle = JournalUtil.getUrlTitle(id, serviceContextUrlTitle);
        } else {
            if (Validator.isNotNull((String)oldUrlTitle)) {
                return oldUrlTitle;
            }
            urlTitle = this.getUniqueUrlTitle(id, groupId, articleId, title);
        }
        JournalArticle urlTitleArticle = this.fetchArticleByUrlTitle(groupId, urlTitle);
        if (urlTitleArticle != null && !Objects.equals(urlTitleArticle.getArticleId(), articleId)) {
            urlTitle = this.getUniqueUrlTitle(id, groupId, articleId, urlTitle);
        }
        return urlTitle;
    }

    @Deprecated
    protected String getURLViewInContext(JournalArticle article, ServiceContext serviceContext) {
        throw new UnsupportedOperationException();
    }

    protected String getURLViewInContext(JournalArticle article, String portletId, ServiceContext serviceContext) {
        String defaultArticleURL = "";
        try {
            defaultArticleURL = PortalUtil.getControlPanelFullURL((long)article.getGroupId(), (String)portletId, null);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        LiferayPortletRequest liferayPortletRequest = serviceContext.getLiferayPortletRequest();
        if (liferayPortletRequest == null) {
            return defaultArticleURL;
        }
        try {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer((Object)article, 1);
            return assetRenderer.getURLViewInContext(liferayPortletRequest, null, defaultArticleURL);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return "";
        }
    }

    protected boolean hasModifiedLatestApprovedVersion(long groupId, String articleId, double version) {
        JournalArticle article = this.fetchLatestArticle(groupId, articleId, 0);
        return article == null || article.getVersion() <= version;
    }

    protected boolean isArticleCommentsEnabled(long companyId) throws PortalException {
        JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, companyId);
        return journalServiceConfiguration.articleCommentsEnabled();
    }

    protected boolean isExpireAllArticleVersions(long companyId) throws PortalException {
        JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, companyId);
        return journalServiceConfiguration.expireAllArticleVersionsEnabled();
    }

    protected boolean isReindexAllArticleVersions() {
        try {
            long companyId = CompanyThreadLocal.getCompanyId();
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, companyId);
            return journalServiceConfiguration.indexAllArticleVersionsEnabled();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    protected void notifySubscribers(long userId, JournalArticle article, String articleURL, String action, ServiceContext serviceContext) throws PortalException {
        if (!article.isApproved() || Validator.isNull((String)articleURL)) {
            return;
        }
        JournalGroupServiceConfiguration journalGroupServiceConfiguration = this.getJournalGroupServiceConfiguration(article.getGroupId());
        String articleTitle = article.getTitle(serviceContext.getLanguageId());
        String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        articleURL = this.getURLViewInContext(article, portletId, serviceContext);
        if (!(action.equals("add") && journalGroupServiceConfiguration.emailArticleAddedEnabled() || action.equals("move_to") && journalGroupServiceConfiguration.emailArticleMovedToFolderEnabled() || action.equals("move_from") && journalGroupServiceConfiguration.emailArticleMovedFromFolderEnabled() || action.equals("update") && journalGroupServiceConfiguration.emailArticleUpdatedEnabled())) {
            return;
        }
        GroupSubscriptionCheckSubscriptionSender subscriptionSender = new GroupSubscriptionCheckSubscriptionSender("com.liferay.journal");
        subscriptionSender.setClassName(article.getModelClassName());
        subscriptionSender.setClassPK(article.getId());
        subscriptionSender.setCompanyId(article.getCompanyId());
        subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), article.getGroupId());
        JournalFolder folder = this.journalFolderPersistence.fetchByPrimaryKey(article.getFolderId());
        if (folder != null) {
            subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), folder.getFolderId());
            for (Long ancestorFolderId : folder.getAncestorFolderIds()) {
                subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), ancestorFolderId.longValue());
            }
        }
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(article.getGroupId(), this.classNameLocalService.getClassNameId(JournalArticle.class), article.getDDMStructureKey(), true);
        subscriptionSender.addPersistedSubscribers(DDMStructure.class.getName(), ddmStructure.getStructureId());
        subscriptionSender.addPersistedSubscribers(JournalArticle.class.getName(), article.getResourcePrimKey());
        if (!subscriptionSender.hasSubscribers()) {
            return;
        }
        String fromName = journalGroupServiceConfiguration.emailFromName();
        String fromAddress = journalGroupServiceConfiguration.emailFromAddress();
        Map localizedSubjectMap = null;
        Map localizedBodyMap = null;
        if (action.equals("add")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleAddedSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleAddedBody());
        } else if (action.equals("move_to")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleMovedToFolderSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleMovedToFolderBody());
        } else if (action.equals("move_from")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleMovedFromFolderSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleMovedFromFolderBody());
        } else if (action.equals("update")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleUpdatedSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleUpdatedBody());
        }
        String articleContent = "";
        String articleDiffs = "";
        JournalArticle previousApprovedArticle = this.getPreviousApprovedArticle(article);
        try {
            PortletRequestModel portletRequestModel = null;
            if (!ExportImportThreadLocal.isImportInProcess()) {
                portletRequestModel = new PortletRequestModel((PortletRequest)serviceContext.getLiferayPortletRequest(), (PortletResponse)serviceContext.getLiferayPortletResponse());
            }
            JournalArticleDisplay articleDisplay = this.getArticleDisplay(article, null, "view", LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), 1, portletRequestModel, serviceContext.getThemeDisplay());
            articleContent = articleDisplay.getContent();
            articleDiffs = JournalUtil.diffHtml(article.getGroupId(), article.getArticleId(), previousApprovedArticle.getVersion(), article.getVersion(), LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), portletRequestModel, serviceContext.getThemeDisplay());
        }
        catch (Exception portletRequestModel) {
            // empty catch block
        }
        subscriptionSender.setContextAttribute("[$ARTICLE_CONTENT$]", (Object)articleContent, false);
        subscriptionSender.setContextAttribute("[$ARTICLE_DIFFS$]", (Object)DiffHtmlUtil.replaceStyles((String)articleDiffs), false);
        String folderName = "";
        if (folder != null) {
            folderName = folder.getName();
            if (folder.getFolderId() == 0L && Validator.isNull((String)folderName)) {
                folderName = LanguageUtil.get((Locale)LocaleUtil.getSiteDefault(), (String)"home");
            }
        }
        subscriptionSender.setContextAttributes(new Object[]{"[$ARTICLE_ID$]", article.getArticleId(), "[$ARTICLE_TITLE$]", articleTitle, "[$ARTICLE_URL$]", articleURL, "[$ARTICLE_VERSION$]", article.getVersion(), "[$FOLDER_NAME$]", folderName});
        subscriptionSender.setContextCreatorUserPrefix("ARTICLE");
        subscriptionSender.setCreatorUserId(article.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(articleTitle);
        subscriptionSender.setEntryURL(articleURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("journal_article", new Object[]{article.getId()});
        int notificationType = 0;
        if (serviceContext.isCommandUpdate()) {
            notificationType = 1;
        }
        subscriptionSender.setNotificationType(notificationType);
        subscriptionSender.setPortletId(portletId);
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(article.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void saveImages(boolean smallImage, long smallImageId, File smallImageFile, byte[] smallImageBytes) throws PortalException {
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                this.imageLocalService.updateImage(smallImageId, smallImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(smallImageId);
        }
    }

    protected BaseModelSearchResult<JournalArticle> searchJournalArticles(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, JournalUtil.SELECTED_FIELD_NAMES);
            List<JournalArticle> articles = JournalUtil.getArticles(hits);
            if (articles == null) continue;
            return new BaseModelSearchResult(articles, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    @Deprecated
    protected void sendEmail(JournalArticle article, String articleURL, PortletPreferences preferences, String emailType, ServiceContext serviceContext) throws PortalException {
        this.sendEmail(article, articleURL, emailType, serviceContext);
    }

    protected void sendEmail(JournalArticle article, String articleURL, String emailType, ServiceContext serviceContext) throws PortalException {
        JournalGroupServiceConfiguration journalGroupServiceConfiguration = this.getJournalGroupServiceConfiguration(article.getGroupId());
        if (!(emailType.equals("denied") && journalGroupServiceConfiguration.emailArticleApprovalDeniedEnabled() || emailType.equals("granted") && journalGroupServiceConfiguration.emailArticleApprovalGrantedEnabled() || emailType.equals("requested") && journalGroupServiceConfiguration.emailArticleApprovalRequestedEnabled() || emailType.equals("review") && journalGroupServiceConfiguration.emailArticleReviewEnabled())) {
            return;
        }
        Company company = this.companyLocalService.getCompany(article.getCompanyId());
        User user = this.userLocalService.getUser(article.getUserId());
        String fromName = journalGroupServiceConfiguration.emailFromName();
        String fromAddress = journalGroupServiceConfiguration.emailFromAddress();
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        if (emailType.equals("requested")) {
            String tempToName = fromName;
            String tempToAddress = fromAddress;
            fromName = toName;
            fromAddress = toAddress;
            toName = tempToName;
            toAddress = tempToAddress;
        }
        Map localizedSubjectMap = null;
        Map localizedBodyMap = null;
        if (emailType.equals("denied")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleApprovalDeniedSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleApprovalDeniedBody());
        } else if (emailType.equals("granted")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleApprovalGrantedSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleApprovalGrantedBody());
        } else if (emailType.equals("requested")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleApprovalGrantedSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleApprovalGrantedBody());
        } else if (emailType.equals("review")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleReviewSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleReviewBody());
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setCompanyId(company.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$ARTICLE_ID$]", article.getArticleId(), "[$ARTICLE_TITLE$]", article.getTitle(serviceContext.getLanguageId()), "[$ARTICLE_URL$]", articleURL, "[$ARTICLE_USER_NAME$]", article.getUserName(), "[$ARTICLE_VERSION$]", article.getVersion()});
        subscriptionSender.setContextCreatorUserPrefix("ARTICLE");
        subscriptionSender.setCreatorUserId(article.getUserId());
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("journal_article", new Object[]{article.getId()});
        String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        subscriptionSender.setPortletId(portletId);
        subscriptionSender.setScopeGroupId(article.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void setArticlesExpirationDate(JournalArticle article) {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        if (!article.isApproved() || article.getExpirationDate() == null) {
            return;
        }
        final List articles = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
        final Date expirationDate = article.getExpirationDate();
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (JournalArticle curArticle : articles) {
                    curArticle.setExpirationDate(expirationDate);
                    JournalArticleLocalServiceImpl.this.journalArticleLocalService.updateJournalArticle(curArticle);
                }
                return null;
            }
        });
    }

    protected void startWorkflowInstance(long userId, JournalArticle article, ServiceContext serviceContext) throws PortalException {
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        workflowContext.put("url", PortalUtil.getControlPanelFullURL((long)article.getGroupId(), (String)portletId, null));
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)article.getCompanyId(), (long)article.getGroupId(), (long)userId, (String)JournalArticle.class.getName(), (long)article.getId(), (Object)article, (ServiceContext)serviceContext, workflowContext);
    }

    protected void updateDDMFormFieldPredefinedValue(DDMFormField ddmFormField, LocalizedValue ddmFormFieldValue) {
        DDMForm ddmForm = ddmFormField.getDDMForm();
        Set ddmFormAvailableLocales = ddmForm.getAvailableLocales();
        ddmFormField.setPredefinedValue(ddmFormFieldValue);
        ddmFormAvailableLocales.addAll(ddmFormFieldValue.getAvailableLocales());
        for (Locale locale : ddmFormAvailableLocales) {
            LocalizedValue tip;
            Map tipValues;
            LocalizedValue style;
            Map styleValues;
            LocalizedValue label = ddmFormField.getLabel();
            Map labelValues = label.getValues();
            if (!labelValues.containsKey(locale)) {
                label.addString(locale, label.getString(label.getDefaultLocale()));
            }
            if (!(styleValues = (style = ddmFormField.getStyle()).getValues()).containsKey(locale)) {
                style.addString(locale, style.getString(style.getDefaultLocale()));
            }
            if ((tipValues = (tip = ddmFormField.getTip()).getValues()).containsKey(locale)) continue;
            tip.addString(locale, tip.getString(tip.getDefaultLocale()));
        }
    }

    protected void updateDDMLinks(long id, long groupId, String ddmStructureKey, String ddmTemplateKey, boolean incrementVersion) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(PortalUtil.getSiteGroupId((long)groupId), this.classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.getTemplate(PortalUtil.getSiteGroupId((long)groupId), this.classNameLocalService.getClassNameId(DDMStructure.class), ddmTemplateKey, true);
        if (incrementVersion) {
            this.ddmStorageLinkLocalService.addStorageLink(ddmStructure.getClassNameId(), id, ddmStructure.getStructureId(), new ServiceContext());
            this.ddmTemplateLinkLocalService.addTemplateLink(this.classNameLocalService.getClassNameId(JournalArticle.class), id, ddmTemplate.getTemplateId());
        } else {
            DDMStorageLink ddmStorageLink = this.ddmStorageLinkLocalService.getClassStorageLink(id);
            ddmStorageLink.setStructureId(ddmStructure.getStructureId());
            this.ddmStorageLinkLocalService.updateDDMStorageLink(ddmStorageLink);
            this.ddmTemplateLinkLocalService.updateTemplateLink(this.classNameLocalService.getClassNameId(JournalArticle.class), id, ddmTemplate.getTemplateId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDDMStructurePredefinedValues(long ddmStructureId, String content, ServiceContext serviceContext) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchDDMStructure(ddmStructureId);
        if (ddmStructure == null) {
            return;
        }
        DDMForm ddmForm = ddmStructure.getDDMForm();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Map fullHierarchyDDMFormFieldsMap = ddmStructure.getFullHierarchyDDMFormFieldsMap(true);
        Map<String, LocalizedValue> fieldsValuesMap = this.createFieldsValuesMap(content);
        for (Map.Entry<String, LocalizedValue> fieldValue : fieldsValuesMap.entrySet()) {
            String ddmFormFieldName = fieldValue.getKey();
            LocalizedValue ddmFormFieldValue = fieldValue.getValue();
            if (fullHierarchyDDMFormFieldsMap.containsKey(ddmFormFieldName)) {
                this.updateDDMFormFieldPredefinedValue((DDMFormField)fullHierarchyDDMFormFieldsMap.get(ddmFormFieldName), ddmFormFieldValue);
            }
            if (!ddmFormFieldsMap.containsKey(ddmFormFieldName)) continue;
            this.updateDDMFormFieldPredefinedValue((DDMFormField)ddmFormFieldsMap.get(ddmFormFieldName), ddmFormFieldValue);
        }
        boolean indexingEnabled = serviceContext.isIndexingEnabled();
        try {
            serviceContext.setIndexingEnabled(false);
            this.ddmStructureLocalService.updateStructure(serviceContext.getUserId(), ddmStructureId, ddmForm, ddmStructure.getDDMFormLayout(), serviceContext);
        }
        finally {
            serviceContext.setIndexingEnabled(indexingEnabled);
        }
    }

    protected void updatePreviousApprovedArticle(JournalArticle article) throws PortalException {
        JournalArticle previousApprovedArticle = this.getPreviousApprovedArticle(article);
        if (previousApprovedArticle.getVersion() == article.getVersion()) {
            this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
        } else {
            AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(JournalArticle.class.getName(), article.getResourcePrimKey(), previousApprovedArticle.getDisplayDate(), previousApprovedArticle.getExpirationDate(), this.isListable(article), true);
            assetEntry.setModifiedDate(previousApprovedArticle.getModifiedDate());
            assetEntry.setTitle(previousApprovedArticle.getTitle());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected void updateUrlTitles(long groupId, String articleId, String urlTitle) throws PortalException {
        JournalArticle firstArticle = this.journalArticlePersistence.findByG_A_First(groupId, articleId, (OrderByComparator)new ArticleVersionComparator(false));
        String firstArticleUrlTitle = firstArticle.getUrlTitle();
        if (firstArticleUrlTitle.equals(urlTitle)) {
            return;
        }
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId);
        for (JournalArticle article : articles) {
            String curArticleUrlTitle = article.getUrlTitle();
            if (curArticleUrlTitle.equals(urlTitle)) continue;
            article.setUrlTitle(urlTitle);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    protected void validate(long companyId, long groupId, long classNameId, Map<Locale, String> titleMap, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDate, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, ServiceContext serviceContext) throws PortalException {
        Locale articleDefaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)content));
        if (!ExportImportThreadLocal.isImportInProcess()) {
            if (!LanguageUtil.isAvailableLocale((long)groupId, (Locale)articleDefaultLocale)) {
                LocaleException le = new LocaleException(3, StringBundler.concat((String[])new String[]{"The locale ", String.valueOf(articleDefaultLocale), " is not available in site with groupId", String.valueOf(groupId)}));
                le.setSourceAvailableLocales(Collections.singleton(articleDefaultLocale));
                le.setTargetAvailableLocales((Collection)LanguageUtil.getAvailableLocales((long)groupId));
                throw le;
            }
            if (expirationDate != null && (expirationDate.before(new Date()) || displayDate != null && expirationDate.before(displayDate))) {
                throw new ArticleExpirationDateException("Expiration date " + expirationDate + " is in the past");
            }
        }
        if (classNameId == 0L && (titleMap.isEmpty() || Validator.isNull((String)titleMap.get(articleDefaultLocale)))) {
            throw new ArticleTitleException("Title is null");
        }
        this.validateContent(content);
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(PortalUtil.getSiteGroupId((long)groupId), this.classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        this.validateDDMStructureFields(ddmStructure, classNameId, content, articleDefaultLocale);
        if (Validator.isNotNull((String)ddmTemplateKey)) {
            DDMTemplate ddmTemplate = this.ddmTemplateLocalService.getTemplate(PortalUtil.getSiteGroupId((long)groupId), this.classNameLocalService.getClassNameId(DDMStructure.class), ddmTemplateKey, true);
            if (ddmTemplate.getClassPK() != ddmStructure.getStructureId()) {
                throw new NoSuchTemplateException("{templateKey=" + ddmTemplateKey + "}");
            }
        } else if (classNameId == 0L) {
            throw new NoSuchTemplateException("DDM template key is null");
        }
        String[] imageExtensions = PrefsPropsUtil.getStringArray((String)"journal.image.extensions", (String)",");
        if (!smallImage || Validator.isNotNull((String)smallImageURL) || smallImageFile == null || smallImageBytes == null) {
            return;
        }
        String smallImageName = smallImageFile.getName();
        boolean validSmallImageExtension = false;
        for (String imageExtension : imageExtensions) {
            if (!"*".equals(imageExtension) && !StringUtil.endsWith((String)smallImageName, (String)imageExtension)) continue;
            validSmallImageExtension = true;
            break;
        }
        if (!validSmallImageExtension) {
            throw new ArticleSmallImageNameException(smallImageName);
        }
        long smallImageMaxSize = PrefsPropsUtil.getLong((String)"journal.image.small.max.size");
        if (smallImageMaxSize > 0L && (long)smallImageBytes.length > smallImageMaxSize) {
            throw new ArticleSmallImageSizeException(smallImageBytes.length + " exceeds " + smallImageMaxSize);
        }
    }

    protected void validate(long companyId, long groupId, long classNameId, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDate, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, ServiceContext serviceContext) throws PortalException {
        List articles;
        if (!autoArticleId) {
            this.validate(articleId);
        }
        if (!(ExportImportThreadLocal.isImportInProcess() && !autoArticleId || (articles = this.journalArticlePersistence.findByG_A(groupId, articleId)).isEmpty())) {
            StringBundler sb = new StringBundler(7);
            sb.append("{groupId=");
            sb.append(groupId);
            sb.append(", articleId=");
            sb.append(articleId);
            sb.append(", version=");
            sb.append(version);
            sb.append("}");
            throw new DuplicateArticleIdException(sb.toString());
        }
        this.validate(companyId, groupId, classNameId, titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
    }

    protected void validate(String articleId) throws PortalException {
        if (Validator.isNull((String)articleId) || articleId.indexOf(44) != -1 || articleId.indexOf(32) != -1) {
            throw new ArticleIdException("Invalid articleId: " + articleId);
        }
    }

    protected void validateContent(String content) throws PortalException {
        if (Validator.isNull((String)content)) {
            throw new ArticleContentException("Content is null");
        }
        try {
            SAXReaderUtil.read((String)content);
        }
        catch (DocumentException de) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalid content:\n" + content));
            }
            throw new ArticleContentException("Unable to read content with an XML parser", (Throwable)de);
        }
    }

    protected void validateDDMStructureFields(DDMStructure ddmStructure, long classNameId, Fields fields, Locale defaultlocale) throws PortalException {
        for (Field field : fields) {
            if (!ddmStructure.hasField(field.getName())) {
                throw new StorageFieldNameException("No field exists for {name=" + field.getName() + "}");
            }
            if (!ddmStructure.getFieldRequired(field.getName()) || !Validator.isNull((Object)field.getValue(defaultlocale)) || classNameId != 0L) continue;
            StringBundler sb = new StringBundler(6);
            sb.append("Required field ");
            sb.append(field.getName());
            sb.append(" is not present for structure ");
            sb.append(ddmStructure.getNameCurrentValue());
            sb.append(" for locale ");
            sb.append((Object)defaultlocale);
            throw new StorageFieldRequiredException(sb.toString());
        }
    }

    protected void validateDDMStructureFields(DDMStructure ddmStructure, long classNameId, String content, Locale defaultlocale) throws PortalException {
        Fields fields = this.journalConverter.getDDMFields(ddmStructure, content);
        this.validateDDMStructureFields(ddmStructure, classNameId, fields, defaultlocale);
    }

    protected void validateDDMStructureId(long groupId, long folderId, String ddmStructureKey) throws PortalException {
        int restrictionType = JournalUtil.getRestrictionType(folderId);
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(PortalUtil.getSiteGroupId((long)groupId), this.classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        List folderDDMStructures = this.journalFolderLocalService.getDDMStructures(PortalUtil.getCurrentAndAncestorSiteGroupIds((long)groupId), folderId, restrictionType);
        for (DDMStructure folderDDMStructure : folderDDMStructures) {
            if (folderDDMStructure.getStructureId() != ddmStructure.getStructureId()) continue;
            return;
        }
        throw new InvalidDDMStructureException(StringBundler.concat((String[])new String[]{"Invalid structure ", String.valueOf(ddmStructure.getStructureId()), " for folder ", String.valueOf(folderId)}));
    }

    protected void validateReferences(long groupId, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, boolean smallImage, String smallImageURL, byte[] smallImageBytes, long smallImageId, String content) throws PortalException {
        Image image;
        Layout layout;
        DDMTemplate ddmTemplate;
        DDMStructure ddmStructure;
        long classNameId = this.classNameLocalService.getClassNameId(JournalArticle.class.getName());
        if (Validator.isNotNull((String)ddmStructureKey) && (ddmStructure = this.ddmStructureLocalService.fetchStructure(groupId, classNameId, ddmStructureKey, true)) == null) {
            throw new NoSuchStructureException();
        }
        classNameId = this.classNameLocalService.getClassNameId(DDMStructure.class.getName());
        if (Validator.isNotNull((String)ddmTemplateKey) && (ddmTemplate = this.ddmTemplateLocalService.fetchTemplate(groupId, classNameId, ddmTemplateKey, true)) == null) {
            throw new NoSuchTemplateException();
        }
        if (Validator.isNotNull((String)layoutUuid) && (layout = JournalUtil.getArticleLayout(layoutUuid, groupId)) == null) {
            throw new NoSuchLayoutException("display-page");
        }
        if (smallImage && Validator.isNull((String)smallImageURL) && ArrayUtil.isEmpty((byte[])smallImageBytes) && (image = this.imageLocalService.fetchImage(smallImageId)) == null) {
            throw new NoSuchImageException();
        }
        ExportImportContentProcessor exportImportContentProcessor = ExportImportContentProcessorRegistryUtil.getExportImportContentProcessor((String)JournalArticle.class.getName());
        exportImportContentProcessor.validateContentReferences(groupId, (Serializable)((Object)content));
    }

    @Deprecated
    protected void validateReferences(long groupId, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, boolean smallImage, String smallImageURL, byte[] smallImageBytes, String content) throws PortalException {
        this.validateReferences(groupId, ddmStructureKey, ddmTemplateKey, layoutUuid, smallImage, smallImageURL, smallImageBytes, 0L, content);
    }

    private boolean _addDraftAssetEntry(JournalArticle journalArticle) {
        if (journalArticle.isApproved()) {
            return false;
        }
        if (journalArticle.getVersion() == 1.0) {
            return false;
        }
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
        if (assetEntry == null) {
            return false;
        }
        int approvedArticlesCount = this.journalArticlePersistence.countByG_A_ST(journalArticle.getGroupId(), journalArticle.getArticleId(), JournalArticleConstants.ASSET_ENTRY_CREATION_STATUSES);
        return approvedArticlesCount != 0;
    }

    private long _countSimilarURLTitles(long groupId, String urlTitle) {
        DynamicQuery dynamicQuery = this.dynamicQuery();
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        Property urlTitleProperty = PropertyFactoryUtil.forName((String)"urlTitle");
        dynamicQuery.setProjection(ProjectionFactoryUtil.countDistinct((String)"resourcePrimKey"));
        dynamicQuery.add(groupIdProperty.eq((Object)groupId));
        dynamicQuery.add(urlTitleProperty.like((Object)(urlTitle + "%")));
        List results = this.dynamicQuery(dynamicQuery);
        if (results.isEmpty()) {
            return 0L;
        }
        return (Long)results.get(0);
    }

    private String _fetchArticleIdByURLTitle(long groupId, String urlTitle) {
        DynamicQuery dynamicQuery = this.dynamicQuery();
        Property articleIdProperty = PropertyFactoryUtil.forName((String)"articleId");
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        Property urlTitleProperty = PropertyFactoryUtil.forName((String)"urlTitle");
        dynamicQuery.setProjection(ProjectionFactoryUtil.distinct((Projection)articleIdProperty));
        dynamicQuery.add(groupIdProperty.eq((Object)groupId));
        dynamicQuery.add(urlTitleProperty.eq((Object)urlTitle));
        List articleIds = this.dynamicQuery(dynamicQuery);
        if (articleIds.isEmpty()) {
            return null;
        }
        return (String)articleIds.get(0);
    }
}

