/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.impl;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.base.JournalArticleServiceBaseImpl;
import com.liferay.journal.service.permission.JournalArticlePermission;
import com.liferay.journal.service.permission.JournalFolderPermission;
import com.liferay.journal.service.permission.JournalPermission;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class JournalArticleServiceImpl
extends JournalArticleServiceBaseImpl {
    public JournalArticle addArticle(long groupId, long folderId, long classNameId, long classPK, String articleId, boolean autoArticleId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_ARTICLE");
        return this.journalArticleLocalService.addArticle(this.getUserId(), groupId, folderId, classNameId, classPK, articleId, autoArticleId, 1.0, titleMap, descriptionMap, content, ddmStructureKey, ddmTemplateKey, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, smallFile, images, articleURL, serviceContext);
    }

    public JournalArticle addArticle(long groupId, long folderId, long classNameId, long classPK, String articleId, boolean autoArticleId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_ARTICLE");
        return this.journalArticleLocalService.addArticle(this.getUserId(), groupId, folderId, classNameId, classPK, articleId, autoArticleId, 1.0, titleMap, descriptionMap, content, ddmStructureKey, ddmTemplateKey, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, false, null, null, null, articleURL, serviceContext);
    }

    public JournalArticle addArticle(long groupId, long folderId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, ServiceContext serviceContext) throws PortalException {
        JournalFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_ARTICLE");
        return this.journalArticleLocalService.addArticle(this.getUserId(), groupId, folderId, titleMap, descriptionMap, content, ddmStructureKey, ddmTemplateKey, serviceContext);
    }

    public JournalArticle copyArticle(long groupId, String oldArticleId, String newArticleId, boolean autoArticleId, double version) throws PortalException {
        JournalArticle article = this.getArticle(groupId, oldArticleId);
        JournalFolderPermission.check(this.getPermissionChecker(), groupId, article.getFolderId(), "ADD_ARTICLE");
        return this.journalArticleLocalService.copyArticle(this.getUserId(), groupId, oldArticleId, newArticleId, autoArticleId, version);
    }

    public void deleteArticle(long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "DELETE");
        this.journalArticleLocalService.deleteArticle(groupId, articleId, version, articleURL, serviceContext);
    }

    public void deleteArticle(long groupId, String articleId, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "DELETE");
        this.journalArticleLocalService.deleteArticle(groupId, articleId, serviceContext);
    }

    public JournalArticle expireArticle(long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "EXPIRE");
        return this.journalArticleLocalService.expireArticle(this.getUserId(), groupId, articleId, version, articleURL, serviceContext);
    }

    public void expireArticle(long groupId, String articleId, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "EXPIRE");
        this.journalArticleLocalService.expireArticle(this.getUserId(), groupId, articleId, articleURL, serviceContext);
    }

    public JournalArticle fetchArticle(long groupId, String articleId) throws PortalException {
        JournalArticle article = this.journalArticleLocalService.fetchArticle(groupId, articleId);
        if (article != null) {
            JournalArticlePermission.check(this.getPermissionChecker(), article, "VIEW");
        }
        return article;
    }

    public JournalArticle getArticle(long id) throws PortalException {
        JournalArticle article = this.journalArticleLocalService.getArticle(id);
        JournalArticlePermission.check(this.getPermissionChecker(), article, "VIEW");
        return article;
    }

    public JournalArticle getArticle(long groupId, String articleId) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "VIEW");
        return this.journalArticleLocalService.getArticle(groupId, articleId);
    }

    public JournalArticle getArticle(long groupId, String articleId, double version) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "VIEW");
        return this.journalArticleLocalService.getArticle(groupId, articleId, version);
    }

    public JournalArticle getArticle(long groupId, String className, long classPK) throws PortalException {
        JournalArticle article = this.journalArticleLocalService.getArticle(groupId, className, classPK);
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, article.getArticleId(), article.getVersion(), "VIEW");
        return article;
    }

    public JournalArticle getArticleByUrlTitle(long groupId, String urlTitle) throws PortalException {
        JournalArticle article = this.journalArticleLocalService.getArticleByUrlTitle(groupId, urlTitle);
        JournalArticlePermission.check(this.getPermissionChecker(), article, "VIEW");
        return article;
    }

    public String getArticleContent(long groupId, String articleId, double version, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "VIEW");
        return this.journalArticleLocalService.getArticleContent(groupId, articleId, version, null, null, languageId, portletRequestModel, themeDisplay);
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, double version, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "VIEW");
        return this.journalArticleLocalService.getArticleContent(groupId, articleId, version, null, languageId, themeDisplay);
    }

    public String getArticleContent(long groupId, String articleId, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "VIEW");
        return this.journalArticleLocalService.getArticleContent(groupId, articleId, null, null, languageId, portletRequestModel, themeDisplay);
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "VIEW");
        return this.journalArticleLocalService.getArticleContent(groupId, articleId, null, languageId, themeDisplay);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.journalArticleFinder.filterFindByG_F(groupId, folderIds, queryDefinition);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(-1, start, end, obc);
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.journalArticleFinder.filterFindByG_F(groupId, folderIds, queryDefinition);
    }

    public List<JournalArticle> getArticlesByArticleId(long groupId, String articleId, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticlePersistence.filterFindByG_A(groupId, articleId, start, end, obc);
    }

    public List<JournalArticle> getArticlesByLayoutUuid(long groupId, String layoutUuid) {
        return this.journalArticlePersistence.filterFindByG_L(groupId, layoutUuid);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, long classNameId, String ddmStructureKey, int status, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.filterFindByG_C_S(groupId, classNameId, ddmStructureKey, queryDefinition);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, String ddmStructureKey, int status, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.filterFindByG_C_S(groupId, 0L, ddmStructureKey, queryDefinition);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, String ddmStructureKey, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.getArticlesByStructureId(groupId, ddmStructureKey, -1, start, end, obc);
    }

    public int getArticlesCount(long groupId, long folderId) {
        return this.getArticlesCount(groupId, folderId, -1);
    }

    public int getArticlesCount(long groupId, long folderId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.journalArticleFinder.filterCountByG_F(groupId, folderIds, queryDefinition);
    }

    public int getArticlesCountByArticleId(long groupId, String articleId) {
        return this.journalArticlePersistence.filterCountByG_A(groupId, articleId);
    }

    public int getArticlesCountByStructureId(long groupId, long classNameId, String ddmStructureKey, int status) {
        return this.journalArticleFinder.filterCountByG_C_S(groupId, classNameId, ddmStructureKey, new QueryDefinition(status));
    }

    public int getArticlesCountByStructureId(long groupId, String ddmStructureKey) {
        return this.getArticlesCountByStructureId(groupId, ddmStructureKey, -1);
    }

    public int getArticlesCountByStructureId(long groupId, String ddmStructureKey, int status) {
        return this.getArticlesCountByStructureId(groupId, 0L, ddmStructureKey, status);
    }

    public JournalArticle getDisplayArticleByUrlTitle(long groupId, String urlTitle) throws PortalException {
        JournalArticle article = this.journalArticleLocalService.getDisplayArticleByUrlTitle(groupId, urlTitle);
        JournalArticlePermission.check(this.getPermissionChecker(), article, "VIEW");
        return article;
    }

    public int getFoldersAndArticlesCount(long groupId, List<Long> folderIds) {
        return this.journalArticlePersistence.filterCountByG_F(groupId, ArrayUtil.toArray((Long[])folderIds.toArray(new Long[0])));
    }

    public List<JournalArticle> getGroupArticles(long groupId, long userId, long rootFolderId, int status, boolean includeOwner, int start, int end, OrderByComparator<JournalArticle> orderByComparator) throws PortalException {
        List folderIds = new ArrayList();
        if (rootFolderId != 0L) {
            folderIds = this.journalFolderService.getFolderIds(groupId, rootFolderId);
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, userId, includeOwner, start, end, orderByComparator);
        return this.journalArticleFinder.filterFindByG_F_C(groupId, folderIds, 0L, queryDefinition);
    }

    public List<JournalArticle> getGroupArticles(long groupId, long userId, long rootFolderId, int status, int start, int end, OrderByComparator<JournalArticle> orderByComparator) throws PortalException {
        return this.getGroupArticles(groupId, userId, rootFolderId, status, false, start, end, orderByComparator);
    }

    public List<JournalArticle> getGroupArticles(long groupId, long userId, long rootFolderId, int start, int end, OrderByComparator<JournalArticle> orderByComparator) throws PortalException {
        return this.getGroupArticles(groupId, userId, rootFolderId, -1, start, end, orderByComparator);
    }

    public int getGroupArticlesCount(long groupId, long userId, long rootFolderId) throws PortalException {
        return this.getGroupArticlesCount(groupId, userId, rootFolderId, -1);
    }

    public int getGroupArticlesCount(long groupId, long userId, long rootFolderId, int status) throws PortalException {
        return this.getGroupArticlesCount(groupId, userId, rootFolderId, status, false);
    }

    public int getGroupArticlesCount(long groupId, long userId, long rootFolderId, int status, boolean includeOwner) throws PortalException {
        List folderIds = new ArrayList();
        if (rootFolderId != 0L) {
            folderIds = this.journalFolderService.getFolderIds(groupId, rootFolderId);
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, userId, includeOwner);
        return this.journalArticleFinder.filterCountByG_F_C(groupId, folderIds, 0L, queryDefinition);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), resourcePrimKey, "VIEW");
        return this.journalArticleLocalService.getLatestArticle(resourcePrimKey);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId, int status) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, status, "VIEW");
        return this.journalArticleLocalService.getLatestArticle(groupId, articleId, status);
    }

    public JournalArticle getLatestArticle(long groupId, String className, long classPK) throws PortalException {
        JournalArticle article = this.journalArticleLocalService.getLatestArticle(groupId, className, classPK);
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, article.getArticleId(), article.getVersion(), "VIEW");
        return article;
    }

    public List<JournalArticle> getLayoutArticles(long groupId) {
        return this.journalArticlePersistence.filterFindByG_NotL(groupId, new String[]{null, ""});
    }

    @Deprecated
    public void moveArticle(long groupId, String articleId, long newFolderId) throws PortalException {
        this.moveArticle(groupId, articleId, newFolderId, null);
    }

    public void moveArticle(long groupId, String articleId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        JournalFolderPermission.check(this.getPermissionChecker(), groupId, newFolderId, "ADD_ARTICLE");
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId);
        for (JournalArticle article : articles) {
            JournalArticlePermission.check(this.getPermissionChecker(), article, "UPDATE");
            this.journalArticleLocalService.moveArticle(groupId, articleId, newFolderId, serviceContext);
        }
    }

    public JournalArticle moveArticleFromTrash(long groupId, long resourcePrimKey, long newFolderId, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.getLatestArticle(resourcePrimKey);
        JournalArticlePermission.check(this.getPermissionChecker(), article, "UPDATE");
        return this.journalArticleLocalService.moveArticleFromTrash(this.getUserId(), groupId, article, newFolderId, serviceContext);
    }

    public JournalArticle moveArticleFromTrash(long groupId, String articleId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId, 8);
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "UPDATE");
        return this.journalArticleLocalService.moveArticleFromTrash(this.getUserId(), groupId, article, newFolderId, serviceContext);
    }

    public JournalArticle moveArticleToTrash(long groupId, String articleId) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "DELETE");
        return this.journalArticleLocalService.moveArticleToTrash(this.getUserId(), groupId, articleId);
    }

    public void removeArticleLocale(long companyId, String languageId) throws PortalException {
        for (JournalArticle article : this.journalArticlePersistence.findByCompanyId(companyId)) {
            this.removeArticleLocale(article.getGroupId(), article.getArticleId(), article.getVersion(), languageId);
        }
    }

    public JournalArticle removeArticleLocale(long groupId, String articleId, double version, String languageId) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "UPDATE");
        return this.journalArticleLocalService.removeArticleLocale(groupId, articleId, version, languageId);
    }

    public void restoreArticleFromTrash(long resourcePrimKey) throws PortalException {
        JournalArticle article = this.getLatestArticle(resourcePrimKey);
        JournalArticlePermission.check(this.getPermissionChecker(), article, "DELETE");
        this.journalArticleLocalService.restoreArticleFromTrash(this.getUserId(), article);
    }

    public void restoreArticleFromTrash(long groupId, String articleId) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId, 8);
        this.restoreArticleFromTrash(article.getResourcePrimKey());
    }

    public Hits search(long groupId, long creatorUserId, int status, int start, int end) throws PortalException {
        return this.journalArticleLocalService.search(groupId, this.getUserId(), creatorUserId, status, start, end);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String keywords, Double version, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticleFinder.filterFindByKeywords(companyId, groupId, folderIds, classNameId, keywords, version, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, status, reviewDate, start, end, obc);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.filterFindByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, andOperator, queryDefinition);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String[] ddmStructureKeys, String[] ddmTemplateKeys, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.filterFindByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKeys, ddmTemplateKeys, displayDateGT, displayDateLT, reviewDate, andOperator, queryDefinition);
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String keywords, Double version, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate) {
        return this.journalArticleFinder.filterCountByKeywords(companyId, groupId, folderIds, classNameId, keywords, version, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, status, reviewDate);
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) {
        return this.journalArticleFinder.filterCountByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, andOperator, new QueryDefinition(status));
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String[] ddmStructureKeys, String[] ddmTemplateKeys, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) {
        return this.journalArticleFinder.filterCountByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKeys, ddmTemplateKeys, displayDateGT, displayDateLT, reviewDate, andOperator, new QueryDefinition(status));
    }

    public void subscribeStructure(long groupId, long userId, long ddmStructureId) throws PortalException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.journalArticleLocalService.subscribeStructure(groupId, userId, ddmStructureId);
    }

    public void unsubscribeStructure(long groupId, long userId, long ddmStructureId) throws PortalException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.journalArticleLocalService.unsubscribeStructure(groupId, userId, ddmStructureId);
    }

    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String layoutUuid, ServiceContext serviceContext) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "UPDATE");
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, titleMap, descriptionMap, content, layoutUuid, serviceContext);
    }

    public JournalArticle updateArticle(long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "UPDATE");
        return this.journalArticleLocalService.updateArticle(this.getUserId(), groupId, folderId, articleId, version, titleMap, descriptionMap, content, ddmStructureKey, ddmTemplateKey, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, smallFile, images, articleURL, serviceContext);
    }

    public JournalArticle updateArticle(long groupId, long folderId, String articleId, double version, String content, ServiceContext serviceContext) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "UPDATE");
        return this.journalArticleLocalService.updateArticle(this.getUserId(), groupId, folderId, articleId, version, content, serviceContext);
    }

    public JournalArticle updateArticleTranslation(long groupId, String articleId, double version, Locale locale, String title, String description, String content, Map<String, byte[]> images, ServiceContext serviceContext) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "UPDATE");
        return this.journalArticleLocalService.updateArticleTranslation(groupId, articleId, version, locale, title, description, content, images, serviceContext);
    }

    public JournalArticle updateContent(long groupId, String articleId, double version, String content) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "UPDATE");
        return this.journalArticleLocalService.updateContent(groupId, articleId, version, content);
    }

    public JournalArticle updateStatus(long groupId, String articleId, double version, int status, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "UPDATE");
        return this.journalArticleLocalService.updateStatus(this.getUserId(), groupId, articleId, version, status, articleURL, new HashMap(), serviceContext);
    }
}

