/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.service.permission.JournalFolderPermission;
import com.liferay.journal.service.permission.JournalPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={BaseModelPermissionChecker.class})
public class JournalArticlePermission
implements BaseModelPermissionChecker {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticlePermission.class);
    private static ConfigurationProvider _configurationProvider;
    private static JournalArticleLocalService _journalArticleLocalService;
    private static JournalFolderLocalService _journalFolderLocalService;

    public static void check(PermissionChecker permissionChecker, JournalArticle article, String actionId) throws PortalException {
        if (!JournalArticlePermission.contains(permissionChecker, article, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{JournalArticle.class.getName(), article.getArticleId(), actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException {
        if (!JournalArticlePermission.contains(permissionChecker, resourcePrimKey, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, JournalArticle.class.getName(), resourcePrimKey, new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String articleId, double version, String actionId) throws PortalException {
        if (!JournalArticlePermission.contains(permissionChecker, groupId, articleId, version, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{JournalArticle.class.getName(), articleId, actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String articleId, int status, String actionId) throws PortalException {
        if (!JournalArticlePermission.contains(permissionChecker, groupId, articleId, status, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{JournalArticle.class.getName(), articleId, actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String articleId, String actionId) throws PortalException {
        if (!JournalArticlePermission.contains(permissionChecker, groupId, articleId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{JournalArticle.class.getName(), articleId, actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, JournalArticle article, String actionId) throws PortalException {
        CacheKey cacheKey;
        Map permissionChecksMap = permissionChecker.getPermissionChecksMap();
        Boolean contains = (Boolean)permissionChecksMap.get(cacheKey = new CacheKey(article.getGroupId(), article.getArticleId(), actionId));
        if (contains == null) {
            contains = JournalArticlePermission._contains(permissionChecker, article, actionId);
            permissionChecksMap.put(cacheKey, contains);
        }
        return contains;
    }

    public static boolean contains(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        JournalArticle article = _journalArticleLocalService.fetchLatestArticle(classPK);
        if (article == null) {
            article = _journalArticleLocalService.getArticle(classPK);
        }
        return JournalArticlePermission.contains(permissionChecker, article, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String articleId, double version, String actionId) throws PortalException {
        JournalArticle article = _journalArticleLocalService.getArticle(groupId, articleId, version);
        return JournalArticlePermission.contains(permissionChecker, article, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String articleId, int status, String actionId) throws PortalException {
        JournalArticle article = _journalArticleLocalService.getLatestArticle(groupId, articleId, status);
        return JournalArticlePermission.contains(permissionChecker, article, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String articleId, String actionId) throws PortalException {
        JournalArticle article = _journalArticleLocalService.getArticle(groupId, articleId);
        return JournalArticlePermission.contains(permissionChecker, article, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        JournalArticlePermission.check(permissionChecker, primaryKey, actionId);
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        _configurationProvider = configurationProvider;
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
        _journalArticleLocalService = journalArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalFolderLocalService(JournalFolderLocalService journalFolderLocalService) {
        _journalFolderLocalService = journalFolderLocalService;
    }

    private static boolean _contains(PermissionChecker permissionChecker, JournalArticle article, String actionId) throws PortalException {
        String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)article.getGroupId(), (String)JournalArticle.class.getName(), (long)article.getResourcePrimKey(), (String)portletId, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (article.isDraft()) {
            if (actionId.equals("VIEW") && !JournalArticlePermission.contains(permissionChecker, article, "UPDATE")) {
                return false;
            }
        } else if (article.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)article.getGroupId(), (String)JournalArticle.class.getName(), (long)article.getId(), (String)actionId)) != null) {
            return hasPermission;
        }
        if (actionId.equals("VIEW")) {
            JournalServiceConfiguration journalServiceConfiguration = null;
            try {
                journalServiceConfiguration = (JournalServiceConfiguration)_configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, permissionChecker.getCompanyId());
            }
            catch (ConfigurationException ce) {
                _log.error((Object)("Unable to get journal service configuration for company " + permissionChecker.getCompanyId()), (Throwable)ce);
                return false;
            }
            if (!journalServiceConfiguration.articleViewPermissionsCheckEnabled()) {
                return true;
            }
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                long folderId = article.getFolderId();
                if (folderId == 0L) {
                    if (!JournalPermission.contains(permissionChecker, article.getGroupId(), actionId)) {
                        return false;
                    }
                } else {
                    JournalFolder folder = _journalFolderLocalService.fetchFolder(folderId);
                    if (folder != null) {
                        if (!JournalFolderPermission.contains(permissionChecker, folder, "ACCESS") && !JournalFolderPermission.contains(permissionChecker, folder, "VIEW")) {
                            return false;
                        }
                    } else if (!article.isInTrash()) {
                        _log.error((Object)("Unable to get journal folder " + folderId));
                        return false;
                    }
                }
            }
        }
        if (permissionChecker.hasOwnerPermission(article.getCompanyId(), JournalArticle.class.getName(), article.getResourcePrimKey(), article.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), actionId);
    }

    private static class CacheKey {
        private final String _actionId;
        private final String _articleId;
        private final long _groupId;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)obj;
            return this._groupId == cacheKey._groupId && Objects.equals(this._articleId, cacheKey._articleId) && Objects.equals(this._actionId, cacheKey._actionId);
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (long)this._groupId);
            hash = HashUtil.hash((int)hash, (Object)this._articleId);
            return HashUtil.hash((int)hash, (Object)this._actionId);
        }

        private CacheKey(long groupId, String articleId, String actionId) {
            this._groupId = groupId;
            this._articleId = articleId;
            this._actionId = actionId;
        }
    }
}

