/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.transformer;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class RegexTransformerUtil {
    private static final Log _log = LogFactoryUtil.getLog(RegexTransformerUtil.class);
    private static final RegexTransformerUtil _instance = new RegexTransformerUtil();
    private final List<Pattern> _patterns = new ArrayList<Pattern>();
    private final List<String> _replacements = new ArrayList<String>();

    public static List<Pattern> getPatterns() {
        return RegexTransformerUtil._instance._patterns;
    }

    public static List<String> getReplacements() {
        return RegexTransformerUtil._instance._replacements;
    }

    private RegexTransformerUtil() {
        for (int i = 0; i < 100; ++i) {
            String regex = PropsUtil.get((String)("journal.transformer.regex.pattern." + i));
            String replacement = PropsUtil.get((String)("journal.transformer.regex.replacement." + i));
            if (Validator.isNull((String)regex) || Validator.isNull((String)replacement)) break;
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Pattern ", regex, " will be replaced with ", replacement}));
            }
            this._patterns.add(Pattern.compile(regex));
            this._replacements.add(replacement);
        }
    }
}

