/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.transformer;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.BaseTransformerListener;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet"}, service={TransformerListener.class})
public class ViewCounterTransformerListener
extends BaseTransformerListener {
    private static final String _COUNTER_TOKEN = "@view_counter@";
    private static final Log _log = LogFactoryUtil.getLog(ViewCounterTransformerListener.class);

    public String onOutput(String output, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onOutput");
        }
        return this.replace(output, tokens);
    }

    protected String replace(String s, Map<String, String> tokens) {
        if (!s.contains(_COUNTER_TOKEN)) {
            return s;
        }
        String articleResourcePK = tokens.get("article_resource_pk");
        StringBundler sb = new StringBundler(6);
        sb.append("<script type=\"text/javascript\">");
        sb.append("Liferay.Service.Asset.AssetEntry.incrementViewCounter");
        sb.append("({userId:0, className:'");
        sb.append("com.liferay.journal.model.JournalArticle', classPK:");
        sb.append(articleResourcePK);
        sb.append("});</script>");
        return StringUtil.replace((String)s, (String)_COUNTER_TOKEN, (String)sb.toString());
    }
}

