/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.util.impl;

import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.exception.FolderNameException;
import com.liferay.journal.util.JournalValidator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={JournalValidator.class})
public final class JournalValidatorImpl
implements JournalValidator {
    private static final Log _log = LogFactoryUtil.getLog(JournalValidatorImpl.class);
    private ConfigurationProvider _configurationProvider;

    public boolean isValidName(String name) {
        if (Validator.isNull((String)name)) {
            return false;
        }
        String[] charactersBlacklist = new String[]{};
        try {
            long companyId = CompanyThreadLocal.getCompanyId();
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this._configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, companyId);
            charactersBlacklist = journalServiceConfiguration.charactersblacklist();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        for (String blacklistChar : charactersBlacklist) {
            if (!name.contains(blacklistChar)) continue;
            return false;
        }
        return true;
    }

    public void validateFolderName(String folderName) throws FolderNameException {
        if (!this.isValidName(folderName)) {
            throw new FolderNameException(folderName);
        }
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }
}

