/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.verify;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.internal.verify.model.JournalArticleResourceVerifiableModel;
import com.liferay.journal.internal.verify.model.JournalArticleVerifiableModel;
import com.liferay.journal.internal.verify.model.JournalFeedVerifiableModel;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleImage;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.model.JournalContentSearch;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleImageLocalService;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.journal.service.JournalContentSearchLocalService;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.util.JournalConverter;
import com.liferay.journal.util.comparator.ArticleVersionComparator;
import com.liferay.journal.verify.JournalServiceSystemEventVerifyProcess;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.verify.model.VerifiableResourcedModel;
import com.liferay.portal.kernel.verify.model.VerifiableUUIDModel;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.upgrade.AutoBatchPreparedStatementUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyLayout;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portal.verify.VerifyResourcePermissions;
import com.liferay.portal.verify.VerifyUUID;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.journal.service"}, service={JournalServiceVerifyProcess.class, VerifyProcess.class})
public class JournalServiceVerifyProcess
extends VerifyLayout {
    public static final long DEFAULT_GROUP_ID = 14L;
    public static final int NUM_OF_ARTICLES = 5;
    private static final Log _log = LogFactoryUtil.getLog(JournalServiceVerifyProcess.class);
    private AssetEntryLocalService _assetEntryLocalService;
    private CompanyLocalService _companyLocalService;
    private DDMStructureLocalService _ddmStructureLocalService;
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private Http _http;
    private JournalArticleImageLocalService _journalArticleImageLocalService;
    private JournalArticleLocalService _journalArticleLocalService;
    private JournalArticleResourceLocalService _journalArticleResourceLocalService;
    private JournalContentSearchLocalService _journalContentSearchLocalService;
    private JournalConverter _journalConverter;
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference
    private Portal _portal;
    private ResourceLocalService _resourceLocalService;
    private SystemEventLocalService _systemEventLocalService;
    private final VerifyResourcePermissions _verifyResourcePermissions = new VerifyResourcePermissions();

    protected void doVerify() throws Exception {
        this.verifyArticleAssets();
        this.verifyArticleContents();
        this.verifyArticleExpirationDate();
        this.verifyArticleLayouts();
        this.verifyArticleStructures();
        this.verifyContentSearch();
        this.verifyFolderAssets();
        this.verifyOracleNewLine();
        this.verifyPermissions();
        this.verifyResourcedModels();
        this.verifyUUIDModels();
        this.verifyArticleImages();
        JournalServiceSystemEventVerifyProcess verifyProcess = new JournalServiceSystemEventVerifyProcess(this._journalArticleLocalService, this._journalArticleResourceLocalService, this._systemEventLocalService);
        verifyProcess.verify();
    }

    @Reference(unbind="-")
    protected void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
    }

    @Deprecated
    @Reference(unbind="-")
    protected void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    @Deprecated
    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleImageLocalService(JournalArticleImageLocalService journalArticleImageLocalService) {
        this._journalArticleImageLocalService = journalArticleImageLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleResourceLocalService(JournalArticleResourceLocalService journalArticleResourceLocalService) {
        this._journalArticleResourceLocalService = journalArticleResourceLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalContentSearchLocalService(JournalContentSearchLocalService journalContentSearchLocalService) {
        this._journalContentSearchLocalService = journalContentSearchLocalService;
    }

    @Deprecated
    @Reference(unbind="-")
    protected void setJournalConverter(JournalConverter journalConverter) {
        this._journalConverter = journalConverter;
    }

    @Reference(unbind="-")
    protected void setJournalFolderLocalService(JournalFolderLocalService journalFolderLocalService) {
        this._journalFolderLocalService = journalFolderLocalService;
    }

    @Reference(unbind="-")
    protected void setResourceLocalService(ResourceLocalService resourceLocalService) {
        this._resourceLocalService = resourceLocalService;
    }

    @Reference(unbind="-")
    protected void setSystemEventLocalService(SystemEventLocalService systemEventLocalService) {
        this._systemEventLocalService = systemEventLocalService;
    }

    protected void updateContentSearch(long groupId, String portletId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select preferences from PortletPreferences inner join Layout on PortletPreferences.plid = Layout.plid where groupId = ? and portletId = ?");){
            ps.setLong(1, groupId);
            ps.setString(2, portletId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String xml = rs.getString("preferences");
                    PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)xml);
                    String articleId = portletPreferences.getValue("articleId", null);
                    List contentSearches = this._journalContentSearchLocalService.getArticleContentSearches(groupId, articleId);
                    if (contentSearches.isEmpty()) continue;
                    JournalContentSearch contentSearch = (JournalContentSearch)contentSearches.get(0);
                    this._journalContentSearchLocalService.updateContentSearch(contentSearch.getGroupId(), contentSearch.isPrivateLayout(), contentSearch.getLayoutId(), contentSearch.getPortletId(), articleId, true);
                }
            }
        }
    }

    @Deprecated
    protected void updateCreateAndModifiedDates() throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._journalArticleResourceLocalService.getActionableDynamicQuery();
        if (_log.isDebugEnabled()) {
            long count = actionableDynamicQuery.performCount();
            _log.debug((Object)("Processing " + count + " article resources for create and modified dates"));
        }
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<JournalArticleResource>(){

            public void performAction(JournalArticleResource articleResource) {
                JournalServiceVerifyProcess.this.updateCreateDate(articleResource);
                JournalServiceVerifyProcess.this.updateModifiedDate(articleResource);
            }
        });
        actionableDynamicQuery.performActions();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Create and modified dates verified for articles");
        }
    }

    @Deprecated
    protected void updateCreateDate(JournalArticleResource articleResource) {
        List articles = this._journalArticleLocalService.getArticles(articleResource.getGroupId(), articleResource.getArticleId(), -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
        if (articles.size() <= 1) {
            return;
        }
        JournalArticle firstArticle = (JournalArticle)articles.get(0);
        Date createDate = firstArticle.getCreateDate();
        for (JournalArticle article : articles) {
            if (createDate.equals(article.getCreateDate())) continue;
            article.setCreateDate(createDate);
            this._journalArticleLocalService.updateJournalArticle(article);
        }
    }

    protected void updateDocumentLibraryElements(Element element) {
        List dynamicContentElements = element.elements("dynamic-content");
        for (Element dynamicContentElement : dynamicContentElements) {
            String path = dynamicContentElement.getStringValue();
            String[] pathArray = StringUtil.split((String)path, (char)'/');
            if (pathArray.length != 5) {
                return;
            }
            long groupId = GetterUtil.getLong((String)pathArray[2]);
            long folderId = GetterUtil.getLong((String)pathArray[3]);
            String title = this._http.decodeURL(HtmlUtil.escape((String)pathArray[4]));
            try {
                FileEntry fileEntry = this._dlAppLocalService.getFileEntry(groupId, folderId, title);
                Node node = dynamicContentElement.node(0);
                node.setText(path + "/" + fileEntry.getUuid());
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void updateDynamicElements(JournalArticle article) throws Exception {
        if (Validator.isNull((String)article.getDDMStructureKey())) {
            return;
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(article.getGroupId(), this._portal.getClassNameId(JournalArticle.class), article.getDDMStructureKey(), true);
        Locale originalefaultLocale = LocaleThreadLocal.getDefaultLocale();
        Locale originalSiteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        try {
            Company company = this._companyLocalService.getCompany(article.getCompanyId());
            LocaleThreadLocal.setDefaultLocale((Locale)company.getLocale());
            LocaleThreadLocal.setSiteDefaultLocale((Locale)this._portal.getSiteDefaultLocale(article.getGroupId()));
            Fields ddmFields = this._journalConverter.getDDMFields(ddmStructure, article.getContent());
            String content = this._journalConverter.getContent(ddmStructure, ddmFields);
            if (!content.equals(article.getContent())) {
                article.setContent(content);
                this._journalArticleLocalService.updateJournalArticle(article);
            }
        }
        finally {
            LocaleThreadLocal.setDefaultLocale((Locale)originalefaultLocale);
            LocaleThreadLocal.setSiteDefaultLocale((Locale)originalSiteDefaultLocale);
        }
    }

    protected void updateElement(long groupId, Element element) {
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateElement(groupId, dynamicElementElement);
        }
        String type = element.attributeValue("type");
        if (type.equals("document_library")) {
            this.updateDocumentLibraryElements(element);
        } else if (type.equals("link_to_layout")) {
            this.updateLinkToLayoutElements(groupId, element);
        }
    }

    @Deprecated
    protected void updateExpirationDate(long groupId, long articleId, Timestamp expirationDate, int status) throws Exception {
        this.updateExpirationDate(groupId, String.valueOf(articleId), expirationDate, status);
    }

    protected void updateExpirationDate(long groupId, String articleId, Timestamp expirationDate, int status) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update JournalArticle set expirationDate = ? where groupId = ? and articleId = ? and status = ?");){
            ps.setTimestamp(1, expirationDate);
            ps.setLong(2, groupId);
            ps.setString(3, articleId);
            ps.setInt(4, status);
            ps.executeUpdate();
        }
    }

    protected void updateImageElement(Element element) {
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateImageElement(dynamicElementElement);
        }
        String type = element.attributeValue("type");
        if (!type.equals("image")) {
            return;
        }
        String elName = element.attributeValue("name");
        List dynamicContentElements = element.elements("dynamic-content");
        for (Element dynamicContentElement : dynamicContentElements) {
            long articleImageId = GetterUtil.getLong((String)dynamicContentElement.attributeValue("id"));
            JournalArticleImage articleImage = this._journalArticleImageLocalService.fetchJournalArticleImage(articleImageId);
            if (articleImage == null || elName.equals(articleImage.getElName())) continue;
            articleImage.setElName(elName);
            this._journalArticleImageLocalService.updateJournalArticleImage(articleImage);
        }
    }

    protected void updateLinkToLayoutElements(long groupId, Element element) {
        Element dynamicContentElement = element.element("dynamic-content");
        Node node = dynamicContentElement.node(0);
        String text = node.getText();
        if (!text.isEmpty() && !text.endsWith("@" + groupId)) {
            node.setText(dynamicContentElement.getStringValue() + "@" + groupId);
        }
    }

    @Deprecated
    protected void updateModifiedDate(JournalArticleResource articleResource) {
        JournalArticle article = this._journalArticleLocalService.fetchLatestArticle(articleResource.getResourcePrimKey(), 0, true);
        if (article == null) {
            return;
        }
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(articleResource.getGroupId(), articleResource.getUuid());
        if (assetEntry == null) {
            return;
        }
        Date modifiedDate = article.getModifiedDate();
        if (modifiedDate.equals(assetEntry.getModifiedDate())) {
            return;
        }
        article.setModifiedDate(assetEntry.getModifiedDate());
        this._journalArticleLocalService.updateJournalArticle(article);
    }

    protected void updateResourcePrimKey() throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._journalArticleLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property resourcePrimKey = PropertyFactoryUtil.forName((String)"resourcePrimKey");
                dynamicQuery.add(resourcePrimKey.le((Object)0L));
            }
        });
        if (_log.isDebugEnabled()) {
            long count = actionableDynamicQuery.performCount();
            _log.debug((Object)("Processing " + count + " default article versions in draft mode"));
        }
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<JournalArticle>(){

            public void performAction(JournalArticle article) throws PortalException {
                long groupId = article.getGroupId();
                String articleId = article.getArticleId();
                double version = article.getVersion();
                JournalServiceVerifyProcess.this._journalArticleLocalService.checkArticleResourcePrimKey(groupId, articleId, version);
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void verifyArticleAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List journalArticles = this._journalArticleLocalService.getNoAssetArticles();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + journalArticles.size() + " articles with no asset"));
            }
            for (JournalArticle journalArticle : journalArticles) {
                try {
                    this._journalArticleLocalService.updateAsset(journalArticle.getUserId(), journalArticle, null, null, null, null);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to update asset for article ", String.valueOf(journalArticle.getId()), ": ", e.getMessage()}));
                }
            }
            ActionableDynamicQuery actionableDynamicQuery = this._journalArticleLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

                public void addCriteria(DynamicQuery dynamicQuery) {
                    Property versionProperty = PropertyFactoryUtil.forName((String)"version");
                    dynamicQuery.add(versionProperty.eq((Object)1.0));
                    Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                    dynamicQuery.add(statusProperty.eq((Object)2));
                }
            });
            if (_log.isDebugEnabled()) {
                long count = actionableDynamicQuery.performCount();
                _log.debug((Object)("Processing " + count + " default article versions in draft mode"));
            }
            actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<JournalArticle>(){

                public void performAction(JournalArticle article) throws PortalException {
                    AssetEntry assetEntry = JournalServiceVerifyProcess.this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
                    boolean listable = JournalServiceVerifyProcess.this._journalArticleLocalService.isListable(article);
                    JournalServiceVerifyProcess.this._assetEntryLocalService.updateEntry(assetEntry.getClassName(), assetEntry.getClassPK(), null, null, listable, assetEntry.isVisible());
                }
            });
            actionableDynamicQuery.performActions();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for articles");
            }
            this.updateResourcePrimKey();
        }
    }

    protected void verifyArticleContents() throws Exception {
        block41: {
            try (LoggingTimer loggingTimer = new LoggingTimer();
                 PreparedStatement ps = this.connection.prepareStatement("select id_ from JournalArticle where (content like '%document_library%' or content like '%link_to_layout%') and DDMStructureKey != ''");){
                ResultSet rs = ps.executeQuery();
                Throwable throwable = null;
                block29: while (true) {
                    try {
                        while (rs.next()) {
                            long id = rs.getLong("id_");
                            JournalArticle article = this._journalArticleLocalService.getArticle(id);
                            try {
                                Document document = SAXReaderUtil.read((String)article.getContent());
                                Element rootElement = document.getRootElement();
                                for (Element element : rootElement.elements()) {
                                    this.updateElement(article.getGroupId(), element);
                                }
                                article.setContent(document.asXML());
                                this._journalArticleLocalService.updateJournalArticle(article);
                                continue block29;
                            }
                            catch (Exception e) {
                                _log.error((Object)("Unable to update content for article " + article.getId()), (Throwable)e);
                            }
                        }
                        break block41;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
        }
    }

    protected void verifyArticleExpirationDate() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long companyId = CompanyThreadLocal.getCompanyId();
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)companyId);
            if (!journalServiceConfiguration.expireAllArticleVersionsEnabled()) {
                return;
            }
            StringBundler sb = new StringBundler(15);
            sb.append("select JournalArticle.* from JournalArticle left join ");
            sb.append("JournalArticle tempJournalArticle on ");
            sb.append("(JournalArticle.groupId = tempJournalArticle.groupId) ");
            sb.append("and (JournalArticle.articleId = ");
            sb.append("tempJournalArticle.articleId) and ");
            sb.append("(JournalArticle.version < tempJournalArticle.version) ");
            sb.append("and (JournalArticle.status = ");
            sb.append("tempJournalArticle.status) where ");
            sb.append("(JournalArticle.classNameId = ");
            sb.append(0L);
            sb.append(") and (tempJournalArticle.version is null) and ");
            sb.append("(JournalArticle.expirationDate is not null) and ");
            sb.append("(JournalArticle.status = ");
            sb.append(0);
            sb.append(")");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long groupId = rs.getLong("groupId");
                    String articleId = rs.getString("articleId");
                    Timestamp expirationDate = rs.getTimestamp("expirationDate");
                    int status = rs.getInt("status");
                    this.updateExpirationDate(groupId, articleId, expirationDate, status);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void verifyArticleImages() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select id_ from JournalArticle where (content like '%type=\"image\"%') and DDMStructureKey != ''");
             ResultSet rs = ps.executeQuery();){
            block29: while (rs.next()) {
                long id = rs.getLong("id_");
                JournalArticle article = this._journalArticleLocalService.getArticle(id);
                try {
                    Document document = SAXReaderUtil.read((String)article.getContent());
                    Element rootElement = document.getRootElement();
                    Iterator iterator = rootElement.elements().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block29;
                        Element element = (Element)iterator.next();
                        this.updateImageElement(element);
                    }
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to update images for article " + article.getId()), (Throwable)e);
                }
            }
            return;
        }
    }

    protected void verifyArticleLayouts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.verifyUuid("JournalArticle");
        }
    }

    protected void verifyArticleStructures() throws PortalException {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = this._journalArticleLocalService.getActionableDynamicQuery();
            if (_log.isDebugEnabled()) {
                long count = actionableDynamicQuery.performCount();
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Processing ", String.valueOf(count), " articles for invalid structures and dynamic ", "elements"}));
            }
            actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<JournalArticle>(){

                public void performAction(JournalArticle article) {
                    try {
                        JournalServiceVerifyProcess.this._journalArticleLocalService.checkStructure(article.getGroupId(), article.getArticleId(), article.getVersion());
                    }
                    catch (NoSuchStructureException nsse) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Removing reference to missing structure for article " + article.getId()));
                        }
                        article.setDDMStructureKey("");
                        article.setDDMTemplateKey("");
                        JournalServiceVerifyProcess.this._journalArticleLocalService.updateJournalArticle(article);
                    }
                    catch (Exception e) {
                        _log.error((Object)("Unable to check the structure for article " + article.getId()), (Throwable)e);
                    }
                }
            });
            actionableDynamicQuery.performActions();
        }
    }

    protected void verifyContentSearch() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select groupId, portletId from JournalContentSearch group by groupId, portletId having count(groupId) > 1 and count(portletId) > 1");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                String portletId = rs.getString("portletId");
                this.updateContentSearch(groupId, portletId);
            }
        }
    }

    protected void verifyFolderAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List folders = this._journalFolderLocalService.getNoAssetFolders();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + folders.size() + " folders with no asset"));
            }
            for (JournalFolder folder : folders) {
                try {
                    this._journalFolderLocalService.updateAsset(folder.getUserId(), folder, null, null, null, null);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to update asset for folder ", String.valueOf(folder.getFolderId()), ": ", e.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for folders");
            }
        }
    }

    protected void verifyOracleNewLine() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DB db = DBManagerUtil.getDB();
            if (db.getDBType() != DBType.ORACLE) {
                return;
            }
            boolean checkNewLine = false;
            List articles = this._journalArticleLocalService.getArticles(14L, 0, 5);
            for (JournalArticle article : articles) {
                String content = article.getContent();
                if (content == null || !content.contains("\\n")) continue;
                articles = this._journalArticleLocalService.getArticles(14L);
                Iterator iterator = articles.iterator();
                while (iterator.hasNext()) {
                    JournalArticle curArticle;
                    article = curArticle = (JournalArticle)iterator.next();
                    this._journalArticleLocalService.checkNewLine(article.getGroupId(), article.getArticleId(), article.getVersion());
                }
                checkNewLine = true;
                break;
            }
            if (!checkNewLine) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Do not fix oracle new line");
                }
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Fix oracle new line");
            }
        }
    }

    protected void verifyPermissions() throws PortalException {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List articles = this._journalArticleLocalService.getNoPermissionArticles();
            for (JournalArticle article : articles) {
                this._resourceLocalService.addResources(article.getCompanyId(), 0L, 0L, JournalArticle.class.getName(), article.getResourcePrimKey(), false, false, false);
            }
        }
    }

    protected void verifyResourcedModels() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._verifyResourcePermissions.verify(new VerifiableResourcedModel[]{new JournalArticleVerifiableModel()});
            this._verifyResourcePermissions.verify(new VerifiableResourcedModel[]{new JournalFeedVerifiableModel()});
        }
    }

    @Deprecated
    protected void verifyTree() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long[] companyIds;
            for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
                this._journalFolderLocalService.rebuildTree(companyId);
            }
        }
    }

    @Deprecated
    protected void verifyURLTitle() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select distinct groupId, articleId, urlTitle from JournalArticle");
             ResultSet rs = ps1.executeQuery();
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update JournalArticle set urlTitle = ? where urlTitle = ?"));){
            while (rs.next()) {
                String normalizedURLTitle;
                long groupId = rs.getLong("groupId");
                String articleId = rs.getString("articleId");
                String urlTitle = GetterUtil.getString((String)rs.getString("urlTitle"));
                if (urlTitle.equals(normalizedURLTitle = FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)urlTitle))) {
                    return;
                }
                normalizedURLTitle = this._journalArticleLocalService.getUniqueUrlTitle(groupId, articleId, normalizedURLTitle);
                ps2.setString(1, normalizedURLTitle);
                ps2.setString(2, urlTitle);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void verifyUUIDModels() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            VerifyUUID.verify((VerifiableUUIDModel[])new VerifiableUUIDModel[]{new JournalArticleResourceVerifiableModel()});
            VerifyUUID.verify((VerifiableUUIDModel[])new VerifiableUUIDModel[]{new JournalFeedVerifiableModel()});
        }
    }
}

