/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.content.processor;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ImageImportDDMFormFieldValueTransformer
implements DDMFormFieldValueTransformer {
    private static final Log _log = LogFactoryUtil.getLog(ImageImportDDMFormFieldValueTransformer.class);
    private final DLAppService _dlAppService;
    private Document _document;
    private final PortletDataContext _portletDataContext;
    private final StagedModel _stagedModel;

    public ImageImportDDMFormFieldValueTransformer(String content, DLAppService dlAppService, PortletDataContext portletDataContext, StagedModel stagedModel) {
        this._dlAppService = dlAppService;
        this._portletDataContext = portletDataContext;
        this._stagedModel = stagedModel;
        this._setContent(content);
    }

    public String getContent() {
        return this._document.asXML();
    }

    public String getFieldType() {
        return "ddm-image";
    }

    public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
        Value value = ddmFormFieldValue.getValue();
        for (Locale locale : value.getAvailableLocales()) {
            String valueString = value.getString(locale);
            JSONObject jsonObject = null;
            try {
                jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            }
            catch (JSONException jsone) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsone);
                continue;
            }
            FileEntry importedFileEntry = this.fetchImportedFileEntry(this._portletDataContext, jsonObject.getLong("fileEntryId"), jsonObject.getString("uuid"));
            if (importedFileEntry == null) continue;
            String fileEntryJSON = this.toJSON(importedFileEntry, jsonObject.getString("type"), jsonObject.getString("alt"));
            value.addString(locale, fileEntryJSON);
            StringBundler sb = new StringBundler(4);
            sb.append("//dynamic-element[@type='image']");
            sb.append("/dynamic-content[contains(text(),");
            sb.append(HtmlUtil.escapeXPathAttribute((String)valueString));
            sb.append(")]");
            XPath xPath = SAXReaderUtil.createXPath((String)sb.toString());
            List imageNodes = xPath.selectNodes((Object)this._document);
            for (Node imageNode : imageNodes) {
                Element imageElement = (Element)imageNode;
                imageElement.clearContent();
                imageElement.addCDATA(fileEntryJSON);
            }
        }
    }

    protected FileEntry fetchImportedFileEntry(PortletDataContext portletDataContext, long oldClassPK, String uuid) throws PortalException {
        try {
            Map fileEntryPKs = portletDataContext.getNewPrimaryKeysMap(DLFileEntry.class);
            Long classPK = (Long)fileEntryPKs.get(oldClassPK);
            if (classPK == null) {
                if (Validator.isNotNull((String)uuid)) {
                    return this._dlAppService.getFileEntryByUuidAndGroupId(uuid, portletDataContext.getScopeGroupId());
                }
                return null;
            }
            return this._dlAppService.getFileEntry(classPK.longValue());
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to find file entry", (Throwable)pe);
            }
            return null;
        }
    }

    protected String toJSON(FileEntry fileEntry, String type, String alt) {
        JournalArticle article = (JournalArticle)this._stagedModel;
        JSONObject jsonObject = JSONUtil.put((String)"alt", (Object)alt).put("fileEntryId", fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("name", fileEntry.getFileName()).put("resourcePrimKey", article.getResourcePrimKey()).put("title", fileEntry.getTitle()).put("type", type).put("uuid", fileEntry.getUuid());
        return jsonObject.toString();
    }

    private void _setContent(String content) {
        block2: {
            try {
                this._document = SAXReaderUtil.read((String)content);
            }
            catch (DocumentException de) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)("Invalid content:\n" + content));
            }
        }
    }
}

