/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.content.processor;

import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.journal.model.JournalFeed;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalFeed"}, service={ExportImportContentProcessor.class, JournalFeedExportImportContentProcessor.class})
public class JournalFeedExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final String _DATA_HANDLER_GROUP_FRIENDLY_URL = "@data_handler_group_friendly_url@";
    @Reference(target="(model.class.name=java.lang.String)")
    private ExportImportContentProcessor<String> _defaultTextExportImportContentProcessor;
    private GroupLocalService _groupLocalService;
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        String[] friendlyURLParts;
        String oldGroupFriendlyURL;
        JournalFeed feed = (JournalFeed)stagedModel;
        Group group = this._groupLocalService.getGroup(portletDataContext.getScopeGroupId());
        String newGroupFriendlyURL = group.getFriendlyURL();
        if ((newGroupFriendlyURL = newGroupFriendlyURL.substring(1)).equals(oldGroupFriendlyURL = (friendlyURLParts = StringUtil.split((String)feed.getTargetLayoutFriendlyUrl(), (String)"/"))[2])) {
            String targetLayoutFriendlyUrl = StringUtil.replaceFirst((String)feed.getTargetLayoutFriendlyUrl(), (String)("/" + newGroupFriendlyURL + "/"), (String)"/@data_handler_group_friendly_url@/");
            feed.setTargetLayoutFriendlyUrl(targetLayoutFriendlyUrl);
        }
        Group targetLayoutGroup = this._groupLocalService.fetchFriendlyURLGroup(portletDataContext.getCompanyId(), "/" + oldGroupFriendlyURL);
        boolean privateLayout = false;
        if (!PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING.equals("/" + friendlyURLParts[1])) {
            privateLayout = true;
        }
        String targetLayoutFriendlyURL = "/" + friendlyURLParts[3];
        Layout targetLayout = this._layoutLocalService.fetchLayoutByFriendlyURL(targetLayoutGroup.getGroupId(), privateLayout, targetLayoutFriendlyURL);
        Element feedElement = portletDataContext.getExportDataElement((ClassedModel)feed);
        portletDataContext.addReferenceElement((ClassedModel)feed, feedElement, (ClassedModel)targetLayout, "dependency", true);
        return content;
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        JournalFeed feed = (JournalFeed)stagedModel;
        Group group = this._groupLocalService.getGroup(portletDataContext.getScopeGroupId());
        String newGroupFriendlyURL = group.getFriendlyURL();
        newGroupFriendlyURL = newGroupFriendlyURL.substring(1);
        String newTargetLayoutFriendlyURL = StringUtil.replace((String)feed.getTargetLayoutFriendlyUrl(), (String)_DATA_HANDLER_GROUP_FRIENDLY_URL, (String)newGroupFriendlyURL);
        long plid = this._portal.getPlidFromFriendlyURL(portletDataContext.getCompanyId(), newTargetLayoutFriendlyURL);
        if (plid <= 0L) {
            Group oldGroup = this._groupLocalService.fetchGroup(portletDataContext.getSourceGroupId());
            if (oldGroup == null) {
                return content;
            }
            String oldGroupFriendlyURL = oldGroup.getFriendlyURL();
            oldGroupFriendlyURL = oldGroupFriendlyURL.substring(1);
            newTargetLayoutFriendlyURL = StringUtil.replace((String)feed.getTargetLayoutFriendlyUrl(), (String)_DATA_HANDLER_GROUP_FRIENDLY_URL, (String)oldGroupFriendlyURL);
        }
        feed.setTargetLayoutFriendlyUrl(newTargetLayoutFriendlyURL);
        return content;
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        this._defaultTextExportImportContentProcessor.validateContentReferences(groupId, (Serializable)((Object)content));
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }
}

