/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.data.handler;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.journal.exception.FeedTargetLayoutFriendlyUrlException;
import com.liferay.journal.internal.exportimport.content.processor.JournalFeedExportImportContentProcessor;
import com.liferay.journal.internal.exportimport.creation.strategy.JournalCreationStrategy;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFeed;
import com.liferay.journal.service.JournalFeedLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class JournalFeedStagedModelDataHandler
extends BaseStagedModelDataHandler<JournalFeed> {
    public static final String[] CLASS_NAMES = new String[]{JournalFeed.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(JournalFeedStagedModelDataHandler.class);
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMTemplateLocalService _ddmTemplateLocalService;
    private JournalCreationStrategy _journalCreationStrategy;
    private JournalFeedExportImportContentProcessor _journalFeedExportImportContentProcessor;
    private JournalFeedLocalService _journalFeedLocalService;
    @Reference
    private Portal _portal;

    public void deleteStagedModel(JournalFeed feed) throws PortalException {
        this._journalFeedLocalService.deleteFeed(feed);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        JournalFeed feed = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (feed != null) {
            this.deleteStagedModel(feed);
        }
    }

    public JournalFeed fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._journalFeedLocalService.fetchJournalFeedByUuidAndGroupId(uuid, groupId);
    }

    public List<JournalFeed> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._journalFeedLocalService.getJournalFeedsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, JournalFeed feed) throws Exception {
        Element feedElement = portletDataContext.getExportDataElement((ClassedModel)feed);
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(feed.getGroupId(), this._portal.getClassNameId(JournalArticle.class), feed.getDDMStructureKey(), true);
        if (ddmStructure != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)feed, (StagedModel)ddmStructure, (String)"strong");
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to find DDM structure with key " + feed.getDDMStructureKey()));
        }
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(feed.getGroupId(), this._portal.getClassNameId(DDMStructure.class), feed.getDDMTemplateKey());
        if (ddmTemplate != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)feed, (StagedModel)ddmTemplate, (String)"strong");
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to find DDM template with key " + feed.getDDMTemplateKey()));
        }
        DDMTemplate rendererDDMTemplate = this._ddmTemplateLocalService.fetchTemplate(feed.getGroupId(), this._portal.getClassNameId(DDMStructure.class), feed.getDDMRendererTemplateKey());
        if (rendererDDMTemplate != null) {
            Element rendererDDMTemplateElement = StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)feed, (StagedModel)rendererDDMTemplate, (String)"strong");
            rendererDDMTemplateElement.addAttribute("rendererDDMTemplate", "true");
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to find DDM template with key " + feed.getDDMRendererTemplateKey()));
        }
        this._journalFeedExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)feed, "", true, true);
        portletDataContext.addClassedModel(feedElement, ExportImportPathUtil.getModelPath((StagedModel)feed), (ClassedModel)feed);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, JournalFeed feed) throws Exception {
        block9: {
            long userId = portletDataContext.getUserId(feed.getUserUuid());
            long authorId = this._journalCreationStrategy.getAuthorUserId(portletDataContext, feed);
            if (authorId != 0L) {
                userId = authorId;
            }
            this._journalFeedExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)feed, "");
            String feedId = feed.getFeedId();
            boolean autoFeedId = false;
            if (Validator.isNumber((String)feedId) || this._journalFeedLocalService.fetchFeed(portletDataContext.getScopeGroupId(), feedId) != null) {
                autoFeedId = true;
            }
            Map ddmStructureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
            String parentDDMStructureKey = MapUtil.getString((Map)ddmStructureKeys, (String)feed.getDDMStructureKey(), (String)feed.getDDMStructureKey());
            Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
            String parentDDMTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)feed.getDDMTemplateKey(), (String)feed.getDDMTemplateKey());
            String parentRendererDDMTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)feed.getDDMRendererTemplateKey(), (String)feed.getDDMRendererTemplateKey());
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)feed);
            boolean addGroupPermissions = this._journalCreationStrategy.addGroupPermissions(portletDataContext, feed);
            serviceContext.setAddGroupPermissions(addGroupPermissions);
            boolean addGuestPermissions = this._journalCreationStrategy.addGuestPermissions(portletDataContext, feed);
            serviceContext.setAddGuestPermissions(addGuestPermissions);
            JournalFeed importedFeed = null;
            try {
                if (portletDataContext.isDataStrategyMirror()) {
                    JournalFeed existingFeed = this.fetchStagedModelByUuidAndGroupId(feed.getUuid(), portletDataContext.getScopeGroupId());
                    if (existingFeed == null) {
                        serviceContext.setUuid(feed.getUuid());
                        importedFeed = this._journalFeedLocalService.addFeed(userId, portletDataContext.getScopeGroupId(), feedId, autoFeedId, feed.getName(), feed.getDescription(), parentDDMStructureKey, parentDDMTemplateKey, parentRendererDDMTemplateKey, feed.getDelta(), feed.getOrderByCol(), feed.getOrderByType(), feed.getTargetLayoutFriendlyUrl(), feed.getTargetPortletId(), feed.getContentField(), feed.getFeedFormat(), feed.getFeedVersion(), serviceContext);
                    } else {
                        importedFeed = this._journalFeedLocalService.updateFeed(existingFeed.getGroupId(), existingFeed.getFeedId(), feed.getName(), feed.getDescription(), parentDDMStructureKey, parentDDMTemplateKey, parentRendererDDMTemplateKey, feed.getDelta(), feed.getOrderByCol(), feed.getOrderByType(), feed.getTargetLayoutFriendlyUrl(), feed.getTargetPortletId(), feed.getContentField(), feed.getFeedFormat(), feed.getFeedVersion(), serviceContext);
                    }
                } else {
                    importedFeed = this._journalFeedLocalService.addFeed(userId, portletDataContext.getScopeGroupId(), feedId, autoFeedId, feed.getName(), feed.getDescription(), parentDDMStructureKey, parentDDMTemplateKey, parentRendererDDMTemplateKey, feed.getDelta(), feed.getOrderByCol(), feed.getOrderByType(), feed.getTargetLayoutFriendlyUrl(), feed.getTargetPortletId(), feed.getContentField(), feed.getFeedFormat(), feed.getFeedVersion(), serviceContext);
                }
                portletDataContext.importClassedModel((ClassedModel)feed, (ClassedModel)importedFeed);
                if (!feedId.equals(importedFeed.getFeedId()) && _log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler(5);
                    sb.append("A feed with the ID ");
                    sb.append(feedId);
                    sb.append(" already exists. The new generated ID is ");
                    sb.append(importedFeed.getFeedId());
                    sb.append(".");
                    _log.warn((Object)sb.toString());
                }
            }
            catch (FeedTargetLayoutFriendlyUrlException ftlfue) {
                if (!_log.isWarnEnabled()) break block9;
                StringBundler sb = new StringBundler(7);
                sb.append("A feed with the ID ");
                sb.append(feedId);
                sb.append(" cannot be imported because layout with friendly ");
                sb.append("URL ");
                sb.append(feed.getTargetLayoutFriendlyUrl());
                sb.append(" does not exist: ");
                sb.append(ftlfue.getMessage());
                _log.warn((Object)sb.toString());
            }
        }
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalCreationStrategy(JournalCreationStrategy journalCreationStrategy) {
        this._journalCreationStrategy = journalCreationStrategy;
    }

    @Reference(unbind="-")
    protected void setJournalFeedExportImportContentProcessor(JournalFeedExportImportContentProcessor journalFeedExportImportContentProcessor) {
        this._journalFeedExportImportContentProcessor = journalFeedExportImportContentProcessor;
    }

    @Reference(unbind="-")
    protected void setJournalFeedLocalService(JournalFeedLocalService journalFeedLocalService) {
        this._journalFeedLocalService = journalFeedLocalService;
    }
}

