/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.search;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.DDMStructureIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.search.index.IndexStatusManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.structure.indexer.class.name=com.liferay.journal.model.JournalArticle"}, service={Indexer.class})
public class JournalArticleDDMStructureIndexer
extends BaseIndexer<DDMStructure>
implements DDMStructureIndexer {
    public static final String CLASS_NAME = DDMStructure.class.getName();
    @Reference
    protected ConfigurationProvider configurationProvider;
    @Reference
    protected DDMStructureLocalService ddmStructureLocalService;
    @Reference
    protected IndexerRegistry indexerRegistry;
    @Reference
    protected IndexWriterHelper indexWriterHelper;
    @Reference
    protected JournalArticleResourceLocalService journalArticleResourceLocalService;
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleDDMStructureIndexer.class);
    @Reference
    private IndexStatusManager _indexStatusManager;

    public JournalArticleDDMStructureIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"classNameId", "classPK", "companyId", "description", "entryClassName", "entryClassPK", "name", "uid"});
        this.setDefaultSelectedLocalizedFieldNames(new String[]{"description", "name"});
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void reindexDDMStructures(List<Long> ddmStructureIds) throws SearchException {
        try {
            Indexer indexer = this.indexerRegistry.nullSafeGetIndexer(JournalArticle.class);
            if (this._indexStatusManager.isIndexReadOnly() || !indexer.isIndexerEnabled()) {
                return;
            }
            String[] ddmStructureKeys = new String[ddmStructureIds.size()];
            for (int i = 0; i < ddmStructureIds.size(); ++i) {
                long ddmStructureId = ddmStructureIds.get(i);
                DDMStructure ddmStructure = this.ddmStructureLocalService.getDDMStructure(ddmStructureId);
                ddmStructureKeys[i] = ddmStructure.getStructureKey();
                this.doReindex(ddmStructure);
            }
            ActionableDynamicQuery actionableDynamicQuery = this.journalArticleResourceLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                Class<?> clazz = ((Object)((Object)this)).getClass();
                DynamicQuery journalArticleDynamicQuery = DynamicQueryFactoryUtil.forClass(JournalArticle.class, (String)"journalArticle", (ClassLoader)clazz.getClassLoader());
                journalArticleDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"resourcePrimKey"));
                journalArticleDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"journalArticle.resourcePrimKey", (String)"this.resourcePrimKey"));
                journalArticleDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"journalArticle.groupId", (String)"this.groupId"));
                Property ddmStructureKey = PropertyFactoryUtil.forName((String)"DDMStructureKey");
                journalArticleDynamicQuery.add(ddmStructureKey.in((Object[])ddmStructureKeys));
                if (!this.isIndexAllArticleVersions()) {
                    Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                    Object[] statuses = new Integer[]{0, 8};
                    journalArticleDynamicQuery.add(statusProperty.in(statuses));
                }
                Property resourcePrimKeyProperty = PropertyFactoryUtil.forName((String)"resourcePrimKey");
                dynamicQuery.add(resourcePrimKeyProperty.in(journalArticleDynamicQuery));
            });
            actionableDynamicQuery.setPerformActionMethod(article -> {
                try {
                    indexer.reindex(indexer.getClassName(), article.getResourcePrimKey());
                }
                catch (Exception e) {
                    throw new PortalException((Throwable)e);
                }
            });
            actionableDynamicQuery.performActions();
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    protected void doDelete(DDMStructure ddmStructure) throws Exception {
        this.deleteDocument(ddmStructure.getCompanyId(), ddmStructure.getStructureId());
    }

    protected Document doGetDocument(DDMStructure ddmStructure) throws Exception {
        String[] nameLanguageIds;
        String[] descriptionLanguageIds;
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)ddmStructure);
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        for (String descriptionLanguageId : descriptionLanguageIds = this.getLanguageIds(defaultLanguageId, ddmStructure.getDescription())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"description", (String)descriptionLanguageId), ddmStructure.getDescription(descriptionLanguageId));
        }
        for (String nameLanguageId : nameLanguageIds = this.getLanguageIds(defaultLanguageId, ddmStructure.getName())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"name", (String)nameLanguageId), ddmStructure.getName(nameLanguageId));
        }
        document.addLocalizedKeyword("localized_name", LocalizationUtil.populateLocalizationMap((Map)ddmStructure.getNameMap(), (String)ddmStructure.getDefaultLanguageId(), (long)ddmStructure.getGroupId()), true, true);
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        return null;
    }

    protected void doReindex(DDMStructure ddmStructure) throws Exception {
        Document document = this.getDocument(ddmStructure);
        this.indexWriterHelper.updateDocument(this.getSearchEngineId(), ddmStructure.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this.ddmStructureLocalService.getStructure(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexDDMStructures(companyId);
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLanguageIds((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }

    protected boolean isIndexAllArticleVersions() {
        JournalServiceConfiguration journalServiceConfiguration = null;
        try {
            journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return journalServiceConfiguration.indexAllArticleVersionsEnabled();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    protected void reindexDDMStructures(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.ddmStructureLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(ddmStructure -> {
            block3: {
                try {
                    Document document = this.getDocument(ddmStructure);
                    if (document != null) {
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to index ddm structure " + ddmStructure.getStructureId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

