/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.search;

import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.FolderIndexer;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.trash.TrashHelper;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class JournalFolderIndexer
extends BaseIndexer<JournalFolder>
implements FolderIndexer {
    public static final String CLASS_NAME = JournalFolder.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(JournalFolderIndexer.class);
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalFolder)")
    private ModelResourcePermission<JournalFolder> _journalFolderModelResourcePermission;
    @Reference
    private TrashHelper _trashHelper;

    public JournalFolderIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "description", "entryClassName", "entryClassPK", "title", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String[] getFolderClassNames() {
        return new String[]{CLASS_NAME};
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._journalFolderModelResourcePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this.addStatus(contextBooleanFilter, searchContext);
    }

    protected void doDelete(JournalFolder journalFolder) throws Exception {
        this.deleteDocument(journalFolder.getCompanyId(), journalFolder.getFolderId());
    }

    protected Document doGetDocument(JournalFolder journalFolder) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing journalFolder " + journalFolder));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)journalFolder);
        document.addText("description", journalFolder.getDescription());
        document.addKeyword("folderId", journalFolder.getParentFolderId());
        String title = journalFolder.getName();
        if (journalFolder.isInTrash()) {
            title = this._trashHelper.getOriginalTitle(title);
        }
        document.addText("title", title);
        document.addKeyword("treePath", StringUtil.split((String)journalFolder.getTreePath(), (char)'/'));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + journalFolder + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "title", "description");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(JournalFolder journalFolder) throws Exception {
        Document document = this.getDocument(journalFolder);
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), journalFolder.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        JournalFolder folder = this._journalFolderLocalService.getFolder(classPK);
        this.doReindex(folder);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
    }

    protected void reindexFolders(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._journalFolderLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(folder -> {
            block3: {
                try {
                    Document document = this.getDocument(folder);
                    if (document != null) {
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to index journal folder " + folder.getFolderId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    @Reference(unbind="-")
    protected void setJournalFolderLocalService(JournalFolderLocalService journalFolderLocalService) {
        this._journalFolderLocalService = journalFolderLocalService;
    }
}

