/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.transformer;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.internal.transformer.JournalTransformerListenerRegistryUtil;
import com.liferay.journal.internal.transformer.JournalXSLURIResolver;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.templateparser.TransformException;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.xsl.XSLTemplateResource;
import com.liferay.portal.xsl.XSLURIResolver;
import com.liferay.taglib.servlet.PipingServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JournalTransformer {
    private static final Log _log = LogFactoryUtil.getLog(JournalTransformer.class);
    private static final Log _logOutputAfterListener = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".OutputAfterListener"));
    private static final Log _logOutputBeforeListener = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".OutputBeforeListener"));
    private static final Log _logScriptAfterListener = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".ScriptAfterListener"));
    private static final Log _logScriptBeforeListener = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".ScriptBeforeListener"));
    private static final Log _logTokens = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".Tokens"));
    private static final Log _logTransformBefore = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".TransformBefore"));
    private static final Log _logTransfromAfter = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".TransformAfter"));
    private static final Log _logXmlAfterListener = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".XmlAfterListener"));
    private static final Log _logXmlBeforeListener = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".XmlBeforeListener"));
    private final boolean _restricted;

    public JournalTransformer(boolean restricted) {
        this._restricted = restricted;
    }

    public String transform(ThemeDisplay themeDisplay, Map<String, Object> contextObjects, Map<String, String> tokens, String viewMode, String languageId, Document document, PortletRequestModel portletRequestModel, String script, String langType, boolean propagateException) throws Exception {
        return this.doTransform(themeDisplay, contextObjects, tokens, viewMode, languageId, document, portletRequestModel, script, langType, propagateException);
    }

    public String transform(ThemeDisplay themeDisplay, Map<String, String> tokens, String viewMode, String languageId, Document document, PortletRequestModel portletRequestModel, String script, String langType) throws Exception {
        return this.doTransform(themeDisplay, null, tokens, viewMode, languageId, document, portletRequestModel, script, langType, false);
    }

    public String transform(ThemeDisplay themeDisplay, Map<String, String> tokens, String viewMode, String languageId, Document document, PortletRequestModel portletRequestModel, String script, String langType, boolean propagateException) throws Exception {
        return this.doTransform(themeDisplay, null, tokens, viewMode, languageId, document, portletRequestModel, script, langType, propagateException);
    }

    protected String doTransform(ThemeDisplay themeDisplay, Map<String, Object> contextObjects, Map<String, String> tokens, String viewMode, String languageId, Document document, PortletRequestModel portletRequestModel, String script, String langType, boolean propagateException) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Language " + languageId));
        }
        if (Validator.isNull((String)viewMode)) {
            viewMode = "view";
        }
        if (_logTokens.isDebugEnabled()) {
            String tokensString = PropertiesUtil.list(tokens);
            _logTokens.debug((Object)tokensString);
        }
        if (_logTransformBefore.isDebugEnabled()) {
            _logTransformBefore.debug((Object)document);
        }
        List<TransformerListener> transformerListeners = JournalTransformerListenerRegistryUtil.getTransformerListeners();
        for (TransformerListener transformerListener : transformerListeners) {
            if (_logXmlBeforeListener.isDebugEnabled()) {
                _logXmlBeforeListener.debug((Object)document);
            }
            if (transformerListener != null) {
                document = transformerListener.onXml(document, languageId, tokens);
                if (_logXmlAfterListener.isDebugEnabled()) {
                    _logXmlAfterListener.debug((Object)document);
                }
            }
            if (_logScriptBeforeListener.isDebugEnabled()) {
                _logScriptBeforeListener.debug((Object)script);
            }
            if (transformerListener == null) continue;
            script = transformerListener.onScript(script, document, languageId, tokens);
            if (!_logScriptAfterListener.isDebugEnabled()) continue;
            _logScriptAfterListener.debug((Object)script);
        }
        String output = null;
        if (Validator.isNull((String)langType)) {
            output = LocalizationUtil.getLocalization((String)document.asXML(), (String)languageId);
        } else {
            long companyId = 0L;
            long companyGroupId = 0L;
            long articleGroupId = 0L;
            long classNameId = 0L;
            if (tokens != null) {
                companyId = GetterUtil.getLong((String)tokens.get("company_id"));
                companyGroupId = GetterUtil.getLong((String)tokens.get("company_group_id"));
                articleGroupId = GetterUtil.getLong((String)tokens.get("article_group_id"));
                classNameId = GetterUtil.getLong((String)tokens.get("class_name_id"));
            }
            long scopeGroupId = 0L;
            long siteGroupId = 0L;
            if (themeDisplay != null) {
                companyId = themeDisplay.getCompanyId();
                companyGroupId = themeDisplay.getCompanyGroupId();
                scopeGroupId = themeDisplay.getScopeGroupId();
                siteGroupId = themeDisplay.getSiteGroupId();
            }
            String templateId = tokens.get("template_id");
            templateId = this.getTemplateId(templateId, companyId, companyGroupId, articleGroupId);
            Template template = this.getTemplate(templateId, tokens, languageId, document, script, langType);
            if (themeDisplay != null && themeDisplay.getRequest() != null) {
                HttpServletRequest request = themeDisplay.getRequest();
                if (portletRequestModel != null) {
                    request.setAttribute("javax.portlet.request", (Object)portletRequestModel.getPortletRequest());
                    request.setAttribute("javax.portlet.response", (Object)portletRequestModel.getPortletResponse());
                    request.setAttribute("javax.portlet.lifecycle_phase", (Object)portletRequestModel.getLifecycle());
                }
                template.prepare(request);
            }
            if (contextObjects != null) {
                template.putAll(contextObjects);
            }
            UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
            try {
                Locale locale = LocaleUtil.fromLanguageId((String)languageId);
                if (document != null) {
                    Element rootElement = document.getRootElement();
                    List<TemplateNode> templateNodes = this.getTemplateNodes(themeDisplay, rootElement, Long.valueOf(tokens.get("ddm_structure_id")), locale);
                    if (templateNodes != null) {
                        for (TemplateNode templateNode : templateNodes) {
                            template.put((Object)templateNode.getName(), (Object)templateNode);
                        }
                    }
                    if (portletRequestModel != null) {
                        template.put((Object)"requestMap", (Object)portletRequestModel.toMap());
                        if (langType.equals("xsl")) {
                            Document requestDocument = SAXReaderUtil.read((String)portletRequestModel.toXML());
                            Element requestElement = requestDocument.getRootElement();
                            template.put((Object)"xmlRequest", (Object)requestElement.asXML());
                        }
                    } else {
                        Element requestElement = rootElement.element("request");
                        template.put((Object)"requestMap", this.insertRequestVariables(requestElement));
                        if (langType.equals("xsl")) {
                            template.put((Object)"xmlRequest", (Object)requestElement.asXML());
                        }
                    }
                }
                template.put((Object)"articleGroupId", (Object)articleGroupId);
                template.put((Object)"company", (Object)this.getCompany(themeDisplay, companyId));
                template.put((Object)"companyId", (Object)companyId);
                template.put((Object)"device", (Object)this.getDevice(themeDisplay));
                template.put((Object)"locale", (Object)locale);
                template.put((Object)"permissionChecker", (Object)PermissionThreadLocal.getPermissionChecker());
                template.put((Object)"randomNamespace", (Object)(StringUtil.randomId() + "_"));
                template.put((Object)"scopeGroupId", (Object)scopeGroupId);
                template.put((Object)"siteGroupId", (Object)siteGroupId);
                String templatesPath = this.getTemplatesPath(companyId, articleGroupId, classNameId);
                template.put((Object)"templatesPath", (Object)templatesPath);
                template.put((Object)"viewMode", (Object)viewMode);
                if (themeDisplay != null) {
                    TemplateManager templateManager = TemplateManagerUtil.getTemplateManager((String)langType);
                    HttpServletRequest request = themeDisplay.getRequest();
                    templateManager.addTaglibSupport((Map)template, request, themeDisplay.getResponse());
                    templateManager.addTaglibTheme((Map)template, "taglibLiferay", request, (HttpServletResponse)new PipingServletResponse(themeDisplay.getResponse(), (Writer)unsyncStringWriter));
                }
                template.put((Object)"groupId", (Object)articleGroupId);
                template.put((Object)"journalTemplatesPath", (Object)templatesPath);
                this.mergeTemplate(template, unsyncStringWriter, propagateException);
            }
            catch (Exception e) {
                if (e instanceof DocumentException) {
                    throw new TransformException("Unable to read XML document", (Throwable)e);
                }
                if (e instanceof IOException) {
                    throw new TransformException("Error reading template", (Throwable)e);
                }
                if (e instanceof TransformException) {
                    throw (TransformException)e;
                }
                throw new TransformException("Unhandled exception", (Throwable)e);
            }
            output = unsyncStringWriter.toString();
        }
        for (TransformerListener transformerListener : transformerListeners) {
            if (_logOutputBeforeListener.isDebugEnabled()) {
                _logOutputBeforeListener.debug((Object)output);
            }
            output = transformerListener.onOutput(output, languageId, tokens);
            if (!_logOutputAfterListener.isDebugEnabled()) continue;
            _logOutputAfterListener.debug((Object)output);
        }
        if (_logTransfromAfter.isDebugEnabled()) {
            _logTransfromAfter.debug((Object)output);
        }
        return output;
    }

    protected ClassLoader getClassLoader() {
        Class<?> clazz = this.getClass();
        return clazz.getClassLoader();
    }

    protected Company getCompany(ThemeDisplay themeDisplay, long companyId) throws Exception {
        if (themeDisplay != null) {
            return themeDisplay.getCompany();
        }
        return CompanyLocalServiceUtil.getCompany((long)companyId);
    }

    protected Device getDevice(ThemeDisplay themeDisplay) {
        if (themeDisplay != null) {
            return themeDisplay.getDevice();
        }
        return UnknownDevice.getInstance();
    }

    protected TemplateResource getErrorTemplateResource(String langType) {
        try {
            long companyId = CompanyThreadLocal.getCompanyId();
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)companyId);
            String template = "";
            if (langType.equals("ftl")) {
                template = journalServiceConfiguration.errorTemplateFTL();
            } else if (langType.equals("vm")) {
                template = journalServiceConfiguration.errorTemplateVM();
            } else if (langType.equals("xsl")) {
                template = journalServiceConfiguration.errorTemplateXSL();
            } else {
                return null;
            }
            return new StringTemplateResource(langType, template);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Template getTemplate(String templateId, Map<String, String> tokens, String languageId, Document document, String script, String langType) throws Exception {
        StringTemplateResource templateResource = null;
        if (langType.equals("xsl")) {
            JournalXSLURIResolver xslURIResolver = new JournalXSLURIResolver(tokens, languageId);
            templateResource = new XSLTemplateResource(templateId, script, (XSLURIResolver)xslURIResolver, document.asXML());
        } else {
            templateResource = new StringTemplateResource(templateId, script);
        }
        TemplateResource errorTemplateResource = this.getErrorTemplateResource(langType);
        return TemplateManagerUtil.getTemplate((String)langType, (TemplateResource)templateResource, (TemplateResource)errorTemplateResource, (boolean)this._restricted);
    }

    protected String getTemplateId(String templateId, long companyId, long companyGroupId, long groupId) {
        StringBundler sb = new StringBundler(5);
        sb.append(companyId);
        sb.append("#");
        if (companyGroupId > 0L) {
            sb.append(companyGroupId);
        } else {
            sb.append(groupId);
        }
        sb.append("#");
        sb.append(templateId);
        return sb.toString();
    }

    protected List<TemplateNode> getTemplateNodes(ThemeDisplay themeDisplay, Element element, long ddmStructureId) throws Exception {
        Locale locale = LocaleThreadLocal.getSiteDefaultLocale();
        if (themeDisplay != null && themeDisplay.getLocale() != null) {
            locale = themeDisplay.getLocale();
        }
        return this.getTemplateNodes(themeDisplay, element, ddmStructureId, locale);
    }

    protected List<TemplateNode> getTemplateNodes(ThemeDisplay themeDisplay, Element element, long ddmStructureId, Locale locale) throws Exception {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        DDMForm ddmForm = ddmStructure.getDDMForm();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        ArrayList<TemplateNode> templateNodes = new ArrayList<TemplateNode>();
        HashMap<String, TemplateNode> prototypeTemplateNodes = new HashMap<String, TemplateNode>();
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            TemplateNode prototypeTemplateNode;
            String name;
            Element dynamicContentElement = dynamicElementElement.element("dynamic-content");
            String data = "";
            if (dynamicContentElement != null) {
                data = dynamicContentElement.getText();
            }
            if ((name = dynamicElementElement.attributeValue("name", "")).length() == 0) {
                throw new TransformException("Element missing \"name\" attribute");
            }
            String type = dynamicElementElement.attributeValue("type", "");
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (type.equals("image")) {
                JSONObject dataJSONObject = JSONFactoryUtil.createJSONObject((String)data);
                Iterator itr = dataJSONObject.keys();
                while (itr.hasNext()) {
                    String key = (String)itr.next();
                    String value = dataJSONObject.getString(key);
                    attributes.put(key, value);
                }
            }
            if (dynamicContentElement != null) {
                for (Attribute attribute : dynamicContentElement.attributes()) {
                    attributes.put(attribute.getName(), attribute.getValue());
                }
            }
            TemplateNode templateNode = new TemplateNode(themeDisplay, name, StringUtil.stripCDATA((String)data), type, attributes);
            if (dynamicElementElement.element("dynamic-element") != null) {
                templateNode.appendChildren(this.getTemplateNodes(themeDisplay, dynamicElementElement, ddmStructureId, locale));
            } else if (dynamicContentElement != null && dynamicContentElement.element("option") != null) {
                List optionElements = dynamicContentElement.elements("option");
                for (Element optionElement : optionElements) {
                    templateNode.appendOption(StringUtil.stripCDATA((String)optionElement.getText()));
                }
            }
            DDMFormField ddmFormField = (DDMFormField)ddmFormFieldsMap.get(name);
            if (ddmFormField != null) {
                DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
                Map options = ddmFormFieldOptions.getOptions();
                for (Map.Entry entry : options.entrySet()) {
                    String optionValue = StringUtil.stripCDATA((String)((String)entry.getKey()));
                    LocalizedValue localizedLabel = (LocalizedValue)entry.getValue();
                    String optionLabel = localizedLabel.getString(locale);
                    templateNode.appendOptionMap(optionValue, optionLabel);
                }
            }
            if ((prototypeTemplateNode = (TemplateNode)prototypeTemplateNodes.get(name)) == null) {
                prototypeTemplateNode = templateNode;
                prototypeTemplateNodes.put(name, prototypeTemplateNode);
                templateNodes.add(templateNode);
            }
            prototypeTemplateNode.appendSibling(templateNode);
        }
        return templateNodes;
    }

    protected String getTemplatesPath(long companyId, long groupId, long classNameId) {
        StringBundler sb = new StringBundler(7);
        sb.append("_TEMPLATE_CONTEXT_");
        sb.append("/");
        sb.append(companyId);
        sb.append("/");
        sb.append(groupId);
        sb.append("/");
        sb.append(classNameId);
        return sb.toString();
    }

    protected Map<String, Object> insertRequestVariables(Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (element == null) {
            return map;
        }
        for (Element childElement : element.elements()) {
            Element nameElement;
            String name = childElement.getName();
            if (name.equals("attribute")) {
                nameElement = childElement.element("name");
                Element valueElement = childElement.element("value");
                map.put(nameElement.getText(), valueElement.getText());
                continue;
            }
            if (name.equals("parameter")) {
                nameElement = childElement.element("name");
                List valueElements = childElement.elements("value");
                if (valueElements.size() == 1) {
                    Element valueElement = (Element)valueElements.get(0);
                    map.put(nameElement.getText(), valueElement.getText());
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                for (Element valueElement : valueElements) {
                    values.add(valueElement.getText());
                }
                map.put(nameElement.getText(), values);
                continue;
            }
            List elements = childElement.elements();
            if (!elements.isEmpty()) {
                map.put(name, this.insertRequestVariables(childElement));
                continue;
            }
            map.put(name, childElement.getText());
        }
        return map;
    }

    protected void mergeTemplate(Template template, UnsyncStringWriter unsyncStringWriter, boolean propagateException) throws Exception {
        if (propagateException) {
            template.doProcessTemplate((Writer)unsyncStringWriter);
        } else {
            template.processTemplate((Writer)unsyncStringWriter);
        }
    }
}

