/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.transformer;

import com.liferay.journal.internal.util.JournalHelperUtil;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.xsl.XSLURIResolver;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class JournalXSLURIResolver
implements Externalizable,
XSLURIResolver {
    private static final Log _log = LogFactoryUtil.getLog(JournalXSLURIResolver.class);
    private static final Pattern _templateIdPattern = Pattern.compile(".*_templateId=([0-9]+).*");
    private String _languageId;
    private Map<String, String> _tokens;

    public JournalXSLURIResolver(Map<String, String> tokens, String languageId) {
        if (tokens == null) {
            throw new IllegalArgumentException("Tokens map is null");
        }
        this._tokens = tokens;
        this._languageId = languageId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JournalXSLURIResolver)) {
            return false;
        }
        JournalXSLURIResolver journalXSLURIResolver = (JournalXSLURIResolver)obj;
        return Objects.equals(this._languageId, journalXSLURIResolver._languageId) && this._tokens.equals(journalXSLURIResolver._tokens);
    }

    public String getLanguageId() {
        return this._languageId;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (Object)this._languageId);
        return HashUtil.hash((int)hashCode, this._tokens);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this._languageId = objectInput.readUTF();
        if (this._languageId.equals("")) {
            this._languageId = null;
        }
        this._tokens = (Map)objectInput.readObject();
    }

    public Source resolve(String href, String base) {
        try {
            String content = null;
            Matcher matcher = _templateIdPattern.matcher(href);
            if (matcher.matches()) {
                long articleGroupId = GetterUtil.getLong((String)this._tokens.get("article_group_id"));
                String templateId = matcher.group(1);
                content = JournalHelperUtil.getTemplateScript(articleGroupId, templateId, this._tokens, this._languageId);
            } else {
                content = HttpUtil.URLtoString((String)href);
            }
            return new StreamSource((Reader)new UnsyncStringReader(content));
        }
        catch (Exception e) {
            _log.error((Object)(href + " does not reference a valid template"));
            return null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this._languageId == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this._languageId);
        }
        objectOutput.writeObject(this._tokens);
    }
}

