/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.transformer;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.BaseTransformerListener;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet"}, service={TransformerListener.class})
public class LocaleTransformerListener
extends BaseTransformerListener {
    private static final Log _log = LogFactoryUtil.getLog(LocaleTransformerListener.class);
    private DDMStructureLocalService _ddmStructureLocalService;

    public String onScript(String script, Document document, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        return StringUtil.replace((String)script, (String)"@language_id@", (String)languageId);
    }

    public Document onXml(Document document, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onXml");
        }
        this.filterByLocalizability(document, tokens);
        this.filterByLanguage(document, languageId);
        return document;
    }

    protected void filter(Element dynamicElementElement, DDMStructure ddmStructure, String name, String defaultLanguageId) throws PortalException {
        boolean localizable = GetterUtil.getBoolean((String)ddmStructure.getFieldProperty(name, "localizable"));
        List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
        for (Element dynamicContentElement : dynamicContentElements) {
            String languageId = dynamicContentElement.attributeValue("language-id");
            if (localizable || languageId.equals(defaultLanguageId)) continue;
            dynamicElementElement.remove(dynamicContentElement);
        }
    }

    protected void filterByLanguage(Document document, String languageId) {
        String defaultLanguageId;
        String articleDefaultLanguageId;
        Element rootElement = document.getRootElement();
        String[] availableLanguageIds = StringUtil.split((String)rootElement.attributeValue("available-locales", articleDefaultLanguageId = rootElement.attributeValue("default-locale", defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()))));
        if (!ArrayUtil.contains((String[])availableLanguageIds, (String)languageId, (boolean)true)) {
            this.filterByLanguage(rootElement, articleDefaultLanguageId, articleDefaultLanguageId);
        } else {
            this.filterByLanguage(rootElement, languageId, articleDefaultLanguageId);
        }
    }

    protected void filterByLanguage(Element root, String languageId, String defaultLanguageId) {
        Element defaultLanguageElement = null;
        boolean hasLanguageIdElement = false;
        for (Element element : root.elements()) {
            String tempLanguageId = element.attributeValue("language-id", languageId);
            if (StringUtil.equalsIgnoreCase((String)tempLanguageId, (String)languageId)) {
                if (Validator.isNotNull((String)element.attributeValue("language-id", ""))) {
                    hasLanguageIdElement = true;
                }
                this.filterByLanguage(element, languageId, defaultLanguageId);
                continue;
            }
            if (StringUtil.equalsIgnoreCase((String)tempLanguageId, (String)defaultLanguageId)) {
                defaultLanguageElement = element;
            }
            root.remove(element);
        }
        if (!hasLanguageIdElement && defaultLanguageElement != null) {
            root.add(defaultLanguageElement);
            this.filterByLanguage(defaultLanguageElement, languageId, defaultLanguageId);
        }
    }

    protected void filterByLocalizability(Document document, Map<String, String> tokens) {
        try {
            long ddmStructureId = GetterUtil.getLong((String)tokens.get("ddm_structure_id"));
            DDMStructure ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(ddmStructureId);
            if (ddmStructure == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Not checking localization because dynamic data mapping structure is not available");
                }
                return;
            }
            Element rootElement = document.getRootElement();
            String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            String articleDefaultLanguageId = rootElement.attributeValue("default-locale", defaultLanguageId);
            this.filterByLocalizability(rootElement, articleDefaultLanguageId, ddmStructure);
        }
        catch (NullPointerException npe) {
            _log.error((Object)"Unable to filter by localizability", (Throwable)npe);
        }
        catch (PortalException pe) {
            _log.error((Object)"Unable to filter by localizability", (Throwable)pe);
        }
    }

    protected void filterByLocalizability(Element root, String defaultLanguageId, DDMStructure ddmStructure) throws PortalException {
        for (Element element : root.elements("dynamic-element")) {
            String name = element.attributeValue("name");
            if (!ddmStructure.hasField(name)) continue;
            if (!ddmStructure.isFieldTransient(name)) {
                this.filter(element, ddmStructure, name, defaultLanguageId);
            }
            this.filterByLocalizability(element, defaultLanguageId, ddmStructure);
        }
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }
}

