/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.trash;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.journal.exception.InvalidDDMStructureException;
import com.liferay.journal.internal.trash.JournalBaseTrashHandler;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.util.JournalHelper;
import com.liferay.journal.util.impl.JournalUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalFolder"}, service={TrashHandler.class})
public class JournalFolderTrashHandler
extends JournalBaseTrashHandler {
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalFolder)")
    private ModelResourcePermission<JournalFolder> _journalFolderModelResourcePermission;
    @Reference
    private JournalHelper _journalHelper;

    public void checkRestorableEntry(long classPK, long containerModelId, String newName) throws PortalException {
        JournalFolder folder = this._journalFolderLocalService.getFolder(classPK);
        this.checkRestorableEntry(classPK, 0L, containerModelId, folder.getName(), newName);
    }

    public void checkRestorableEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException {
        this.checkRestorableEntry(trashEntry.getClassPK(), trashEntry.getEntryId(), containerModelId, trashEntry.getTypeSettingsProperty("title"), newName);
    }

    public void deleteTrashEntry(long classPK) throws PortalException {
        this._journalFolderLocalService.deleteFolder(classPK, false);
    }

    public String getClassName() {
        return JournalFolder.class.getName();
    }

    public String getDeleteMessage() {
        return "found-in-deleted-folder-x";
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        JournalFolder folder = this.getJournalFolder(classPK);
        long parentFolderId = folder.getParentFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        JournalFolder folder = this._journalFolderLocalService.getFolder(classPK);
        return JournalUtil.getJournalControlPanelLink(portletRequest, folder.getFolderId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        JournalFolder folder = this._journalFolderLocalService.getFolder(classPK);
        return JournalUtil.getJournalControlPanelLink(portletRequest, folder.getParentFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        JournalFolder folder = this._journalFolderLocalService.getFolder(classPK);
        return this._journalHelper.getAbsolutePath(portletRequest, folder.getParentFolderId());
    }

    public TrashedModel getTrashedModel(long classPK) {
        return this._journalFolderLocalService.fetchFolder(classPK);
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalFolder.class);
        return (TrashRenderer)assetRendererFactory.getAssetRenderer(classPK);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return ModelResourcePermissionHelper.contains(this._journalFolderModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)classPK, (String)"ADD_FOLDER");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isMovable(long classPK) throws PortalException {
        JournalFolder parentFolder;
        JournalFolder folder = this.getJournalFolder(classPK);
        return folder.getParentFolderId() > 0L && ((parentFolder = this._journalFolderLocalService.fetchFolder(folder.getParentFolderId())) == null || parentFolder.isInTrash());
    }

    public boolean isRestorable(long classPK) throws PortalException {
        JournalFolder folder = this.getJournalFolder(classPK);
        if (folder.getParentFolderId() > 0L && this._journalFolderLocalService.fetchFolder(folder.getParentFolderId()) == null) {
            return false;
        }
        if (!this.hasTrashPermission(PermissionThreadLocal.getPermissionChecker(), folder.getGroupId(), classPK, "RESTORE")) {
            return false;
        }
        return !folder.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this._journalFolderLocalService.moveFolder(classPK, containerModelId, serviceContext);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this._journalFolderLocalService.moveFolderFromTrash(userId, classPK, containerModelId, serviceContext);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        this._journalFolderLocalService.restoreFolderFromTrash(userId, classPK);
    }

    public void updateTitle(long classPK, String name) throws PortalException {
        JournalFolder folder = this._journalFolderLocalService.getFolder(classPK);
        folder.setName(name);
        this._journalFolderLocalService.updateJournalFolder(folder);
    }

    protected void checkDuplicateEntry(long classPK, long trashEntryId, long containerModelId, String originalTitle, String newName) throws PortalException {
        JournalFolder duplicateFolder;
        JournalFolder folder = this._journalFolderLocalService.getFolder(classPK);
        if (containerModelId == -1L) {
            containerModelId = 0L;
        }
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((duplicateFolder = this._journalFolderLocalService.fetchFolder(folder.getGroupId(), containerModelId, originalTitle)) != null) {
            RestoreEntryException ree = new RestoreEntryException(1);
            ree.setDuplicateEntryId(duplicateFolder.getFolderId());
            ree.setOldName(duplicateFolder.getName());
            ree.setTrashEntryId(trashEntryId);
            throw ree;
        }
    }

    protected void checkRestorableEntry(long classPK, long trashEntryId, long containerModelId, String originalTitle, String newName) throws PortalException {
        this.checkValidContainer(classPK, containerModelId);
        this.checkDuplicateEntry(classPK, trashEntryId, containerModelId, originalTitle, newName);
    }

    protected void checkValidContainer(long classPK, long containerModelId) throws PortalException {
        try {
            this._journalFolderLocalService.validateFolderDDMStructures(classPK, containerModelId);
        }
        catch (InvalidDDMStructureException iddmse) {
            throw new RestoreEntryException(2, (Throwable)iddmse);
        }
    }

    @Override
    protected long getGroupId(long classPK) throws PortalException {
        JournalFolder folder = this._journalFolderLocalService.getFolder(classPK);
        return folder.getGroupId();
    }

    protected JournalFolder getJournalFolder(long classPK) throws PortalException {
        return this._journalFolderLocalService.getFolder(classPK);
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        return this._journalFolderModelResourcePermission.contains(permissionChecker, classPK, actionId);
    }

    @Reference(unbind="-")
    protected void setJournalFolderLocalService(JournalFolderLocalService journalFolderLocalService) {
        this._journalFolderLocalService = journalFolderLocalService;
    }
}

