/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class UpgradeJournalArticleLocalizedValues
extends UpgradeProcess {
    private static final int _MAX_LENGTH_DESCRIPTION = 4000;
    private static final int _MAX_LENGTH_TITLE = 400;
    private static final Log _log = LogFactoryUtil.getLog(UpgradeJournalArticleLocalizedValues.class);
    private final Map<Long, Locale> _defaultSiteLocales = new HashMap<Long, Locale>();

    protected void doUpgrade() throws Exception {
        if (!this.hasColumn("JournalArticle", "title") || !this.hasColumn("JournalArticle", "description")) {
            throw new IllegalStateException("JournalArticle must have title and description columns");
        }
        this.upgradeSchema();
        this.updateJournalArticleDefaultLanguageId();
        this.updateJournalArticleLocalizedFields();
        this.dropTitleColumn();
        this.dropDescriptionColumn();
    }

    protected void dropDescriptionColumn() throws Exception {
        block2: {
            try {
                this.runSQL("alter table JournalArticle drop column description");
            }
            catch (SQLException sqle) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)sqle, (Throwable)sqle);
            }
        }
    }

    protected void dropTitleColumn() throws Exception {
        block2: {
            try {
                this.runSQL("alter table JournalArticle drop column title");
            }
            catch (SQLException sqle) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)sqle, (Throwable)sqle);
            }
        }
    }

    protected void updateJournalArticleDefaultLanguageId() throws Exception {
        if (!this.hasColumn("JournalArticle", "defaultLanguageId")) {
            this.runSQL("alter table JournalArticle add defaultLanguageId VARCHAR(75) null");
        }
        this._updateDefaultLanguage("title", false);
        this._updateDefaultLanguage("content", true);
    }

    protected void updateJournalArticleLocalizedFields() throws Exception {
        StringBundler sb = new StringBundler(3);
        sb.append("insert into JournalArticleLocalization(");
        sb.append("articleLocalizationId, companyId, articlePK, title, ");
        sb.append("description, languageId) values(?, ?, ?, ?, ?, ?)");
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select id_, companyId, title, description, defaultLanguageId from JournalArticle");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb.toString());
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long articleId = rs.getLong(1);
                long companyId = rs.getLong(2);
                String defaultLanguageId = rs.getString(5);
                Map<Locale, String> titleMap = UpgradeJournalArticleLocalizedValues._getLocalizationMap(rs.getString(3), defaultLanguageId);
                Map<Locale, String> descriptionMap = UpgradeJournalArticleLocalizedValues._getLocalizationMap(rs.getString(4), defaultLanguageId);
                HashSet<Locale> locales = new HashSet<Locale>();
                locales.addAll(titleMap.keySet());
                locales.addAll(descriptionMap.keySet());
                for (Locale locale : locales) {
                    String localizedTitle = titleMap.get(locale);
                    String localizedDescription = descriptionMap.get(locale);
                    if (localizedTitle != null && localizedTitle.length() > 400) {
                        localizedTitle = StringUtil.shorten((String)localizedTitle, (int)400);
                        this._log(articleId, "title");
                    }
                    if (localizedDescription != null) {
                        String safeLocalizedDescription = this._truncate(localizedDescription, 4000);
                        if (localizedDescription != safeLocalizedDescription) {
                            this._log(articleId, "description");
                        }
                        localizedDescription = safeLocalizedDescription;
                    }
                    ps2.setLong(1, UpgradeJournalArticleLocalizedValues._increment());
                    ps2.setLong(2, companyId);
                    ps2.setLong(3, articleId);
                    ps2.setString(4, localizedTitle);
                    ps2.setString(5, localizedDescription);
                    ps2.setString(6, LocaleUtil.toLanguageId((Locale)locale));
                    ps2.addBatch();
                }
            }
            ps2.executeBatch();
        }
    }

    protected void upgradeSchema() throws Exception {
        if (this.hasTable("JournalArticleLocalization")) {
            this.runSQL("drop table JournalArticleLocalization");
        }
        String template = StringUtil.read((InputStream)UpgradeJournalArticleLocalizedValues.class.getResourceAsStream("dependencies/update.sql"));
        this.runSQLTemplateString(template, false, false);
    }

    private static Map<Locale, String> _getLocalizationMap(String value, String defaultLanguageId) {
        if (Validator.isXml((String)value)) {
            return LocalizationUtil.getLocalizationMap((String)value);
        }
        HashMap<Locale, String> localizationMap = new HashMap<Locale, String>();
        localizationMap.put(LocaleUtil.fromLanguageId((String)defaultLanguageId), value);
        return localizationMap;
    }

    private static long _increment() {
        DB db = DBManagerUtil.getDB();
        return db.increment();
    }

    private void _log(long articleId, String columnName) {
        if (!_log.isWarnEnabled()) {
            return;
        }
        _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Truncated the ", columnName, " value for article ", articleId, " because it is too long"}));
    }

    private String _truncate(String value, int maxLength) throws Exception {
        byte[] valueBytes = value.getBytes("UTF-8");
        if (valueBytes.length <= maxLength) {
            return value;
        }
        byte[] convertedValue = new byte[maxLength];
        System.arraycopy(valueBytes, 0, convertedValue, 0, maxLength);
        String returnValue = new String(convertedValue, "UTF-8");
        return StringUtil.shorten((String)returnValue, (int)(returnValue.length() - 1));
    }

    private void _updateDefaultLanguage(String columnName, boolean strictUpdate) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select id_, groupId, ", columnName, " from JournalArticle where defaultLanguageId is null or ", "defaultLanguageId = ''"}));
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set defaultLanguageId = ? where id_ = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String columnValue = rs.getString(3);
                if (!Validator.isXml((String)columnValue) && !strictUpdate) continue;
                long groupId = rs.getLong(2);
                Locale defaultSiteLocale = this._defaultSiteLocales.get(groupId);
                if (defaultSiteLocale == null) {
                    defaultSiteLocale = PortalUtil.getSiteDefaultLocale((long)groupId);
                    this._defaultSiteLocales.put(groupId, defaultSiteLocale);
                }
                ps2.setString(1, LocalizationUtil.getDefaultLanguageId((String)columnValue, (Locale)defaultSiteLocale));
                ps2.setLong(2, rs.getLong(1));
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }
}

