/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_6;

import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class UpgradeAssetDisplayPageEntry
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeAssetDisplayPageEntry.class);
    private final AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    private final CompanyLocalService _companyLocalService;

    public UpgradeAssetDisplayPageEntry(AssetDisplayPageEntryLocalService assetDisplayPageEntryLocalService, CompanyLocalService companyLocalService) {
        this._assetDisplayPageEntryLocalService = assetDisplayPageEntryLocalService;
        this._companyLocalService = companyLocalService;
    }

    protected void doUpgrade() throws Exception {
        List companies = this._companyLocalService.getCompanies();
        for (Company company : companies) {
            this.updateAssetDisplayPageEntry(company);
        }
    }

    protected void updateAssetDisplayPageEntry(Company company) throws Exception {
        StringBuilder sb = new StringBuilder(9);
        sb.append("select groupId, resourcePrimKey from JournalArticle ");
        sb.append("where JournalArticle.companyId = ? and ");
        sb.append("JournalArticle.layoutUuid is not null and ");
        sb.append("JournalArticle.layoutUuid != '' and not exists ( ");
        sb.append("select 1 from AssetDisplayPageEntry where ");
        sb.append("AssetDisplayPageEntry.groupId = JournalArticle.groupId ");
        sb.append("and AssetDisplayPageEntry.classNameId = ? and ");
        sb.append("AssetDisplayPageEntry.classPK = ");
        sb.append("JournalArticle.resourcePrimKey ) ");
        sb.append("group by groupId, resourcePrimKey");
        long journalArticleClassNameId = PortalUtil.getClassNameId(JournalArticle.class);
        User user = company.getDefaultUser();
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement(SQLTransformer.transform((String)sb.toString()));){
            ps1.setLong(1, company.getCompanyId());
            ps1.setLong(2, journalArticleClassNameId);
            ArrayList<SaveAssetDisplayPageEntryCallable> saveAssetDisplayPageEntryCallables = new ArrayList<SaveAssetDisplayPageEntryCallable>();
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long groupId = rs.getLong("groupId");
                    long resourcePrimKey = rs.getLong("resourcePrimKey");
                    SaveAssetDisplayPageEntryCallable saveAssetDisplayPageEntryCallable = new SaveAssetDisplayPageEntryCallable(groupId, user.getUserId(), journalArticleClassNameId, resourcePrimKey);
                    saveAssetDisplayPageEntryCallables.add(saveAssetDisplayPageEntryCallable);
                }
            }
            ExecutorService executorService = Executors.newWorkStealingPool();
            List futures = executorService.invokeAll(saveAssetDisplayPageEntryCallables);
            executorService.shutdown();
            for (Future future : futures) {
                boolean success = GetterUtil.get(future.get(), (boolean)true);
                if (success) continue;
                throw new UpgradeException("Unable to add asset display pages for the journal articles");
            }
        }
    }

    private class SaveAssetDisplayPageEntryCallable
    implements Callable<Boolean> {
        private final long _classNameId;
        private final long _classPK;
        private final long _groupId;
        private final long _userId;

        public SaveAssetDisplayPageEntryCallable(long groupId, long userId, long classNameId, long classPK) {
            this._groupId = groupId;
            this._userId = userId;
            this._classNameId = classNameId;
            this._classPK = classPK;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setUuid(PortalUUIDUtil.generate());
                UpgradeAssetDisplayPageEntry.this._assetDisplayPageEntryLocalService.addAssetDisplayPageEntry(this._userId, this._groupId, this._classNameId, this._classPK, 0L, 2, serviceContext);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to add asset display page entry for article " + this._classPK), (Throwable)e);
                return false;
            }
            return true;
        }
    }
}

