/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.util;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.FieldConstants;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMFieldsCounter;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.journal.exception.ArticleContentException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.util.JournalConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={JournalConverter.class})
public class JournalConverterImpl
implements JournalConverter {
    private static final Log _log = LogFactoryUtil.getLog(JournalConverterImpl.class);
    private final Map<String, String> _ddmDataTypes = new HashMap<String, String>();
    private final Map<String, String> _ddmMetadataAttributes;
    private final Map<String, String> _ddmTypesToJournalTypes;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Http _http;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    private final Map<String, String> _journalTypesToDDMTypes;
    @Reference(unbind="-")
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public JournalConverterImpl() {
        this._ddmDataTypes.put("boolean", "boolean");
        this._ddmDataTypes.put("document_library", "document-library");
        this._ddmDataTypes.put("image", "image");
        this._ddmDataTypes.put("link_to_layout", "link-to-page");
        this._ddmDataTypes.put("list", "string");
        this._ddmDataTypes.put("multi-list", "string");
        this._ddmDataTypes.put("text", "string");
        this._ddmDataTypes.put("text_area", "html");
        this._ddmDataTypes.put("text_box", "string");
        this._ddmMetadataAttributes = new HashMap<String, String>();
        this._ddmMetadataAttributes.put("instructions", "tip");
        this._ddmMetadataAttributes.put("label", "label");
        this._ddmMetadataAttributes.put("predefinedValue", "predefinedValue");
        this._ddmTypesToJournalTypes = new HashMap<String, String>();
        this._ddmTypesToJournalTypes.put("checkbox", "boolean");
        this._ddmTypesToJournalTypes.put("ddm-documentlibrary", "document_library");
        this._ddmTypesToJournalTypes.put("ddm-image", "image");
        this._ddmTypesToJournalTypes.put("ddm-link-to-page", "link_to_layout");
        this._ddmTypesToJournalTypes.put("ddm-separator", "selection_break");
        this._ddmTypesToJournalTypes.put("ddm-text-html", "text_area");
        this._ddmTypesToJournalTypes.put("select", "list");
        this._ddmTypesToJournalTypes.put("text", "text");
        this._ddmTypesToJournalTypes.put("textarea", "text_box");
        this._journalTypesToDDMTypes = new HashMap<String, String>();
        this._journalTypesToDDMTypes.put("boolean", "checkbox");
        this._journalTypesToDDMTypes.put("document_library", "ddm-documentlibrary");
        this._journalTypesToDDMTypes.put("image", "ddm-image");
        this._journalTypesToDDMTypes.put("image_gallery", "ddm-documentlibrary");
        this._journalTypesToDDMTypes.put("link_to_layout", "ddm-link-to-page");
        this._journalTypesToDDMTypes.put("list", "select");
        this._journalTypesToDDMTypes.put("multi-list", "select");
        this._journalTypesToDDMTypes.put("selection_break", "ddm-separator");
        this._journalTypesToDDMTypes.put("text", "text");
        this._journalTypesToDDMTypes.put("text_area", "ddm-text-html");
        this._journalTypesToDDMTypes.put("text_box", "textarea");
    }

    public String getContent(DDMStructure ddmStructure, Fields ddmFields) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        String availableLocales = this.getAvailableLocales(ddmFields);
        rootElement.addAttribute("available-locales", availableLocales);
        Locale defaultLocale = ddmFields.getDefaultLocale();
        rootElement.addAttribute("default-locale", LocaleUtil.toLanguageId((Locale)defaultLocale));
        DDMFieldsCounter ddmFieldsCounter = new DDMFieldsCounter();
        for (String fieldName : ddmStructure.getRootFieldNames()) {
            int repetitions = this.countFieldRepetition(ddmFields, fieldName, null, -1);
            for (int i = 0; i < repetitions; ++i) {
                Element dynamicElementElement = rootElement.addElement("dynamic-element");
                dynamicElementElement.addAttribute("name", fieldName);
                this.updateContentDynamicElement(dynamicElementElement, ddmStructure, ddmFields, ddmFieldsCounter);
            }
        }
        try {
            return XMLUtil.formatXML((String)document.asXML());
        }
        catch (Exception e) {
            throw new ArticleContentException("Unable to read content with an XML parser", (Throwable)e);
        }
    }

    public Fields getDDMFields(DDMStructure ddmStructure, Document document) throws PortalException {
        Field fieldsDisplayField = new Field(ddmStructure.getStructureId(), "_fieldsDisplay", (Serializable)((Object)""));
        Fields ddmFields = new Fields();
        ddmFields.put(fieldsDisplayField);
        Element rootElement = document.getRootElement();
        String[] availableLanguageIds = StringUtil.split((String)rootElement.attributeValue("available-locales"));
        String defaultLanguageId = rootElement.attributeValue("default-locale");
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.addDDMFields(dynamicElementElement, ddmStructure, ddmFields, availableLanguageIds, defaultLanguageId);
        }
        return ddmFields;
    }

    public Fields getDDMFields(DDMStructure ddmStructure, String content) throws PortalException {
        try {
            return this.getDDMFields(ddmStructure, SAXReaderUtil.read((String)content));
        }
        catch (DocumentException de) {
            throw new PortalException((Throwable)de);
        }
    }

    public DDMFormValues getDDMFormValues(DDMStructure ddmStructure, Fields fields) throws PortalException {
        return this._fieldsToDDMFormValuesConverter.convert(ddmStructure, fields);
    }

    @Deprecated
    public String getDDMXSD(String journalXSD) throws Exception {
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        return this.getDDMXSD(journalXSD, defaultLocale);
    }

    @Deprecated
    public String getDDMXSD(String journalXSD, Locale defaultLocale) throws Exception {
        Document document = SAXReaderUtil.read((String)journalXSD);
        Element rootElement = document.getRootElement();
        rootElement.addAttribute("available-locales", defaultLocale.toString());
        rootElement.addAttribute("default-locale", defaultLocale.toString());
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateJournalXSDDynamicElement(dynamicElementElement, defaultLocale.toString());
        }
        return XMLUtil.formatXML((Document)document);
    }

    @Deprecated
    public String getJournalXSD(String ddmXSD) throws Exception {
        Document document = SAXReaderUtil.read((String)ddmXSD);
        Element rootElement = document.getRootElement();
        String defaultLanguageId = rootElement.attributeValue("default-locale");
        this.removeAttribute(rootElement, "available-locales");
        this.removeAttribute(rootElement, "default-locale");
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateDDMXSDDynamicElement(dynamicElementElement, defaultLanguageId);
        }
        return XMLUtil.formatXML((Document)document);
    }

    protected void addDDMFields(Element dynamicElementElement, DDMStructure ddmStructure, Fields ddmFields, String[] availableLanguageIds, String defaultLanguageId) throws PortalException {
        String name = dynamicElementElement.attributeValue("name");
        if (!ddmStructure.hasField(name)) {
            return;
        }
        if (!ddmStructure.isFieldTransient(name)) {
            Field ddmField = this.getField(dynamicElementElement, ddmStructure, availableLanguageIds, defaultLanguageId);
            String fieldName = ddmField.getName();
            Field existingDDMField = ddmFields.get(fieldName);
            if (existingDDMField != null) {
                for (Locale locale : ddmField.getAvailableLocales()) {
                    existingDDMField.addValues(locale, ddmField.getValues(locale));
                }
            } else {
                ddmFields.put(ddmField);
            }
        }
        String instanceId = dynamicElementElement.attributeValue("instance-id");
        this.updateFieldsDisplay(ddmFields, name, instanceId);
        List childrenDynamicElementElements = dynamicElementElement.elements("dynamic-element");
        for (Element childrenDynamicElementElement : childrenDynamicElementElements) {
            this.addDDMFields(childrenDynamicElementElement, ddmStructure, ddmFields, availableLanguageIds, defaultLanguageId);
        }
    }

    protected void addMetadataEntry(Element metadataElement, String name, String value) {
        Element entryElement = metadataElement.addElement("entry");
        entryElement.addAttribute("name", name);
        entryElement.addCDATA(value);
    }

    protected void addMissingFieldValues(Field ddmField, String defaultLanguageId, Set<String> missingLanguageIds) {
        if (missingLanguageIds.isEmpty()) {
            return;
        }
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        Serializable fieldValue = ddmField.getValue(defaultLocale);
        for (String missingLanguageId : missingLanguageIds) {
            Locale missingLocale = LocaleUtil.fromLanguageId((String)missingLanguageId);
            ddmField.setValue(missingLocale, fieldValue);
        }
    }

    protected int countFieldRepetition(Fields ddmFields, String fieldName, String parentFieldName, int parentOffset) throws Exception {
        Field fieldsDisplayField = ddmFields.get("_fieldsDisplay");
        String[] fieldsDisplayValues = this.getDDMFieldsDisplayValues(fieldsDisplayField);
        int offset = -1;
        int repetitions = 0;
        for (String fieldDisplayName : fieldsDisplayValues) {
            if (offset > parentOffset) break;
            if (fieldDisplayName.equals(parentFieldName)) {
                ++offset;
            }
            if (!fieldDisplayName.equals(fieldName) || offset != parentOffset) continue;
            ++repetitions;
        }
        return repetitions;
    }

    protected String decodeURL(String url) {
        try {
            return this._http.decodeURL(url);
        }
        catch (IllegalArgumentException iae) {
            return url;
        }
    }

    protected Element fetchMetadataEntry(Element parentElement, String attributeName, String attributeValue) {
        StringBundler sb = new StringBundler(5);
        sb.append("entry[@");
        sb.append(attributeName);
        sb.append("=");
        sb.append(HtmlUtil.escapeXPathAttribute((String)attributeValue));
        sb.append("]");
        XPath xPathSelector = SAXReaderUtil.createXPath((String)sb.toString());
        return (Element)xPathSelector.selectSingleNode((Object)parentElement);
    }

    protected String getAvailableLocales(Fields ddmFields) {
        Set availableLocales = ddmFields.getAvailableLocales();
        Locale[] availableLocalesArray = new Locale[availableLocales.size()];
        availableLocalesArray = availableLocales.toArray(availableLocalesArray);
        Object[] languageIds = LocaleUtil.toLanguageIds((Locale[])availableLocalesArray);
        return StringUtil.merge((Object[])languageIds);
    }

    protected String[] getDDMFieldsDisplayValues(Field ddmFieldsDisplayField) throws PortalException {
        try {
            String[] values;
            DDMStructure ddmStructure = ddmFieldsDisplayField.getDDMStructure();
            ArrayList<String> fieldsDisplayValues = new ArrayList<String>();
            for (String value : values = this.splitFieldsDisplayValue(ddmFieldsDisplayField)) {
                String fieldName = StringUtil.extractFirst((String)value, (String)"_INSTANCE_");
                if (!ddmStructure.hasField(fieldName)) continue;
                fieldsDisplayValues.add(fieldName);
            }
            return fieldsDisplayValues.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
    }

    @Deprecated
    protected Serializable getDocumentLibraryValue(String url) {
        return null;
    }

    protected Field getField(Element dynamicElementElement, DDMStructure ddmStructure, String[] availableLanguageIds, String defaultLanguageId) throws PortalException {
        Field ddmField = new Field();
        ddmField.setDDMStructureId(ddmStructure.getStructureId());
        Locale defaultLocale = null;
        defaultLocale = defaultLanguageId == null ? LocaleUtil.getSiteDefault() : LocaleUtil.fromLanguageId((String)defaultLanguageId);
        ddmField.setDefaultLocale(defaultLocale);
        String name = dynamicElementElement.attributeValue("name");
        ddmField.setName(name);
        String dataType = ddmStructure.getFieldDataType(name);
        String type = ddmStructure.getFieldType(name);
        Set missingLanguageIds = SetUtil.fromArray((Object[])availableLanguageIds);
        missingLanguageIds.remove(defaultLanguageId);
        List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
        for (Element dynamicContentElement : dynamicContentElements) {
            Locale locale = defaultLocale;
            String languageId = dynamicContentElement.attributeValue("language-id");
            if (Validator.isNotNull((String)languageId)) {
                locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)true, (boolean)false);
                if (locale == null) continue;
                missingLanguageIds.remove(languageId);
            }
            Serializable serializable = this.getFieldValue(dataType, type, dynamicContentElement, defaultLocale);
            ddmField.addValue(locale, serializable);
        }
        this.addMissingFieldValues(ddmField, defaultLanguageId, missingLanguageIds);
        return ddmField;
    }

    protected String getFieldInstanceId(Fields ddmFields, String fieldName, int index) {
        String[] fieldsDisplayValues;
        Field fieldsDisplayField = ddmFields.get("_fieldsDisplay");
        String prefix = fieldName.concat("_INSTANCE_");
        for (String fieldsDisplayValue : fieldsDisplayValues = StringUtil.split((String)((String)((Object)fieldsDisplayField.getValue())))) {
            if (!fieldsDisplayValue.startsWith(prefix) || --index >= 0) continue;
            return StringUtil.extractLast((String)fieldsDisplayValue, (String)"_INSTANCE_");
        }
        return null;
    }

    protected Serializable getFieldValue(String dataType, String type, Element dynamicContentElement, Locale defaultLocale) {
        Object serializable = null;
        if (Objects.equals("ddm-documentlibrary", type)) {
            try {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)dynamicContentElement.getText());
                if (!ExportImportThreadLocal.isImportInProcess()) {
                    String uuid = jsonObject.getString("uuid");
                    long groupId = jsonObject.getLong("groupId");
                    this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
                }
                serializable = dynamicContentElement.getText();
            }
            catch (Exception e) {
                return "";
            }
        } else if (Objects.equals("ddm-journal-article", type)) {
            try {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)dynamicContentElement.getText());
                Long classPK = jsonObject.getLong("classPK");
                if (Validator.isNotNull((Long)classPK)) {
                    JournalArticle article = this._journalArticleLocalService.fetchLatestArticle(classPK.longValue());
                    if (article != null) {
                        jsonObject.put("groupId", article.getGroupId());
                        String title = article.getTitle(defaultLocale);
                        if (article.isInTrash()) {
                            jsonObject.put("message", LanguageUtil.get((ResourceBundle)this._getResourceBundle(defaultLocale), (String)"the-selected-web-content-was-moved-to-the-recycle-bin"));
                        }
                        jsonObject.put("title", title);
                        jsonObject.put("uuid", article.getUuid());
                    } else {
                        jsonObject.put("message", LanguageUtil.get((ResourceBundle)this._getResourceBundle(defaultLocale), (String)"the-selected-web-content-was-deleted"));
                    }
                }
                serializable = jsonObject.toString();
            }
            catch (JSONException jsone) {
                serializable = FieldConstants.getSerializable((String)dataType, (String)dynamicContentElement.getText());
            }
        } else if (Objects.equals("ddm-link-to-page", type)) {
            boolean privateLayout;
            Object[] values = StringUtil.split((String)dynamicContentElement.getText(), (char)'@');
            if (ArrayUtil.isEmpty((Object[])values)) {
                return "";
            }
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            long layoutId = GetterUtil.getLong((String)values[0]);
            boolean bl = privateLayout = !Objects.equals(values[1], "public");
            if (values.length > 2) {
                long groupId = GetterUtil.getLong((String)values[2]);
                jsonObject.put("groupId", groupId);
                Layout layout = this._layoutLocalService.fetchLayout(groupId, privateLayout, layoutId);
                if (layout != null) {
                    jsonObject.put("label", layout.getName(defaultLocale));
                }
            }
            jsonObject.put("layoutId", layoutId);
            jsonObject.put("privateLayout", privateLayout);
            serializable = jsonObject.toString();
        } else if (Objects.equals("select", type)) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            List optionElements = dynamicContentElement.elements("option");
            if (!optionElements.isEmpty()) {
                for (Element optionElement : optionElements) {
                    jsonArray.put(optionElement.getText());
                }
            } else {
                jsonArray.put(dynamicContentElement.getText());
            }
            serializable = jsonArray.toString();
        } else {
            serializable = FieldConstants.getSerializable((String)dataType, (String)dynamicContentElement.getText());
        }
        return serializable;
    }

    @Deprecated
    protected FileEntry getFileEntryByDocumentLibraryURL(String url) {
        return null;
    }

    @Deprecated
    protected FileEntry getFileEntryByOldDocumentLibraryURL(String url) throws PortalException {
        return null;
    }

    protected void getJournalMetadataElement(Element metadataElement) {
        this.removeAttribute(metadataElement, "locale");
        Element dynamicElementElement = metadataElement.getParent();
        boolean required = GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("required"));
        this.addMetadataEntry(metadataElement, "required", String.valueOf(required));
        Element tipElement = this.fetchMetadataEntry(metadataElement, "name", "tip");
        if (tipElement != null) {
            tipElement.addAttribute("name", "instructions");
            this.addMetadataEntry(metadataElement, "displayAsTooltip", "true");
        }
    }

    protected void removeAttribute(Element element, String attributeName) {
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            return;
        }
        element.remove(attribute);
    }

    protected String[] splitFieldsDisplayValue(Field fieldsDisplayField) {
        String value = (String)((Object)fieldsDisplayField.getValue());
        return StringUtil.split((String)value);
    }

    protected void updateContentDynamicElement(Element dynamicElementElement, DDMStructure ddmStructure, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) throws Exception {
        String fieldName = dynamicElementElement.attributeValue("name");
        for (String childFieldName : ddmStructure.getChildrenFieldNames(fieldName)) {
            int count = ddmFieldsCounter.get((Object)fieldName);
            int repetitions = this.countFieldRepetition(ddmFields, childFieldName, fieldName, count);
            for (int i = 0; i < repetitions; ++i) {
                Element childDynamicElementElement = dynamicElementElement.addElement("dynamic-element");
                childDynamicElementElement.addAttribute("name", childFieldName);
                String instanceId = this.getFieldInstanceId(ddmFields, fieldName, count + i);
                childDynamicElementElement.addAttribute("instance-id", instanceId);
                this.updateContentDynamicElement(childDynamicElementElement, ddmStructure, ddmFields, ddmFieldsCounter);
            }
        }
        this.updateContentDynamicElement(dynamicElementElement, ddmStructure, ddmFields, fieldName, ddmFieldsCounter);
    }

    protected void updateContentDynamicElement(Element dynamicElementElement, DDMStructure ddmStructure, Fields ddmFields, String fieldName, DDMFieldsCounter ddmFieldsCounter) throws Exception {
        String fieldType = ddmStructure.getFieldType(fieldName);
        String indexType = ddmStructure.getFieldProperty(fieldName, "indexType");
        boolean multiple = GetterUtil.getBoolean((String)ddmStructure.getFieldProperty(fieldName, "multiple"));
        String type = this._ddmTypesToJournalTypes.get(fieldType);
        if (type == null) {
            type = fieldType;
        }
        dynamicElementElement.addAttribute("type", type);
        dynamicElementElement.addAttribute("index-type", indexType);
        int count = ddmFieldsCounter.get((Object)fieldName);
        String instanceId = this.getFieldInstanceId(ddmFields, fieldName, count);
        dynamicElementElement.addAttribute("instance-id", instanceId);
        Field ddmField = ddmFields.get(fieldName);
        if (!ddmStructure.isFieldTransient(fieldName) && ddmField != null) {
            for (Locale locale : ddmField.getAvailableLocales()) {
                Element dynamicContentElement = dynamicElementElement.addElement("dynamic-content");
                dynamicContentElement.addAttribute("language-id", LocaleUtil.toLanguageId((Locale)locale));
                Serializable fieldValue = ddmField.getValue(locale, count);
                String valueString = String.valueOf(fieldValue);
                this.updateDynamicContentValue(dynamicContentElement, fieldType, multiple, valueString.trim());
            }
        }
        ddmFieldsCounter.incrementKey((Object)fieldName);
    }

    protected void updateDDMXSDDynamicElement(Element dynamicElementElement, String defaultLanguageId) {
        String[] removableAttributeNames;
        List metadataElements = dynamicElementElement.elements("meta-data");
        for (Element metadataElement : metadataElements) {
            String languageId = metadataElement.attributeValue("locale");
            if (languageId.equals(defaultLanguageId)) {
                this.getJournalMetadataElement(metadataElement);
                continue;
            }
            dynamicElementElement.remove(metadataElement);
        }
        Element parentElement = dynamicElementElement.getParent();
        String parentType = parentElement.attributeValue("type");
        if (Objects.equals(parentType, "list") || Objects.equals(parentType, "multi-list")) {
            Element metadataElement = dynamicElementElement.element("meta-data");
            Element labelElement = this.fetchMetadataEntry(metadataElement, "name", "label");
            dynamicElementElement.addAttribute("name", labelElement.getText());
            String repeatable = parentElement.attributeValue("repeatable");
            dynamicElementElement.addAttribute("repeatable", repeatable);
            String value = dynamicElementElement.attributeValue("value");
            dynamicElementElement.addAttribute("type", value);
            this.removeAttribute(dynamicElementElement, "value");
            dynamicElementElement.remove(metadataElement);
            return;
        }
        String indexType = GetterUtil.getString((String)dynamicElementElement.attributeValue("indexType"));
        this.removeAttribute(dynamicElementElement, "indexType");
        dynamicElementElement.addAttribute("index-type", indexType);
        String type = dynamicElementElement.attributeValue("type");
        boolean multiple = GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("multiple"));
        String newType = this._ddmTypesToJournalTypes.get(type);
        if (newType.equals("list") && multiple) {
            newType = "multi-list";
        }
        dynamicElementElement.addAttribute("type", newType);
        for (String removableAttributeName : removableAttributeNames = new String[]{"dataType", "fieldNamespace", "multiple", "readOnly", "required", "showLabel", "width"}) {
            this.removeAttribute(dynamicElementElement, removableAttributeName);
        }
        List childrenDynamicElementElements = dynamicElementElement.elements("dynamic-element");
        for (Element childrenDynamicElementElement : childrenDynamicElementElements) {
            this.updateDDMXSDDynamicElement(childrenDynamicElementElement, defaultLanguageId);
        }
    }

    protected void updateDynamicContentValue(Element dynamicContentElement, String fieldType, boolean multiple, String fieldValue) throws Exception {
        if ("checkbox".equals(fieldType)) {
            if (fieldValue.equals(Boolean.FALSE.toString())) {
                fieldValue = "";
            }
            dynamicContentElement.addCDATA(fieldValue);
        } else if ("ddm-link-to-page".equals(fieldType) && Validator.isNotNull((String)fieldValue)) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fieldValue);
            long groupId = jsonObject.getLong("groupId");
            long layoutId = jsonObject.getLong("layoutId");
            boolean privateLayout = jsonObject.getBoolean("privateLayout");
            StringBundler sb = new StringBundler(groupId > 0L ? 5 : 3);
            sb.append(layoutId);
            sb.append("@");
            if (privateLayout) {
                Group group = this._groupLocalService.fetchGroup(groupId);
                if (group == null) {
                    sb.append("private");
                } else if (group.isUser()) {
                    sb.append("private-user");
                } else {
                    sb.append("private-group");
                }
            } else {
                sb.append("public");
            }
            if (groupId > 0L) {
                sb.append("@");
                sb.append(groupId);
            }
            dynamicContentElement.addCDATA(sb.toString());
        } else if ("select".equals(fieldType) && Validator.isNotNull((String)fieldValue)) {
            JSONArray jsonArray = null;
            try {
                jsonArray = JSONFactoryUtil.createJSONArray((String)fieldValue);
            }
            catch (JSONException jsone) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Unable to parse object", (Throwable)jsone);
                }
                return;
            }
            if (multiple) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Element optionElement = dynamicContentElement.addElement("option");
                    optionElement.addCDATA(jsonArray.getString(i));
                }
            } else {
                dynamicContentElement.addCDATA(jsonArray.getString(0));
            }
        } else {
            dynamicContentElement.addCDATA(fieldValue);
        }
    }

    protected void updateFieldsDisplay(Fields ddmFields, String fieldName, String instanceId) {
        if (Validator.isNull((String)instanceId)) {
            instanceId = StringUtil.randomString();
        }
        String fieldsDisplayValue = fieldName.concat("_INSTANCE_").concat(instanceId);
        Field fieldsDisplayField = ddmFields.get("_fieldsDisplay");
        Object[] fieldsDisplayValues = StringUtil.split((String)((String)((Object)fieldsDisplayField.getValue())));
        fieldsDisplayValues = (String[])ArrayUtil.append((Object[])fieldsDisplayValues, (Object)fieldsDisplayValue);
        fieldsDisplayField.setValue((Serializable)((Object)StringUtil.merge((Object[])fieldsDisplayValues)));
    }

    protected void updateJournalXSDDynamicElement(Element element) {
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        this.updateJournalXSDDynamicElement(element, LocaleUtil.toLanguageId((Locale)defaultLocale));
    }

    protected void updateJournalXSDDynamicElement(Element element, String defaultLanguageId) {
        String name = element.attributeValue("name");
        String type = element.attributeValue("type");
        Element metadataElement = element.element("meta-data");
        if (metadataElement == null) {
            metadataElement = element.addElement("meta-data");
        }
        if (type.equals("multi-list")) {
            element.addAttribute("multiple", "true");
        } else {
            Element parentElement = element.getParent();
            String parentType = parentElement.attributeValue("type");
            if (parentType != null && parentType.equals("select")) {
                metadataElement.addAttribute("locale", defaultLanguageId);
                this.addMetadataEntry(metadataElement, "label", this.decodeURL(name));
                this.removeAttribute(element, "index-type");
                element.addAttribute("name", "option" + parentElement.attributeValue("name") + StringUtil.randomString((int)8));
                element.addAttribute("type", "option");
                element.addAttribute("value", this.decodeURL(type));
                return;
            }
        }
        String indexType = "";
        Attribute indexTypeAttribute = element.attribute("index-type");
        if (indexTypeAttribute != null) {
            indexType = indexTypeAttribute.getValue();
            element.remove(indexTypeAttribute);
        }
        element.remove(element.attribute("type"));
        if (!type.equals("selection_break")) {
            String dataType = this._ddmDataTypes.get(type);
            if (dataType == null) {
                dataType = "string";
            }
            element.addAttribute("dataType", dataType);
        }
        element.addAttribute("indexType", indexType);
        String required = "false";
        Element requiredElement = this.fetchMetadataEntry(metadataElement, "name", "required");
        if (requiredElement != null) {
            required = requiredElement.getText();
        }
        element.addAttribute("required", required);
        element.addAttribute("showLabel", "true");
        String newType = this._journalTypesToDDMTypes.get(type);
        if (newType == null) {
            newType = type;
        }
        element.addAttribute("type", newType);
        if (newType.startsWith("ddm")) {
            element.addAttribute("fieldNamespace", "ddm");
        }
        metadataElement.addAttribute("locale", defaultLanguageId);
        List entryElements = metadataElement.elements();
        if (entryElements.isEmpty()) {
            this.addMetadataEntry(metadataElement, "label", name);
        } else {
            for (Element entryElement : entryElements) {
                String oldEntryName = entryElement.attributeValue("name");
                String newEntryName = this._ddmMetadataAttributes.get(oldEntryName);
                if (newEntryName == null) {
                    metadataElement.remove(entryElement);
                    continue;
                }
                entryElement.addAttribute("name", newEntryName);
            }
        }
        if (newType.equals("ddm-date") || newType.equals("ddm-decimal") || newType.equals("ddm-integer") || newType.equals("ddm-link-to-page") || newType.equals("ddm-number") || newType.equals("ddm-text-html") || newType.equals("text") || newType.equals("textarea")) {
            element.addAttribute("width", "25");
        } else if (newType.equals("ddm-image")) {
            element.addAttribute("fieldNamespace", "ddm");
            element.addAttribute("readOnly", "false");
        }
        element.add(metadataElement.detach());
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateJournalXSDDynamicElement(dynamicElementElement, defaultLanguageId);
        }
    }

    private ResourceBundle _getResourceBundle(Locale locale) {
        ResourceBundle classResourceBundle = ResourceBundleUtil.getBundle((Locale)locale, (String)"com.liferay.journal.lang");
        return new AggregateResourceBundle(new ResourceBundle[]{classResourceBundle, this._portal.getResourceBundle(locale)});
    }
}

