/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.validation;

import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.exception.NoSuchTemplateException;
import com.liferay.dynamic.data.mapping.exception.StorageFieldNameException;
import com.liferay.dynamic.data.mapping.exception.StorageFieldRequiredException;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.content.processor.ExportImportContentProcessorRegistryUtil;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.journal.configuration.JournalFileUploadsConfiguration;
import com.liferay.journal.exception.ArticleContentException;
import com.liferay.journal.exception.ArticleExpirationDateException;
import com.liferay.journal.exception.ArticleIdException;
import com.liferay.journal.exception.ArticleSmallImageNameException;
import com.liferay.journal.exception.ArticleSmallImageSizeException;
import com.liferay.journal.exception.ArticleTitleException;
import com.liferay.journal.exception.DuplicateArticleIdException;
import com.liferay.journal.exception.InvalidDDMStructureException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleLocalization;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.service.persistence.JournalArticlePersistence;
import com.liferay.journal.util.JournalConverter;
import com.liferay.journal.util.JournalHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.validation.ModelValidationResults;
import com.liferay.portal.validation.ModelValidator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={ModelValidator.class})
public class JournalArticleModelValidator
implements ModelValidator<JournalArticle> {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleModelValidator.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private JournalArticlePersistence _journalArticlePersistence;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private JournalFileUploadsConfiguration _journalFileUploadsConfiguration;
    @Reference
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference
    private JournalHelper _journalHelper;
    @Reference
    private Portal _portal;

    public void validate(long companyId, long groupId, long classNameId, Map<Locale, String> titleMap, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDate, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, ServiceContext serviceContext) throws PortalException {
        Locale articleDefaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)content));
        if (!ExportImportThreadLocal.isImportInProcess()) {
            if (!LanguageUtil.isAvailableLocale((long)groupId, (Locale)articleDefaultLocale)) {
                LocaleException le = new LocaleException(3, StringBundler.concat((Object[])new Object[]{"The locale ", articleDefaultLocale.getLanguage(), " is not available in site with groupId", groupId}));
                le.setSourceAvailableLocales(Collections.singleton(articleDefaultLocale));
                le.setTargetAvailableLocales((Collection)LanguageUtil.getAvailableLocales((long)groupId));
                throw le;
            }
            if (expirationDate != null && (expirationDate.before(new Date()) || displayDate != null && expirationDate.before(displayDate))) {
                throw new ArticleExpirationDateException("Expiration date " + expirationDate + " is in the past");
            }
        }
        if (classNameId == 0L && (titleMap.isEmpty() || Validator.isNull((String)titleMap.get(articleDefaultLocale)))) {
            throw new ArticleTitleException("Title is null");
        }
        int titleMaxLength = ModelHintsUtil.getMaxLength((String)JournalArticleLocalization.class.getName(), (String)"title");
        for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
            String title = entry.getValue();
            if (Validator.isNull((String)title) || title.length() <= titleMaxLength) continue;
            throw new ArticleTitleException.MustNotExceedMaximumLength(title, titleMaxLength);
        }
        this.validateContent(content);
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(this._portal.getSiteGroupId(groupId), this._classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        if (!ExportImportThreadLocal.isImportInProcess()) {
            this.validateDDMStructureFields(ddmStructure, classNameId, content, articleDefaultLocale);
        }
        if (Validator.isNotNull((String)ddmTemplateKey)) {
            DDMTemplate ddmTemplate = this._ddmTemplateLocalService.getTemplate(this._portal.getSiteGroupId(groupId), this._classNameLocalService.getClassNameId(DDMStructure.class), ddmTemplateKey, true);
            if (ddmTemplate.getClassPK() != ddmStructure.getStructureId()) {
                throw new NoSuchTemplateException("{templateKey=" + ddmTemplateKey + "}");
            }
        } else if (classNameId == 0L) {
            throw new NoSuchTemplateException("DDM template key is null");
        }
        if (!smallImage || Validator.isNotNull((String)smallImageURL) || smallImageFile == null || smallImageBytes == null) {
            return;
        }
        String smallImageName = smallImageFile.getName();
        boolean validSmallImageExtension = false;
        for (String imageExtension : this._journalFileUploadsConfiguration.imageExtensions()) {
            if (!"*".equals(imageExtension) && !StringUtil.endsWith((String)smallImageName, (String)imageExtension)) continue;
            validSmallImageExtension = true;
            break;
        }
        if (!validSmallImageExtension) {
            throw new ArticleSmallImageNameException(smallImageName);
        }
        long smallImageMaxSize = this._journalFileUploadsConfiguration.smallImageMaxSize();
        if (smallImageMaxSize > 0L && (long)smallImageBytes.length > smallImageMaxSize) {
            throw new ArticleSmallImageSizeException(smallImageBytes.length + " exceeds " + smallImageMaxSize);
        }
    }

    public void validate(long companyId, long groupId, long classNameId, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDate, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, ServiceContext serviceContext) throws PortalException {
        List articles;
        if (!autoArticleId) {
            this.validate(articleId);
        }
        if (!(ExportImportThreadLocal.isImportInProcess() && !autoArticleId || (articles = this._journalArticlePersistence.findByG_A(groupId, articleId)).isEmpty())) {
            StringBundler sb = new StringBundler(7);
            sb.append("{groupId=");
            sb.append(groupId);
            sb.append(", articleId=");
            sb.append(articleId);
            sb.append(", version=");
            sb.append(version);
            sb.append("}");
            throw new DuplicateArticleIdException(sb.toString());
        }
        this.validate(companyId, groupId, classNameId, titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
    }

    public void validate(String articleId) throws PortalException {
        if (Validator.isNull((String)articleId) || articleId.indexOf(44) != -1 || articleId.indexOf(32) != -1) {
            throw new ArticleIdException("Invalid article ID: " + articleId);
        }
    }

    public void validateContent(String content) throws PortalException {
        if (Validator.isNull((String)content)) {
            throw new ArticleContentException("Content is null");
        }
        try {
            SAXReaderUtil.read((String)content);
        }
        catch (DocumentException de) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalid content:\n" + content));
            }
            throw new ArticleContentException("Unable to read content with an XML parser", (Throwable)de);
        }
    }

    public void validateDDMStructureFields(DDMStructure ddmStructure, long classNameId, Fields fields, Locale defaultlocale) throws PortalException {
        for (Field field : fields) {
            if (!ddmStructure.hasField(field.getName())) {
                throw new StorageFieldNameException("No field exists for {name=" + field.getName() + "}");
            }
            if (!ddmStructure.getFieldRequired(field.getName()) || !Validator.isNull((Object)field.getValue(defaultlocale)) || classNameId != 0L) continue;
            StringBundler sb = new StringBundler(6);
            sb.append("Required field ");
            sb.append(field.getName());
            sb.append(" is not present for structure ");
            sb.append(ddmStructure.getNameCurrentValue());
            sb.append(" for locale ");
            sb.append((Object)defaultlocale);
            throw new StorageFieldRequiredException(sb.toString());
        }
    }

    public void validateDDMStructureFields(DDMStructure ddmStructure, long classNameId, String content, Locale defaultlocale) throws PortalException {
        Fields fields = this._journalConverter.getDDMFields(ddmStructure, content);
        this.validateDDMStructureFields(ddmStructure, classNameId, fields, defaultlocale);
    }

    public void validateDDMStructureId(long groupId, long folderId, String ddmStructureKey) throws PortalException {
        int restrictionType = this._journalHelper.getRestrictionType(folderId);
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(this._portal.getSiteGroupId(groupId), this._classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        List folderDDMStructures = this._journalFolderLocalService.getDDMStructures(this._portal.getCurrentAndAncestorSiteGroupIds(groupId), folderId, restrictionType);
        for (DDMStructure folderDDMStructure : folderDDMStructures) {
            if (folderDDMStructure.getStructureId() != ddmStructure.getStructureId()) continue;
            return;
        }
        throw new InvalidDDMStructureException(StringBundler.concat((Object[])new Object[]{"Invalid structure ", ddmStructure.getStructureId(), " for folder ", folderId}));
    }

    public ModelValidationResults validateModel(JournalArticle article) {
        ServiceContext serviceContext;
        Image image;
        long groupId = article.getGroupId();
        String content = article.getContent();
        String ddmStructureKey = article.getDDMStructureKey();
        String ddmTemplateKey = article.getDDMTemplateKey();
        boolean smallImage = article.isSmallImage();
        String smallImageURL = article.getSmallImageURL();
        byte[] smallImageBytes = null;
        File smallImageFile = null;
        if (smallImage && (image = this._imageLocalService.fetchImage(article.getSmallImageId())) != null) {
            smallImageBytes = image.getTextObj();
            try {
                smallImageFile = FileUtil.createTempFile((byte[])smallImageBytes);
            }
            catch (IOException ioe) {
                smallImageBytes = null;
            }
        }
        if ((serviceContext = ServiceContextThreadLocal.getServiceContext()) == null) {
            serviceContext = new ServiceContext();
        }
        try {
            this.validate(article.getCompanyId(), article.getGroupId(), article.getClassNameId(), article.getTitleMap(), article.getContent(), ddmStructureKey, ddmTemplateKey, article.getDisplayDate(), article.getExpirationDate(), smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
        }
        catch (PortalException pe) {
            ModelValidationResults.FailureBuilder failureBuilder = ModelValidationResults.failure();
            return failureBuilder.exceptionFailure(pe.getMessage(), (Throwable)pe).getResults();
        }
        try {
            this.validateReferences(groupId, ddmStructureKey, ddmTemplateKey, article.getLayoutUuid(), smallImage, smallImageURL, smallImageBytes, article.getSmallImageId(), content);
        }
        catch (ExportImportContentValidationException eicve) {
            eicve.setStagedModelClassName(JournalArticle.class.getName());
            eicve.setStagedModelClassPK(Long.valueOf(article.getArticleId()).longValue());
            ModelValidationResults.FailureBuilder failureBuilder = ModelValidationResults.failure();
            return failureBuilder.exceptionFailure(eicve.getMessage(), (Throwable)eicve).getResults();
        }
        catch (PortalException pe) {
            ModelValidationResults.FailureBuilder failureBuilder = ModelValidationResults.failure();
            return failureBuilder.exceptionFailure(pe.getMessage(), (Throwable)pe).getResults();
        }
        return ModelValidationResults.success();
    }

    public void validateReferences(long groupId, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, boolean smallImage, String smallImageURL, byte[] smallImageBytes, long smallImageId, String content) throws PortalException {
        Image image;
        DDMTemplate ddmTemplate;
        DDMStructure ddmStructure;
        long classNameId = this._classNameLocalService.getClassNameId(JournalArticle.class.getName());
        if (Validator.isNotNull((String)ddmStructureKey) && (ddmStructure = this._ddmStructureLocalService.fetchStructure(this._portal.getSiteGroupId(groupId), classNameId, ddmStructureKey, true)) == null) {
            throw new NoSuchStructureException();
        }
        classNameId = this._classNameLocalService.getClassNameId(DDMStructure.class.getName());
        if (Validator.isNotNull((String)ddmTemplateKey) && (ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(this._portal.getSiteGroupId(groupId), classNameId, ddmTemplateKey, true)) == null) {
            throw new NoSuchTemplateException();
        }
        if (smallImage && Validator.isNull((String)smallImageURL) && ArrayUtil.isEmpty((byte[])smallImageBytes) && (image = this._imageLocalService.fetchImage(smallImageId)) == null) {
            throw new NoSuchImageException();
        }
        ExportImportContentProcessor exportImportContentProcessor = ExportImportContentProcessorRegistryUtil.getExportImportContentProcessor((String)JournalArticle.class.getName());
        exportImportContentProcessor.validateContentReferences(groupId, (Serializable)((Object)content));
    }
}

