/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.impl;

import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.service.base.JournalArticleResourceLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;

public class JournalArticleResourceLocalServiceImpl
extends JournalArticleResourceLocalServiceBaseImpl {
    public void deleteArticleResource(long groupId, String articleId) throws PortalException {
        this.journalArticleResourcePersistence.removeByG_A(groupId, articleId);
    }

    public JournalArticleResource fetchArticleResource(long groupId, String articleId) {
        return this.journalArticleResourcePersistence.fetchByG_A(groupId, articleId);
    }

    public JournalArticleResource fetchArticleResource(String uuid, long groupId) {
        return this.journalArticleResourcePersistence.fetchByUUID_G(uuid, groupId);
    }

    public JournalArticleResource getArticleResource(long articleResourcePrimKey) throws PortalException {
        return this.journalArticleResourcePersistence.findByPrimaryKey(articleResourcePrimKey);
    }

    public long getArticleResourcePrimKey(long groupId, String articleId) {
        return this.getArticleResourcePrimKey(null, groupId, articleId);
    }

    public long getArticleResourcePrimKey(String uuid, long groupId, String articleId) {
        JournalArticleResource articleResource = null;
        if (Validator.isNotNull((String)uuid)) {
            articleResource = this.journalArticleResourcePersistence.fetchByUUID_G(uuid, groupId);
        }
        if (articleResource == null) {
            articleResource = this.journalArticleResourcePersistence.fetchByG_A(groupId, articleId);
        }
        if (articleResource == null) {
            long articleResourcePrimKey = this.counterLocalService.increment();
            articleResource = this.journalArticleResourcePersistence.create(articleResourcePrimKey);
            if (Validator.isNotNull((String)uuid)) {
                articleResource.setUuid(uuid);
            }
            articleResource.setGroupId(groupId);
            articleResource.setArticleId(articleId);
            this.journalArticleResourcePersistence.update((BaseModel)articleResource);
        }
        return articleResource.getResourcePrimKey();
    }

    public List<JournalArticleResource> getArticleResources(long groupId) {
        return this.journalArticleResourcePersistence.findByGroupId(groupId);
    }
}

