/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLink;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.journal.exception.DuplicateFeedIdException;
import com.liferay.journal.exception.FeedContentFieldException;
import com.liferay.journal.exception.FeedIdException;
import com.liferay.journal.exception.FeedNameException;
import com.liferay.journal.exception.FeedTargetLayoutFriendlyUrlException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFeed;
import com.liferay.journal.service.base.JournalFeedLocalServiceBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.rss.util.RSSUtil;
import java.util.List;
import java.util.Map;

public class JournalFeedLocalServiceImpl
extends JournalFeedLocalServiceBaseImpl {
    @ServiceReference(type=DDMStructureLinkLocalService.class)
    protected DDMStructureLinkLocalService ddmStructureLinkLocalService;
    @ServiceReference(type=DDMStructureLocalService.class)
    protected DDMStructureLocalService ddmStructureLocalService;

    public JournalFeed addFeed(long userId, long groupId, String feedId, boolean autoFeedId, String name, String description, String ddmStructureKey, String ddmTemplateKey, String ddmRendererTemplateKey, int delta, String orderByCol, String orderByType, String targetLayoutFriendlyUrl, String targetPortletId, String contentField, String feedFormat, double feedVersion, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        feedId = StringUtil.toUpperCase((String)StringUtil.trim((String)feedId));
        this.validate(user.getCompanyId(), groupId, feedId, autoFeedId, name, ddmStructureKey, targetLayoutFriendlyUrl, contentField);
        if (autoFeedId) {
            feedId = String.valueOf(this.counterLocalService.increment());
        }
        long id = this.counterLocalService.increment();
        JournalFeed feed = this.journalFeedPersistence.create(id);
        feed.setUuid(serviceContext.getUuid());
        feed.setGroupId(groupId);
        feed.setCompanyId(user.getCompanyId());
        feed.setUserId(user.getUserId());
        feed.setUserName(user.getFullName());
        feed.setFeedId(feedId);
        feed.setName(name);
        feed.setDescription(description);
        feed.setDDMStructureKey(ddmStructureKey);
        feed.setDDMTemplateKey(ddmTemplateKey);
        feed.setDDMRendererTemplateKey(ddmRendererTemplateKey);
        feed.setDelta(delta);
        feed.setOrderByCol(orderByCol);
        feed.setOrderByType(orderByType);
        feed.setTargetLayoutFriendlyUrl(targetLayoutFriendlyUrl);
        feed.setTargetPortletId(targetPortletId);
        feed.setContentField(contentField);
        if (Validator.isNull((String)feedFormat)) {
            feed.setFeedFormat(RSSUtil.FORMAT_DEFAULT);
            feed.setFeedVersion(RSSUtil.VERSION_DEFAULT);
        } else {
            feed.setFeedFormat(feedFormat);
            feed.setFeedVersion(feedVersion);
        }
        feed.setExpandoBridgeAttributes(serviceContext);
        this.journalFeedPersistence.update((BaseModel)feed);
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(groupId, this.classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        this.ddmStructureLinkLocalService.addStructureLink(this.classNameLocalService.getClassNameId(JournalFeed.class), feed.getPrimaryKey(), ddmStructure.getStructureId());
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFeedResources(feed, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addFeedResources(feed, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return feed;
    }

    public void addFeedResources(JournalFeed feed, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(feed.getCompanyId(), feed.getGroupId(), feed.getUserId(), JournalFeed.class.getName(), feed.getId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addFeedResources(JournalFeed feed, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(feed.getCompanyId(), feed.getGroupId(), feed.getUserId(), JournalFeed.class.getName(), feed.getId(), groupPermissions, guestPermissions);
    }

    public void addFeedResources(long feedId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        JournalFeed feed = this.journalFeedPersistence.findByPrimaryKey(feedId);
        this.addFeedResources(feed, addGroupPermissions, addGuestPermissions);
    }

    public void addFeedResources(long feedId, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        JournalFeed feed = this.journalFeedPersistence.findByPrimaryKey(feedId);
        this.addFeedResources(feed, groupPermissions, guestPermissions);
    }

    @SystemEvent(type=1)
    public void deleteFeed(JournalFeed feed) throws PortalException {
        this.journalFeedPersistence.remove((BaseModel)feed);
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(feed.getGroupId(), this.classNameLocalService.getClassNameId(JournalArticle.class), feed.getDDMStructureKey(), true);
        this.ddmStructureLinkLocalService.deleteStructureLink(this.classNameLocalService.getClassNameId(JournalFeed.class), feed.getPrimaryKey(), ddmStructure.getStructureId());
        this.resourceLocalService.deleteResource(feed.getCompanyId(), JournalFeed.class.getName(), 4, feed.getId());
        this.expandoValueLocalService.deleteValues(JournalFeed.class.getName(), feed.getId());
    }

    public void deleteFeed(long feedId) throws PortalException {
        JournalFeed feed = this.journalFeedPersistence.findByPrimaryKey(feedId);
        this.journalFeedLocalService.deleteFeed(feed);
    }

    public void deleteFeed(long groupId, String feedId) throws PortalException {
        JournalFeed feed = this.journalFeedPersistence.findByG_F(groupId, feedId);
        this.journalFeedLocalService.deleteFeed(feed);
    }

    public JournalFeed fetchFeed(long groupId, String feedId) {
        return this.journalFeedPersistence.fetchByG_F(groupId, feedId);
    }

    public JournalFeed getFeed(long feedId) throws PortalException {
        return this.journalFeedPersistence.findByPrimaryKey(feedId);
    }

    public JournalFeed getFeed(long groupId, String feedId) throws PortalException {
        return this.journalFeedPersistence.findByG_F(groupId, feedId);
    }

    public List<JournalFeed> getFeeds() {
        return this.journalFeedPersistence.findAll();
    }

    public List<JournalFeed> getFeeds(long groupId) {
        return this.journalFeedPersistence.findByGroupId(groupId);
    }

    public List<JournalFeed> getFeeds(long groupId, int start, int end) {
        return this.journalFeedPersistence.findByGroupId(groupId, start, end);
    }

    public int getFeedsCount(long groupId) {
        return this.journalFeedPersistence.countByGroupId(groupId);
    }

    public List<JournalFeed> search(long companyId, long groupId, String keywords, int start, int end, OrderByComparator<JournalFeed> obc) {
        return this.journalFeedFinder.findByKeywords(companyId, groupId, keywords, start, end, obc);
    }

    public List<JournalFeed> search(long companyId, long groupId, String feedId, String name, String description, boolean andOperator, int start, int end, OrderByComparator<JournalFeed> obc) {
        return this.journalFeedFinder.findByC_G_F_N_D(companyId, groupId, feedId, name, description, andOperator, start, end, obc);
    }

    public int searchCount(long companyId, long groupId, String keywords) {
        return this.journalFeedFinder.countByKeywords(companyId, groupId, keywords);
    }

    public int searchCount(long companyId, long groupId, String feedId, String name, String description, boolean andOperator) {
        return this.journalFeedFinder.countByC_G_F_N_D(companyId, groupId, feedId, name, description, andOperator);
    }

    public JournalFeed updateFeed(long groupId, String feedId, String name, String description, String ddmStructureKey, String ddmTemplateKey, String ddmRendererTemplateKey, int delta, String orderByCol, String orderByType, String targetLayoutFriendlyUrl, String targetPortletId, String contentField, String feedFormat, double feedVersion, ServiceContext serviceContext) throws PortalException {
        JournalFeed feed = this.journalFeedPersistence.findByG_F(groupId, feedId);
        this.validate(feed.getCompanyId(), groupId, name, ddmStructureKey, targetLayoutFriendlyUrl, contentField);
        feed.setName(name);
        feed.setDescription(description);
        feed.setDDMStructureKey(ddmStructureKey);
        feed.setDDMTemplateKey(ddmTemplateKey);
        feed.setDDMRendererTemplateKey(ddmRendererTemplateKey);
        feed.setDelta(delta);
        feed.setOrderByCol(orderByCol);
        feed.setOrderByType(orderByType);
        feed.setTargetLayoutFriendlyUrl(targetLayoutFriendlyUrl);
        feed.setTargetPortletId(targetPortletId);
        feed.setContentField(contentField);
        if (Validator.isNull((String)feedFormat)) {
            feed.setFeedFormat(RSSUtil.FORMAT_DEFAULT);
            feed.setFeedVersion(RSSUtil.VERSION_DEFAULT);
        } else {
            feed.setFeedFormat(feedFormat);
            feed.setFeedVersion(feedVersion);
        }
        feed.setExpandoBridgeAttributes(serviceContext);
        this.journalFeedPersistence.update((BaseModel)feed);
        long classNameId = this.classNameLocalService.getClassNameId(JournalFeed.class);
        DDMStructureLink ddmStructureLink = this.ddmStructureLinkLocalService.getUniqueStructureLink(classNameId, feed.getPrimaryKey());
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(groupId, this.classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        this.ddmStructureLinkLocalService.updateStructureLink(ddmStructureLink.getStructureLinkId(), classNameId, feed.getPrimaryKey(), ddmStructure.getStructureId());
        return feed;
    }

    protected boolean isValidStructureOptionValue(Map<String, DDMFormField> ddmFormFieldsMap, String contentField) {
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            String ddmFormFieldType = ddmFormField.getType();
            if (!ddmFormFieldType.equals("radio") && !ddmFormFieldType.equals("select")) continue;
            DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
            for (String optionValue : ddmFormFieldOptions.getOptionsValues()) {
                optionValue = ddmFormField.getName() + "_" + optionValue;
                if (!contentField.equals(optionValue)) continue;
                return true;
            }
        }
        return false;
    }

    protected void validate(long companyId, long groupId, String feedId, boolean autoFeedId, String name, String ddmStructureKey, String targetLayoutFriendlyUrl, String contentField) throws PortalException {
        if (!autoFeedId) {
            if (Validator.isNull((String)feedId) || Validator.isNumber((String)feedId) || feedId.indexOf(44) != -1 || feedId.indexOf(32) != -1) {
                throw new FeedIdException("Invalid feedId: " + feedId);
            }
            JournalFeed feed = this.journalFeedPersistence.fetchByG_F(groupId, feedId);
            if (feed != null) {
                StringBundler sb = new StringBundler(5);
                sb.append("{groupId=");
                sb.append(groupId);
                sb.append(", feedId=");
                sb.append(feedId);
                sb.append("}");
                throw new DuplicateFeedIdException(sb.toString());
            }
        }
        this.validate(companyId, groupId, name, ddmStructureKey, targetLayoutFriendlyUrl, contentField);
    }

    protected void validate(long companyId, long groupId, String name, String ddmStructureKey, String targetLayoutFriendlyUrl, String contentField) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new FeedNameException("Name is null");
        }
        long plid = PortalUtil.getPlidFromFriendlyURL((long)companyId, (String)targetLayoutFriendlyUrl);
        if (plid <= 0L) {
            StringBundler sb = new StringBundler(4);
            sb.append("No layout exists for company ");
            sb.append(companyId);
            sb.append(" and friendly URL ");
            sb.append(targetLayoutFriendlyUrl);
            throw new FeedTargetLayoutFriendlyUrlException(sb.toString());
        }
        if (contentField.equals("rendered-web-content") || contentField.equals("web-content-description")) {
            return;
        }
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(groupId, this.classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        DDMForm ddmForm = ddmStructure.getDDMForm();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        if (ddmFormFieldsMap.containsKey(contentField)) {
            return;
        }
        if (!this.isValidStructureOptionValue(ddmFormFieldsMap, contentField)) {
            throw new FeedContentFieldException("Invalid content field " + contentField);
        }
    }
}

