/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.persistence.impl;

import com.liferay.journal.model.JournalFeed;
import com.liferay.journal.model.impl.JournalFeedImpl;
import com.liferay.journal.service.persistence.JournalFeedFinder;
import com.liferay.journal.service.persistence.impl.JournalFeedFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Iterator;
import java.util.List;

public class JournalFeedFinderImpl
extends JournalFeedFinderBaseImpl
implements JournalFeedFinder {
    public static final String COUNT_BY_C_G_F_N_D = JournalFeedFinder.class.getName() + ".countByC_G_F_N_D";
    public static final String FIND_BY_C_G_F_N_D = JournalFeedFinder.class.getName() + ".findByC_G_F_N_D";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public int countByKeywords(long companyId, long groupId, String keywords) {
        String[] feedIds = null;
        String[] names = null;
        String[] descriptions = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            feedIds = this._customSQL.keywords(keywords, false);
            names = this._customSQL.keywords(keywords);
            descriptions = this._customSQL.keywords(keywords);
        } else {
            andOperator = true;
        }
        return this.countByC_G_F_N_D(companyId, groupId, feedIds, names, descriptions, andOperator);
    }

    public int countByC_G_F_N_D(long companyId, long groupId, String feedId, String name, String description, boolean andOperator) {
        String[] feedIds = this._customSQL.keywords(feedId, false);
        String[] names = this._customSQL.keywords(name);
        String[] descriptions = this._customSQL.keywords(description);
        return this.countByC_G_F_N_D(companyId, groupId, feedIds, names, descriptions, andOperator);
    }

    public int countByC_G_F_N_D(long companyId, long groupId, String[] feedIds, String[] names, String[] descriptions, boolean andOperator) {
        feedIds = this._customSQL.keywords(feedIds, false);
        names = this._customSQL.keywords(names);
        descriptions = this._customSQL.keywords(descriptions);
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_C_G_F_N_D);
            if (groupId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)"(groupId = ?) AND", (String)"");
            }
            sql = this._customSQL.replaceKeywords(sql, "feedId", "LIKE", false, feedIds);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(name)", "LIKE", false, names);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(description)", "LIKE", true, descriptions);
            sql = this._customSQL.replaceAndOperator(sql, andOperator);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            if (groupId > 0L) {
                qPos.add(groupId);
            }
            qPos.add(feedIds, 2);
            qPos.add(names, 2);
            qPos.add(descriptions, 2);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<JournalFeed> findByKeywords(long companyId, long groupId, String keywords, int start, int end, OrderByComparator<JournalFeed> obc) {
        String[] feedIds = null;
        String[] names = null;
        String[] descriptions = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            feedIds = this._customSQL.keywords(keywords, false);
            names = this._customSQL.keywords(keywords);
            descriptions = this._customSQL.keywords(keywords);
        } else {
            andOperator = true;
        }
        return this.findByC_G_F_N_D(companyId, groupId, feedIds, names, descriptions, andOperator, start, end, obc);
    }

    public List<JournalFeed> findByC_G_F_N_D(long companyId, long groupId, String feedId, String name, String description, boolean andOperator, int start, int end, OrderByComparator<JournalFeed> obc) {
        String[] feedIds = this._customSQL.keywords(feedId, false);
        String[] names = this._customSQL.keywords(name);
        String[] descriptions = this._customSQL.keywords(description);
        return this.findByC_G_F_N_D(companyId, groupId, feedIds, names, descriptions, andOperator, start, end, obc);
    }

    public List<JournalFeed> findByC_G_F_N_D(long companyId, long groupId, String[] feedIds, String[] names, String[] descriptions, boolean andOperator, int start, int end, OrderByComparator<JournalFeed> obc) {
        feedIds = this._customSQL.keywords(feedIds, false);
        names = this._customSQL.keywords(names);
        descriptions = this._customSQL.keywords(descriptions);
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_C_G_F_N_D);
            if (groupId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)"(groupId = ?) AND", (String)"");
            }
            sql = this._customSQL.replaceKeywords(sql, "feedId", "LIKE", false, feedIds);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(name)", "LIKE", false, names);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(description)", "LIKE", true, descriptions);
            sql = this._customSQL.replaceAndOperator(sql, andOperator);
            sql = this._customSQL.replaceOrderBy(sql, obc);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("JournalFeed", JournalFeedImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            if (groupId > 0L) {
                qPos.add(groupId);
            }
            qPos.add(feedIds, 2);
            qPos.add(names, 2);
            qPos.add(descriptions, 2);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

