/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.util.impl;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.util.impl.JournalUtil;
import com.liferay.layouts.admin.kernel.util.SitemapURLProvider;
import com.liferay.layouts.admin.kernel.util.SitemapUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Element;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SitemapURLProvider.class})
public class JournalArticleSitemapURLProvider
implements SitemapURLProvider {
    private JournalArticleService _journalArticleService;
    private LayoutLocalService _layoutLocalService;
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public void visitLayout(Element element, String layoutUuid, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        List journalArticles = this._journalArticleService.getArticlesByLayoutUuid(layoutSet.getGroupId(), layoutUuid);
        this.visitArticles(element, layoutSet, themeDisplay, journalArticles);
    }

    public void visitLayoutSet(Element element, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        List journalArticles = this._journalArticleService.getLayoutArticles(layoutSet.getGroupId());
        this.visitArticles(element, layoutSet, themeDisplay, journalArticles);
    }

    @Reference(unbind="-")
    protected void setJournalArticleService(JournalArticleService journalArticleService) {
        this._journalArticleService = journalArticleService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetLocalService(LayoutSetLocalService layoutSetLocalService) {
        this._layoutSetLocalService = layoutSetLocalService;
    }

    protected void visitArticles(Element element, LayoutSet layoutSet, ThemeDisplay themeDisplay, List<JournalArticle> journalArticles) throws PortalException {
        if (journalArticles.isEmpty()) {
            return;
        }
        HashSet<String> processedArticleIds = new HashSet<String>();
        String portalURL = this._portal.getPortalURL(layoutSet, themeDisplay);
        for (JournalArticle journalArticle : journalArticles) {
            Layout layout;
            if (processedArticleIds.contains(journalArticle.getArticleId()) || journalArticle.getStatus() != 0 || !JournalUtil.isHead(journalArticle) || (layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(journalArticle.getLayoutUuid(), layoutSet.getGroupId(), layoutSet.isPrivateLayout())) == null) continue;
            String groupFriendlyURL = this._portal.getGroupFriendlyURL(this._layoutSetLocalService.getLayoutSet(journalArticle.getGroupId(), false), themeDisplay);
            StringBundler sb = new StringBundler(4);
            if (!groupFriendlyURL.startsWith(portalURL)) {
                sb.append(portalURL);
            }
            sb.append(groupFriendlyURL);
            sb.append("/-/");
            sb.append(journalArticle.getUrlTitle());
            String articleURL = this._portal.getCanonicalURL(sb.toString(), themeDisplay, layout);
            Map alternateURLs = SitemapUtil.getAlternateURLs((String)articleURL, (ThemeDisplay)themeDisplay, (Layout)layout);
            for (String alternateURL : alternateURLs.values()) {
                SitemapUtil.addURLElement((Element)element, (String)alternateURL, null, (Date)journalArticle.getModifiedDate(), (String)articleURL, (Map)alternateURLs);
            }
            processedArticleIds.add(journalArticle.getArticleId());
        }
    }
}

