/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.search;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.search.DDMStructureIndexer;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.search.index.IndexStatusManager;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.structure.indexer.class.name=com.liferay.journal.model.JournalArticle"}, service={DDMStructureIndexer.class})
public class JournalArticleDDMStructureIndexer
implements DDMStructureIndexer {
    @Reference
    protected ConfigurationProvider configurationProvider;
    @Reference
    protected DDMStructureLocalService ddmStructureLocalService;
    @Reference
    protected IndexerRegistry indexerRegistry;
    @Reference
    protected JournalArticleResourceLocalService journalArticleResourceLocalService;
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleDDMStructureIndexer.class);
    @Reference
    private IndexStatusManager _indexStatusManager;

    public void reindexDDMStructures(List<Long> ddmStructureIds) throws SearchException {
        try {
            Indexer indexer = this.indexerRegistry.nullSafeGetIndexer(JournalArticle.class);
            if (this._indexStatusManager.isIndexReadOnly() || !indexer.isIndexerEnabled()) {
                return;
            }
            String[] ddmStructureKeys = new String[ddmStructureIds.size()];
            for (int i = 0; i < ddmStructureIds.size(); ++i) {
                long ddmStructureId = ddmStructureIds.get(i);
                DDMStructure ddmStructure = this.ddmStructureLocalService.getDDMStructure(ddmStructureId);
                ddmStructureKeys[i] = ddmStructure.getStructureKey();
            }
            ActionableDynamicQuery actionableDynamicQuery = this.journalArticleResourceLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                Class<?> clazz = this.getClass();
                DynamicQuery journalArticleDynamicQuery = DynamicQueryFactoryUtil.forClass(JournalArticle.class, (String)"journalArticle", (ClassLoader)clazz.getClassLoader());
                journalArticleDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"resourcePrimKey"));
                journalArticleDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"journalArticle.resourcePrimKey", (String)"this.resourcePrimKey"));
                journalArticleDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"journalArticle.groupId", (String)"this.groupId"));
                Property ddmStructureKey = PropertyFactoryUtil.forName((String)"DDMStructureKey");
                journalArticleDynamicQuery.add(ddmStructureKey.in((Object[])ddmStructureKeys));
                if (!this.isIndexAllArticleVersions()) {
                    Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                    Object[] statuses = new Integer[]{0, 8};
                    journalArticleDynamicQuery.add(statusProperty.in(statuses));
                }
                Property resourcePrimKeyProperty = PropertyFactoryUtil.forName((String)"resourcePrimKey");
                dynamicQuery.add(resourcePrimKeyProperty.in(journalArticleDynamicQuery));
            });
            actionableDynamicQuery.setPerformActionMethod(article -> {
                try {
                    indexer.reindex(indexer.getClassName(), article.getResourcePrimKey());
                }
                catch (Exception exception) {
                    throw new PortalException((Throwable)exception);
                }
            });
            actionableDynamicQuery.performActions();
        }
        catch (Exception exception) {
            throw new SearchException((Throwable)exception);
        }
    }

    protected boolean isIndexAllArticleVersions() {
        JournalServiceConfiguration journalServiceConfiguration = null;
        try {
            journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return journalServiceConfiguration.indexAllArticleVersionsEnabled();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return false;
        }
    }
}

