/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.security.permission.resource;

import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleModel;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.DynamicInheritancePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.StagedModelPermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.WorkflowedModelPermissionLogic;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermission;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class JournalArticleModelResourcePermissionRegistrar {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleModelResourcePermissionRegistrar.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalFolder)")
    private ModelResourcePermission<JournalFolder> _journalFolderModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.journal)")
    private PortletResourcePermission _portletResourcePermission;
    private ServiceRegistration<ModelResourcePermission> _serviceRegistration;
    @Reference
    private StagingPermission _stagingPermission;
    @Reference
    private WorkflowPermission _workflowPermission;

    @Activate
    public void activate(BundleContext bundleContext) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("model.class.name", JournalArticle.class.getName());
        this._serviceRegistration = bundleContext.registerService(ModelResourcePermission.class, (Object)ModelResourcePermissionFactory.create(JournalArticle.class, JournalArticleModel::getResourcePrimKey, classPK -> {
            JournalArticle article = this._journalArticleLocalService.fetchLatestArticle(classPK.longValue());
            if (article != null) {
                return article;
            }
            return this._journalArticleLocalService.getArticle(classPK.longValue());
        }, (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> {
            consumer.accept(new StagedModelPermissionLogic<JournalArticle>(this._stagingPermission, "com_liferay_journal_web_portlet_JournalPortlet", JournalArticleModel::getResourcePrimKey){

                public Boolean contains(PermissionChecker permissionChecker, String name, JournalArticle journalArticle, String actionId) {
                    if (actionId.equals("SUBSCRIBE")) {
                        return null;
                    }
                    return super.contains(permissionChecker, name, (GroupedModel)journalArticle, actionId);
                }
            });
            consumer.accept(new WorkflowedModelPermissionLogic(this._workflowPermission, modelResourcePermission, this._groupLocalService, JournalArticleModel::getId));
            consumer.accept(new JournalArticleConfigurationModelResourcePermissionLogic());
            consumer.accept(new DynamicInheritancePermissionLogic(this._journalFolderModelResourcePermission, this._getFetchParentFunction(), true));
        }), (Dictionary)properties);
    }

    @Deactivate
    public void deactivate() {
        this._serviceRegistration.unregister();
    }

    private UnsafeFunction<JournalArticle, JournalFolder, PortalException> _getFetchParentFunction() {
        return article -> {
            long folderId = article.getFolderId();
            if (0L == folderId) {
                return null;
            }
            if (article.isInTrash()) {
                return this._journalFolderLocalService.fetchFolder(folderId);
            }
            return this._journalFolderLocalService.getFolder(folderId);
        };
    }

    private class JournalArticleConfigurationModelResourcePermissionLogic
    implements ModelResourcePermissionLogic<JournalArticle> {
        private JournalArticleConfigurationModelResourcePermissionLogic() {
        }

        public Boolean contains(PermissionChecker permissionChecker, String name, JournalArticle article, String actionId) throws PortalException {
            if (!actionId.equals("VIEW")) {
                return null;
            }
            try {
                JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)JournalArticleModelResourcePermissionRegistrar.this._configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, permissionChecker.getCompanyId());
                if (!journalServiceConfiguration.articleViewPermissionsCheckEnabled()) {
                    return true;
                }
            }
            catch (ConfigurationException configurationException) {
                _log.error((Object)("Unable to get journal service configuration for company " + permissionChecker.getCompanyId()), (Throwable)configurationException);
                return false;
            }
            return null;
        }
    }
}

