/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v0_0_5;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLinkLocalService;
import com.liferay.dynamic.data.mapping.util.DefaultDDMStructureHelper;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJournal
extends UpgradeProcess {
    private static final String _BASIC_WEB_CONTENT_STRUCTURE;
    private static final String _INVALID_FIELD_NAME_CHARS_REGEX = "([\\p{Punct}&&[^_]]|\\p{Space})+";
    private static final String _TYPE_ATTRIBUTE_DDM_DATE = "type=\"ddm-date\"";
    private static final DateFormat _dateFormat;
    private static final Pattern _nameAttributePattern;
    private final CompanyLocalService _companyLocalService;
    private final DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final DDMTemplateLinkLocalService _ddmTemplateLinkLocalService;
    private final DefaultDDMStructureHelper _defaultDDMStructureHelper;
    private final Map<Long, String> _defaultLanguageIds = new HashMap<Long, String>();
    private final GroupLocalService _groupLocalService;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourceActions _resourceActions;
    private final ResourceLocalService _resourceLocalService;
    private final UserLocalService _userLocalService;

    public UpgradeJournal(CompanyLocalService companyLocalService, DDMStorageLinkLocalService ddmStorageLinkLocalService, DDMStructureLocalService ddmStructureLocalService, DDMTemplateLinkLocalService ddmTemplateLinkLocalService, DefaultDDMStructureHelper defaultDDMStructureHelper, GroupLocalService groupLocalService, ResourceActionLocalService resourceActionLocalService, ResourceActions resourceActions, ResourceLocalService resourceLocalService, UserLocalService userLocalService) {
        this._companyLocalService = companyLocalService;
        this._ddmStorageLinkLocalService = ddmStorageLinkLocalService;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._ddmTemplateLinkLocalService = ddmTemplateLinkLocalService;
        this._defaultDDMStructureHelper = defaultDDMStructureHelper;
        this._groupLocalService = groupLocalService;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourceActions = resourceActions;
        this._resourceLocalService = resourceLocalService;
        this._userLocalService = userLocalService;
    }

    protected String addBasicWebContentStructureAndTemplate(long companyId) throws Exception {
        this.initJournalDDMCompositeModelsResourceActions();
        Group group = this._groupLocalService.getCompanyGroup(companyId);
        long defaultUserId = this._userLocalService.getDefaultUserId(companyId);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        this._defaultDDMStructureHelper.addDDMStructures(defaultUserId, group.getGroupId(), PortalUtil.getClassNameId(JournalArticle.class), clazz.getClassLoader(), "com/liferay/journal/internal/upgrade/v1_0_0/dependencies/basic-web-content-structure.xml", new ServiceContext());
        this.addDefaultResourcePermissions(group.getGroupId());
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId));
        List<Element> structureElements = this.getDDMStructures(defaultLocale);
        Element structureElement = structureElements.get(0);
        return StringUtil.toUpperCase((String)structureElement.elementText("name"));
    }

    protected void addDDMStorageLink(Map<Long, List<Long>> ddmStructureIdsMap) throws Exception {
        long journalArticleClassNameId = PortalUtil.getClassNameId((String)JournalArticle.class.getName());
        for (Map.Entry<Long, List<Long>> entry : ddmStructureIdsMap.entrySet()) {
            long ddmStructureId = this.getDDMStructureId(entry.getKey(), entry.getValue());
            this._ddmStorageLinkLocalService.addStorageLink(journalArticleClassNameId, entry.getKey().longValue(), ddmStructureId, new ServiceContext());
        }
    }

    protected void addDDMStorageLinks() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(8);
            sb.append("select DDMStructure.structureId, JournalArticle.id_ ");
            sb.append("from JournalArticle inner join DDMStructure on (");
            sb.append("DDMStructure.groupId in (select distinct Group_.");
            sb.append("groupId from Group_ where (Group_.groupId = ");
            sb.append("JournalArticle.groupId) or (Group_.companyId = ");
            sb.append("JournalArticle.companyId and Group_.friendlyURL = ?)) ");
            sb.append("and DDMStructure.structureKey = JournalArticle.");
            sb.append("DDMStructureKey and JournalArticle.classNameId != ?)");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
                ps.setString(1, "/global");
                ps.setLong(2, PortalUtil.getClassNameId((String)DDMStructure.class.getName()));
                try (ResultSet rs = ps.executeQuery();){
                    HashMap<Long, List<Long>> ddmStructureIdsMap = new HashMap<Long, List<Long>>();
                    while (rs.next()) {
                        long structureId = rs.getLong("structureId");
                        long id = rs.getLong("id_");
                        ArrayList<Long> ddmStructureIds = (ArrayList<Long>)ddmStructureIdsMap.get(id);
                        if (ddmStructureIds == null) {
                            ddmStructureIds = new ArrayList<Long>();
                        }
                        ddmStructureIds.add(structureId);
                        ddmStructureIdsMap.put(id, ddmStructureIds);
                    }
                    this.addDDMStorageLink(ddmStructureIdsMap);
                }
            }
        }
    }

    protected void addDDMTemplateLinks() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long ddmStructureClassNameId = PortalUtil.getClassNameId((String)DDMStructure.class.getName());
            long journalArticleClassNameId = PortalUtil.getClassNameId((String)JournalArticle.class.getName());
            StringBundler sb = new StringBundler(6);
            sb.append("select DDMTemplate.templateId, JournalArticle.id_ ");
            sb.append("from JournalArticle inner join DDMTemplate on (");
            sb.append("DDMTemplate.groupId = JournalArticle.groupId and ");
            sb.append("DDMTemplate.templateKey = ");
            sb.append("JournalArticle.DDMTemplateKey and ");
            sb.append("JournalArticle.classNameId != ?)");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
                ps.setLong(1, ddmStructureClassNameId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        long templateId = rs.getLong("templateId");
                        long id = rs.getLong("id_");
                        this._ddmTemplateLinkLocalService.addTemplateLink(journalArticleClassNameId, id, templateId);
                    }
                }
            }
        }
    }

    protected void addDefaultResourcePermissions(long groupId) throws Exception {
        String modelResource = this._resourceActions.getCompositeModelName(new String[]{DDMStructure.class.getName(), JournalArticle.class.getName()});
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(groupId, PortalUtil.getClassNameId(JournalArticle.class), "BASIC-WEB-CONTENT");
        this._resourceLocalService.addResources(ddmStructure.getCompanyId(), 0L, 0L, modelResource, ddmStructure.getStructureId(), false, false, true);
    }

    protected boolean containsDateFieldType(String content) {
        return content.indexOf(_TYPE_ATTRIBUTE_DDM_DATE) != -1;
    }

    protected String convertStaticContentToDynamic(long groupId, String content) throws Exception {
        Document document = SAXReaderUtil.read((String)content);
        Document newDocument = SAXReaderUtil.createDocument();
        Element rootElement = document.getRootElement();
        String defaultLanguageId = this._getDefaultLanguageId(groupId);
        String availableLocales = GetterUtil.getString((String)rootElement.attributeValue("available-locales"), (String)defaultLanguageId);
        String defaultLocale = GetterUtil.getString((String)rootElement.attributeValue("default-locale"), (String)defaultLanguageId);
        Element newRootElement = SAXReaderUtil.createElement((String)"root");
        newRootElement.addAttribute("available-locales", availableLocales);
        newRootElement.addAttribute("default-locale", defaultLocale);
        newDocument.add(newRootElement);
        Element dynamicElementElement = SAXReaderUtil.createElement((String)"dynamic-element");
        dynamicElementElement.addAttribute("name", "content");
        dynamicElementElement.addAttribute("type", "text_area");
        dynamicElementElement.addAttribute("index-type", "text");
        dynamicElementElement.addAttribute("index", String.valueOf(0));
        newRootElement.add(dynamicElementElement);
        List staticContentElements = rootElement.elements("static-content");
        for (Element staticContentElement : staticContentElements) {
            String languageId = GetterUtil.getString((String)staticContentElement.attributeValue("language-id"), (String)defaultLanguageId);
            String text = staticContentElement.getText();
            Element dynamicContentElement = SAXReaderUtil.createElement((String)"dynamic-content");
            dynamicContentElement.addAttribute("language-id", languageId);
            dynamicContentElement.addCDATA(text);
            dynamicElementElement.add(dynamicContentElement);
        }
        return XMLUtil.formatXML((Document)newDocument);
    }

    protected void doUpgrade() throws Exception {
        this.updateJournalArticles();
        this.addDDMStorageLinks();
        this.addDDMTemplateLinks();
    }

    protected Set<String> getArticleDynamicElements(Element rootElement) {
        ArrayList<String> dynamicElementNames = new ArrayList<String>();
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element element : dynamicElementElements) {
            dynamicElementNames.add(element.attributeValue("name"));
            dynamicElementNames.addAll(this.getArticleDynamicElements(element));
        }
        return SetUtil.fromList(dynamicElementNames);
    }

    protected Set<String> getArticleFieldNames(long articleId) throws Exception {
        Set<String> articleFieldNames = new HashSet<String>();
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String sql = "select JournalArticle.content from JournalArticle where JournalArticle.id_ = ?";
            try (PreparedStatement ps = this.connection.prepareStatement(sql);){
                ps.setLong(1, articleId);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        String content = rs.getString("content");
                        Document document = SAXReaderUtil.read((String)content);
                        articleFieldNames = this.getArticleDynamicElements(document.getRootElement());
                    }
                }
            }
        }
        return articleFieldNames;
    }

    protected long getBestDDMStructureIdMatch(long id, long ddmStructureId1, long ddmStructureId2) throws Exception {
        DDMStructure ddmStructure1 = this._ddmStructureLocalService.getStructure(ddmStructureId1);
        Set fieldNames1 = ddmStructure1.getFieldNames();
        Set<String> articleFieldNames = this.getArticleFieldNames(id);
        fieldNames1.removeAll(articleFieldNames);
        DDMStructure ddmStructure2 = this._ddmStructureLocalService.getStructure(ddmStructureId2);
        Set fieldNames2 = ddmStructure2.getFieldNames();
        fieldNames2.removeAll(articleFieldNames);
        if (fieldNames1.size() <= fieldNames2.size()) {
            return ddmStructure1.getStructureId();
        }
        return ddmStructure2.getStructureId();
    }

    protected long getDDMStructureId(long id, List<Long> ddmStructureIds) throws Exception {
        if (ddmStructureIds.size() == 1) {
            return ddmStructureIds.get(0);
        }
        return this.getBestDDMStructureIdMatch(id, ddmStructureIds.get(0), ddmStructureIds.get(1));
    }

    protected List<Element> getDDMStructures(Locale locale) throws DocumentException {
        String xml = StringUtil.replace((String)_BASIC_WEB_CONTENT_STRUCTURE, (String)"[$LOCALE_DEFAULT$]", (String)locale.toString());
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        return rootElement.elements("structure");
    }

    protected Map<String, String> getInvalidDDMFormFieldNamesMap(String content) {
        HashMap<String, String> invalidDDMFormFieldNamesMap = new HashMap<String, String>();
        Matcher matcher = _nameAttributePattern.matcher(content);
        while (matcher.find()) {
            String newFieldName;
            String oldFieldName = matcher.group(1);
            if (oldFieldName.equals(newFieldName = oldFieldName.replaceAll(_INVALID_FIELD_NAME_CHARS_REGEX, ""))) continue;
            invalidDDMFormFieldNamesMap.put(oldFieldName, newFieldName);
        }
        return invalidDDMFormFieldNamesMap;
    }

    protected void initJournalDDMCompositeModelsResourceActions() throws Exception {
        this._resourceActions.read(null, UpgradeJournal.class.getClassLoader(), "/META-INF/resource-actions/journal_ddm_composite_models.xml");
        List modelNames = this._resourceActions.getPortletModelResources("com_liferay_journal_web_portlet_JournalPortlet");
        for (String modelName : modelNames) {
            List modelActions = this._resourceActions.getModelResourceActions(modelName);
            this._resourceActionLocalService.checkResourceActions(modelName, modelActions);
        }
    }

    protected void transformDateFieldValue(Element dynamicContentElement) {
        String value = dynamicContentElement.getText();
        if (!Validator.isNumber((String)value)) {
            return;
        }
        Date date = new Date(GetterUtil.getLong((String)value));
        dynamicContentElement.clearContent();
        dynamicContentElement.addCDATA(_dateFormat.format(date));
    }

    protected void transformDateFieldValues(List<Element> dynamicElementElements) {
        if (dynamicElementElements == null || dynamicElementElements.isEmpty()) {
            return;
        }
        for (Element dynamicElementElement : dynamicElementElements) {
            String type = GetterUtil.getString((String)dynamicElementElement.attributeValue("type"));
            if (type.equals("ddm-date")) {
                List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
                for (Element dynamicContentElement : dynamicContentElements) {
                    this.transformDateFieldValue(dynamicContentElement);
                }
            }
            List childDynamicElementElements = dynamicElementElement.elements("dynamic-element");
            this.transformDateFieldValues(childDynamicElementElements);
        }
    }

    protected String transformDateFieldValues(String content) throws Exception {
        if (!this.containsDateFieldType(content)) {
            return content;
        }
        Document document = SAXReaderUtil.read((String)content);
        Element rootElement = document.getRootElement();
        List dynamicElementElements = rootElement.elements("dynamic-element");
        this.transformDateFieldValues(dynamicElementElements);
        return XMLUtil.formatXML((Document)document);
    }

    protected String transformFieldNames(String content) {
        Map<String, String> invalidDDMFormFieldNamesMap = this.getInvalidDDMFormFieldNamesMap(content);
        for (Map.Entry<String, String> entry : invalidDDMFormFieldNamesMap.entrySet()) {
            content = StringUtil.replace((String)content, (String)("name=\"" + entry.getKey() + "\""), (String)("name=\"" + entry.getValue() + "\""));
        }
        return content;
    }

    protected void updateJournalArticle(long id, String ddmStructureKey, String ddmTemplateKey, String content) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update JournalArticle set DDMStructureKey = ?, DDMTemplateKey = ?, content = ? where id_ = ?");){
            ps.setString(1, ddmStructureKey);
            ps.setString(2, ddmTemplateKey);
            ps.setString(3, content);
            ps.setLong(4, id);
            ps.executeUpdate();
        }
    }

    protected void updateJournalArticleContent(long id, String content) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update JournalArticle set content = ? where id_ = ?");){
            ps.setString(1, content);
            ps.setLong(2, id);
            ps.executeUpdate();
        }
    }

    protected void updateJournalArticles() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List companies = this._companyLocalService.getCompanies();
            for (Company company : companies) {
                this.updateJournalArticles(company.getCompanyId());
            }
        }
    }

    protected void updateJournalArticles(long companyId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select id_, groupId, content, DDMStructureKey from JournalArticle where companyId = " + companyId);
             ResultSet rs = ps.executeQuery();){
            String name = this.addBasicWebContentStructureAndTemplate(companyId);
            while (rs.next()) {
                long id = rs.getLong("id_");
                long groupId = rs.getLong("groupId");
                String content = rs.getString("content");
                String ddmStructureKey = rs.getString("DDMStructureKey");
                if (Validator.isNull((String)ddmStructureKey)) {
                    content = this.convertStaticContentToDynamic(groupId, content);
                    this.updateJournalArticle(id, name, name, content);
                    continue;
                }
                String updatedContent = this.transformDateFieldValues(content);
                if (content.equals(updatedContent = this.transformFieldNames(updatedContent))) continue;
                this.updateJournalArticleContent(id, updatedContent);
            }
        }
    }

    private String _getDefaultLanguageId(long groupId) throws Exception {
        String defaultLanguageId = this._defaultLanguageIds.get(groupId);
        if (defaultLanguageId == null) {
            Locale defaultLocale = PortalUtil.getSiteDefaultLocale((long)groupId);
            defaultLanguageId = LanguageUtil.getLanguageId((Locale)defaultLocale);
            this._defaultLanguageIds.put(groupId, defaultLanguageId);
        }
        return defaultLanguageId;
    }

    static {
        _dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd");
        _nameAttributePattern = Pattern.compile("name=\"([^\"]+)\"");
        try {
            _BASIC_WEB_CONTENT_STRUCTURE = StringUtil.read((ClassLoader)UpgradeJournal.class.getClassLoader(), (String)"com/liferay/journal/internal/upgrade/v1_0_0/dependencies/basic-web-content-structure.xml");
        }
        catch (IOException ioException) {
            throw new ExceptionInInitializerError(ioException);
        }
    }
}

