/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_0;

import com.liferay.journal.internal.upgrade.util.JournalArticleImageUpgradeHelper;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class UpgradeDocumentLibraryTypeContent
extends UpgradeProcess {
    private final JournalArticleImageUpgradeHelper _journalArticleImageUpgradeHelper;

    public UpgradeDocumentLibraryTypeContent(JournalArticleImageUpgradeHelper journalArticleImageUpgradeHelper) {
        this._journalArticleImageUpgradeHelper = journalArticleImageUpgradeHelper;
    }

    protected String convertContent(String content) throws Exception {
        Document contentDocument = SAXReaderUtil.read((String)content);
        contentDocument = contentDocument.clone();
        XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='document_library']");
        List imageNodes = xPath.selectNodes((Object)contentDocument);
        for (Node imageNode : imageNodes) {
            Element imageEl = (Element)imageNode;
            List dynamicContentEls = imageEl.elements("dynamic-content");
            for (Element dynamicContentEl : dynamicContentEls) {
                String data = this._journalArticleImageUpgradeHelper.getDocumentLibraryValue(dynamicContentEl.getText());
                dynamicContentEl.clearContent();
                dynamicContentEl.addCDATA(data);
            }
        }
        return contentDocument.formattedString();
    }

    protected void doUpgrade() throws Exception {
        this.updateContent();
    }

    protected void updateContent() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select content, id_ from JournalArticle where content like ?");){
            ps1.setString(1, "%type=\"document_library\"%");
            ResultSet rs1 = ps1.executeQuery();
            while (rs1.next()) {
                String content = rs1.getString(1);
                long id = rs1.getLong(2);
                PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set content = ? where id_ = ?");
                Throwable throwable = null;
                try {
                    ps2.setString(1, this.convertContent(content));
                    ps2.setLong(2, id);
                    ps2.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps2 == null) continue;
                    if (throwable != null) {
                        try {
                            ps2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ps2.close();
                }
            }
        }
    }
}

