/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_0;

import com.liferay.journal.internal.upgrade.util.JournalArticleImageUpgradeHelper;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class UpgradeImageTypeContent
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeImageTypeContent.class);
    private final ImageLocalService _imageLocalService;
    private final JournalArticleImageUpgradeHelper _journalArticleImageUpgradeHelper;
    private final PortletFileRepository _portletFileRepository;

    public UpgradeImageTypeContent(ImageLocalService imageLocalService, JournalArticleImageUpgradeHelper journalArticleImageUpgradeHelper, PortletFileRepository portletFileRepository) {
        this._imageLocalService = imageLocalService;
        this._journalArticleImageUpgradeHelper = journalArticleImageUpgradeHelper;
        this._portletFileRepository = portletFileRepository;
    }

    protected void copyJournalArticleImagesToJournalRepository() throws Exception {
        StringBundler sb = new StringBundler(8);
        sb.append("select JournalArticleImage.articleImageId, ");
        sb.append("JournalArticleImage.groupId, ");
        sb.append("JournalArticleImage.companyId, ");
        sb.append("JournalArticle.resourcePrimKey, JournalArticle.userId ");
        sb.append("from JournalArticleImage inner join JournalArticle on ");
        sb.append("(JournalArticle.groupId = JournalArticleImage.groupId and ");
        sb.append("JournalArticle.articleId = JournalArticleImage.articleId ");
        sb.append("and JournalArticle.version = JournalArticleImage.version)");
        ArrayList<SaveImageFileEntryCallable> saveImageFileEntryCallables = new ArrayList<SaveImageFileEntryCallable>();
        try (LoggingTimer loggingTimer = new LoggingTimer();
             Statement statement = this.connection.createStatement();
             ResultSet rs1 = statement.executeQuery(sb.toString());){
            while (rs1.next()) {
                long articleImageId = rs1.getLong(1);
                long groupId = rs1.getLong(2);
                long companyId = rs1.getLong(3);
                long resourcePrimKey = rs1.getLong(4);
                long userId = PortalUtil.getValidUserId((long)companyId, (long)rs1.getLong(5));
                long folderId = this._journalArticleImageUpgradeHelper.getFolderId(userId, groupId, resourcePrimKey);
                SaveImageFileEntryCallable saveImageFileEntryCallable = new SaveImageFileEntryCallable(articleImageId, folderId, groupId, resourcePrimKey, userId);
                saveImageFileEntryCallables.add(saveImageFileEntryCallable);
            }
            ExecutorService executorService = Executors.newWorkStealingPool();
            List futures = executorService.invokeAll(saveImageFileEntryCallables);
            executorService.shutdown();
            for (Future future : futures) {
                boolean success = GetterUtil.get(future.get(), (boolean)true);
                if (success) continue;
                throw new UpgradeException("Unable to copy journal article images to the file repository");
            }
        }
    }

    protected void doUpgrade() throws Exception {
        this.copyJournalArticleImagesToJournalRepository();
        this.dropJournalArticleImageTable();
    }

    protected void dropJournalArticleImageTable() throws Exception {
        this.runSQL(this.connection, "drop table JournalArticleImage");
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Deleted table JournalArticleImage");
        }
    }

    private class SaveImageFileEntryCallable
    implements Callable<Boolean> {
        private final long _articleImageId;
        private final long _folderId;
        private final long _groupId;
        private final long _resourcePrimaryKey;
        private final long _userId;

        public SaveImageFileEntryCallable(long articleImageId, long folderId, long groupId, long resourcePrimaryKey, long userId) {
            this._articleImageId = articleImageId;
            this._folderId = folderId;
            this._groupId = groupId;
            this._resourcePrimaryKey = resourcePrimaryKey;
            this._userId = userId;
        }

        @Override
        public Boolean call() throws Exception {
            String fileName = String.valueOf(this._articleImageId);
            FileEntry fileEntry = UpgradeImageTypeContent.this._portletFileRepository.fetchPortletFileEntry(this._groupId, this._folderId, fileName);
            if (fileEntry != null) {
                return null;
            }
            try {
                Image image = UpgradeImageTypeContent.this._imageLocalService.getImage(this._articleImageId);
                if (image == null) {
                    return null;
                }
                String mimeType = MimeTypesUtil.getContentType((String)(fileName + "." + image.getType()));
                UpgradeImageTypeContent.this._portletFileRepository.addPortletFileEntry(this._groupId, this._userId, JournalArticle.class.getName(), this._resourcePrimaryKey, "com.liferay.journal", this._folderId, image.getTextObj(), fileName, mimeType, false);
                UpgradeImageTypeContent.this._imageLocalService.deleteImage(image.getImageId());
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to add the journal article image " + fileName + " into the file repository"), (Throwable)exception);
                return false;
            }
            return true;
        }
    }
}

