/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_5;

import com.liferay.journal.internal.upgrade.util.JournalArticleImageUpgradeHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class UpgradeContentImages
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeContentImages.class);
    private final JournalArticleImageUpgradeHelper _journalArticleImageUpgradeHelper;

    public UpgradeContentImages(JournalArticleImageUpgradeHelper journalArticleImageUpgradeHelper) {
        this._journalArticleImageUpgradeHelper = journalArticleImageUpgradeHelper;
    }

    protected String convertTypeImageElements(long userId, long groupId, long companyId, String content, long resourcePrimKey) throws Exception {
        Document contentDocument = SAXReaderUtil.read((String)content);
        contentDocument = contentDocument.clone();
        XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='image']");
        List imageNodes = xPath.selectNodes((Object)contentDocument);
        for (Node imageNode : imageNodes) {
            Element imageElement = (Element)imageNode;
            List dynamicContentElements = imageElement.elements("dynamic-content");
            for (Element dynamicContentElement : dynamicContentElements) {
                long fileEntryId = GetterUtil.getLong((String)dynamicContentElement.attributeValue("fileEntryId"));
                String id = dynamicContentElement.attributeValue("id");
                boolean emptyDynamicContentElement = false;
                FileEntry fileEntry = null;
                if (Validator.isNotNull((String)id)) {
                    fileEntry = this._getFileEntryById(userId, groupId, companyId, resourcePrimKey, id);
                } else if (fileEntryId > 0L) {
                    fileEntry = this._getFileEntryByFileEntryId(fileEntryId);
                } else {
                    String data = String.valueOf(dynamicContentElement.getData());
                    if (Validator.isNull((String)data)) {
                        emptyDynamicContentElement = true;
                    } else {
                        fileEntry = this._journalArticleImageUpgradeHelper.getFileEntryFromURL(data);
                    }
                }
                dynamicContentElement.clearContent();
                if (fileEntry == null) {
                    if (emptyDynamicContentElement || !_log.isWarnEnabled()) continue;
                    _log.warn((Object)"Deleted dynamic content because the file entry does not exist");
                    continue;
                }
                dynamicContentElement.addCDATA(JSONUtil.put((String)"alt", (Object)GetterUtil.getString((String)dynamicContentElement.attributeValue("alt"))).put("fileEntryId", fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("name", fileEntry.getFileName()).put("resourcePrimKey", resourcePrimKey).put("title", fileEntry.getTitle()).put("type", "journal").put("uuid", fileEntry.getUuid()).toString());
                if (fileEntryId > 0L) continue;
                dynamicContentElement.addAttribute("fileEntryId", String.valueOf(fileEntry.getFileEntryId()));
            }
        }
        return contentDocument.formattedString();
    }

    protected void doUpgrade() throws Exception {
        this.updateContentImages();
    }

    protected void updateContentImages() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select id_, resourcePrimKey, groupId, companyId, userId, content from JournalArticle where content like ?");){
            ps1.setString(1, "%type=\"image\"%");
            ResultSet rs1 = ps1.executeQuery();
            while (rs1.next()) {
                long id = rs1.getLong(1);
                long resourcePrimKey = rs1.getLong(2);
                long groupId = rs1.getLong(3);
                long companyId = rs1.getLong(4);
                long userId = rs1.getLong(5);
                String content = rs1.getString(6);
                String newContent = this.convertTypeImageElements(userId, groupId, companyId, content, resourcePrimKey);
                PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set content = ? where id_ = ?");
                Throwable throwable = null;
                try {
                    ps2.setString(1, newContent);
                    ps2.setLong(2, id);
                    ps2.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps2 == null) continue;
                    if (throwable != null) {
                        try {
                            ps2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ps2.close();
                }
            }
        }
    }

    private FileEntry _getFileEntryByFileEntryId(long fileEntryId) {
        FileEntry fileEntry;
        block3: {
            fileEntry = null;
            try {
                fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)fileEntryId);
            }
            catch (PortalException portalException) {
                String message = "Unable to get file entry " + fileEntryId;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)message, (Throwable)portalException);
                }
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)message);
            }
        }
        return fileEntry;
    }

    private FileEntry _getFileEntryById(long userId, long groupId, long companyId, long resourcePrimKey, String id) throws PortalException {
        FileEntry fileEntry;
        block3: {
            userId = PortalUtil.getValidUserId((long)companyId, (long)userId);
            long folderId = this._journalArticleImageUpgradeHelper.getFolderId(userId, groupId, resourcePrimKey);
            fileEntry = null;
            try {
                fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)groupId, (long)folderId, (String)id);
            }
            catch (PortalException portalException) {
                String message = StringBundler.concat((Object[])new Object[]{"Unable to get file entry with group ID ", groupId, ", folder ID ", folderId, ", and file name ", id, " for resourcePrimKey ", resourcePrimKey});
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)message, (Throwable)portalException);
                }
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)message);
            }
        }
        return fileEntry;
    }
}

