/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_6;

import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class UpgradeAssetDisplayPageEntry
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeAssetDisplayPageEntry.class);
    private final AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    private final CompanyLocalService _companyLocalService;
    private Map<Long, Long> _liveGroupIdsMap = new HashMap<Long, Long>();
    private Set<Long> _stagedGroupIds = new HashSet<Long>();
    private Map<Long, Map<String, String>> _uuidsMaps = new HashMap<Long, Map<String, String>>();

    public UpgradeAssetDisplayPageEntry(AssetDisplayPageEntryLocalService assetDisplayPageEntryLocalService, CompanyLocalService companyLocalService) {
        this._assetDisplayPageEntryLocalService = assetDisplayPageEntryLocalService;
        this._companyLocalService = companyLocalService;
    }

    protected void doUpgrade() throws Exception {
        List companies = this._companyLocalService.getCompanies();
        for (Company company : companies) {
            this.updateAssetDisplayPageEntry(company);
        }
    }

    protected void updateAssetDisplayPageEntry(Company company) throws Exception {
        this._init(company.getCompanyId());
        StringBuilder sb = new StringBuilder(17);
        sb.append("select JournalArticle.groupId, ");
        sb.append("JournalArticle.resourcePrimKey, AssetEntry.classUuid from ");
        sb.append("JournalArticle inner join AssetEntry on ( ");
        sb.append("AssetEntry.classNameId = ? and AssetEntry.classPK = ");
        sb.append("JournalArticle.resourcePrimKey ) inner join Group_ on ( ");
        sb.append("Group_.groupId = JournalArticle.groupId) where ");
        sb.append("JournalArticle.companyId = ? and ");
        sb.append("JournalArticle.layoutUuid is not null and ");
        sb.append("JournalArticle.layoutUuid != '' and ");
        sb.append("Group_.remoteStagingGroupCount = 0 and not exists ( ");
        sb.append("select 1 from AssetDisplayPageEntry where ");
        sb.append("AssetDisplayPageEntry.groupId = JournalArticle.groupId ");
        sb.append("and AssetDisplayPageEntry.classNameId = ? and ");
        sb.append("AssetDisplayPageEntry.classPK = ");
        sb.append("JournalArticle.resourcePrimKey) group by ");
        sb.append("JournalArticle.groupId, JournalArticle.resourcePrimKey, ");
        sb.append("AssetEntry.classUuid ");
        long journalArticleClassNameId = PortalUtil.getClassNameId(JournalArticle.class);
        User user = company.getDefaultUser();
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement(SQLTransformer.transform((String)sb.toString()));){
            ps1.setLong(1, journalArticleClassNameId);
            ps1.setLong(2, company.getCompanyId());
            ps1.setLong(3, journalArticleClassNameId);
            ArrayList<SaveAssetDisplayPageEntryCallable> saveAssetDisplayPageEntryCallables = new ArrayList<SaveAssetDisplayPageEntryCallable>();
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long groupId = rs.getLong("groupId");
                    long resourcePrimKey = rs.getLong("resourcePrimKey");
                    String journalArticleUuid = rs.getString("classUuid");
                    SaveAssetDisplayPageEntryCallable saveAssetDisplayPageEntryCallable = new SaveAssetDisplayPageEntryCallable(groupId, user.getUserId(), journalArticleClassNameId, resourcePrimKey, this._generateLocalStagingAwareUUID(groupId, journalArticleUuid));
                    saveAssetDisplayPageEntryCallables.add(saveAssetDisplayPageEntryCallable);
                }
            }
            ExecutorService executorService = Executors.newWorkStealingPool();
            List futures = executorService.invokeAll(saveAssetDisplayPageEntryCallables);
            executorService.shutdown();
            for (Future future : futures) {
                boolean success = GetterUtil.get(future.get(), (boolean)true);
                if (success) continue;
                throw new UpgradeException("Unable to add asset display pages for the journal articles");
            }
        }
    }

    private String _generateLocalStagingAwareUUID(long groupId, String journalArticleUuid) {
        Map<String, String> uuids;
        if (!this._stagedGroupIds.contains(groupId)) {
            return PortalUUIDUtil.generate();
        }
        long liveGroupId = groupId;
        if (this._liveGroupIdsMap.containsKey(groupId)) {
            liveGroupId = this._liveGroupIdsMap.get(groupId);
        }
        if (!this._uuidsMaps.containsKey(liveGroupId)) {
            this._uuidsMaps.put(liveGroupId, new HashMap());
        }
        if ((uuids = this._uuidsMaps.get(liveGroupId)).containsKey(journalArticleUuid)) {
            return uuids.get(journalArticleUuid);
        }
        String newUuid = PortalUUIDUtil.generate();
        uuids.put(journalArticleUuid, newUuid);
        return newUuid;
    }

    private void _init(long companyId) throws Exception {
        this._liveGroupIdsMap.clear();
        this._stagedGroupIds.clear();
        this._uuidsMaps.clear();
        StringBuilder sb = new StringBuilder(3);
        sb.append("select groupId, liveGroupId from Group_ where ");
        sb.append("companyId = ? and liveGroupId is not null and ");
        sb.append("liveGroupId != 0 and remoteStagingGroupCount = 0");
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement(SQLTransformer.transform((String)sb.toString()));){
            ps.setLong(1, companyId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long groupId = rs.getLong("groupId");
                    long liveGroupId = rs.getLong("liveGroupId");
                    this._liveGroupIdsMap.put(groupId, liveGroupId);
                    this._stagedGroupIds.add(groupId);
                    this._stagedGroupIds.add(liveGroupId);
                }
            }
        }
    }

    private class SaveAssetDisplayPageEntryCallable
    implements Callable<Boolean> {
        private final long _classNameId;
        private final long _classPK;
        private final long _groupId;
        private final long _userId;
        private final String _uuid;

        public SaveAssetDisplayPageEntryCallable(long groupId, long userId, long classNameId, long classPK, String uuid) {
            this._groupId = groupId;
            this._userId = userId;
            this._classNameId = classNameId;
            this._classPK = classPK;
            this._uuid = uuid;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setUuid(this._uuid);
                UpgradeAssetDisplayPageEntry.this._assetDisplayPageEntryLocalService.addAssetDisplayPageEntry(this._userId, this._groupId, this._classNameId, this._classPK, 0L, 2, serviceContext);
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to add asset display page entry for article " + this._classPK), (Throwable)exception);
                return false;
            }
            return true;
        }
    }
}

