/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.util;

import com.liferay.journal.internal.util.JournalUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.layout.admin.kernel.util.Sitemap;
import com.liferay.layout.admin.kernel.util.SitemapURLProvider;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Element;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SitemapURLProvider.class})
public class JournalArticleSitemapURLProvider
implements SitemapURLProvider {
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Sitemap _sitemap;

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public void visitLayout(Element element, String layoutUuid, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        List journalArticles = this._journalArticleService.getArticlesByLayoutUuid(layoutSet.getGroupId(), layoutUuid);
        this.visitArticles(element, layoutSet, themeDisplay, journalArticles);
    }

    public void visitLayoutSet(Element element, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        List journalArticles = this._journalArticleService.getLayoutArticles(layoutSet.getGroupId());
        this.visitArticles(element, layoutSet, themeDisplay, journalArticles);
    }

    protected void visitArticles(Element element, LayoutSet layoutSet, ThemeDisplay themeDisplay, List<JournalArticle> journalArticles) throws PortalException {
        if (journalArticles.isEmpty()) {
            return;
        }
        HashSet<String> processedArticleIds = new HashSet<String>();
        String portalURL = this._portal.getPortalURL(layoutSet, themeDisplay);
        for (JournalArticle journalArticle : journalArticles) {
            Layout layout;
            if (processedArticleIds.contains(journalArticle.getArticleId()) || journalArticle.getStatus() != 0 || !JournalUtil.isHead(journalArticle) || (layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(journalArticle.getLayoutUuid(), layoutSet.getGroupId(), layoutSet.isPrivateLayout())) == null) continue;
            String groupFriendlyURL = this._portal.getGroupFriendlyURL(this._layoutSetLocalService.getLayoutSet(journalArticle.getGroupId(), false), themeDisplay);
            StringBundler sb = new StringBundler(4);
            if (!groupFriendlyURL.startsWith(portalURL)) {
                sb.append(portalURL);
            }
            sb.append(groupFriendlyURL);
            sb.append("/-/");
            sb.append(journalArticle.getUrlTitle());
            String articleURL = this._portal.getCanonicalURL(sb.toString(), themeDisplay, layout);
            Map alternateURLs = this._sitemap.getAlternateURLs(articleURL, themeDisplay, layout);
            for (String alternateURL : alternateURLs.values()) {
                this._sitemap.addURLElement(element, alternateURL, null, journalArticle.getModifiedDate(), articleURL, alternateURLs);
            }
            processedArticleIds.add(journalArticle.getArticleId());
        }
    }
}

