/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.journal.internal.transformer.JournalTransformerListenerRegistryUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.journal.util.JournalHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.diff.CompareVersionsException;
import com.liferay.portal.kernel.diff.DiffHtmlUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={JournalHelper.class})
public class JournalHelperImpl
implements JournalHelper {
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public String diffHtml(long groupId, String articleId, double sourceVersion, double targetVersion, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws Exception {
        JournalArticle sourceArticle = JournalArticleLocalServiceUtil.getArticle((long)groupId, (String)articleId, (double)sourceVersion);
        if (!JournalArticleLocalServiceUtil.isRenderable((JournalArticle)sourceArticle, (PortletRequestModel)portletRequestModel, (ThemeDisplay)themeDisplay)) {
            throw new CompareVersionsException(sourceVersion);
        }
        JournalArticleDisplay sourceArticleDisplay = JournalArticleLocalServiceUtil.getArticleDisplay((JournalArticle)sourceArticle, null, (String)"view", (String)languageId, (int)1, (PortletRequestModel)portletRequestModel, (ThemeDisplay)themeDisplay);
        JournalArticle targetArticle = JournalArticleLocalServiceUtil.getArticle((long)groupId, (String)articleId, (double)targetVersion);
        if (!JournalArticleLocalServiceUtil.isRenderable((JournalArticle)targetArticle, (PortletRequestModel)portletRequestModel, (ThemeDisplay)themeDisplay)) {
            throw new CompareVersionsException(targetVersion);
        }
        JournalArticleDisplay targetArticleDisplay = JournalArticleLocalServiceUtil.getArticleDisplay((JournalArticle)targetArticle, null, (String)"view", (String)languageId, (int)1, (PortletRequestModel)portletRequestModel, (ThemeDisplay)themeDisplay);
        return DiffHtmlUtil.diff((Reader)new UnsyncStringReader(sourceArticleDisplay.getContent()), (Reader)new UnsyncStringReader(targetArticleDisplay.getContent()));
    }

    public String getAbsolutePath(PortletRequest portletRequest, long folderId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (folderId == 0L) {
            return themeDisplay.translate("home");
        }
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)folderId);
        List folders = folder.getAncestors();
        Collections.reverse(folders);
        StringBundler sb = new StringBundler(folders.size() * 3 + 5);
        sb.append(themeDisplay.translate("home"));
        sb.append(" ");
        for (JournalFolder curFolder : folders) {
            sb.append("\u00bb");
            sb.append(" ");
            sb.append(curFolder.getName());
        }
        sb.append("\u00bb");
        sb.append(" ");
        sb.append(folder.getName());
        return sb.toString();
    }

    public Layout getArticleLayout(String layoutUuid, long groupId) {
        if (Validator.isNull((String)layoutUuid)) {
            return null;
        }
        Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layoutUuid, groupId, false);
        if (layout == null) {
            layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layoutUuid, groupId, true);
        }
        return layout;
    }

    @Deprecated
    public List<JournalArticle> getArticles(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<JournalArticle> articles = new ArrayList<JournalArticle>(documents.size());
        for (Document document : documents) {
            String articleId = document.get("articleId");
            long groupId = GetterUtil.getLong((String)document.get("scopeGroupId"));
            JournalArticle article = JournalArticleLocalServiceUtil.fetchLatestArticle((long)groupId, (String)articleId, (int)0);
            if (article == null) {
                articles = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(JournalArticle.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (articles == null) continue;
            articles.add(article);
        }
        return articles;
    }

    public int getRestrictionType(long folderId) {
        int restrictionType = 0;
        JournalFolder folder = JournalFolderLocalServiceUtil.fetchFolder((long)folderId);
        if (folder != null) {
            restrictionType = folder.getRestrictionType();
        }
        return restrictionType;
    }

    public String getTemplateScript(long groupId, String ddmTemplateKey, Map<String, String> tokens, String languageId) throws PortalException {
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.getTemplate(groupId, this._portal.getClassNameId(DDMStructure.class), ddmTemplateKey, true);
        String script = ddmTemplate.getScript();
        for (TransformerListener transformerListener : JournalTransformerListenerRegistryUtil.getTransformerListeners()) {
            script = transformerListener.onScript(script, null, languageId, tokens);
        }
        return script;
    }
}

