/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.impl;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.exception.StructureDefinitionException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLink;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeUtil;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.journal.configuration.JournalGroupServiceConfiguration;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.exception.ArticleExpirationDateException;
import com.liferay.journal.exception.ArticleFriendlyURLException;
import com.liferay.journal.exception.ArticleReviewDateException;
import com.liferay.journal.exception.ArticleVersionException;
import com.liferay.journal.exception.DuplicateArticleIdException;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.exception.RequiredArticleLocalizationException;
import com.liferay.journal.internal.util.JournalTreePathUtil;
import com.liferay.journal.internal.util.JournalUtil;
import com.liferay.journal.internal.validation.JournalArticleModelValidator;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleConstants;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.model.JournalArticleLocalization;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.model.impl.JournalArticleDisplayImpl;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.journal.service.JournalContentSearchLocalService;
import com.liferay.journal.service.base.JournalArticleLocalServiceBaseImpl;
import com.liferay.journal.util.JournalDefaultTemplateProvider;
import com.liferay.journal.util.JournalHelper;
import com.liferay.journal.util.comparator.ArticleIDComparator;
import com.liferay.journal.util.comparator.ArticleVersionComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.diff.DiffHtmlUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupSubscriptionCheckSubscriptionSender;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.validation.ModelValidator;
import com.liferay.portal.validation.ModelValidatorRegistryUtil;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.trash.kernel.model.TrashVersion;
import com.liferay.upload.AttachmentContentUpdater;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={AopService.class})
public class JournalArticleLocalServiceImpl
extends JournalArticleLocalServiceBaseImpl {
    @Reference
    protected ConfigurationProvider configurationProvider;
    @Reference
    protected DDMStorageLinkLocalService ddmStorageLinkLocalService;
    @Reference
    protected DDMStructureLinkLocalService ddmStructureLinkLocalService;
    @Reference
    protected DDMStructureLocalService ddmStructureLocalService;
    @Reference
    protected DDMTemplateLinkLocalService ddmTemplateLinkLocalService;
    @Reference
    protected DDMTemplateLocalService ddmTemplateLocalService;
    @Reference
    protected FriendlyURLEntryLocalService friendlyURLEntryLocalService;
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleLocalServiceImpl.class);
    @Reference
    private AttachmentContentUpdater _attachmentContentUpdater;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private Http _http;
    @Reference
    private JournalArticleResourceLocalService _journalArticleResourceLocalService;
    @Reference
    private JournalContentSearchLocalService _journalContentSearchLocalService;
    @Reference
    private JournalDefaultTemplateProvider _journalDefaultTemplateProvider;
    @Reference
    private JournalHelper _journalHelper;
    @Reference
    private Portal _portal;
    private Date _previousCheckDate;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private TrashHelper _trashHelper;

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle addArticle(long userId, long groupId, long folderId, long classNameId, long classPK, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> friendlyURLMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        boolean validate;
        User user = this.userLocalService.getUser(userId);
        articleId = StringUtil.toUpperCase((String)StringUtil.trim((String)articleId));
        Date displayDate = this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), null);
        Date expirationDate = null;
        Date reviewDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), ArticleExpirationDateException.class);
        }
        if (!neverReview) {
            reviewDate = this._portal.getDate(reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, user.getTimeZone(), ArticleReviewDateException.class);
        }
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = validate = !ExportImportThreadLocal.isImportInProcess();
        if (validate) {
            this.validateDDMStructureId(groupId, folderId, ddmStructureKey);
        }
        if (autoArticleId) {
            articleId = String.valueOf(this.counterLocalService.increment());
        }
        this.sanitize(user.getCompanyId(), groupId, userId, classPK, descriptionMap);
        if (validate) {
            this.validate(user.getCompanyId(), groupId, classNameId, articleId, autoArticleId, version, titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
            try {
                this.validateReferences(groupId, ddmStructureKey, ddmTemplateKey, layoutUuid, smallImage, smallImageURL, smallImageBytes, 0L, content);
            }
            catch (ExportImportContentValidationException exportImportContentValidationException) {
                exportImportContentValidationException.setStagedModelClassName(JournalArticle.class.getName());
                exportImportContentValidationException.setStagedModelPrimaryKeyObj((Serializable)((Object)articleId));
                throw exportImportContentValidationException;
            }
        }
        serviceContext.setAttribute("articleId", (Serializable)((Object)articleId));
        long id = this.counterLocalService.increment();
        String articleResourceUuid = GetterUtil.getString((Object)serviceContext.getAttribute("articleResourceUuid"));
        long resourcePrimKey = this._journalArticleResourceLocalService.getArticleResourcePrimKey(articleResourceUuid, groupId, articleId);
        JournalArticle article = this.journalArticlePersistence.create(id);
        Locale locale = this.getArticleDefaultLocale(content);
        friendlyURLMap = this._checkFriendlyURLMap(locale, friendlyURLMap, titleMap);
        Map<String, String> urlTitleMap = this._getURLTitleMap(groupId, resourcePrimKey, friendlyURLMap, titleMap);
        String urlTitle = urlTitleMap.get(LocaleUtil.toLanguageId((Locale)locale));
        article.setUuid(serviceContext.getUuid());
        article.setResourcePrimKey(resourcePrimKey);
        article.setGroupId(groupId);
        article.setCompanyId(user.getCompanyId());
        article.setUserId(user.getUserId());
        article.setUserName(user.getFullName());
        article.setFolderId(folderId);
        article.setClassNameId(classNameId);
        article.setClassPK(classPK);
        article.setTreePath(article.buildTreePath());
        article.setArticleId(articleId);
        article.setVersion(version);
        article.setUrlTitle(urlTitle);
        content = this.format(user, groupId, article, content);
        content = this._replaceTempImages(article, content);
        article.setContent(content);
        article.setDDMStructureKey(ddmStructureKey);
        article.setDDMTemplateKey(ddmTemplateKey);
        article.setDefaultLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        article.setSmallImageId(this.counterLocalService.increment());
        article.setSmallImageURL(smallImageURL);
        Date now = new Date();
        if (expirationDate == null || expirationDate.after(now)) {
            article.setStatus(2);
        } else {
            article.setStatus(3);
        }
        article.setStatusByUserId(userId);
        article.setStatusDate(serviceContext.getModifiedDate(now));
        article.setExpandoBridgeAttributes(serviceContext);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        this.updateFriendlyURLs(article, urlTitleMap, serviceContext);
        this._addArticleLocalizedFields(user.getCompanyId(), article.getId(), titleMap, descriptionMap);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addArticleResources(article, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addArticleResources(article, serviceContext.getModelPermissions());
        }
        this.saveImages(smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        if (this.classNameLocalService.getClassNameId(DDMStructure.class) == classNameId) {
            this.updateDDMStructurePredefinedValues(classPK, content, serviceContext);
        } else {
            this.updateDDMLinks(id, groupId, ddmStructureKey, ddmTemplateKey, true);
        }
        articleURL = this.buildArticleURL(articleURL, groupId, folderId, articleId);
        serviceContext.setAttribute("articleURL", (Serializable)((Object)articleURL));
        this.sendEmail(article, articleURL, "requested", serviceContext);
        this.startWorkflowInstance(userId, article, serviceContext);
        return article;
    }

    public JournalArticle addArticle(long userId, long groupId, long folderId, long classNameId, long classPK, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        return this.journalArticleLocalService.addArticle(userId, groupId, folderId, classNameId, classPK, articleId, autoArticleId, version, titleMap, descriptionMap, titleMap, content, ddmStructureKey, ddmTemplateKey, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, smallImageFile, images, articleURL, serviceContext);
    }

    public JournalArticle addArticle(long userId, long groupId, long folderId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Calendar calendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        int displayDateMonth = calendar.get(2);
        int displayDateDay = calendar.get(5);
        int displayDateYear = calendar.get(1);
        int displayDateHour = calendar.get(11);
        int displayDateMinute = calendar.get(12);
        return this.journalArticleLocalService.addArticle(userId, groupId, folderId, 0L, 0L, "", true, 1.0, titleMap, descriptionMap, content, ddmStructureKey, ddmTemplateKey, null, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, serviceContext);
    }

    public JournalArticle addArticleDefaultValues(long userId, long groupId, long classNameId, long classPK, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String articleId = String.valueOf(this.counterLocalService.increment());
        this.sanitize(user.getCompanyId(), groupId, userId, classPK, descriptionMap);
        this.validate(user.getCompanyId(), groupId, classNameId, articleId, true, 0.0, titleMap, content, ddmStructureKey, ddmTemplateKey, null, null, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
        serviceContext.setAttribute("articleId", (Serializable)((Object)articleId));
        long id = this.counterLocalService.increment();
        JournalArticle article = this.journalArticlePersistence.create(id);
        article.setUuid(serviceContext.getUuid());
        String articleResourceUuid = GetterUtil.getString((Object)serviceContext.getAttribute("articleResourceUuid"));
        long resourcePrimKey = this._journalArticleResourceLocalService.getArticleResourcePrimKey(articleResourceUuid, groupId, articleId);
        article.setResourcePrimKey(resourcePrimKey);
        article.setGroupId(groupId);
        article.setCompanyId(user.getCompanyId());
        article.setUserId(user.getUserId());
        article.setUserName(user.getFullName());
        article.setClassNameId(classNameId);
        article.setClassPK(classPK);
        article.setArticleId(articleId);
        content = this.format(user, groupId, article, content);
        content = this._replaceTempImages(article, content);
        article.setContent(content);
        article.setDDMStructureKey(ddmStructureKey);
        article.setDDMTemplateKey(ddmTemplateKey);
        Locale locale = this.getArticleDefaultLocale(content);
        article.setDefaultLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        article.setLayoutUuid(layoutUuid);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        article.setSmallImageId(this.counterLocalService.increment());
        article.setSmallImageURL(smallImageURL);
        article.setStatus(0);
        article.setStatusByUserId(userId);
        article.setStatusDate(serviceContext.getModifiedDate(new Date()));
        article.setExpandoBridgeAttributes(serviceContext);
        this.journalArticlePersistence.update((BaseModel)article);
        this._addArticleLocalizedFields(user.getCompanyId(), article.getId(), titleMap, descriptionMap);
        this.addArticleResources(article, serviceContext.getModelPermissions());
        this.saveImages(smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        this.updateDDMStructurePredefinedValues(classPK, content, serviceContext);
        return this.journalArticlePersistence.findByPrimaryKey(article.getId());
    }

    public void addArticleResources(JournalArticle article, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(article.getCompanyId(), article.getGroupId(), article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addArticleResources(JournalArticle article, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(article.getCompanyId(), article.getGroupId(), article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), modelPermissions);
    }

    @Deprecated
    public void addArticleResources(JournalArticle article, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(article.getCompanyId(), article.getGroupId(), article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), groupPermissions, guestPermissions);
    }

    public void addArticleResources(long groupId, String articleId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        this.addArticleResources(article, addGroupPermissions, addGuestPermissions);
    }

    @Deprecated
    public void addArticleResources(long groupId, String articleId, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        this.addArticleResources(article, groupPermissions, guestPermissions);
    }

    public JournalArticle checkArticleResourcePrimKey(long groupId, String articleId, double version) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (article.getResourcePrimKey() > 0L) {
            return article;
        }
        long resourcePrimKey = this._journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, articleId);
        article.setResourcePrimKey(resourcePrimKey);
        this.journalArticlePersistence.update((BaseModel)article);
        return article;
    }

    public void checkArticles() throws PortalException {
        Date now = new Date();
        this.checkArticlesByExpirationDate(now);
        this.checkArticlesByReviewDate(now);
        this.checkArticlesByDisplayDate(now);
        this._previousCheckDate = now;
    }

    public void checkNewLine(long groupId, String articleId, double version) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        String content = GetterUtil.getString((String)article.getContent());
        if (content.contains("\\n")) {
            content = StringUtil.replace((String)content, (String[])new String[]{"\\n", "\\r"}, (String[])new String[]{"\n", "\r"});
            article.setContent(content);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    public void checkStructure(long groupId, String articleId, double version) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        this.checkStructure(article);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle copyArticle(long userId, long groupId, String oldArticleId, String newArticleId, boolean autoArticleId, double version) throws PortalException {
        Image image;
        User user = this.userLocalService.getUser(userId);
        oldArticleId = StringUtil.toUpperCase((String)StringUtil.trim((String)oldArticleId));
        newArticleId = StringUtil.toUpperCase((String)StringUtil.trim((String)newArticleId));
        JournalArticle oldArticle = this.journalArticlePersistence.findByG_A_V(groupId, oldArticleId, version);
        if (autoArticleId) {
            newArticleId = String.valueOf(this.counterLocalService.increment());
        } else {
            this.validate(newArticleId);
            if (this.journalArticlePersistence.countByG_A(groupId, newArticleId) > 0) {
                StringBundler sb = new StringBundler(5);
                sb.append("{groupId=");
                sb.append(groupId);
                sb.append(", articleId=");
                sb.append(newArticleId);
                sb.append("}");
                throw new DuplicateArticleIdException(sb.toString());
            }
        }
        long id = this.counterLocalService.increment();
        long resourcePrimKey = this._journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, newArticleId);
        JournalArticle newArticle = this.journalArticlePersistence.create(id);
        newArticle.setResourcePrimKey(resourcePrimKey);
        newArticle.setGroupId(groupId);
        newArticle.setCompanyId(user.getCompanyId());
        newArticle.setUserId(user.getUserId());
        newArticle.setUserName(user.getFullName());
        newArticle.setFolderId(oldArticle.getFolderId());
        newArticle.setTreePath(oldArticle.getTreePath());
        newArticle.setArticleId(newArticleId);
        newArticle.setVersion(1.0);
        newArticle.setUrlTitle(this.getUniqueUrlTitle(id, groupId, newArticleId, oldArticle.getTitleCurrentValue()));
        try {
            this.copyArticleImages(oldArticle, newArticle);
        }
        catch (Exception exception) {
            newArticle.setContent(oldArticle.getContent());
        }
        newArticle.setDDMStructureKey(oldArticle.getDDMStructureKey());
        newArticle.setDDMTemplateKey(oldArticle.getDDMTemplateKey());
        newArticle.setDefaultLanguageId(oldArticle.getDefaultLanguageId());
        newArticle.setLayoutUuid(oldArticle.getLayoutUuid());
        newArticle.setDisplayDate(oldArticle.getDisplayDate());
        newArticle.setExpirationDate(oldArticle.getExpirationDate());
        newArticle.setReviewDate(oldArticle.getReviewDate());
        newArticle.setIndexable(oldArticle.isIndexable());
        newArticle.setSmallImage(oldArticle.isSmallImage());
        newArticle.setSmallImageId(this.counterLocalService.increment());
        newArticle.setSmallImageURL(oldArticle.getSmallImageURL());
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)JournalArticle.class.getName());
        WorkflowDefinitionLink workflowDefinitionLink = workflowHandler.getWorkflowDefinitionLink(oldArticle.getCompanyId(), oldArticle.getGroupId(), oldArticle.getId());
        if (oldArticle.isPending() || workflowDefinitionLink != null) {
            newArticle.setStatus(2);
        } else {
            newArticle.setStatus(oldArticle.getStatus());
        }
        ExpandoBridgeUtil.copyExpandoBridgeAttributes((ExpandoBridge)oldArticle.getExpandoBridge(), (ExpandoBridge)newArticle.getExpandoBridge());
        this.journalArticlePersistence.update((BaseModel)newArticle);
        String urlTitle = JournalUtil.getUrlTitle(id, oldArticle.getUrlTitle());
        int uniqueUrlTitleCount = this._getUniqueUrlTitleCount(groupId, newArticleId, urlTitle);
        Map newTitleMap = oldArticle.getTitleMap();
        for (Map.Entry entry : newTitleMap.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            StringBundler sb = new StringBundler(5);
            sb.append((String)entry.getValue());
            sb.append(" ");
            sb.append(LanguageUtil.get((Locale)locale, (String)"duplicate"));
            sb.append(" ");
            sb.append(uniqueUrlTitleCount);
            newTitleMap.put(locale, sb.toString());
        }
        this._addArticleLocalizedFields(newArticle.getCompanyId(), newArticle.getId(), newTitleMap, oldArticle.getDescriptionMap());
        this.resourceLocalService.copyModelResources(oldArticle.getCompanyId(), JournalArticle.class.getName(), oldArticle.getResourcePrimKey(), resourcePrimKey);
        if (oldArticle.isSmallImage() && (image = this.imageLocalService.fetchImage(oldArticle.getSmallImageId())) != null) {
            byte[] smallImageBytes = image.getTextObj();
            this.imageLocalService.updateImage(newArticle.getSmallImageId(), smallImageBytes);
        }
        long[] assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        String[] assetTagNames = this.assetTagLocalService.getTagNames(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        AssetEntry oldAssetEntry = this.assetEntryLocalService.getEntry(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        List assetLinks = this.assetLinkLocalService.getDirectLinks(oldAssetEntry.getEntryId(), false);
        long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
        this.updateAsset(userId, newArticle, assetCategoryIds, assetTagNames, assetLinkEntryIds, oldAssetEntry.getPriority());
        this.updateDDMLinks(id, groupId, oldArticle.getDDMStructureKey(), oldArticle.getDDMTemplateKey(), true);
        return newArticle;
    }

    @SystemEvent(action=1, send=false, type=1)
    public JournalArticle deleteArticle(JournalArticle article) throws PortalException {
        return this.journalArticleLocalService.deleteArticle(article, "", null);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, send=false, type=1)
    public JournalArticle deleteArticle(JournalArticle article, String articleURL, ServiceContext serviceContext) throws PortalException {
        int articlesCount;
        TrashEntry trashEntry;
        JournalArticleResource articleResource = this._journalArticleResourceLocalService.fetchArticleResource(article.getGroupId(), article.getArticleId());
        if (article.isApproved() && this.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion(), 0)) {
            this.updatePreviousApprovedArticle(article);
        }
        this.journalArticleLocalizationPersistence.removeByArticlePK(article.getId());
        if (article.isDraft() || article.isInTrash()) {
            this.assetEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getPrimaryKey());
        }
        if (serviceContext != null && Validator.isNotNull((String)articleURL) && !article.isApproved() && this.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion())) {
            articleURL = this.buildArticleURL(articleURL, article.getGroupId(), article.getFolderId(), article.getArticleId());
            this.sendEmail(article, articleURL, "denied", serviceContext);
        }
        if (article.getClassNameId() != this.classNameLocalService.getClassNameId(DDMStructure.class)) {
            this.ddmStorageLinkLocalService.deleteClassStorageLink(article.getId());
            this.ddmStructureLinkLocalService.deleteStructureLinks(this.classNameLocalService.getClassNameId(JournalArticle.class), article.getId());
            this.ddmTemplateLinkLocalService.deleteTemplateLink(this.classNameLocalService.getClassNameId(JournalArticle.class), article.getId());
        }
        this.expandoRowLocalService.deleteRows(article.getId());
        if (article.isInTrash() && (trashEntry = article.getTrashEntry()) != null) {
            this.trashVersionLocalService.deleteTrashVersion(JournalArticle.class.getName(), article.getId());
        }
        if (!article.isDraft()) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(article.getCompanyId(), article.getGroupId(), JournalArticle.class.getName(), article.getId());
        }
        if ((articlesCount = this.journalArticlePersistence.countByG_A(article.getGroupId(), article.getArticleId())) == 1) {
            this.assetEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
            this._commentManager.deleteDiscussion(JournalArticle.class.getName(), article.getResourcePrimKey());
            this._journalContentSearchLocalService.deleteArticleContentSearches(article.getGroupId(), article.getArticleId());
            long folderId = article.getImagesFolderId();
            if (folderId != 0L) {
                PortletFileRepositoryUtil.deletePortletFolder((long)folderId);
            }
            this.ratingsStatsLocalService.deleteStats(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.imageLocalService.deleteImage(article.getSmallImageId());
            this.trashEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.resourceLocalService.deleteResource(article.getCompanyId(), JournalArticle.class.getName(), 4, article.getResourcePrimKey());
            if (articleResource != null) {
                this._journalArticleResourceLocalService.deleteJournalArticleResource(articleResource);
            }
        }
        long classNameId = this.classNameLocalService.getClassNameId(JournalArticle.class);
        List friendlyURLEntries = this.friendlyURLEntryLocalService.getFriendlyURLEntries(article.getGroupId(), classNameId, article.getResourcePrimKey());
        if (!friendlyURLEntries.isEmpty()) {
            this.friendlyURLEntryLocalService.deleteFriendlyURLEntry(article.getGroupId(), JournalArticle.class, article.getResourcePrimKey());
        }
        this.journalArticlePersistence.remove((BaseModel)article);
        if (articleResource != null) {
            JSONObject extraDataJSONObject = JSONUtil.put((String)"uuid", (Object)article.getUuid()).put("version", article.getVersion());
            this.systemEventLocalService.addSystemEvent(0L, article.getGroupId(), article.getModelClassName(), article.getPrimaryKey(), articleResource.getUuid(), null, 1, extraDataJSONObject.toString());
        }
        return article;
    }

    public JournalArticle deleteArticle(long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.deleteArticle(article, articleURL, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArticle(long groupId, String articleId, ServiceContext serviceContext) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        JournalArticleResource articleResource = this._journalArticleResourceLocalService.fetchArticleResource(groupId, articleId);
        try {
            List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
            for (JournalArticle article : articles) {
                this.journalArticleLocalService.deleteArticle(article, null, serviceContext);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        if (articleResource != null) {
            this.systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    public void deleteArticleDefaultValues(long groupId, String articleId, String ddmStructureKey) throws PortalException {
        this._deleteDDMStructurePredefinedValues(groupId, ddmStructureKey);
        this.journalArticleLocalService.deleteArticle(groupId, articleId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArticles(long groupId) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        ArrayList<JournalArticleResource> articleResources = new ArrayList<JournalArticleResource>();
        try {
            JournalArticleResource articleResource = null;
            for (JournalArticle article : this.journalArticlePersistence.findByGroupId(groupId)) {
                if (articleResource == null || articleResource.getPrimaryKey() != article.getResourcePrimKey()) {
                    articleResource = this._journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
                    articleResources.add(articleResource);
                }
                this.journalArticleLocalService.deleteArticle(article, null, null);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        for (JournalArticleResource articleResource : articleResources) {
            this.systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    public void deleteArticles(long groupId, long folderId) throws PortalException {
        this.deleteArticles(groupId, folderId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArticles(long groupId, long folderId, boolean includeTrashedEntries) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        ArrayList<JournalArticleResource> articleResources = new ArrayList<JournalArticleResource>();
        try {
            JournalArticleResource articleResource = null;
            for (JournalArticle article : this.journalArticlePersistence.findByG_F(groupId, folderId)) {
                if (articleResource == null || articleResource.getPrimaryKey() != article.getResourcePrimKey()) {
                    articleResource = this._journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
                    articleResources.add(articleResource);
                }
                if (includeTrashedEntries || !article.isInTrashExplicitly()) {
                    this.journalArticleLocalService.deleteArticle(article, null, null);
                    continue;
                }
                articleResources.remove(articleResource);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        for (JournalArticleResource articleResource : articleResources) {
            this.systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    public void deleteArticles(long groupId, String className, long classPK) throws PortalException {
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, this.classNameLocalService.getClassNameId(className), classPK);
        for (JournalArticle article : articles) {
            this.journalArticleLocalService.deleteArticle(article, null, null);
        }
    }

    public void deleteLayoutArticleReferences(long groupId, String layoutUuid) {
        List articles = this.journalArticlePersistence.findByG_L(groupId, layoutUuid);
        for (JournalArticle article : articles) {
            article.setLayoutUuid("");
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle expireArticle(long userId, long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException {
        return this.updateStatus(userId, groupId, articleId, version, 3, articleURL, new HashMap<String, Serializable>(), serviceContext);
    }

    public void expireArticle(long userId, long groupId, String articleId, String articleURL, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        if (this.isExpireAllArticleVersions(user.getCompanyId())) {
            List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
            for (JournalArticle article : articles) {
                this.journalArticleLocalService.expireArticle(userId, groupId, article.getArticleId(), article.getVersion(), articleURL, serviceContext);
            }
        } else {
            JournalArticle article = this.getLatestArticle(groupId, articleId, 0);
            this.journalArticleLocalService.expireArticle(userId, groupId, article.getArticleId(), article.getVersion(), articleURL, serviceContext);
        }
    }

    public JournalArticle fetchArticle(long id) {
        return this.journalArticlePersistence.fetchByPrimaryKey(id);
    }

    public JournalArticle fetchArticle(long groupId, String articleId) {
        JournalArticle article = this.fetchLatestArticle(groupId, articleId, 0);
        if (article != null) {
            return article;
        }
        return this.fetchLatestArticle(groupId, articleId, -1);
    }

    public JournalArticle fetchArticle(long groupId, String articleId, double version) {
        return this.journalArticlePersistence.fetchByG_A_V(groupId, articleId, version);
    }

    public JournalArticle fetchArticleByUrlTitle(long groupId, String urlTitle) {
        JournalArticle article = this.fetchLatestArticleByUrlTitle(groupId, urlTitle, 0);
        if (article != null) {
            return article;
        }
        return this.fetchLatestArticleByUrlTitle(groupId, urlTitle, -1);
    }

    public JournalArticle fetchArticleByUrlTitle(long groupId, String urlTitle, double version) {
        JournalArticle article;
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, JournalArticle.class, urlTitle);
        if (friendlyURLEntry != null && (article = this.fetchLatestArticle(friendlyURLEntry.getClassPK(), -1, true)).getVersion() == version) {
            return article;
        }
        article = this.fetchLatestArticleByUrlTitle(groupId, urlTitle, 0);
        if (article != null && article.getVersion() == version) {
            return article;
        }
        article = this.fetchLatestArticleByUrlTitle(groupId, urlTitle, -1);
        if (article != null && article.getVersion() == version) {
            return article;
        }
        if (article != null) {
            return this.fetchArticle(article.getGroupId(), article.getArticleId(), version);
        }
        return null;
    }

    public JournalArticle fetchDisplayArticle(long groupId, String articleId) {
        List articles = this.journalArticlePersistence.findByG_A_ST(groupId, articleId, 0);
        if (articles.isEmpty()) {
            return null;
        }
        Date now = new Date();
        for (JournalArticle article : articles) {
            Date displayDate = article.getDisplayDate();
            Date expirationDate = article.getExpirationDate();
            if (displayDate != null && !displayDate.before(now) || expirationDate != null && !expirationDate.after(now)) continue;
            return article;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey) {
        return this.fetchLatestArticle(resourcePrimKey, -1);
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey, int status) {
        return this.fetchLatestArticle(resourcePrimKey, status, true);
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey, int status, boolean preferApproved) {
        JournalArticle article = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                article = this.journalArticlePersistence.fetchByR_ST_First(resourcePrimKey, 0, (OrderByComparator)orderByComparator);
            }
            if (article == null) {
                article = this.journalArticlePersistence.fetchByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)orderByComparator);
            }
        } else {
            article = this.journalArticlePersistence.fetchByR_ST_First(resourcePrimKey, status, (OrderByComparator)orderByComparator);
        }
        return article;
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey, int[] statuses) {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        List articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, statuses, 0, 1, (OrderByComparator)orderByComparator);
        if (!articles.isEmpty()) {
            return (JournalArticle)articles.get(0);
        }
        return null;
    }

    public JournalArticle fetchLatestArticle(long groupId, String articleId, int status) {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            return this.journalArticlePersistence.fetchByG_A_NotST_First(groupId, articleId, 8, (OrderByComparator)orderByComparator);
        }
        return this.journalArticlePersistence.fetchByG_A_ST_First(groupId, articleId, status, (OrderByComparator)orderByComparator);
    }

    public JournalArticle fetchLatestArticleByUrlTitle(long groupId, String urlTitle, int status) {
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, JournalArticle.class, urlTitle);
        if (friendlyURLEntry != null) {
            JournalArticle article = this.fetchLatestArticle(friendlyURLEntry.getClassPK(), status);
            if (article != null && article.getGroupId() != groupId) {
                article = this.fetchLatestArticle(groupId, article.getArticleId(), status);
            }
            return article;
        }
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        articles = status == -1 ? this.journalArticlePersistence.findByG_UT(groupId, FriendlyURLNormalizerUtil.normalizeWithEncoding((String)urlTitle), 0, 1, (OrderByComparator)orderByComparator) : this.journalArticlePersistence.findByG_UT_ST(groupId, FriendlyURLNormalizerUtil.normalizeWithEncoding((String)urlTitle), status, 0, 1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            return null;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle fetchLatestIndexableArticle(long resourcePrimKey) {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        int[] statuses = new int[]{0, 8};
        List articles = this.journalArticlePersistence.findByR_I_S(resourcePrimKey, true, statuses, 0, 1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            return null;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getArticle(long id) throws PortalException {
        return this.journalArticlePersistence.findByPrimaryKey(id);
    }

    public JournalArticle getArticle(long groupId, String articleId) throws PortalException {
        JournalArticle article = this.fetchLatestArticle(groupId, articleId, 0);
        if (article != null) {
            return article;
        }
        return this.getLatestArticle(groupId, articleId, -1);
    }

    public JournalArticle getArticle(long groupId, String articleId, double version) throws PortalException {
        return this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
    }

    public JournalArticle getArticle(long groupId, String className, long classPK) throws PortalException {
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, this.classNameLocalService.getClassNameId(className), classPK);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No approved JournalArticle exists with the key {groupId=", groupId, ", className=", className, ", classPK=", classPK, "}"}));
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getArticleByUrlTitle(long groupId, String urlTitle) throws PortalException {
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, JournalArticle.class, urlTitle);
        if (friendlyURLEntry != null) {
            return this.getLatestArticle(friendlyURLEntry.getClassPK(), -1, true);
        }
        JournalArticle article = this.fetchLatestArticleByUrlTitle(groupId, urlTitle, 0);
        if (article != null) {
            return article;
        }
        return this.getLatestArticleByUrlTitle(groupId, urlTitle, -1);
    }

    public String getArticleContent(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        if (articleDisplay == null) {
            return "";
        }
        return articleDisplay.getContent();
    }

    @Deprecated
    public String getArticleContent(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(article, ddmTemplateKey, viewMode, languageId, null, themeDisplay);
    }

    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String ddmTemplateKey, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(groupId, articleId, version, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        if (articleDisplay == null) {
            return "";
        }
        return articleDisplay.getContent();
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String ddmTemplateKey, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(groupId, articleId, version, viewMode, ddmTemplateKey, languageId, null, themeDisplay);
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(groupId, articleId, version, viewMode, null, languageId, null, themeDisplay);
    }

    public String getArticleContent(long groupId, String articleId, String viewMode, String ddmTemplateKey, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        return articleDisplay.getContent();
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, String viewMode, String ddmTemplateKey, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(groupId, articleId, viewMode, ddmTemplateKey, languageId, null, themeDisplay);
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle article = this.fetchDisplayArticle(groupId, articleId);
        return this.getArticleContent(groupId, articleId, viewMode, article.getDDMTemplateKey(), languageId, null, themeDisplay);
    }

    public String getArticleDescription(long articlePK, Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getArticleDescription(articlePK, languageId);
    }

    public String getArticleDescription(long articlePK, String languageId) {
        JournalArticleLocalization journalArticleLocalization = this.journalArticleLocalizationPersistence.fetchByA_L(articlePK, languageId);
        if (journalArticleLocalization == null) {
            return null;
        }
        return journalArticleLocalization.getDescription();
    }

    public Map<Locale, String> getArticleDescriptionMap(long articlePK) {
        HashMap<Locale, String> journalArticleLocalizationDescriptionMap = new HashMap<Locale, String>();
        List journalArticleLocalizationList = this.journalArticleLocalizationPersistence.findByArticlePK(articlePK);
        for (JournalArticleLocalization journalArticleLocalization : journalArticleLocalizationList) {
            journalArticleLocalizationDescriptionMap.put(LocaleUtil.fromLanguageId((String)journalArticleLocalization.getLanguageId()), journalArticleLocalization.getDescription());
        }
        return journalArticleLocalizationDescriptionMap;
    }

    public JournalArticleDisplay getArticleDisplay(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay, false);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        Date expirationDate;
        Date now = new Date();
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (article.isExpired() && (expirationDate = article.getExpirationDate()) != null && expirationDate.before(now)) {
            return null;
        }
        Date displayDate = article.getDisplayDate();
        if (displayDate != null && displayDate.after(now)) {
            return null;
        }
        return this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleDisplay(groupId, articleId, version, ddmTemplateKey, viewMode, languageId, 1, null, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getDDMTemplateKey(), viewMode, languageId, page, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getVersion(), ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getVersion(), ddmTemplateKey, viewMode, languageId, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getDDMTemplateKey(), viewMode, languageId, themeDisplay);
    }

    public List<String> getArticleLocalizationLanguageIds(long articlePK) {
        List journalArticleLocalizationList = this.journalArticleLocalizationPersistence.findByArticlePK(articlePK);
        ArrayList<String> availableLanguageIds = new ArrayList<String>();
        for (JournalArticleLocalization journalArticleLocalization : journalArticleLocalizationList) {
            availableLanguageIds.add(journalArticleLocalization.getLanguageId());
        }
        return availableLanguageIds;
    }

    public List<JournalArticle> getArticles() {
        return this.journalArticlePersistence.findAll();
    }

    public List<JournalArticle> getArticles(long groupId) {
        return this.journalArticlePersistence.findByGroupId(groupId);
    }

    public List<JournalArticle> getArticles(long groupId, int start, int end) {
        return this.journalArticlePersistence.findByGroupId(groupId, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticlePersistence.findByGroupId(groupId, start, end, obc);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId) {
        return this.journalArticlePersistence.findByG_F(groupId, folderId);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int start, int end) {
        return this.journalArticlePersistence.findByG_F(groupId, folderId, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int status, int start, int end) {
        return this.journalArticlePersistence.findByG_F_ST(groupId, folderId, status, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        return this.journalArticlePersistence.findByG_F(groupId, folderId, start, end, orderByComparator);
    }

    public List<JournalArticle> getArticles(long groupId, String articleId) {
        return this.journalArticlePersistence.findByG_A(groupId, articleId);
    }

    public List<JournalArticle> getArticles(long groupId, String articleId, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        return this.journalArticlePersistence.findByG_A(groupId, articleId, start, end, orderByComparator);
    }

    public List<JournalArticle> getArticlesByResourcePrimKey(long resourcePrimKey) {
        return this.journalArticlePersistence.findByResourcePrimKey(resourcePrimKey);
    }

    public List<JournalArticle> getArticlesBySmallImageId(long smallImageId) {
        return this.journalArticlePersistence.findBySmallImageId(smallImageId);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, long classNameId, String ddmStructureKey, int status, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByG_C_S_L(groupId, classNameId, ddmStructureKey, LocaleUtil.getMostRelevantLocale(), queryDefinition);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, long classNameId, String ddmStructureKey, Locale locale, int status, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByG_C_S_L(groupId, classNameId, ddmStructureKey, locale, queryDefinition);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, String ddmStructureKey, int status, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByG_C_S_L(groupId, 0L, ddmStructureKey, LocaleUtil.getMostRelevantLocale(), queryDefinition);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, String ddmStructureKey, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.getArticlesByStructureId(groupId, ddmStructureKey, -1, start, end, obc);
    }

    public List<JournalArticle> getArticlesByStructureId(long groupId, String ddmStructureKey, Locale locale, int status, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByG_C_S_L(groupId, 0L, ddmStructureKey, locale, queryDefinition);
    }

    public int getArticlesCount(long groupId) {
        return this.journalArticlePersistence.countByGroupId(groupId);
    }

    public int getArticlesCount(long groupId, long folderId) {
        return this.journalArticlePersistence.countByG_F(groupId, folderId);
    }

    public int getArticlesCount(long groupId, long folderId, int status) {
        return this.journalArticlePersistence.countByG_F_ST(groupId, folderId, status);
    }

    public int getArticlesCount(long groupId, String articleId) {
        return this.journalArticlePersistence.countByG_A(groupId, articleId);
    }

    public String getArticleTitle(long articlePK, Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getArticleTitle(articlePK, languageId);
    }

    public String getArticleTitle(long articlePK, String languageId) {
        JournalArticleLocalization journalArticleLocalization = this.journalArticleLocalizationPersistence.fetchByA_L(articlePK, languageId);
        if (journalArticleLocalization == null) {
            return null;
        }
        return journalArticleLocalization.getTitle();
    }

    public Map<Locale, String> getArticleTitleMap(long articlePK) {
        HashMap<Locale, String> journalArticleLocalizationTitleMap = new HashMap<Locale, String>();
        List journalArticleLocalizationList = this.journalArticleLocalizationPersistence.findByArticlePK(articlePK);
        for (JournalArticleLocalization journalArticleLocalization : journalArticleLocalizationList) {
            journalArticleLocalizationTitleMap.put(LocaleUtil.fromLanguageId((String)journalArticleLocalization.getLanguageId()), journalArticleLocalization.getTitle());
        }
        return journalArticleLocalizationTitleMap;
    }

    public List<JournalArticle> getCompanyArticles(long companyId, double version, int status, int start, int end) {
        if (status == -1) {
            return this.journalArticlePersistence.findByC_V(companyId, version, start, end, (OrderByComparator)new ArticleIDComparator(true));
        }
        return this.journalArticlePersistence.findByC_V_ST(companyId, version, status, start, end, (OrderByComparator)new ArticleIDComparator(true));
    }

    public List<JournalArticle> getCompanyArticles(long companyId, int status, int start, int end) {
        if (status == -1) {
            return this.journalArticlePersistence.findByCompanyId(companyId, start, end, (OrderByComparator)new ArticleIDComparator(true));
        }
        return this.journalArticlePersistence.findByC_ST(companyId, status, start, end, (OrderByComparator)new ArticleIDComparator(true));
    }

    public int getCompanyArticlesCount(long companyId, double version, int status, int start, int end) {
        if (status == -1) {
            return this.journalArticlePersistence.countByC_V(companyId, version);
        }
        return this.journalArticlePersistence.countByC_V_ST(companyId, version, status);
    }

    public int getCompanyArticlesCount(long companyId, int status) {
        if (status == -1) {
            return this.journalArticlePersistence.countByCompanyId(companyId);
        }
        return this.journalArticlePersistence.countByC_ST(companyId, status);
    }

    public JournalArticle getDisplayArticle(long groupId, String articleId) throws PortalException {
        JournalArticle article = this.fetchDisplayArticle(groupId, articleId);
        if (article == null) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No approved JournalArticle exists with the key {groupId=", groupId, ", articleId=", articleId, "}"}));
        }
        return article;
    }

    public JournalArticle getDisplayArticleByUrlTitle(long groupId, String urlTitle) throws PortalException {
        List articles = null;
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, JournalArticle.class, urlTitle);
        articles = friendlyURLEntry != null ? this.journalArticlePersistence.findByR_ST(friendlyURLEntry.getClassPK(), 0, -1, -1, (OrderByComparator)new ArticleVersionComparator()) : this.journalArticlePersistence.findByG_UT_ST(groupId, FriendlyURLNormalizerUtil.normalizeWithEncoding((String)urlTitle), 0, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        if (articles.isEmpty()) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No JournalArticle exists with the key {groupId=", groupId, ", urlTitle=", urlTitle, "}"}));
        }
        Date now = new Date();
        for (JournalArticle article : articles) {
            Date displayDate = article.getDisplayDate();
            Date expirationDate = article.getExpirationDate();
            if (displayDate == null || !displayDate.before(now) || expirationDate != null && !expirationDate.after(now)) continue;
            return article;
        }
        return (JournalArticle)articles.get(0);
    }

    public List<JournalArticle> getIndexableArticlesByDDMStructureKey(String[] ddmStructureKeys) {
        if (this.isReindexAllArticleVersions()) {
            return this.getStructureArticles(ddmStructureKeys);
        }
        ArrayList<JournalArticle> articles = new ArrayList<JournalArticle>();
        QueryDefinition approvedQueryDefinition = new QueryDefinition(0, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        articles.addAll(this.journalArticleFinder.findByG_C_S_L(0L, 0L, ddmStructureKeys, LocaleUtil.getMostRelevantLocale(), approvedQueryDefinition));
        QueryDefinition trashQueryDefinition = new QueryDefinition(8, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        articles.addAll(this.journalArticleFinder.findByG_C_S_L(0L, 0L, ddmStructureKeys, LocaleUtil.getMostRelevantLocale(), trashQueryDefinition));
        return articles;
    }

    public List<JournalArticle> getIndexableArticlesByDDMStructureKey(String[] ddmStructureKeys, Locale locale) {
        if (this.isReindexAllArticleVersions()) {
            return this.getStructureArticles(ddmStructureKeys);
        }
        QueryDefinition approvedQueryDefinition = new QueryDefinition(0, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        ArrayList<JournalArticle> articles = new ArrayList<JournalArticle>();
        articles.addAll(this.journalArticleFinder.findByG_C_S_L(0L, 0L, ddmStructureKeys, locale, approvedQueryDefinition));
        QueryDefinition trashQueryDefinition = new QueryDefinition(8, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        articles.addAll(this.journalArticleFinder.findByG_C_S_L(0L, 0L, ddmStructureKeys, locale, trashQueryDefinition));
        return articles;
    }

    public List<JournalArticle> getIndexableArticlesByResourcePrimKey(long resourcePrimKey) {
        return this.journalArticlePersistence.findByR_I(resourcePrimKey, true);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey) throws PortalException {
        return this.getLatestArticle(resourcePrimKey, -1);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey, int status) throws PortalException {
        return this.getLatestArticle(resourcePrimKey, status, true);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey, int status, boolean preferApproved) throws PortalException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, 0, 0, 1, (OrderByComparator)orderByComparator);
            }
            if (ListUtil.isEmpty(articles)) {
                articles = this.journalArticlePersistence.findByResourcePrimKey(resourcePrimKey, 0, 1, (OrderByComparator)orderByComparator);
            }
        } else {
            articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, status, 0, 1, (OrderByComparator)orderByComparator);
        }
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {resourcePrimKey=" + resourcePrimKey + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId) throws PortalException {
        return this.getLatestArticle(groupId, articleId, -1);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId, int status) throws PortalException {
        return this.getFirstArticle(groupId, articleId, status, (OrderByComparator<JournalArticle>)new ArticleVersionComparator());
    }

    public JournalArticle getLatestArticle(long groupId, String className, long classPK) throws PortalException {
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, this.classNameLocalService.getClassNameId(className), classPK, 0, 1, (OrderByComparator)new ArticleVersionComparator());
        if (articles.isEmpty()) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No JournalArticle exists with the key {groupId=", groupId, ", className=", className, ", classPK =", classPK, "}"}));
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticleByUrlTitle(long groupId, String urlTitle, int status) throws PortalException {
        JournalArticle article = null;
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, JournalArticle.class, urlTitle);
        article = friendlyURLEntry != null ? this.fetchLatestArticle(friendlyURLEntry.getClassPK(), status) : this.fetchLatestArticleByUrlTitle(groupId, urlTitle, status);
        if (article == null) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No JournalArticle exists with the key {groupId=", groupId, ", urlTitle=", urlTitle, ", status=", status, "}"}));
        }
        return article;
    }

    public double getLatestVersion(long groupId, String articleId) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        return article.getVersion();
    }

    public double getLatestVersion(long groupId, String articleId, int status) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId, status);
        return article.getVersion();
    }

    public List<JournalArticle> getNoAssetArticles() {
        return this.journalArticleFinder.findByNoAssets();
    }

    public List<JournalArticle> getNoPermissionArticles() {
        return this.journalArticleFinder.findByNoPermissions();
    }

    public int getNotInTrashArticlesCount(long groupId, long folderId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.journalArticleFinder.countByG_F(groupId, ListUtil.fromArray((Object[])new Long[]{folderId}), queryDefinition);
    }

    public JournalArticle getOldestArticle(long groupId, String articleId) throws PortalException {
        return this.getOldestArticle(groupId, articleId, -1);
    }

    public JournalArticle getOldestArticle(long groupId, String articleId, int status) throws PortalException {
        return this.getFirstArticle(groupId, articleId, status, (OrderByComparator<JournalArticle>)new ArticleVersionComparator(true));
    }

    public JournalArticle getPreviousApprovedArticle(JournalArticle article) {
        List approvedArticles = this.journalArticlePersistence.findByG_A_ST(article.getGroupId(), article.getArticleId(), 0, 0, 2);
        if (approvedArticles.isEmpty() || approvedArticles.size() == 1 && article.getStatus() == 0) {
            return article;
        }
        JournalArticle previousApprovedArticle = (JournalArticle)approvedArticles.get(0);
        if (previousApprovedArticle.getVersion() == article.getVersion()) {
            previousApprovedArticle = (JournalArticle)approvedArticles.get(1);
        }
        return previousApprovedArticle;
    }

    public List<JournalArticle> getStructureArticles(long groupId, String ddmStructureKey) {
        return this.journalArticlePersistence.findByG_DDMSK(groupId, ddmStructureKey);
    }

    public List<JournalArticle> getStructureArticles(long groupId, String ddmStructureKey, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticlePersistence.findByG_DDMSK(groupId, ddmStructureKey, start, end, obc);
    }

    public List<JournalArticle> getStructureArticles(String[] ddmStructureKeys) {
        return this.journalArticlePersistence.findByDDMStructureKey(ddmStructureKeys);
    }

    public int getStructureArticlesCount(long groupId, String ddmStructureKey) {
        return this.journalArticlePersistence.countByG_DDMSK(groupId, ddmStructureKey);
    }

    @Deprecated
    public com.liferay.portal.kernel.service.SubscriptionLocalService getSubscriptionLocalService() {
        return null;
    }

    public List<JournalArticle> getTemplateArticles(long groupId, String ddmTemplateKey) {
        return this.journalArticlePersistence.findByG_DDMTK(groupId, ddmTemplateKey);
    }

    public List<JournalArticle> getTemplateArticles(long groupId, String ddmTemplateKey, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticlePersistence.findByG_DDMTK(groupId, ddmTemplateKey, start, end, obc);
    }

    public int getTemplateArticlesCount(long groupId, String ddmTemplateKey) {
        return this.journalArticlePersistence.countByG_DDMTK(groupId, ddmTemplateKey);
    }

    public String getUniqueUrlTitle(long groupId, String articleId, String urlTitle) throws PortalException {
        JournalArticle article;
        int i = 1;
        while ((article = this.fetchArticleByUrlTitle(groupId, urlTitle)) != null && !articleId.equals(article.getArticleId())) {
            String suffix = "-" + i;
            String prefix = urlTitle;
            if (urlTitle.length() > suffix.length()) {
                prefix = urlTitle.substring(0, urlTitle.length() - suffix.length());
            }
            urlTitle = prefix + suffix;
            ++i;
        }
        return urlTitle;
    }

    public boolean hasArticle(long groupId, String articleId) {
        JournalArticle article = this.fetchArticle(groupId, articleId);
        return article != null;
    }

    public boolean isLatestVersion(long groupId, String articleId, double version) throws PortalException {
        return this.getLatestVersion(groupId, articleId) == version;
    }

    public boolean isLatestVersion(long groupId, String articleId, double version, int status) throws PortalException {
        return this.getLatestVersion(groupId, articleId, status) == version;
    }

    public boolean isListable(JournalArticle article) {
        return article != null && article.isIndexable();
    }

    public boolean isRenderable(JournalArticle article, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        try {
            this.getArticleDisplay(article, article.getDDMTemplateKey(), "view", article.getDefaultLanguageId(), 0, portletRequestModel, themeDisplay, true);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticle(long groupId, String articleId, long newFolderId) throws PortalException {
        return this.moveArticle(groupId, articleId, newFolderId, null);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticle(long groupId, String articleId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        JournalArticle latestArticle = this.getLatestArticle(groupId, articleId);
        this.validateDDMStructureId(groupId, newFolderId, latestArticle.getDDMStructureKey());
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId);
        String treePath = null;
        for (JournalArticle article : articles) {
            article.setFolderId(newFolderId);
            if (treePath == null) {
                treePath = article.buildTreePath();
            }
            article.setTreePath(treePath);
            this.journalArticlePersistence.update((BaseModel)article);
        }
        if (serviceContext != null) {
            this.notifySubscribers(serviceContext.getUserId(), latestArticle, "move_from", serviceContext);
            latestArticle.setFolderId(newFolderId);
            latestArticle.setTreePath(latestArticle.buildTreePath());
            this.notifySubscribers(serviceContext.getUserId(), latestArticle, "move_to", serviceContext);
        }
        return this.getArticle(groupId, articleId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticleFromTrash(long userId, long groupId, JournalArticle article, long newFolderId, ServiceContext serviceContext) throws PortalException {
        if (!article.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (article.isInTrashExplicitly()) {
            article = this.restoreArticleFromTrash(userId, article);
        } else {
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(JournalArticle.class.getName(), article.getResourcePrimKey());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            article = this.updateStatus(userId, article, status, null, serviceContext, new HashMap<String, Serializable>());
            for (FileEntry fileEntry : article.getImagesFileEntries()) {
                PortletFileRepositoryUtil.restorePortletFileEntryFromTrash((long)userId, (long)fileEntry.getFileEntryId());
            }
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
        }
        return this.moveArticle(groupId, article.getArticleId(), newFolderId, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticleToTrash(long userId, JournalArticle article) throws PortalException {
        if (article.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = article.getStatus();
        if (oldStatus == 1) {
            article.setStatus(2);
            this.journalArticlePersistence.update((BaseModel)article);
        }
        article = this.updateStatus(userId, article.getId(), 8, new HashMap<String, Serializable>(), new ServiceContext());
        List articleVersions = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
        articleVersions = ListUtil.sort((List)articleVersions, (Comparator)new ArticleVersionComparator());
        List<Object> articleVersionStatusOVPs = new ArrayList();
        if (articleVersions != null && !articleVersions.isEmpty()) {
            articleVersionStatusOVPs = this.getArticleVersionStatuses(articleVersions);
        }
        JournalArticleResource articleResource = this._journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("title", article.getArticleId());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), articleResource.getUuid(), null, oldStatus, articleVersionStatusOVPs, typeSettingsProperties);
        String trashArticleId = this._trashHelper.getTrashTitle(trashEntry.getEntryId());
        for (JournalArticle articleVersion : articleVersions) {
            articleVersion.setArticleId(trashArticleId);
            articleVersion.setStatus(8);
            this.journalArticlePersistence.update((BaseModel)articleVersion);
        }
        articleResource.setArticleId(trashArticleId);
        this.journalArticleResourcePersistence.update((BaseModel)articleResource);
        article.setArticleId(trashArticleId);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
        for (FileEntry fileEntry : article.getImagesFileEntries()) {
            PortletFileRepositoryUtil.movePortletFileEntryToTrash((long)userId, (long)fileEntry.getFileEntryId());
        }
        if (this.isArticleCommentsEnabled(article.getCompanyId())) {
            this._commentManager.moveDiscussionToTrash(JournalArticle.class.getName(), article.getResourcePrimKey());
        }
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)article.getTitleMapAsXML());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)article, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        if (oldStatus == 1) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(article.getCompanyId(), article.getGroupId(), JournalArticle.class.getName(), article.getId());
        }
        return article;
    }

    public JournalArticle moveArticleToTrash(long userId, long groupId, String articleId) throws PortalException {
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, 0, 1, (OrderByComparator)new ArticleVersionComparator());
        if (!articles.isEmpty()) {
            return this.journalArticleLocalService.moveArticleToTrash(userId, (JournalArticle)articles.get(0));
        }
        return null;
    }

    public void rebuildTree(long companyId) throws PortalException {
        JournalTreePathUtil.rebuildTree(companyId, 0L, "/", this.journalFolderPersistence, this);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle removeArticleLocale(long groupId, String articleId, double version, String languageId) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (Objects.equals(languageId, article.getDefaultLanguageId())) {
            throw new RequiredArticleLocalizationException("Default article localization is required");
        }
        this.journalArticleLocalizationPersistence.removeByA_L(article.getId(), languageId);
        com.liferay.portal.kernel.xml.Document document = article.getDocument();
        if (document != null) {
            String content = article.getContent();
            content = JournalUtil.removeArticleLocale(document, content, languageId);
            article.setContent(content);
        }
        this.journalArticlePersistence.update((BaseModel)article);
        return article;
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle restoreArticleFromTrash(long userId, JournalArticle article) throws PortalException {
        if (!article.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        String trashArticleId = this._trashHelper.getOriginalTitle(article.getArticleId());
        List articleVersions = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
        for (JournalArticle articleVersion : articleVersions) {
            articleVersion.setArticleId(trashArticleId);
            if (!article.equals(articleVersion = (JournalArticle)this.journalArticlePersistence.update((BaseModel)articleVersion))) continue;
            article = articleVersion;
        }
        article.setArticleId(trashArticleId);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        JournalArticleResource articleResource = this.journalArticleResourcePersistence.fetchByPrimaryKey(article.getResourcePrimKey());
        articleResource.setArticleId(trashArticleId);
        this.journalArticleResourcePersistence.update((BaseModel)articleResource);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(article.getGroupId());
        article = this.updateStatus(userId, article, trashEntry.getStatus(), null, serviceContext, new HashMap<String, Serializable>());
        List trashVersions = this.trashVersionLocalService.getVersions(trashEntry.getEntryId());
        boolean visible = false;
        for (TrashVersion trashVersion : trashVersions) {
            JournalArticle trashArticleVersion = this.journalArticlePersistence.findByPrimaryKey(trashVersion.getClassPK());
            trashArticleVersion.setStatus(trashEntry.getStatus());
            if (trashEntry.getStatus() == 0) {
                visible = true;
            }
            this.journalArticlePersistence.update((BaseModel)trashArticleVersion);
        }
        this.trashEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
        if (visible) {
            this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), true);
        }
        if (this.isArticleCommentsEnabled(article.getCompanyId())) {
            this._commentManager.restoreDiscussionFromTrash(JournalArticle.class.getName(), article.getResourcePrimKey());
        }
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)article.getTitleMapAsXML());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)article, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
        return article;
    }

    @Deprecated
    public List<JournalArticle> search(long groupId, List<Long> folderIds, int status, int start, int end) {
        Locale locale = LocaleUtil.getMostRelevantLocale();
        return this.search(groupId, folderIds, locale, status, start, end);
    }

    public List<JournalArticle> search(long groupId, List<Long> folderIds, Locale locale, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.journalArticleFinder.findByG_F_L(groupId, folderIds, locale, queryDefinition);
    }

    public List<JournalArticle> search(long groupId, long folderId, int status, int start, int end) {
        return this.search(groupId, ListUtil.fromArray((Object[])new Long[]{folderId}), LocaleUtil.getMostRelevantLocale(), status, start, end);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String keywords, Double version, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticleFinder.findByKeywords(companyId, groupId, folderIds, classNameId, keywords, version, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, status, reviewDate, start, end, obc);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, andOperator, queryDefinition);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String[] ddmStructureKeys, String[] ddmTemplateKeys, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKeys, ddmTemplateKeys, displayDateGT, displayDateLT, reviewDate, andOperator, queryDefinition);
    }

    public Hits search(long companyId, long groupId, List<Long> folderIds, long classNameId, String ddmStructureKey, String ddmTemplateKey, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        String articleId = null;
        String title = null;
        String description = null;
        String content = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            articleId = keywords;
            title = keywords;
            description = keywords;
            content = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.search(companyId, groupId, folderIds, classNameId, articleId, title, description, content, -1, ddmStructureKey, ddmTemplateKey, params, andOperator, start, end, sort);
    }

    public Hits search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, int status, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
            SearchContext searchContext = this.buildSearchContext(companyId, groupId, folderIds, classNameId, articleId, title, description, content, status, ddmStructureKey, ddmTemplateKey, params, andSearch, start, end, sort);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    @Deprecated
    public Hits search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, String type, String statusString, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        int status = GetterUtil.getInteger((String)statusString);
        return this.search(companyId, groupId, folderIds, classNameId, articleId, title, description, content, status, ddmStructureKey, ddmTemplateKey, params, andSearch, start, end, sort);
    }

    public Hits search(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)JournalArticle.class.getName());
        SearchContext searchContext = this.buildSearchContext(groupId, userId, creatorUserId, status, start, end);
        return indexer.search(searchContext);
    }

    public int searchCount(long groupId, List<Long> folderIds, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.journalArticleFinder.countByG_F(groupId, folderIds, queryDefinition);
    }

    public int searchCount(long groupId, long folderId, int status) {
        return this.searchCount(groupId, ListUtil.fromArray((Object[])new Long[]{folderId}), status);
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String keywords, Double version, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate) {
        return this.journalArticleFinder.countByKeywords(companyId, groupId, folderIds, classNameId, keywords, version, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, status, reviewDate);
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) {
        return this.journalArticleFinder.countByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, andOperator, new QueryDefinition(status));
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String[] ddmStructureKeys, String[] ddmTemplateKeys, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) {
        return this.journalArticleFinder.countByC_G_F_C_A_V_T_D_C_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, ddmStructureKeys, ddmTemplateKeys, displayDateGT, displayDateLT, reviewDate, andOperator, new QueryDefinition(status));
    }

    public BaseModelSearchResult<JournalArticle> searchJournalArticles(long companyId, long groupId, List<Long> folderIds, long classNameId, String ddmStructureKey, String ddmTemplateKey, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws PortalException {
        String articleId = null;
        String title = null;
        String description = null;
        String content = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            articleId = keywords;
            title = keywords;
            description = keywords;
            content = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.searchJournalArticles(companyId, groupId, folderIds, classNameId, articleId, title, description, content, -1, ddmStructureKey, ddmTemplateKey, params, andOperator, start, end, sort);
    }

    public BaseModelSearchResult<JournalArticle> searchJournalArticles(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, int status, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, folderIds, classNameId, articleId, title, description, content, status, ddmStructureKey, ddmTemplateKey, params, andSearch, start, end, sort);
        return this.searchJournalArticles(searchContext);
    }

    public BaseModelSearchResult<JournalArticle> searchJournalArticles(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(groupId, userId, creatorUserId, status, start, end);
        return this.searchJournalArticles(searchContext);
    }

    @Deprecated
    public void setSubscriptionLocalService(com.liferay.portal.kernel.service.SubscriptionLocalService subscriptionLocalService) {
    }

    public void setTreePaths(long folderId, String treePath, boolean reindex) throws PortalException {
        if (treePath == null) {
            throw new IllegalArgumentException("Tree path is null");
        }
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
            dynamicQuery.add(folderIdProperty.eq((Object)folderId));
            Property treePathProperty = PropertyFactoryUtil.forName((String)"treePath");
            dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)treePathProperty.isNull(), (Criterion)treePathProperty.ne((Object)treePath)));
        });
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)JournalArticle.class.getName());
        indexableActionableDynamicQuery.setPerformActionMethod(article -> {
            article.setTreePath(treePath);
            this.updateJournalArticle((JournalArticle)article);
            if (!reindex) {
                return;
            }
            indexableActionableDynamicQuery.setCompanyId(article.getCompanyId());
            indexableActionableDynamicQuery.addDocuments(new Document[]{indexer.getDocument(article)});
        });
        indexableActionableDynamicQuery.performActions();
    }

    public void subscribe(long userId, long groupId, long articleId) throws PortalException {
        this._subscriptionLocalService.addSubscription(userId, groupId, JournalArticle.class.getName(), articleId);
    }

    public void subscribeStructure(long groupId, long userId, long ddmStructureId) throws PortalException {
        this._subscriptionLocalService.addSubscription(userId, groupId, DDMStructure.class.getName(), ddmStructureId);
    }

    public void unsubscribe(long userId, long groupId, long articleId) throws PortalException {
        this._subscriptionLocalService.deleteSubscription(userId, JournalArticle.class.getName(), articleId);
    }

    public void unsubscribeStructure(long groupId, long userId, long ddmStructureId) throws PortalException {
        this._subscriptionLocalService.deleteSubscription(userId, DDMStructure.class.getName(), ddmStructureId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> friendlyURLMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        boolean validate;
        JournalArticle latestArticle;
        User user = this.userLocalService.getUser(userId);
        articleId = StringUtil.toUpperCase((String)StringUtil.trim((String)articleId));
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JournalArticle article = latestArticle = this.getLatestArticle(groupId, articleId, -1);
        boolean imported = ExportImportThreadLocal.isImportInProcess();
        boolean addNewVersion = false;
        if (imported) {
            article = this.getArticle(groupId, articleId, version);
        } else {
            double latestArticleVersion = latestArticle.getVersion();
            if (version > 0.0 && version != latestArticleVersion) {
                StringBundler sb = new StringBundler(4);
                sb.append("Version ");
                sb.append(version);
                sb.append(" is not the same as ");
                sb.append(latestArticleVersion);
                throw new ArticleVersionException(sb.toString());
            }
            serviceContext.validateModifiedDate((AuditedModel)latestArticle, ArticleVersionException.class);
            if (latestArticle.isApproved() || latestArticle.isExpired() || latestArticle.isScheduled()) {
                addNewVersion = true;
                version = this.getNextVersion(article);
            }
        }
        Date displayDate = this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), null);
        Date expirationDate = null;
        Date reviewDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), ArticleExpirationDateException.class);
        }
        if (!neverReview) {
            reviewDate = this._portal.getDate(reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, user.getTimeZone(), ArticleReviewDateException.class);
        }
        Date now = new Date();
        boolean expired = false;
        if (expirationDate != null && expirationDate.before(now)) {
            expired = true;
        }
        this.sanitize(user.getCompanyId(), groupId, userId, article.getClassPK(), descriptionMap);
        boolean bl = validate = !ExportImportThreadLocal.isImportInProcess();
        if (validate) {
            this.validate(user.getCompanyId(), groupId, latestArticle.getClassNameId(), titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
            try {
                this.validateReferences(groupId, ddmStructureKey, ddmTemplateKey, layoutUuid, smallImage, smallImageURL, smallImageBytes, latestArticle.getSmallImageId(), content);
            }
            catch (ExportImportContentValidationException exportImportContentValidationException) {
                exportImportContentValidationException.setStagedModelClassName(JournalArticle.class.getName());
                exportImportContentValidationException.setStagedModelPrimaryKeyObj((Serializable)((Object)articleId));
                throw exportImportContentValidationException;
            }
        }
        if (addNewVersion) {
            long id = this.counterLocalService.increment();
            article = this.journalArticlePersistence.create(id);
            article.setResourcePrimKey(latestArticle.getResourcePrimKey());
            article.setGroupId(latestArticle.getGroupId());
            article.setCompanyId(latestArticle.getCompanyId());
            article.setUserId(user.getUserId());
            article.setUserName(user.getFullName());
            article.setCreateDate(latestArticle.getCreateDate());
            article.setClassNameId(latestArticle.getClassNameId());
            article.setClassPK(latestArticle.getClassPK());
            article.setArticleId(articleId);
            article.setVersion(version);
            article.setSmallImageId(latestArticle.getSmallImageId());
            serviceContext.setAttribute("version", (Serializable)Double.valueOf(version));
            this._addArticleLocalizedFields(article.getCompanyId(), article.getId(), titleMap, descriptionMap);
        } else {
            this._updateArticleLocalizedFields(article.getCompanyId(), article.getId(), titleMap, descriptionMap);
        }
        Locale locale = this.getArticleDefaultLocale(content);
        Map<String, String> urlTitleMap = this._getURLTitleMap(groupId, article.getResourcePrimKey(), friendlyURLMap, titleMap);
        String urlTitle = urlTitleMap.get(LocaleUtil.toLanguageId((Locale)locale));
        if (Validator.isNull((String)urlTitle)) {
            throw new ArticleFriendlyURLException();
        }
        content = this.format(user, groupId, article, content);
        content = this._replaceTempImages(article, content);
        article.setFolderId(folderId);
        article.setTreePath(article.buildTreePath());
        article.setUrlTitle(urlTitle);
        article.setContent(content);
        article.setDDMStructureKey(ddmStructureKey);
        article.setDDMTemplateKey(ddmTemplateKey);
        article.setDefaultLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null && article.getSmallImageId() <= 0L) {
                article.setSmallImageId(this.counterLocalService.increment());
            }
        } else {
            article.setSmallImageId(0L);
        }
        article.setSmallImageURL(smallImageURL);
        if (latestArticle.isPending()) {
            article.setStatus(latestArticle.getStatus());
        } else if (!expired) {
            article.setStatus(2);
        } else {
            article.setStatus(3);
        }
        ExpandoBridgeUtil.setExpandoBridgeAttributes((ExpandoBridge)latestArticle.getExpandoBridge(), (ExpandoBridge)article.getExpandoBridge(), (ServiceContext)serviceContext);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        this.updateFriendlyURLs(article, urlTitleMap, serviceContext);
        if (this.hasModifiedLatestApprovedVersion(groupId, articleId, version)) {
            this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        }
        this.updateDDMLinks(article.getId(), groupId, ddmStructureKey, ddmTemplateKey, addNewVersion);
        this.saveImages(smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        if (expired && imported) {
            article = this.updateStatus(userId, article, article.getStatus(), articleURL, serviceContext, new HashMap<String, Serializable>());
        }
        if (serviceContext.getWorkflowAction() == 1) {
            articleURL = this.buildArticleURL(articleURL, groupId, folderId, articleId);
            serviceContext.setAttribute("articleURL", (Serializable)((Object)articleURL));
            this.sendEmail(article, articleURL, "requested", serviceContext);
            this.startWorkflowInstance(userId, article, serviceContext);
        }
        return article;
    }

    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String layoutUuid, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        Date displayDate = article.getDisplayDate();
        int displayDateMonth = 0;
        int displayDateDay = 0;
        int displayDateYear = 0;
        int displayDateHour = 0;
        int displayDateMinute = 0;
        if (displayDate != null) {
            Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            displayCal.setTime(displayDate);
            displayDateMonth = displayCal.get(2);
            displayDateDay = displayCal.get(5);
            displayDateYear = displayCal.get(1);
            displayDateHour = displayCal.get(10);
            displayDateMinute = displayCal.get(12);
            if (displayCal.get(9) == 1) {
                displayDateHour += 12;
            }
        }
        Date expirationDate = article.getExpirationDate();
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            expirationCal.setTime(expirationDate);
            expirationDateMonth = expirationCal.get(2);
            expirationDateDay = expirationCal.get(5);
            expirationDateYear = expirationCal.get(1);
            expirationDateHour = expirationCal.get(10);
            expirationDateMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationDateHour += 12;
            }
        }
        Date reviewDate = article.getReviewDate();
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        if (reviewDate != null) {
            Calendar reviewCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            reviewCal.setTime(reviewDate);
            reviewDateMonth = reviewCal.get(2);
            reviewDateDay = reviewCal.get(5);
            reviewDateYear = reviewCal.get(1);
            reviewDateHour = reviewCal.get(10);
            reviewDateMinute = reviewCal.get(12);
            neverReview = false;
            if (reviewCal.get(9) == 1) {
                reviewDateHour += 12;
            }
        }
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, titleMap, descriptionMap, content, article.getDDMStructureKey(), article.getDDMTemplateKey(), layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.isIndexable(), article.isSmallImage(), article.getSmallImageURL(), null, null, null, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId, -1);
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
            String title = entry.getValue();
            if (Validator.isNull((String)title)) continue;
            String urlTitle = this.friendlyURLEntryLocalService.getUniqueUrlTitle(groupId, this.classNameLocalService.getClassNameId(JournalArticle.class), article.getResourcePrimKey(), title);
            friendlyURLMap.put(entry.getKey(), urlTitle);
        }
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, titleMap, descriptionMap, friendlyURLMap, content, ddmStructureKey, ddmTemplateKey, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, null, null, null, serviceContext);
    }

    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, String content, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, article.getTitleMap(), article.getDescriptionMap(), content, article.getLayoutUuid(), serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticle(long id, String urlTitle) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByPrimaryKey(id);
        article.setUrlTitle(urlTitle);
        this.journalArticlePersistence.update((BaseModel)article);
        return article;
    }

    public JournalArticle updateArticleDefaultValues(long userId, long groupId, String articleId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        articleId = StringUtil.toUpperCase((String)StringUtil.trim((String)articleId));
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JournalArticle article = this.getArticle(groupId, articleId);
        serviceContext.validateModifiedDate((AuditedModel)article, ArticleVersionException.class);
        this.sanitize(user.getCompanyId(), groupId, userId, article.getClassPK(), descriptionMap);
        this.validate(user.getCompanyId(), groupId, article.getClassNameId(), titleMap, content, ddmStructureKey, ddmTemplateKey, null, null, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
        this._updateArticleLocalizedFields(article.getCompanyId(), article.getId(), titleMap, descriptionMap);
        content = this.format(user, groupId, article, content);
        content = this._replaceTempImages(article, content);
        article.setContent(content);
        article.setDDMStructureKey(ddmStructureKey);
        article.setDDMTemplateKey(ddmTemplateKey);
        Locale locale = this.getArticleDefaultLocale(content);
        article.setDefaultLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        article.setLayoutUuid(layoutUuid);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null && article.getSmallImageId() <= 0L) {
                article.setSmallImageId(this.counterLocalService.increment());
            }
        } else {
            article.setSmallImageId(0L);
        }
        article.setSmallImageURL(smallImageURL);
        article.setStatus(0);
        ExpandoBridgeUtil.setExpandoBridgeAttributes((ExpandoBridge)article.getExpandoBridge(), (ExpandoBridge)article.getExpandoBridge(), (ServiceContext)serviceContext);
        this.journalArticlePersistence.update((BaseModel)article);
        this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        this.updateDDMStructurePredefinedValues(article.getClassPK(), content, serviceContext);
        this.saveImages(smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        return this.journalArticlePersistence.findByPrimaryKey(article.getId());
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticleTranslation(long groupId, String articleId, double version, Locale locale, String title, String description, String content, Map<String, byte[]> images, ServiceContext serviceContext) throws PortalException {
        this.validateContent(content);
        JournalArticle oldArticle = this.getLatestArticle(groupId, articleId, -1);
        double oldVersion = oldArticle.getVersion();
        if (version > 0.0 && version != oldVersion) {
            StringBundler sb = new StringBundler(4);
            sb.append("Version ");
            sb.append(version);
            sb.append(" is not the same as ");
            sb.append(oldVersion);
            throw new ArticleVersionException(sb.toString());
        }
        boolean incrementVersion = false;
        if (oldArticle.isApproved() || oldArticle.isExpired()) {
            incrementVersion = true;
        }
        if (serviceContext != null) {
            serviceContext.validateModifiedDate((AuditedModel)oldArticle, ArticleVersionException.class);
        }
        JournalArticle article = null;
        User user = this.userLocalService.fetchUser(oldArticle.getUserId());
        if (user == null) {
            user = this.userLocalService.getDefaultUser(oldArticle.getCompanyId());
        }
        if (incrementVersion) {
            double newVersion = this.getNextVersion(oldArticle);
            long id = this.counterLocalService.increment();
            article = this.journalArticlePersistence.create(id);
            article.setResourcePrimKey(oldArticle.getResourcePrimKey());
            article.setGroupId(oldArticle.getGroupId());
            article.setCompanyId(oldArticle.getCompanyId());
            article.setUserId(oldArticle.getUserId());
            article.setUserName(user.getFullName());
            article.setCreateDate(oldArticle.getCreateDate());
            article.setFolderId(oldArticle.getFolderId());
            article.setClassNameId(oldArticle.getClassNameId());
            article.setClassPK(oldArticle.getClassPK());
            article.setArticleId(articleId);
            article.setVersion(newVersion);
            article.setUrlTitle(this.getUniqueUrlTitle(id, groupId, articleId, title, oldArticle.getUrlTitle(), serviceContext));
            article.setDDMStructureKey(oldArticle.getDDMStructureKey());
            article.setDDMTemplateKey(oldArticle.getDDMTemplateKey());
            article.setDefaultLanguageId(LocaleUtil.toLanguageId((Locale)this.getArticleDefaultLocale(content)));
            article.setLayoutUuid(oldArticle.getLayoutUuid());
            article.setDisplayDate(oldArticle.getDisplayDate());
            article.setExpirationDate(oldArticle.getExpirationDate());
            article.setReviewDate(oldArticle.getReviewDate());
            article.setIndexable(oldArticle.isIndexable());
            article.setSmallImage(oldArticle.isSmallImage());
            article.setSmallImageId(oldArticle.getSmallImageId());
            if (article.getSmallImageId() == 0L) {
                article.setSmallImageId(this.counterLocalService.increment());
            }
            article.setSmallImageURL(oldArticle.getSmallImageURL());
            article.setStatus(2);
            article.setStatusDate(new Date());
            ExpandoBridgeUtil.copyExpandoBridgeAttributes((ExpandoBridge)oldArticle.getExpandoBridge(), (ExpandoBridge)article.getExpandoBridge());
            this._addArticleLocalizedFields(article.getCompanyId(), article.getId(), oldArticle.getTitleMap(), oldArticle.getDescriptionMap());
            this.updateDDMLinks(id, groupId, oldArticle.getDDMStructureKey(), oldArticle.getDDMTemplateKey(), true);
        } else {
            article = oldArticle;
        }
        this._updateArticleLocalizedFields(article.getCompanyId(), article.getId(), title, description, LocaleUtil.toLanguageId((Locale)locale));
        content = this.format(user, groupId, article, content);
        content = this._replaceTempImages(article, content);
        article.setContent(content);
        this.journalArticlePersistence.update((BaseModel)article);
        return article;
    }

    @Deprecated
    public void updateAsset(long userId, JournalArticle article, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        this.updateAsset(userId, article, assetCategoryIds, assetTagNames, assetLinkEntryIds, null);
    }

    public void updateAsset(long userId, JournalArticle article, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, Double priority) throws PortalException {
        int approvedArticlesCount;
        boolean visible = article.isApproved();
        if (article.getClassNameId() != 0L) {
            visible = false;
        }
        boolean addDraftAssetEntry = false;
        if (!article.isApproved() && article.getVersion() != 1.0 && (approvedArticlesCount = this.journalArticlePersistence.countByG_A_ST(article.getGroupId(), article.getArticleId(), JournalArticleConstants.ASSET_ENTRY_CREATION_STATUSES)) > 0) {
            addDraftAssetEntry = true;
        }
        AssetEntry assetEntry = null;
        String title = article.getTitleMapAsXML();
        String description = article.getDescriptionMapAsXML();
        if (addDraftAssetEntry) {
            assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), article.getPrimaryKey(), article.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, this.isListable(article), false, null, null, null, article.getExpirationDate(), "text/html", title, description, description, null, article.getLayoutUuid(), 0, 0, priority);
        } else {
            JournalArticleResource journalArticleResource = this._journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
            Date publishDate = null;
            if (article.isApproved()) {
                publishDate = article.getDisplayDate();
            }
            assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), journalArticleResource.getResourcePrimKey(), journalArticleResource.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, this.isListable(article), visible, null, null, publishDate, article.getExpirationDate(), "text/html", title, description, description, null, article.getLayoutUuid(), 0, 0, priority);
        }
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateContent(long groupId, String articleId, double version, String content) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        article.setContent(content);
        this.journalArticlePersistence.update((BaseModel)article);
        return article;
    }

    public void updateDDMTemplateKey(long groupId, long classNameId, String oldDDMTemplateKey, String newDDMTemplateKey) {
        List articles = this.journalArticlePersistence.findByG_C_DDMTK(groupId, classNameId, oldDDMTemplateKey);
        for (JournalArticle article : articles) {
            article.setDDMTemplateKey(newDDMTemplateKey);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateStatus(long userId, JournalArticle article, int status, String articleURL, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        Date expirationDate;
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        if (status == 0 && article.getDisplayDate() != null && now.before(article.getDisplayDate())) {
            status = 7;
        }
        int oldStatus = article.getStatus();
        Date modifiedDate = serviceContext.getModifiedDate(now);
        article.setModifiedDate(modifiedDate);
        if (status == 0 && (expirationDate = article.getExpirationDate()) != null && expirationDate.before(now)) {
            article.setExpirationDate(null);
        }
        if (status == 3) {
            article.setExpirationDate(now);
        }
        article.setStatus(status);
        article.setStatusByUserId(user.getUserId());
        article.setStatusByUserName(user.getFullName());
        article.setStatusDate(modifiedDate);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        if (this.isExpireAllArticleVersions(article.getCompanyId())) {
            article = this.setArticlesExpirationDate(article);
        }
        if (this.hasModifiedLatestApprovedVersion(article.getGroupId(), article.getArticleId(), article.getVersion())) {
            if (status == 0) {
                AssetEntry draftAssetEntry;
                this.updateUrlTitles(article.getGroupId(), article.getArticleId(), article.getUrlTitle());
                String title = article.getTitleMapAsXML();
                if (oldStatus != 0 && article.getVersion() != 1.0 && (draftAssetEntry = this.assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), article.getPrimaryKey())) != null) {
                    long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                    String[] assetTagNames = draftAssetEntry.getTagNames();
                    List assetLinks = this.assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0, false);
                    long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
                    String description = article.getDescriptionMapAsXML();
                    AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), article.getResourcePrimKey(), article.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, this.isListable(article), false, null, null, null, null, "text/html", title, description, description, null, article.getLayoutUuid(), 0, 0, Double.valueOf(draftAssetEntry.getPriority()));
                    this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
                    this.assetEntryLocalService.deleteEntry(draftAssetEntry);
                }
                this.assetEntryLocalService.updateEntry(JournalArticle.class.getName(), article.getResourcePrimKey(), article.getDisplayDate(), article.getExpirationDate(), this.isListable(article), true);
                JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)title);
                if (serviceContext.isCommandUpdate()) {
                    SocialActivityManagerUtil.addActivity((long)user.getUserId(), (ClassedModel)article, (int)2, (String)extraDataJSONObject.toString(), (long)0L);
                } else {
                    SocialActivityManagerUtil.addUniqueActivity((long)user.getUserId(), (ClassedModel)article, (int)1, (String)extraDataJSONObject.toString(), (long)0L);
                }
            } else if (oldStatus == 0) {
                this.updatePreviousApprovedArticle(article);
            }
        }
        String action = "update";
        if (oldStatus != 8 && status != 8) {
            if (oldStatus == 1 && (status == 0 || status == 4)) {
                String msg = "granted";
                if (status == 4) {
                    msg = "denied";
                }
                try {
                    articleURL = this.buildArticleURL(articleURL, article.getGroupId(), article.getFolderId(), article.getArticleId());
                    this.sendEmail(article, articleURL, msg, serviceContext);
                }
                catch (Exception exception) {
                    _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to send email to notify the change of ", "status to ", msg, " for article ", article.getId(), ": ", exception.getMessage()}));
                }
            }
            if (article.equals(this.getOldestArticle(article.getGroupId(), article.getArticleId()))) {
                action = "add";
            }
        }
        if (oldStatus != 8 && status == 8) {
            action = "move_to_trash";
        } else if (oldStatus == 8 && status != 8) {
            action = "move_from_trash";
        }
        this.notifySubscribers(user.getUserId(), article, action, serviceContext);
        return article;
    }

    public JournalArticle updateStatus(long userId, long classPK, int status, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        return this.journalArticleLocalService.updateStatus(userId, this.getArticle(classPK), status, null, serviceContext, workflowContext);
    }

    public JournalArticle updateStatus(long userId, long groupId, String articleId, double version, int status, String articleURL, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.updateStatus(userId, article, status, articleURL, serviceContext, workflowContext);
    }

    @Deprecated
    public void updateTemplateId(long groupId, long classNameId, String oldDDMTemplateKey, String newDDMTemplateKey) {
        this.updateDDMTemplateKey(groupId, classNameId, oldDDMTemplateKey, newDDMTemplateKey);
    }

    protected void addDocumentLibraryFileEntries(Element dynamicElementElement) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        for (Element dynamicContentElement : dynamicElementElement.elements("dynamic-content")) {
            JSONObject jsonObject;
            boolean tempFile;
            String value = dynamicContentElement.getText();
            if (Validator.isNull((String)value) || !(tempFile = (jsonObject = JSONFactoryUtil.createJSONObject((String)value)).getBoolean("tempFile"))) continue;
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            FileEntry fileEntry = this.dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
            String fileEntryName = DLUtil.getUniqueFileName((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getFileName());
            this.dlAppLocalService.addFileEntry(fileEntry.getUserId(), fileEntry.getGroupId(), 0L, fileEntryName, fileEntry.getMimeType(), fileEntryName, "", "", fileEntry.getContentStream(), fileEntry.getSize(), new ServiceContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImageFileEntries(JournalArticle article, Element dynamicElementElement) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        HashSet<Long> tempFileEntryIds = new HashSet<Long>();
        try {
            for (Element dynamicContentElement : dynamicElementElement.elements("dynamic-content")) {
                long groupId;
                String value = dynamicContentElement.getText();
                if (Validator.isNull((String)value)) continue;
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)value);
                String uuid = jsonObject.getString("uuid");
                FileEntry fileEntry = this.dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId = jsonObject.getLong("groupId"));
                boolean tempFile = fileEntry.isRepositoryCapabilityProvided(TemporaryFileEntriesCapability.class);
                if (tempFile) {
                    FileEntry tempFileEntry = fileEntry;
                    Folder folder = article.addImagesFolder();
                    String fileEntryName = DLUtil.getUniqueFileName((long)folder.getGroupId(), (long)folder.getFolderId(), (String)fileEntry.getFileName());
                    fileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)folder.getGroupId(), (long)fileEntry.getUserId(), (String)JournalArticle.class.getName(), (long)article.getResourcePrimKey(), (String)"com.liferay.journal", (long)folder.getFolderId(), (InputStream)fileEntry.getContentStream(), (String)fileEntryName, (String)fileEntry.getMimeType(), (boolean)false);
                    tempFileEntryIds.add(tempFileEntry.getFileEntryId());
                }
                JSONObject cdataJSONObject = JSONFactoryUtil.createJSONObject((String)dynamicContentElement.getText());
                cdataJSONObject.put("fileEntryId", fileEntry.getFileEntryId()).put("resourcePrimKey", article.getResourcePrimKey()).put("uuid", fileEntry.getUuid());
                dynamicContentElement.clearContent();
                dynamicContentElement.addCDATA(cdataJSONObject.toString());
            }
        }
        finally {
            for (Long tempFileEntryId : tempFileEntryIds) {
                TempFileEntryUtil.deleteTempFileEntry((long)tempFileEntryId);
            }
        }
    }

    protected String buildArticleURL(String articleURL, long groupId, long folderId, String articleId) {
        String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        String namespace = this._portal.getPortletNamespace(portletId);
        articleURL = this._http.addParameter(articleURL, namespace + "groupId", groupId);
        articleURL = this._http.addParameter(articleURL, namespace + "folderId", folderId);
        articleURL = this._http.addParameter(articleURL, namespace + "articleId", articleId);
        return articleURL;
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, int status, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andSearch);
        HashMap attributes = HashMapBuilder.put((Object)"articleId", (Object)articleId).put((Object)"classNameId", (Object)classNameId).put((Object)"content", (Object)content).put((Object)"description", (Object)description).put((Object)"status", (Object)status).put((Object)"title", (Object)title).put((Object)"ddmStructureKey", (Object)ddmStructureKey).put((Object)"ddmTemplateKey", (Object)ddmTemplateKey).put((Object)"params", params).build();
        searchContext.setAttributes((Map)attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setFolderIds(folderIds);
        searchContext.setGroupIds(new long[]{groupId});
        if (params != null) {
            searchContext.setIncludeDiscussions(GetterUtil.getBoolean((Object)params.get("includeDiscussions")));
            String keywords = (String)params.remove("keywords");
            if (Validator.isNotNull((String)keywords)) {
                searchContext.setKeywords(keywords);
            }
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    protected SearchContext buildSearchContext(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        searchContext.setAttribute("paginationType", (Serializable)((Object)"none"));
        if (creatorUserId > 0L) {
            searchContext.setAttribute("userId", (Serializable)((Object)String.valueOf(creatorUserId)));
        }
        Group group = this.groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setSorts(new Sort[]{new Sort("modified", true)});
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return searchContext;
    }

    protected void checkArticlesByCompanyIdAndExpirationDate(long companyId, Date expirationDate, Date nextExpirationDate) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.getIndexableActionableDynamicQuery();
        Indexer indexer = IndexerRegistryUtil.getIndexer(JournalArticle.class);
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            dynamicQuery.add(classNameIdProperty.eq((Object)0L));
            Property expirationDateProperty = PropertyFactoryUtil.forName((String)"expirationDate");
            dynamicQuery.add(expirationDateProperty.le((Object)nextExpirationDate));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.eq((Object)0));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(article -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Expiring article " + article.getId()));
            }
            if (this.isExpireAllArticleVersions(companyId)) {
                List currentArticles = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId(), -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
                for (JournalArticle currentArticle : currentArticles) {
                    if (currentArticle.getExpirationDate() == null || currentArticle.getVersion() > article.getVersion()) continue;
                    currentArticle.setExpirationDate(article.getExpirationDate());
                    currentArticle.setStatus(3);
                    this.journalArticlePersistence.update((BaseModel)currentArticle);
                }
            }
            article.setStatus(3);
            this.journalArticlePersistence.update((BaseModel)article);
            this.updatePreviousApprovedArticle((JournalArticle)article);
            if (indexer != null) {
                indexableActionableDynamicQuery.addDocuments(new Document[]{indexer.getDocument(article)});
            }
        });
        if (indexer != null) {
            indexableActionableDynamicQuery.setSearchEngineId(indexer.getSearchEngineId());
        }
        indexableActionableDynamicQuery.setTransactionConfig(DefaultActionableDynamicQuery.REQUIRES_NEW_TRANSACTION_CONFIG);
        indexableActionableDynamicQuery.performActions();
    }

    protected void checkArticlesByDisplayDate(Date displayDate) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Publishing articles with display date less than ", displayDate, " and status ", 7}));
        }
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property displayDateProperty = PropertyFactoryUtil.forName((String)"displayDate");
            dynamicQuery.add(displayDateProperty.lt((Object)displayDate));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.eq((Object)7));
        });
        actionableDynamicQuery.setPerformActionMethod(article -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Publishing article " + article.getId()));
            }
            long userId = this._portal.getValidUserId(article.getCompanyId(), article.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
            String layoutFullURL = this._portal.getLayoutFullURL(article.getGroupId(), portletId);
            serviceContext.setLayoutFullURL(layoutFullURL);
            serviceContext.setScopeGroupId(article.getGroupId());
            this.journalArticleLocalService.updateStatus(userId, article, 0, null, serviceContext, new HashMap());
        });
        actionableDynamicQuery.setTransactionConfig(DefaultActionableDynamicQuery.REQUIRES_NEW_TRANSACTION_CONFIG);
        actionableDynamicQuery.performActions();
    }

    protected void checkArticlesByExpirationDate(Date expirationDate) throws PortalException {
        long checkInterval = this.getArticleCheckInterval();
        Date nextExpirationDate = new Date(expirationDate.getTime() + checkInterval);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Expiring articles with expiration date less than or ", "equal to ", nextExpirationDate, " and status ", 0}));
        }
        for (Company company : this.companyLocalService.getCompanies(false)) {
            this.checkArticlesByCompanyIdAndExpirationDate(company.getCompanyId(), expirationDate, nextExpirationDate);
        }
        if (this._previousCheckDate == null) {
            this._previousCheckDate = new Date(expirationDate.getTime() - this.getArticleCheckInterval());
        }
    }

    protected void checkArticlesByReviewDate(Date reviewDate) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Sending review notification for articles with reviewDate ", "between ", this._previousCheckDate, " and ", reviewDate}));
        }
        HashSet<Long> latestArticleIds = new HashSet<Long>();
        List articles = this.journalArticleFinder.findByReviewDate(0L, reviewDate, this._previousCheckDate);
        for (JournalArticle article : articles) {
            String articleId;
            if (article.isInTrash()) continue;
            long groupId = article.getGroupId();
            if (!this.journalArticleLocalService.isLatestVersion(groupId, articleId = article.getArticleId(), article.getVersion())) {
                article = this.journalArticleLocalService.getLatestArticle(groupId, articleId);
            }
            if (!latestArticleIds.add(article.getPrimaryKey())) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Sending review notification for article " + article.getId()));
            }
            String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
            String articleURL = this._portal.getControlPanelFullURL(article.getGroupId(), portletId, null);
            articleURL = this.buildArticleURL(articleURL, article.getGroupId(), article.getFolderId(), article.getArticleId());
            this.sendEmail(article, articleURL, "review", new ServiceContext());
        }
    }

    protected void checkStructure(com.liferay.portal.kernel.xml.Document contentDocument, DDMForm ddmForm) throws PortalException {
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            this.checkStructureField(ddmFormField, contentDocument.getRootElement());
        }
    }

    protected void checkStructure(JournalArticle article) throws PortalException {
        this.checkStructure(article, article.getDDMStructure());
    }

    protected void checkStructure(JournalArticle article, DDMStructure ddmStructure) throws PortalException {
        this.checkStructure(article.getDocument(), ddmStructure.getDDMForm());
    }

    protected void checkStructureField(DDMFormField ddmFormField, Element contentElement) throws PortalException {
        String contentElementType;
        String fieldName = ddmFormField.getName();
        boolean hasField = false;
        for (Element childElement : contentElement.elements()) {
            if (!fieldName.equals(childElement.attributeValue("name", ""))) continue;
            hasField = true;
            for (DDMFormField childDDMFormField : ddmFormField.getNestedDDMFormFields()) {
                this.checkStructureField(childDDMFormField, childElement);
            }
        }
        if (!(hasField || (contentElementType = contentElement.attributeValue("type", "")).equals("list") || contentElementType.equals("multi-list"))) {
            throw new StructureDefinitionException(fieldName);
        }
    }

    protected void copyArticleImages(JournalArticle oldArticle, JournalArticle newArticle) throws Exception {
        Folder folder = newArticle.addImagesFolder();
        for (FileEntry fileEntry : oldArticle.getImagesFileEntries()) {
            PortletFileRepositoryUtil.addPortletFileEntry((long)oldArticle.getGroupId(), (long)newArticle.getUserId(), (String)JournalArticle.class.getName(), (long)newArticle.getResourcePrimKey(), (String)"com.liferay.journal", (long)folder.getFolderId(), (InputStream)fileEntry.getContentStream(), (String)fileEntry.getFileName(), (String)fileEntry.getMimeType(), (boolean)false);
        }
        com.liferay.portal.kernel.xml.Document contentDocument = oldArticle.getDocument();
        contentDocument = contentDocument.clone();
        XPath xPathSelector = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='image']");
        List imageNodes = xPathSelector.selectNodes((Object)contentDocument);
        for (Node imageNode : imageNodes) {
            Element imageEl = (Element)imageNode;
            List dynamicContentEls = imageEl.elements("dynamic-content");
            for (Element dynamicContentEl : dynamicContentEls) {
                String fileName = dynamicContentEl.attributeValue("name");
                FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)newArticle.getGroupId(), (long)folder.getFolderId(), (String)fileName);
                String previewURL = this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, true);
                dynamicContentEl.addAttribute("resourcePrimKey", String.valueOf(newArticle.getResourcePrimKey()));
                dynamicContentEl.clearContent();
                dynamicContentEl.addCDATA(previewURL);
            }
        }
        newArticle.setContent(contentDocument.formattedString());
    }

    protected Map<String, LocalizedValue> createFieldsValuesMap(Element parentElement, Locale defaultLocale) {
        HashMap<String, LocalizedValue> fieldsValuesMap = new HashMap<String, LocalizedValue>();
        List dynamicElementElements = parentElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            String fieldName = dynamicElementElement.attributeValue("name", "");
            LocalizedValue fieldLocalizedValue = new LocalizedValue(defaultLocale);
            List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
            for (Element dynamicContentElement : dynamicContentElements) {
                String languageId = dynamicContentElement.attributeValue("language-id");
                String value = dynamicContentElement.getText();
                fieldLocalizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), value);
            }
            fieldsValuesMap.put(fieldName, fieldLocalizedValue);
            fieldsValuesMap.putAll(this.createFieldsValuesMap(dynamicElementElement, defaultLocale));
        }
        return fieldsValuesMap;
    }

    protected Map<String, LocalizedValue> createFieldsValuesMap(String content) {
        try {
            com.liferay.portal.kernel.xml.Document document = SAXReaderUtil.read((String)content);
            Element rootElement = document.getRootElement();
            Locale defaultLocale = LocaleUtil.fromLanguageId((String)rootElement.attributeValue("default-locale"));
            return this.createFieldsValuesMap(rootElement, defaultLocale);
        }
        catch (DocumentException documentException) {
            throw new SystemException((Throwable)documentException);
        }
    }

    protected JournalArticle fetchLatestLiveArticle(JournalArticle article) throws PortalException {
        Group group = this.groupLocalService.getGroup(article.getGroupId());
        long liveGroupId = group.getLiveGroupId();
        if (liveGroupId == 0L) {
            return null;
        }
        JournalArticleResource articleResource = this._journalArticleResourceLocalService.fetchJournalArticleResourceByUuidAndGroupId(article.getArticleResourceUuid(), liveGroupId);
        if (articleResource == null) {
            return null;
        }
        return this.journalArticleLocalService.fetchLatestArticle(articleResource.getResourcePrimKey(), -1, false);
    }

    protected void format(User user, long groupId, JournalArticle article, Element root) throws PortalException {
        for (Element element : root.elements()) {
            String elType = element.attributeValue("type", "");
            if (elType.equals("document_library")) {
                this.addDocumentLibraryFileEntries(element);
            } else if (elType.equals("image")) {
                this.addImageFileEntries(article, element);
            } else if (elType.equals("text_area") || elType.equals("text") || elType.equals("text_box")) {
                List dynamicContentElements = element.elements("dynamic-content");
                for (Element dynamicContentElement : dynamicContentElements) {
                    String dynamicContent = dynamicContentElement.getText();
                    if (!Validator.isNotNull((String)dynamicContent)) continue;
                    String contentType = "text/plain";
                    if (elType.equals("text_area")) {
                        contentType = "text/html";
                    }
                    dynamicContent = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)groupId, (long)user.getUserId(), (String)JournalArticle.class.getName(), (long)0L, (String)contentType, (String)dynamicContent);
                    dynamicContentElement.clearContent();
                    dynamicContentElement.addCDATA(dynamicContent);
                }
            }
            this.format(user, groupId, article, element);
        }
    }

    protected String format(User user, long groupId, JournalArticle article, String content) throws PortalException {
        com.liferay.portal.kernel.xml.Document document = null;
        try {
            document = SAXReaderUtil.read((String)content);
            this.format(user, groupId, article, document.getRootElement());
            content = XMLUtil.formatXML((com.liferay.portal.kernel.xml.Document)document);
        }
        catch (DocumentException documentException) {
            _log.error((Object)documentException, (Throwable)documentException);
        }
        return content;
    }

    protected long getArticleCheckInterval() {
        try {
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return (long)journalServiceConfiguration.checkInterval() * 60000L;
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    protected Locale getArticleDefaultLocale(String content) {
        String defaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)content);
        if (Validator.isNotNull((String)defaultLanguageId)) {
            return LocaleUtil.fromLanguageId((String)defaultLanguageId);
        }
        return LocaleUtil.getSiteDefault();
    }

    protected JournalArticleDisplay getArticleDisplay(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay, boolean propagateException) throws PortalException {
        String content = null;
        if (page < 1) {
            page = 1;
        }
        int numberOfPages = 1;
        boolean paginate = false;
        boolean pageFlow = false;
        boolean cacheable = true;
        Map<String, String> tokens = JournalUtil.getTokens(article.getGroupId(), portletRequestModel, themeDisplay);
        if (themeDisplay == null && portletRequestModel == null) {
            tokens.put("company_id", String.valueOf(article.getCompanyId()));
            Group companyGroup = this.groupLocalService.getCompanyGroup(article.getCompanyId());
            tokens.put("article_group_id", String.valueOf(article.getGroupId()));
            tokens.put("company_group_id", String.valueOf(companyGroup.getGroupId()));
            tokens.put("group_id", String.valueOf(article.getGroupId()));
        }
        tokens.put("class_name_id", String.valueOf(this.classNameLocalService.getClassNameId(DDMStructure.class)));
        tokens.put("article_resource_pk", String.valueOf(article.getResourcePrimKey()));
        DDMStructure ddmStructure = article.getDDMStructure();
        tokens.put("ddm_structure_key", String.valueOf(ddmStructure.getStructureKey()));
        tokens.put("ddm_structure_id", String.valueOf(ddmStructure.getStructureId()));
        tokens.put("structure_id", article.getDDMStructureKey());
        com.liferay.portal.kernel.xml.Document document = article.getDocument();
        document = document.clone();
        Element rootElement = document.getRootElement();
        List pages = rootElement.elements("page");
        if (!pages.isEmpty()) {
            String[] values;
            pageFlow = true;
            String targetPage = null;
            Map parameters = portletRequestModel.getParameters();
            if (parameters != null && (values = (String[])parameters.get("targetPage")) != null && values.length > 0) {
                targetPage = values[0];
            }
            Element pageElement = null;
            if (Validator.isNotNull(targetPage)) {
                targetPage = HtmlUtil.escapeXPathAttribute(targetPage);
                XPath xPathSelector = SAXReaderUtil.createXPath((String)("/root/page[@id = " + targetPage + "]"));
                pageElement = (Element)xPathSelector.selectSingleNode((Object)document);
            }
            if (pageElement != null) {
                document = SAXReaderUtil.createDocument(pageElement);
                rootElement = document.getRootElement();
                numberOfPages = pages.size();
            } else {
                if (page > pages.size()) {
                    page = 1;
                }
                pageElement = (Element)pages.get(page - 1);
                document = SAXReaderUtil.createDocument((Element)pageElement);
                rootElement = document.getRootElement();
                numberOfPages = pages.size();
                paginate = true;
            }
        }
        JournalUtil.addAllReservedEls(rootElement, tokens, article, languageId, themeDisplay);
        try {
            JournalServiceConfiguration journalServiceConfiguration;
            String[] pieces;
            Group companyGroup;
            DDMTemplate ddmTemplate;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Transforming ", article.getArticleId(), " ", article.getVersion(), " ", languageId}));
            }
            if ((ddmTemplate = this.ddmTemplateLocalService.fetchTemplate(this._portal.getSiteGroupId(article.getGroupId()), this.classNameLocalService.getClassNameId(DDMStructure.class), ddmTemplateKey, true)) == null && !Objects.equals(article.getDDMTemplateKey(), ddmTemplateKey)) {
                ddmTemplate = this.ddmTemplateLocalService.fetchTemplate(this._portal.getSiteGroupId(article.getGroupId()), this.classNameLocalService.getClassNameId(DDMStructure.class), article.getDDMTemplateKey(), true);
            }
            if (ddmTemplate != null && (companyGroup = this.groupLocalService.getCompanyGroup(article.getCompanyId())).getGroupId() == ddmTemplate.getGroupId()) {
                tokens.put("company_group_id", String.valueOf(companyGroup.getGroupId()));
            }
            String script = "";
            String langType = "";
            if (ddmTemplate != null) {
                tokens.put("ddm_template_key", String.valueOf(ddmTemplate.getTemplateKey()));
                tokens.put("ddm_template_id", String.valueOf(ddmTemplate.getTemplateId()));
                tokens.put("template_id", ddmTemplateKey);
                script = ddmTemplate.getScript();
                langType = ddmTemplate.getLanguage();
                cacheable = ddmTemplate.isCacheable();
            } else {
                script = this._journalDefaultTemplateProvider.getScript(ddmStructure.getStructureId());
                langType = this._journalDefaultTemplateProvider.getLanguage();
                cacheable = this._journalDefaultTemplateProvider.isCacheable();
            }
            content = JournalUtil.transform(themeDisplay, tokens, viewMode, languageId, document, portletRequestModel, script, langType, propagateException);
            if (!pageFlow && (pieces = StringUtil.split((String)content, (String)(journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, article.getCompanyId())).journalArticlePageBreakToken())).length > 1) {
                if (page > pieces.length) {
                    page = 1;
                }
                content = pieces[page - 1];
                numberOfPages = pieces.length;
                paginate = true;
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        return new JournalArticleDisplayImpl(article.getCompanyId(), article.getId(), article.getResourcePrimKey(), article.getGroupId(), article.getUserId(), article.getArticleId(), article.getVersion(), article.getTitle(languageId), article.getUrlTitle(), article.getDescription(languageId), article.getAvailableLanguageIds(), content, article.getDDMStructureKey(), ddmTemplateKey, article.isSmallImage(), article.getSmallImageId(), article.getSmallImageURL(), numberOfPages, page, paginate, cacheable);
    }

    protected List<ObjectValuePair<Long, Integer>> getArticleVersionStatuses(List<JournalArticle> articles) {
        ArrayList<ObjectValuePair<Long, Integer>> articleVersionStatusOVPs = new ArrayList<ObjectValuePair<Long, Integer>>(articles.size());
        for (JournalArticle article : articles) {
            int status = article.getStatus();
            if (status == 1) {
                status = 2;
            }
            ObjectValuePair articleVersionStatusOVP = new ObjectValuePair((Object)article.getId(), (Object)status);
            articleVersionStatusOVPs.add((ObjectValuePair<Long, Integer>)articleVersionStatusOVP);
        }
        return articleVersionStatusOVPs;
    }

    protected long getClassTypeId(JournalArticle article) {
        long classNameId = this.classNameLocalService.getClassNameId(JournalArticle.class);
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(this._portal.getSiteGroupId(article.getGroupId()), classNameId, article.getDDMStructureKey(), true);
        return ddmStructure.getStructureId();
    }

    protected JournalArticle getFirstArticle(long groupId, String articleId, int status, OrderByComparator<JournalArticle> orderByComparator) throws PortalException {
        if (status == -1) {
            return this.journalArticlePersistence.findByG_A_NotST_First(groupId, articleId, 8, orderByComparator);
        }
        return this.journalArticlePersistence.findByG_A_ST_First(groupId, articleId, status, orderByComparator);
    }

    protected JournalGroupServiceConfiguration getJournalGroupServiceConfiguration(long groupId) throws ConfigurationException {
        return (JournalGroupServiceConfiguration)this.configurationProvider.getConfiguration(JournalGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.journal"));
    }

    protected double getNextVersion(JournalArticle article) throws PortalException {
        double nextVersion = article.getVersion();
        JournalArticle latestLiveArticle = this.fetchLatestLiveArticle(article);
        if (latestLiveArticle != null && latestLiveArticle.getVersion() > nextVersion) {
            nextVersion = latestLiveArticle.getVersion();
        }
        return MathUtil.format((double)(nextVersion + 0.1), (int)1, (int)1);
    }

    protected String getUniqueUrlTitle(long id, long groupId, String articleId, String title) throws PortalException {
        String urlTitle = JournalUtil.getUrlTitle(id, title);
        return this.getUniqueUrlTitle(groupId, articleId, urlTitle);
    }

    protected String getUniqueUrlTitle(long id, long groupId, String articleId, String title, String oldUrlTitle, ServiceContext serviceContext) throws PortalException {
        String serviceContextUrlTitle = ParamUtil.getString((ServiceContext)serviceContext, (String)"urlTitle");
        String urlTitle = null;
        if (Validator.isNotNull((String)serviceContextUrlTitle)) {
            urlTitle = JournalUtil.getUrlTitle(id, serviceContextUrlTitle);
        } else {
            if (Validator.isNotNull((String)oldUrlTitle)) {
                return oldUrlTitle;
            }
            urlTitle = this.getUniqueUrlTitle(id, groupId, articleId, title);
        }
        JournalArticle urlTitleArticle = this.fetchArticleByUrlTitle(groupId, urlTitle);
        if (urlTitleArticle != null && !Objects.equals(urlTitleArticle.getArticleId(), articleId)) {
            urlTitle = this.getUniqueUrlTitle(id, groupId, articleId, urlTitle);
        }
        return urlTitle;
    }

    protected String getURLViewInContext(JournalArticle article, String portletId, ServiceContext serviceContext) {
        String defaultArticleURL = "";
        try {
            defaultArticleURL = this._portal.getControlPanelFullURL(article.getGroupId(), portletId, null);
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
        LiferayPortletRequest liferayPortletRequest = serviceContext.getLiferayPortletRequest();
        if (liferayPortletRequest == null) {
            return defaultArticleURL;
        }
        try {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer((Object)article, 1);
            return assetRenderer.getURLViewInContext(liferayPortletRequest, null, defaultArticleURL);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return "";
        }
    }

    protected boolean hasModifiedLatestApprovedVersion(long groupId, String articleId, double version) {
        JournalArticle article = this.fetchLatestArticle(groupId, articleId, 0);
        return article == null || article.getVersion() <= version;
    }

    protected boolean isArticleCommentsEnabled(long companyId) throws PortalException {
        JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, companyId);
        return journalServiceConfiguration.articleCommentsEnabled();
    }

    protected boolean isExpireAllArticleVersions(long companyId) throws PortalException {
        JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, companyId);
        return journalServiceConfiguration.expireAllArticleVersionsEnabled();
    }

    protected boolean isReindexAllArticleVersions() {
        try {
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this.configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return journalServiceConfiguration.indexAllArticleVersionsEnabled();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return false;
        }
    }

    protected void notifySubscribers(long userId, JournalArticle article, String action, ServiceContext serviceContext) throws PortalException {
        JournalGroupServiceConfiguration journalGroupServiceConfiguration = this.getJournalGroupServiceConfiguration(article.getGroupId());
        if (!(action.equals("add") && journalGroupServiceConfiguration.emailArticleAddedEnabled() || action.equals("move_to") && journalGroupServiceConfiguration.emailArticleMovedToFolderEnabled() || action.equals("move_to_trash") && journalGroupServiceConfiguration.emailArticleMovedToTrashEnabled() || action.equals("move_from") && journalGroupServiceConfiguration.emailArticleMovedFromFolderEnabled() || action.equals("move_from_trash") && journalGroupServiceConfiguration.emailArticleMovedToTrashEnabled() || action.equals("update") && journalGroupServiceConfiguration.emailArticleUpdatedEnabled())) {
            return;
        }
        GroupSubscriptionCheckSubscriptionSender subscriptionSender = new GroupSubscriptionCheckSubscriptionSender("com.liferay.journal");
        subscriptionSender.setClassName(article.getModelClassName());
        subscriptionSender.setClassPK(article.getId());
        subscriptionSender.setCompanyId(article.getCompanyId());
        JournalFolder folder = this.journalFolderPersistence.fetchByPrimaryKey(article.getFolderId());
        subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), article.getGroupId());
        subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), article.getGroupId());
        if (folder != null) {
            subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), folder.getFolderId());
            for (Long ancestorFolderId : folder.getAncestorFolderIds()) {
                subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), ancestorFolderId.longValue());
            }
        }
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(this._portal.getSiteGroupId(article.getGroupId()), this.classNameLocalService.getClassNameId(JournalArticle.class), article.getDDMStructureKey(), true);
        subscriptionSender.addPersistedSubscribers(DDMStructure.class.getName(), ddmStructure.getStructureId());
        subscriptionSender.addPersistedSubscribers(JournalArticle.class.getName(), article.getResourcePrimKey());
        if (!subscriptionSender.hasSubscribers()) {
            return;
        }
        String articleTitle = article.getTitle(serviceContext.getLanguageId());
        String fromName = journalGroupServiceConfiguration.emailFromName();
        String fromAddress = journalGroupServiceConfiguration.emailFromAddress();
        Map localizedSubjectMap = null;
        Map localizedBodyMap = null;
        int notificationType = 0;
        if (action.equals("add")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleAddedSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleAddedBody());
        } else if (action.equals("move_to")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleMovedToFolderSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleMovedToFolderBody());
            notificationType = 3;
        } else if (action.equals("move_to_trash")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleMovedToTrashSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleMovedToTrashBody());
            notificationType = 5;
        } else if (action.equals("move_from")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleMovedFromFolderSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleMovedFromFolderBody());
            notificationType = 2;
        } else if (action.equals("move_from_trash")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleMovedFromTrashSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleMovedFromTrashBody());
            notificationType = 4;
        } else if (action.equals("update")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleUpdatedSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleUpdatedBody());
            notificationType = 1;
        }
        String articleContent = "";
        String articleDiffs = "";
        JournalArticle previousApprovedArticle = this.getPreviousApprovedArticle(article);
        try {
            PortletRequestModel portletRequestModel = null;
            if (!ExportImportThreadLocal.isImportInProcess()) {
                portletRequestModel = new PortletRequestModel((PortletRequest)serviceContext.getLiferayPortletRequest(), (PortletResponse)serviceContext.getLiferayPortletResponse());
            }
            JournalArticleDisplay articleDisplay = this.getArticleDisplay(article, article.getDDMTemplateKey(), "view", LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), 1, portletRequestModel, serviceContext.getThemeDisplay());
            articleContent = articleDisplay.getContent();
            articleDiffs = this._journalHelper.diffHtml(article.getGroupId(), article.getArticleId(), previousApprovedArticle.getVersion(), article.getVersion(), LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), portletRequestModel, serviceContext.getThemeDisplay());
        }
        catch (Exception portletRequestModel) {
            // empty catch block
        }
        subscriptionSender.setContextAttribute("[$ARTICLE_CONTENT$]", (Object)articleContent, false);
        subscriptionSender.setContextAttribute("[$ARTICLE_DIFFS$]", (Object)DiffHtmlUtil.replaceStyles((String)articleDiffs), false);
        String folderName = "";
        if (folder != null) {
            folderName = folder.getName();
            if (folder.getFolderId() == 0L && Validator.isNull((String)folderName)) {
                folderName = LanguageUtil.get((Locale)LocaleUtil.getSiteDefault(), (String)"home");
            }
        }
        String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        String articleURL = this.getURLViewInContext(article, portletId, serviceContext);
        String articleStatus = LanguageUtil.get((Locale)LocaleUtil.getSiteDefault(), (String)WorkflowConstants.getStatusLabel((int)article.getStatus()));
        subscriptionSender.setContextAttributes(new Object[]{"[$ARTICLE_ID$]", article.getArticleId(), "[$ARTICLE_TITLE$]", articleTitle, "[$ARTICLE_URL$]", articleURL, "[$ARTICLE_VERSION$]", article.getVersion(), "[$FOLDER_NAME$]", folderName, "[$ARTICLE_STATUS$]", articleStatus});
        subscriptionSender.setContextCreatorUserPrefix("ARTICLE");
        subscriptionSender.setCreatorUserId(article.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(articleTitle);
        subscriptionSender.setEntryURL(articleURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("journal_article", new Object[]{article.getId()});
        subscriptionSender.setNotificationType(notificationType);
        subscriptionSender.setPortletId(portletId);
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(article.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void sanitize(long companyId, long groupId, long userId, long classPK, Map<Locale, String> descriptionMap) throws PortalException {
        if (descriptionMap == null) {
            return;
        }
        for (Map.Entry<Locale, String> entry : descriptionMap.entrySet()) {
            String description = SanitizerUtil.sanitize((long)companyId, (long)groupId, (long)userId, (String)JournalArticle.class.getName(), (long)classPK, (String)"text/html", (String)entry.getValue());
            descriptionMap.put(entry.getKey(), description);
        }
    }

    protected void saveImages(boolean smallImage, long smallImageId, File smallImageFile, byte[] smallImageBytes) throws PortalException {
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                this.imageLocalService.updateImage(smallImageId, smallImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(smallImageId);
        }
    }

    protected BaseModelSearchResult<JournalArticle> searchJournalArticles(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, JournalUtil.SELECTED_FIELD_NAMES);
            List articles = this._journalHelper.getArticles(hits);
            if (articles == null) continue;
            return new BaseModelSearchResult(articles, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void sendEmail(JournalArticle article, String articleURL, String emailType, ServiceContext serviceContext) throws PortalException {
        JournalGroupServiceConfiguration journalGroupServiceConfiguration = this.getJournalGroupServiceConfiguration(article.getGroupId());
        if (!(emailType.equals("denied") && journalGroupServiceConfiguration.emailArticleApprovalDeniedEnabled() || emailType.equals("granted") && journalGroupServiceConfiguration.emailArticleApprovalGrantedEnabled() || emailType.equals("requested") && journalGroupServiceConfiguration.emailArticleApprovalRequestedEnabled() || emailType.equals("review") && journalGroupServiceConfiguration.emailArticleReviewEnabled())) {
            return;
        }
        Company company = this.companyLocalService.getCompany(article.getCompanyId());
        User user = this.userLocalService.getUser(article.getUserId());
        String fromName = journalGroupServiceConfiguration.emailFromName();
        String fromAddress = journalGroupServiceConfiguration.emailFromAddress();
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        if (emailType.equals("requested")) {
            String tempToName = fromName;
            String tempToAddress = fromAddress;
            fromName = toName;
            fromAddress = toAddress;
            toName = tempToName;
            toAddress = tempToAddress;
        }
        Map localizedSubjectMap = null;
        Map localizedBodyMap = null;
        if (emailType.equals("denied")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleApprovalDeniedSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleApprovalDeniedBody());
        } else if (emailType.equals("granted")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleApprovalGrantedSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleApprovalGrantedBody());
        } else if (emailType.equals("requested")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleApprovalRequestedSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleApprovalRequestedBody());
        } else if (emailType.equals("review")) {
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleReviewSubject());
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)journalGroupServiceConfiguration.emailArticleReviewBody());
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setClassName(JournalArticle.class.getName());
        subscriptionSender.setClassPK(article.getPrimaryKey());
        subscriptionSender.setCompanyId(company.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$ARTICLE_ID$]", article.getArticleId(), "[$ARTICLE_TITLE$]", article.getTitle(serviceContext.getLanguageId()), "[$ARTICLE_URL$]", articleURL, "[$ARTICLE_USER_NAME$]", article.getUserName(), "[$ARTICLE_VERSION$]", article.getVersion()});
        subscriptionSender.setContextCreatorUserPrefix("ARTICLE");
        subscriptionSender.setCreatorUserId(article.getUserId());
        subscriptionSender.setEntryTitle(article.getTitle(user.getLocale()));
        subscriptionSender.setEntryURL(articleURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("journal_article", new Object[]{article.getId()});
        String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        subscriptionSender.setPortletId(portletId);
        subscriptionSender.setScopeGroupId(article.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    protected JournalArticle setArticlesExpirationDate(JournalArticle article) {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return article;
        }
        if (!article.isApproved() || article.getExpirationDate() == null) {
            return article;
        }
        List articles = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
        Date expirationDate = article.getExpirationDate();
        for (JournalArticle curArticle : articles) {
            curArticle.setExpirationDate(expirationDate);
            if (!article.equals(curArticle = this.journalArticleLocalService.updateJournalArticle(curArticle))) continue;
            article = curArticle;
        }
        return article;
    }

    protected void startWorkflowInstance(long userId, JournalArticle article, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)article.getCompanyId(), (long)article.getGroupId(), (long)userId, (String)JournalArticle.class.getName(), (long)article.getId(), (Object)article, (ServiceContext)serviceContext, workflowContext);
    }

    protected void updateDDMFormFieldPredefinedValue(DDMFormField ddmFormField, LocalizedValue ddmFormFieldValue) {
        DDMForm ddmForm = ddmFormField.getDDMForm();
        Set ddmFormAvailableLocales = ddmForm.getAvailableLocales();
        ddmFormField.setPredefinedValue(ddmFormFieldValue);
        ddmFormAvailableLocales.addAll(ddmFormFieldValue.getAvailableLocales());
        for (Locale locale : ddmFormAvailableLocales) {
            LocalizedValue tip;
            Map tipValues;
            LocalizedValue style;
            Map styleValues;
            LocalizedValue label = ddmFormField.getLabel();
            Map labelValues = label.getValues();
            if (!labelValues.containsKey(locale)) {
                label.addString(locale, label.getString(label.getDefaultLocale()));
            }
            if (!(styleValues = (style = ddmFormField.getStyle()).getValues()).containsKey(locale)) {
                style.addString(locale, style.getString(style.getDefaultLocale()));
            }
            if ((tipValues = (tip = ddmFormField.getTip()).getValues()).containsKey(locale)) continue;
            tip.addString(locale, tip.getString(tip.getDefaultLocale()));
        }
    }

    protected void updateDDMLinks(long id, long groupId, String ddmStructureKey, String ddmTemplateKey, boolean incrementVersion) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(this._portal.getSiteGroupId(groupId), this.classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.fetchTemplate(this._portal.getSiteGroupId(groupId), this.classNameLocalService.getClassNameId(DDMStructure.class), ddmTemplateKey, true);
        if (incrementVersion) {
            this.ddmStorageLinkLocalService.addStorageLink(ddmStructure.getClassNameId(), id, ddmStructure.getStructureId(), new ServiceContext());
            this.ddmStructureLinkLocalService.addStructureLink(this.classNameLocalService.getClassNameId(JournalArticle.class), id, ddmStructure.getStructureId());
            if (ddmTemplate != null) {
                this.ddmTemplateLinkLocalService.addTemplateLink(this.classNameLocalService.getClassNameId(JournalArticle.class), id, ddmTemplate.getTemplateId());
            }
        } else {
            DDMStorageLink ddmStorageLink = this.ddmStorageLinkLocalService.getClassStorageLink(id);
            ddmStorageLink.setStructureId(ddmStructure.getStructureId());
            this.ddmStorageLinkLocalService.updateDDMStorageLink(ddmStorageLink);
            int count = this.ddmStructureLinkLocalService.getStructureLinksCount(this.classNameLocalService.getClassNameId(JournalArticle.class), id);
            if (count == 0) {
                this.ddmStructureLinkLocalService.addStructureLink(this.classNameLocalService.getClassNameId(JournalArticle.class), id, ddmStructure.getStructureId());
            } else {
                DDMStructureLink ddmStructureLink = this.ddmStructureLinkLocalService.getUniqueStructureLink(this.classNameLocalService.getClassNameId(JournalArticle.class), id);
                ddmStructureLink.setStructureId(ddmStructure.getStructureId());
                this.ddmStructureLinkLocalService.updateDDMStructureLink(ddmStructureLink);
            }
            if (ddmTemplate != null) {
                this.ddmTemplateLinkLocalService.updateTemplateLink(this.classNameLocalService.getClassNameId(JournalArticle.class), id, ddmTemplate.getTemplateId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDDMStructurePredefinedValues(long ddmStructureId, String content, ServiceContext serviceContext) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchDDMStructure(ddmStructureId);
        if (ddmStructure == null) {
            return;
        }
        DDMForm ddmForm = ddmStructure.getDDMForm();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Map fullHierarchyDDMFormFieldsMap = ddmStructure.getFullHierarchyDDMFormFieldsMap(true);
        Map<String, LocalizedValue> fieldsValuesMap = this.createFieldsValuesMap(content);
        for (Map.Entry<String, LocalizedValue> fieldValue : fieldsValuesMap.entrySet()) {
            String ddmFormFieldName = fieldValue.getKey();
            LocalizedValue ddmFormFieldValue = fieldValue.getValue();
            if (fullHierarchyDDMFormFieldsMap.containsKey(ddmFormFieldName)) {
                this.updateDDMFormFieldPredefinedValue((DDMFormField)fullHierarchyDDMFormFieldsMap.get(ddmFormFieldName), ddmFormFieldValue);
            }
            if (!ddmFormFieldsMap.containsKey(ddmFormFieldName)) continue;
            this.updateDDMFormFieldPredefinedValue((DDMFormField)ddmFormFieldsMap.get(ddmFormFieldName), ddmFormFieldValue);
        }
        boolean indexingEnabled = serviceContext.isIndexingEnabled();
        try {
            serviceContext.setIndexingEnabled(false);
            this.ddmStructureLocalService.updateStructure(serviceContext.getUserId(), ddmStructureId, ddmForm, ddmStructure.getDDMFormLayout(), serviceContext);
        }
        finally {
            serviceContext.setIndexingEnabled(indexingEnabled);
        }
    }

    protected void updateFriendlyURLs(JournalArticle article, Map<String, String> urlTitleMap, ServiceContext serviceContext) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess() || ExportImportThreadLocal.isStagingInProcess()) {
            return;
        }
        List friendlyURLEntries = this.friendlyURLEntryLocalService.getFriendlyURLEntries(article.getGroupId(), this.classNameLocalService.getClassNameId(JournalArticle.class), article.getResourcePrimKey());
        FriendlyURLEntry newFriendlyURLEntry = this.friendlyURLEntryLocalService.addFriendlyURLEntry(article.getGroupId(), this.classNameLocalService.getClassNameId(JournalArticle.class), article.getResourcePrimKey(), urlTitleMap, serviceContext);
        for (FriendlyURLEntry friendlyURLEntry : friendlyURLEntries) {
            if (newFriendlyURLEntry.getFriendlyURLEntryId() == friendlyURLEntry.getFriendlyURLEntryId()) continue;
            this.friendlyURLEntryLocalService.deleteFriendlyURLEntry(friendlyURLEntry);
        }
    }

    protected void updatePreviousApprovedArticle(JournalArticle article) throws PortalException {
        JournalArticle previousApprovedArticle = this.getPreviousApprovedArticle(article);
        if (previousApprovedArticle.getVersion() == article.getVersion()) {
            this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
        } else {
            AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(JournalArticle.class.getName(), article.getResourcePrimKey(), previousApprovedArticle.getDisplayDate(), previousApprovedArticle.getExpirationDate(), this.isListable(article), true);
            assetEntry.setModifiedDate(previousApprovedArticle.getModifiedDate());
            assetEntry.setTitle(previousApprovedArticle.getTitleMapAsXML());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected void updateUrlTitles(long groupId, String articleId, String urlTitle) throws PortalException {
        JournalArticle firstArticle = this.journalArticlePersistence.findByG_A_First(groupId, articleId, (OrderByComparator)new ArticleVersionComparator(false));
        String firstArticleUrlTitle = firstArticle.getUrlTitle();
        if (firstArticleUrlTitle.equals(urlTitle)) {
            return;
        }
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId);
        for (JournalArticle article : articles) {
            String curArticleUrlTitle = article.getUrlTitle();
            if (curArticleUrlTitle.equals(urlTitle)) continue;
            article.setUrlTitle(urlTitle);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    protected void validate(long companyId, long groupId, long classNameId, Map<Locale, String> titleMap, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDate, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, ServiceContext serviceContext) throws PortalException {
        this._getModelValidator().validate(companyId, groupId, classNameId, titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
    }

    protected void validate(long companyId, long groupId, long classNameId, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, String content, String ddmStructureKey, String ddmTemplateKey, Date displayDate, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, ServiceContext serviceContext) throws PortalException {
        this._getModelValidator().validate(companyId, groupId, classNameId, articleId, autoArticleId, version, titleMap, content, ddmStructureKey, ddmTemplateKey, displayDate, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
    }

    protected void validate(String articleId) throws PortalException {
        this._getModelValidator().validate(articleId);
    }

    protected void validateContent(String content) throws PortalException {
        this._getModelValidator().validateContent(content);
    }

    protected void validateDDMStructureId(long groupId, long folderId, String ddmStructureKey) throws PortalException {
        this._getModelValidator().validateDDMStructureId(groupId, folderId, ddmStructureKey);
    }

    protected void validateReferences(long groupId, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, boolean smallImage, String smallImageURL, byte[] smallImageBytes, long smallImageId, String content) throws PortalException {
        this._getModelValidator().validateReferences(groupId, ddmStructureKey, ddmTemplateKey, layoutUuid, smallImage, smallImageURL, smallImageBytes, smallImageId, content);
    }

    private FileEntry _addArticleAttachmentFileEntry(JournalArticle article, long folderId, FileEntry fileEntry) throws PortalException {
        String fileEntryName = DLUtil.getUniqueFileName((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getFileName());
        return PortletFileRepositoryUtil.addPortletFileEntry((long)article.getGroupId(), (long)fileEntry.getUserId(), (String)JournalArticle.class.getName(), (long)article.getResourcePrimKey(), (String)"com.liferay.journal", (long)folderId, (InputStream)fileEntry.getContentStream(), (String)fileEntryName, (String)fileEntry.getMimeType(), (boolean)false);
    }

    private List<JournalArticleLocalization> _addArticleLocalizedFields(long companyId, long articlePK, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap) {
        HashSet<Locale> localeSet = new HashSet<Locale>();
        localeSet.addAll(titleMap.keySet());
        if (descriptionMap != null) {
            localeSet.addAll(descriptionMap.keySet());
        }
        ArrayList<JournalArticleLocalization> journalArticleLocalizations = new ArrayList<JournalArticleLocalization>();
        for (Locale locale : localeSet) {
            String title = titleMap.get(locale);
            String description = null;
            if (descriptionMap != null) {
                description = descriptionMap.get(locale);
            }
            if (Validator.isNull((String)title) && Validator.isNull((String)description)) continue;
            JournalArticleLocalization journalArticleLocalization = this._addArticleLocalizedFields(companyId, articlePK, title, description, LocaleUtil.toLanguageId((Locale)locale));
            journalArticleLocalizations.add(journalArticleLocalization);
        }
        return journalArticleLocalizations;
    }

    private JournalArticleLocalization _addArticleLocalizedFields(long companyId, long articlePK, String title, String description, String languageId) {
        JournalArticleLocalization journalArticleLocalization = this.journalArticleLocalizationPersistence.fetchByA_L(articlePK, languageId);
        if (journalArticleLocalization == null) {
            long journalArticleLocalizationId = this.counterLocalService.increment();
            journalArticleLocalization = this.journalArticleLocalizationPersistence.create(journalArticleLocalizationId);
            journalArticleLocalization.setCompanyId(companyId);
            journalArticleLocalization.setArticlePK(articlePK);
            journalArticleLocalization.setTitle(title);
            journalArticleLocalization.setDescription(description);
            journalArticleLocalization.setLanguageId(languageId);
        } else {
            journalArticleLocalization.setTitle(title);
            journalArticleLocalization.setDescription(description);
        }
        return (JournalArticleLocalization)this.journalArticleLocalizationPersistence.update((BaseModel)journalArticleLocalization);
    }

    private Map<Locale, String> _checkFriendlyURLMap(Locale defaultLocale, Map<Locale, String> friendlyURLMap, Map<Locale, String> titleMap) {
        for (Map.Entry<Locale, String> friendlyURL : friendlyURLMap.entrySet()) {
            if (!Validator.isNotNull((String)friendlyURL.getValue())) continue;
            return friendlyURLMap;
        }
        return HashMapBuilder.put((Object)defaultLocale, (Object)titleMap.get(defaultLocale)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deleteDDMStructurePredefinedValues(long groupId, String ddmStructureKey) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(groupId, this.classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        if (ddmStructure == null) {
            return;
        }
        DDMForm ddmForm = ddmStructure.getDDMForm();
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            ddmFormField.setPredefinedValue(new LocalizedValue());
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        boolean indexingEnabled = serviceContext.isIndexingEnabled();
        try {
            serviceContext.setIndexingEnabled(false);
            this.ddmStructureLocalService.updateStructure(serviceContext.getUserId(), ddmStructure.getStructureId(), ddmForm, ddmStructure.getDDMFormLayout(), serviceContext);
        }
        finally {
            serviceContext.setIndexingEnabled(indexingEnabled);
        }
    }

    private JournalArticleModelValidator _getModelValidator() {
        ModelValidator modelValidator = ModelValidatorRegistryUtil.getModelValidator(JournalArticle.class);
        return (JournalArticleModelValidator)modelValidator;
    }

    private int _getUniqueUrlTitleCount(long groupId, String articleId, String urlTitle) {
        int i = 1;
        JournalArticle article;
        while ((article = this.fetchArticleByUrlTitle(groupId, urlTitle)) != null && !Objects.equals(articleId, article.getArticleId())) {
            String suffix = "-" + i;
            String prefix = urlTitle;
            if (urlTitle.length() > suffix.length()) {
                prefix = urlTitle.substring(0, urlTitle.length() - suffix.length());
            }
            urlTitle = prefix + suffix;
            ++i;
        }
        return i - 1;
    }

    private Map<String, String> _getURLTitleMap(long groupId, long resourcePrimKey, Map<Locale, String> friendlyURLMap, Map<Locale, String> titleMap) {
        HashMap<String, String> urlTitleMap = new HashMap<String, String>();
        for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
            String friendlyURL = friendlyURLMap.get(entry.getKey());
            if (Validator.isNull((String)friendlyURL) && Validator.isNull((String)(friendlyURL = titleMap.get(entry.getKey())))) continue;
            String urlTitle = this.friendlyURLEntryLocalService.getUniqueUrlTitle(groupId, this.classNameLocalService.getClassNameId(JournalArticle.class), resourcePrimKey, friendlyURL);
            urlTitleMap.put(LocaleUtil.toLanguageId((Locale)entry.getKey()), urlTitle);
        }
        return urlTitleMap;
    }

    private String _replaceTempImages(JournalArticle article, String content) throws PortalException {
        Folder folder = article.addImagesFolder();
        return this._attachmentContentUpdater.updateContent(content, "text/html", fileEntry -> this._addArticleAttachmentFileEntry(article, folder.getFolderId(), (FileEntry)fileEntry));
    }

    private List<JournalArticleLocalization> _updateArticleLocalizedFields(long companyId, long articleId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap) {
        ArrayList oldJournalArticleLocalizations = new ArrayList(this.journalArticleLocalizationPersistence.findByArticlePK(articleId));
        List<JournalArticleLocalization> newJournalArticleLocalizations = this._addArticleLocalizedFields(companyId, articleId, titleMap, descriptionMap);
        oldJournalArticleLocalizations.removeAll(newJournalArticleLocalizations);
        for (JournalArticleLocalization oldJournalArticleLocalization : oldJournalArticleLocalizations) {
            this.journalArticleLocalizationPersistence.remove((BaseModel)oldJournalArticleLocalization);
        }
        return newJournalArticleLocalizations;
    }

    private JournalArticleLocalization _updateArticleLocalizedFields(long companyId, long articleId, String title, String description, String languageId) {
        JournalArticleLocalization journalArticleLocalization = this.journalArticleLocalizationPersistence.fetchByA_L(articleId, languageId);
        if (journalArticleLocalization == null) {
            return this._addArticleLocalizedFields(companyId, articleId, title, description, languageId);
        }
        journalArticleLocalization.setTitle(title);
        journalArticleLocalization.setDescription(description);
        return (JournalArticleLocalization)this.journalArticleLocalizationPersistence.update((BaseModel)journalArticleLocalization);
    }
}

