/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.impl;

import com.liferay.journal.model.JournalFeed;
import com.liferay.journal.service.base.JournalFeedServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=journal", "json.web.service.context.path=JournalFeed"}, service={AopService.class})
public class JournalFeedServiceImpl
extends JournalFeedServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalFeed)")
    private ModelResourcePermission<JournalFeed> _journalFeedModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.journal)")
    private PortletResourcePermission _portletResourcePermission;

    public JournalFeed addFeed(long groupId, String feedId, boolean autoFeedId, String name, String description, String ddmStructureKey, String ddmTemplateKey, String ddmRendererTemplateKey, int delta, String orderByCol, String orderByType, String targetLayoutFriendlyUrl, String targetPortletId, String contentField, String feedType, double feedVersion, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_FEED");
        return this.journalFeedLocalService.addFeed(this.getUserId(), groupId, feedId, autoFeedId, name, description, ddmStructureKey, ddmTemplateKey, ddmRendererTemplateKey, delta, orderByCol, orderByType, targetLayoutFriendlyUrl, targetPortletId, contentField, feedType, feedVersion, serviceContext);
    }

    public void deleteFeed(long feedId) throws PortalException {
        this._journalFeedModelResourcePermission.check(this.getPermissionChecker(), feedId, "DELETE");
        this.journalFeedLocalService.deleteFeed(feedId);
    }

    public void deleteFeed(long groupId, String feedId) throws PortalException {
        JournalFeed feed = this.journalFeedPersistence.findByG_F(groupId, feedId);
        this._journalFeedModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)feed, "DELETE");
        this.journalFeedLocalService.deleteFeed(feed);
    }

    public JournalFeed getFeed(long feedId) throws PortalException {
        JournalFeed feed = this.journalFeedLocalService.getFeed(feedId);
        this._journalFeedModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)feed, "VIEW");
        return feed;
    }

    public JournalFeed getFeed(long groupId, String feedId) throws PortalException {
        JournalFeed feed = this.journalFeedPersistence.findByG_F(groupId, feedId);
        this._journalFeedModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)feed, "VIEW");
        return feed;
    }

    public JournalFeed updateFeed(long groupId, String feedId, String name, String description, String ddmStructureKey, String ddmTemplateKey, String ddmRendererTemplateKey, int delta, String orderByCol, String orderByType, String targetLayoutFriendlyUrl, String targetPortletId, String contentField, String feedType, double feedVersion, ServiceContext serviceContext) throws PortalException {
        JournalFeed feed = this.journalFeedPersistence.findByG_F(groupId, feedId);
        this._journalFeedModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)feed, "UPDATE");
        return this.journalFeedLocalService.updateFeed(groupId, feedId, name, description, ddmStructureKey, ddmTemplateKey, ddmRendererTemplateKey, delta, orderByCol, orderByType, targetLayoutFriendlyUrl, targetPortletId, contentField, feedType, feedVersion, serviceContext);
    }
}

