/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.search;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.internal.util.JournalUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.journal.util.JournalContent;
import com.liferay.journal.util.JournalConverter;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.highlight.HighlightUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.batch.BatchIndexingHelper;
import com.liferay.portal.search.filter.DateRangeFilterBuilder;
import com.liferay.portal.search.filter.FilterBuilders;
import com.liferay.portal.search.index.IndexStatusManager;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import com.liferay.trash.TrashHelper;
import java.io.Serializable;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class JournalArticleIndexer
extends BaseIndexer<JournalArticle> {
    public static final String CLASS_NAME = JournalArticle.class.getName();
    private static final String[] _ESCAPE_SAFE_HIGHLIGHTS = new String[]{"[@HIGHLIGHT1@]", "[@HIGHLIGHT2@]"};
    private static final String[] _HIGHLIGHT_TAGS = new String[]{"<liferay-hl>", "</liferay-hl>"};
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleIndexer.class);
    @Reference
    private BatchIndexingHelper _batchIndexingHelper;
    private ConfigurationProvider _configurationProvider;
    private DDMIndexer _ddmIndexer;
    private DDMStructureLocalService _ddmStructureLocalService;
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private FilterBuilders _filterBuilders;
    @Reference
    private Html _html;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private IndexStatusManager _indexStatusManager;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalArticle)")
    private ModelResourcePermission<JournalArticle> _journalArticleModelResourcePermission;
    private JournalArticleResourceLocalService _journalArticleResourceLocalService;
    private JournalContent _journalContent;
    private JournalConverter _journalConverter;
    private Localization _localization;
    @Reference
    private Portal _portal;
    @Reference
    private SearchLocalizationHelper _searchLocalizationHelper;
    @Reference
    private TrashHelper _trashHelper;

    public JournalArticleIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetTagNames", "articleId", "companyId", "defaultLanguageId", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "version", "uid"});
        this.setDefaultSelectedLocalizedFieldNames(new String[]{"content", "description", "title"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
        this.setSelectAllLocales(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._journalArticleModelResourcePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        List articles = this._journalArticleLocalService.getArticlesByResourcePrimKey(classPK);
        for (JournalArticle article : articles) {
            if (!this.isVisible(article.getStatus(), status)) continue;
            return true;
        }
        return false;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        String ddmTemplateKey;
        String ddmStructureKey;
        Long classNameId = (Long)searchContext.getAttribute("classNameId");
        if (classNameId != null && classNameId != 0L) {
            contextBooleanFilter.addRequiredTerm("classNameId", classNameId.toString());
        }
        this.addStatus(contextBooleanFilter, searchContext);
        this.addSearchClassTypeIds(contextBooleanFilter, searchContext);
        String ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
        Serializable ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
        if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
            QueryFilter queryFilter = this._ddmIndexer.createFieldValueQueryFilter(ddmStructureFieldName, ddmStructureFieldValue, searchContext.getLocale());
            contextBooleanFilter.add((Filter)queryFilter, BooleanClauseOccur.MUST);
        }
        if (Validator.isNotNull((String)(ddmStructureKey = (String)((Object)searchContext.getAttribute("ddmStructureKey"))))) {
            contextBooleanFilter.addRequiredTerm("ddmStructureKey", ddmStructureKey);
        }
        if (Validator.isNotNull((String)(ddmTemplateKey = (String)((Object)searchContext.getAttribute("ddmTemplateKey"))))) {
            contextBooleanFilter.addRequiredTerm("ddmTemplateKey", ddmTemplateKey);
        }
        boolean head = GetterUtil.getBoolean((Object)searchContext.getAttribute("head"), (boolean)Boolean.TRUE);
        boolean latest = GetterUtil.getBoolean((Object)searchContext.getAttribute("latest"));
        boolean relatedClassName = GetterUtil.getBoolean((Object)searchContext.getAttribute("relatedClassName"));
        boolean showNonindexable = GetterUtil.getBoolean((Object)searchContext.getAttribute("showNonindexable"));
        if (latest && !relatedClassName && !showNonindexable) {
            contextBooleanFilter.addRequiredTerm("latest", Boolean.TRUE);
        } else if (head && !relatedClassName && !showNonindexable) {
            contextBooleanFilter.addRequiredTerm("head", Boolean.TRUE);
        }
        if (latest && !relatedClassName && showNonindexable) {
            contextBooleanFilter.addRequiredTerm("latest", Boolean.TRUE);
        } else if (!relatedClassName && showNonindexable) {
            contextBooleanFilter.addRequiredTerm("headListable", Boolean.TRUE);
        }
        boolean filterExpired = GetterUtil.getBoolean((Object)searchContext.getAttribute("filterExpired"));
        if (!filterExpired) {
            return;
        }
        DateRangeFilterBuilder dateRangeFilterBuilder = this._filterBuilders.dateRangeFilterBuilder();
        dateRangeFilterBuilder.setFieldName("expirationDate");
        String formatPattern = PropsUtil.get((String)"index.date.format.pattern");
        dateRangeFilterBuilder.setFormat(formatPattern);
        Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)formatPattern);
        dateRangeFilterBuilder.setFrom(dateFormat.format(new Date()));
        dateRangeFilterBuilder.setIncludeLower(false);
        dateRangeFilterBuilder.setIncludeUpper(false);
        contextBooleanFilter.add((Filter)dateRangeFilterBuilder.build());
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "articleId", false);
        this.addSearchTerm(searchQuery, searchContext, "classPK", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "content", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "title", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        String[] localizedFieldNames = this._searchLocalizationHelper.getLocalizedFieldNames(new String[]{"content", "description", "title"}, searchContext);
        queryConfig.addHighlightFieldNames(localizedFieldNames);
    }

    protected void addDDMStructureAttributes(Document document, JournalArticle article) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(this._portal.getSiteGroupId(article.getGroupId()), this._portal.getClassNameId(JournalArticle.class), article.getDDMStructureKey(), true);
        if (ddmStructure == null) {
            return;
        }
        document.addKeyword("classTypeId", ddmStructure.getStructureId());
        DDMFormValues ddmFormValues = null;
        try {
            Fields fields = this._journalConverter.getDDMFields(ddmStructure, article.getDocument());
            ddmFormValues = this._fieldsToDDMFormValuesConverter.convert(ddmStructure, fields);
        }
        catch (Exception exception) {
            return;
        }
        if (ddmFormValues != null) {
            this._ddmIndexer.addAttributes(document, ddmStructure, ddmFormValues);
        }
    }

    protected Map<String, Query> addLocalizedFields(BooleanQuery searchQuery, String field, String value, boolean like, SearchContext searchContext) throws ParseException {
        String[] localizedFieldNames = this._searchLocalizationHelper.getLocalizedFieldNames(new String[]{field}, searchContext);
        HashMap<String, Query> queries = new HashMap<String, Query>();
        for (String localizedFieldName : localizedFieldNames) {
            Query query = searchQuery.addTerm(localizedFieldName, value, like);
            queries.put(field, query);
        }
        return queries;
    }

    protected void addLocalizedQuery(BooleanQuery searchQuery, BooleanQuery localizedQuery, SearchContext searchContext) throws ParseException {
        BooleanClauseOccur booleanClauseOccur = BooleanClauseOccur.SHOULD;
        if (searchContext.isAndSearch()) {
            booleanClauseOccur = BooleanClauseOccur.MUST;
        }
        searchQuery.add((Query)localizedQuery, booleanClauseOccur);
    }

    protected Map<String, Query> addSearchLocalizedTerm(BooleanQuery searchQuery, SearchContext searchContext, String field, boolean like) throws Exception {
        if (Validator.isBlank((String)field)) {
            return Collections.emptyMap();
        }
        String value = GetterUtil.getString((Object)searchContext.getAttribute(field));
        if (Validator.isBlank((String)value)) {
            value = searchContext.getKeywords();
        }
        if (Validator.isBlank((String)value)) {
            return Collections.emptyMap();
        }
        Map<String, Query> queries = null;
        if (Validator.isBlank((String)searchContext.getKeywords())) {
            BooleanQueryImpl localizedQuery = new BooleanQueryImpl();
            queries = this.addLocalizedFields((BooleanQuery)localizedQuery, field, value, like, searchContext);
            this.addLocalizedQuery(searchQuery, (BooleanQuery)localizedQuery, searchContext);
        } else {
            queries = this.addLocalizedFields(searchQuery, field, value, like, searchContext);
        }
        return queries;
    }

    protected void doDelete(JournalArticle journalArticle) throws Exception {
        long classPK = journalArticle.getId();
        if (!this.isIndexAllArticleVersions()) {
            int count = this._journalArticleLocalService.getArticlesCount(journalArticle.getGroupId(), journalArticle.getArticleId());
            if (count > 0) {
                this.doReindex(journalArticle);
                return;
            }
            classPK = journalArticle.getResourcePrimKey();
        }
        this.deleteDocument(journalArticle.getCompanyId(), classPK);
        if (!journalArticle.isApproved()) {
            return;
        }
        JournalArticle latestIndexableArticle = this._journalArticleLocalService.fetchLatestIndexableArticle(journalArticle.getResourcePrimKey());
        if (latestIndexableArticle == null || latestIndexableArticle.getVersion() > journalArticle.getVersion()) {
            return;
        }
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), journalArticle.getCompanyId(), this.getDocument(latestIndexableArticle), this.isCommitImmediately());
    }

    protected Document doGetDocument(JournalArticle journalArticle) throws Exception {
        boolean visible;
        String[] titleAvailableLanguageIds;
        String[] descriptionAvailableLanguageIds;
        String[] contentAvailableLanguageIds;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing article " + journalArticle));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)journalArticle);
        long classPK = journalArticle.getId();
        if (!this.isIndexAllArticleVersions()) {
            classPK = journalArticle.getResourcePrimKey();
        }
        document.addUID(CLASS_NAME, classPK);
        String articleId = journalArticle.getArticleId();
        if (journalArticle.isInTrash()) {
            articleId = this._trashHelper.getOriginalTitle(articleId);
        }
        document.addKeywordSortable("articleId", articleId);
        Localization localization = this.getLocalization();
        for (String contentAvailableLanguageId : contentAvailableLanguageIds = localization.getAvailableLanguageIds(journalArticle.getDocument())) {
            String content = this.extractDDMContent(journalArticle, contentAvailableLanguageId);
            document.addText(localization.getLocalizedName("content", contentAvailableLanguageId), content);
        }
        for (String descriptionAvailableLanguageId : descriptionAvailableLanguageIds = localization.getAvailableLanguageIds(journalArticle.getDescriptionMapAsXML())) {
            String description = this._html.stripHtml(journalArticle.getDescription(descriptionAvailableLanguageId));
            document.addText(localization.getLocalizedName("description", descriptionAvailableLanguageId), description);
        }
        document.addDate("displayDate", journalArticle.getDisplayDate());
        document.addDate("expirationDate", journalArticle.getExpirationDate());
        document.addKeyword("folderId", journalArticle.getFolderId());
        document.addKeyword("layoutUuid", journalArticle.getLayoutUuid());
        for (String titleAvailableLanguageId : titleAvailableLanguageIds = localization.getAvailableLanguageIds(journalArticle.getTitleMapAsXML())) {
            String title = journalArticle.getTitle(titleAvailableLanguageId);
            document.addText(localization.getLocalizedName("title", titleAvailableLanguageId), title);
        }
        document.addKeyword("treePath", StringUtil.split((String)journalArticle.getTreePath(), (char)'/'));
        document.addKeyword("version", journalArticle.getVersion());
        document.addKeyword("ddmStructureKey", journalArticle.getDDMStructureKey());
        document.addKeyword("ddmTemplateKey", journalArticle.getDDMTemplateKey());
        String defaultLanguageId = localization.getDefaultLanguageId(journalArticle.getDocument());
        document.addText("defaultLanguageId", defaultLanguageId);
        document.addDate("displayDate", journalArticle.getDisplayDate());
        document.addKeyword("head", JournalUtil.isHead(journalArticle));
        boolean headListable = JournalUtil.isHeadListable(journalArticle);
        document.addKeyword("headListable", headListable);
        boolean latestArticle = JournalUtil.isLatestArticle(journalArticle);
        document.addKeyword("latest", latestArticle);
        if (journalArticle.isScheduled() && headListable && !(visible = GetterUtil.getBoolean((String)document.get("visible")))) {
            document.addKeyword("visible", true);
        }
        this.addDDMStructureAttributes(document, journalArticle);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + journalArticle + " indexed successfully"));
        }
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("display-date")) {
            return "displayDate";
        }
        if (orderByCol.equals("id")) {
            return "entryClassPK";
        }
        if (orderByCol.equals("modified-date")) {
            return "modified";
        }
        if (orderByCol.equals("title")) {
            return "title";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        String content;
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)document.get("defaultLanguageId"));
        Locale snippetLocale = this.getSnippetLocale(document, locale);
        String localizedTitleName = Field.getLocalizedName((Locale)locale, (String)"title");
        String title = document.get(snippetLocale = snippetLocale == null && document.getField(localizedTitleName) == null ? defaultLocale : locale, "snippet_title", "title");
        if (Validator.isBlank((String)title) && !snippetLocale.equals(defaultLocale)) {
            title = document.get(defaultLocale, "snippet_title", "title");
        }
        if (Validator.isBlank((String)(content = this.getDDMContentSummary(document, snippetLocale, portletRequest, portletResponse))) && !snippetLocale.equals(defaultLocale)) {
            content = this.getDDMContentSummary(document, defaultLocale, portletRequest, portletResponse);
        }
        Summary summary = new Summary(snippetLocale, title, content);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(JournalArticle article) throws Exception {
        if (this._portal.getClassNameId(DDMStructure.class) == article.getClassNameId()) {
            Document document = this.getDocument(article);
            this._indexWriterHelper.deleteDocument(this.getSearchEngineId(), article.getCompanyId(), document.get("uid"), this.isCommitImmediately());
            return;
        }
        this.reindexArticleVersions(article);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        JournalArticle article = this._journalArticleLocalService.fetchJournalArticle(classPK);
        if (article == null) {
            article = this._journalArticleLocalService.fetchLatestArticle(classPK);
        }
        if (article != null) {
            this.doReindex(article);
        }
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexArticles(companyId);
    }

    protected String extractDDMContent(JournalArticle article, String languageId) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(this._portal.getSiteGroupId(article.getGroupId()), this._portal.getClassNameId(JournalArticle.class), article.getDDMStructureKey(), true);
        if (ddmStructure == null) {
            return "";
        }
        DDMFormValues ddmFormValues = null;
        try {
            Fields fields = this._journalConverter.getDDMFields(ddmStructure, article.getDocument());
            ddmFormValues = this._fieldsToDDMFormValuesConverter.convert(ddmStructure, fields);
        }
        catch (Exception exception) {
            return "";
        }
        if (ddmFormValues == null) {
            return "";
        }
        return this._ddmIndexer.extractIndexableAttributes(ddmStructure, ddmFormValues, LocaleUtil.fromLanguageId((String)languageId));
    }

    protected JournalArticle fetchLatestIndexableArticleVersion(long resourcePrimKey) {
        JournalArticle latestIndexableArticle = this._journalArticleLocalService.fetchLatestArticle(resourcePrimKey, new int[]{0, 8});
        if (latestIndexableArticle == null) {
            latestIndexableArticle = this._journalArticleLocalService.fetchLatestArticle(resourcePrimKey);
        }
        return latestIndexableArticle;
    }

    protected Collection<Document> getArticleVersions(JournalArticle article) throws PortalException {
        ArrayList<Document> documents = new ArrayList<Document>();
        List<JournalArticle> articles = null;
        if (this.isIndexAllArticleVersions()) {
            articles = this._journalArticleLocalService.getArticlesByResourcePrimKey(article.getResourcePrimKey());
        } else {
            articles = new ArrayList();
            JournalArticle latestIndexableArticle = this.fetchLatestIndexableArticleVersion(article.getResourcePrimKey());
            if (latestIndexableArticle != null) {
                articles.add(latestIndexableArticle);
            }
        }
        for (JournalArticle curArticle : articles) {
            documents.add(this.getDocument(curArticle));
        }
        return documents;
    }

    protected String getDDMContentSummary(Document document, Locale snippetLocale, PortletRequest portletRequest, PortletResponse portletResponse) {
        String content;
        block7: {
            content = "";
            if (portletRequest == null || portletResponse == null) {
                return content;
            }
            try {
                JournalArticleDisplay articleDisplay = null;
                String description = document.get(snippetLocale, "snippet_description", "description");
                if (Validator.isBlank((String)description)) {
                    articleDisplay = this._createArticleDisplay(document, snippetLocale, portletRequest, portletResponse);
                    content = this._html.stripHtml(articleDisplay.getDescription());
                } else {
                    content = this._stripAndHighlight(description);
                }
                content = this._html.replaceNewLine(content);
                if (Validator.isBlank((String)content)) {
                    if (articleDisplay == null) {
                        articleDisplay = this._createArticleDisplay(document, snippetLocale, portletRequest, portletResponse);
                    }
                    content = this._html.extractText(articleDisplay.getContent());
                }
                String snippet = document.get(snippetLocale, "snippet_content");
                HashSet highlights = new HashSet();
                HighlightUtil.addSnippet((Document)document, highlights, (String)snippet, (String)"temp");
                content = HighlightUtil.highlight((String)content, (String[])ArrayUtil.toStringArray(highlights), (String)"<liferay-hl>", (String)"</liferay-hl>");
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        return content;
    }

    protected Localization getLocalization() {
        if (this._localization != null) {
            return this._localization;
        }
        return LocalizationUtil.getLocalization();
    }

    protected boolean isIndexAllArticleVersions() {
        JournalServiceConfiguration journalServiceConfiguration = null;
        try {
            journalServiceConfiguration = (JournalServiceConfiguration)this._configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return journalServiceConfiguration.indexAllArticleVersionsEnabled();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return false;
        }
    }

    protected void reindexArticles(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery;
        if (this.isIndexAllArticleVersions()) {
            indexableActionableDynamicQuery = this._journalArticleLocalService.getIndexableActionableDynamicQuery();
            indexableActionableDynamicQuery.setInterval(this._batchIndexingHelper.getBulkSize(JournalArticle.class.getName()));
            indexableActionableDynamicQuery.setPerformActionMethod(article -> {
                block2: {
                    try {
                        indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(article)});
                    }
                    catch (PortalException portalException) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index journal article " + article.getId()), (Throwable)portalException);
                    }
                }
            });
        } else {
            indexableActionableDynamicQuery = this._journalArticleResourceLocalService.getIndexableActionableDynamicQuery();
            indexableActionableDynamicQuery.setInterval(this._batchIndexingHelper.getBulkSize(JournalArticleResource.class.getName()));
            indexableActionableDynamicQuery.setPerformActionMethod(articleResource -> {
                block3: {
                    JournalArticle latestIndexableArticle = this.fetchLatestIndexableArticleVersion(articleResource.getResourcePrimKey());
                    if (latestIndexableArticle == null) {
                        return;
                    }
                    try {
                        indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(latestIndexableArticle)});
                    }
                    catch (PortalException portalException) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn((Object)("Unable to index journal article " + latestIndexableArticle.getId()), (Throwable)portalException);
                    }
                }
            });
        }
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    protected void reindexArticleVersions(JournalArticle article) throws PortalException {
        this._indexWriterHelper.updateDocuments(this.getSearchEngineId(), article.getCompanyId(), this.getArticleVersions(article), this.isCommitImmediately());
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    @Reference(unbind="-")
    protected void setDDMIndexer(DDMIndexer ddmIndexer) {
        this._ddmIndexer = ddmIndexer;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setFieldsToDDMFormValuesConverter(FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter) {
        this._fieldsToDDMFormValuesConverter = fieldsToDDMFormValuesConverter;
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleResourceLocalService(JournalArticleResourceLocalService journalArticleResourceLocalService) {
        this._journalArticleResourceLocalService = journalArticleResourceLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalContent(JournalContent journalContent) {
        this._journalContent = journalContent;
    }

    @Reference(unbind="-")
    protected void setJournalConverter(JournalConverter journalConverter) {
        this._journalConverter = journalConverter;
    }

    private JournalArticleDisplay _createArticleDisplay(Document document, Locale snippetLocale, PortletRequest portletRequest, PortletResponse portletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = GetterUtil.getLong((String)document.get("groupId"));
        String articleId = document.get("articleId");
        double version = GetterUtil.getDouble((String)document.get("version"));
        return this._journalContent.getDisplay(groupId, articleId, version, null, "view", LocaleUtil.toLanguageId((Locale)snippetLocale), 1, new PortletRequestModel(portletRequest, portletResponse), themeDisplay);
    }

    private String _stripAndHighlight(String text) {
        text = StringUtil.replace((String)text, (String[])_HIGHLIGHT_TAGS, (String[])_ESCAPE_SAFE_HIGHLIGHTS);
        text = this._html.stripHtml(text);
        text = StringUtil.replace((String)text, (String[])_ESCAPE_SAFE_HIGHLIGHTS, (String[])_HIGHLIGHT_TAGS);
        return text;
    }
}

