/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.transformer;

import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.BaseTransformerListener;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.journal.configuration.JournalServiceConfiguration"}, immediate=true, property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet"}, service={TransformerListener.class})
public class ContentTransformerListener
extends BaseTransformerListener {
    private static final Log _log = LogFactoryUtil.getLog(ContentTransformerListener.class);
    private volatile JournalServiceConfiguration _journalServiceConfiguration;

    public boolean isEnabled() {
        return this._journalServiceConfiguration.enableContentTransformerListener();
    }

    public String onScript(String script, Document document, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        return this.injectEditInPlace(script, document);
    }

    public Document onXml(Document document, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onXml");
        }
        this.replace(document, tokens);
        return document;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._journalServiceConfiguration = (JournalServiceConfiguration)ConfigurableUtil.createConfigurable(JournalServiceConfiguration.class, properties);
    }

    protected String getDynamicContent(Document document, String elementName) {
        String content = null;
        try {
            Element rootElement = document.getRootElement();
            for (Element element : rootElement.elements()) {
                String curElementName = element.attributeValue("name", "");
                if (!curElementName.equals(elementName)) continue;
                content = element.elementText("dynamic-content");
                break;
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return GetterUtil.getString(content);
    }

    protected String injectEditInPlace(String script, Document document) {
        block4: {
            if (!script.contains("$editInPlace(")) {
                return script;
            }
            try {
                List nodes = document.selectNodes("//dynamic-element");
                for (Node node : nodes) {
                    Element element = (Element)node;
                    String name = GetterUtil.getString((String)element.attributeValue("name"));
                    String type = GetterUtil.getString((String)element.attributeValue("type"));
                    if (name.startsWith("reserved-") || !type.equals("text") && !type.equals("text_area") && !type.equals("text_box")) continue;
                    script = this.wrapEditInPlaceField(script, name, type, "data");
                    script = this.wrapEditInPlaceField(script, name, type, "getData()");
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)exception.getMessage());
            }
        }
        return script;
    }

    protected void replace(Document document, Map<String, String> tokens) {
        block2: {
            try {
                Element rootElement = document.getRootElement();
                long articleGroupId = GetterUtil.getLong((String)tokens.get("article_group_id"));
                this.replace(rootElement, articleGroupId);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)exception.getMessage());
            }
        }
    }

    protected void replace(Element root, long articleGroupId) throws Exception {
        for (Element element : root.elements()) {
            List dynamicContentElements = element.elements("dynamic-content");
            for (Element dynamicContentElement : dynamicContentElements) {
                String text = dynamicContentElement.getText();
                text = HtmlUtil.stripComments((String)text);
                text = HtmlUtil.stripHtml((String)text);
                if (Validator.isNotNull((String)(text = text.trim())) && text.length() >= 7 && text.startsWith("[@") && text.endsWith("@]")) {
                    int pos = (text = text.substring(2, text.length() - 2)).indexOf(";");
                    if (pos == -1) continue;
                    String articleId = text.substring(0, pos);
                    String elementName = text.substring(pos + 1);
                    JournalArticle article = JournalArticleLocalServiceUtil.getArticle((long)articleGroupId, (String)articleId);
                    dynamicContentElement.clearContent();
                    dynamicContentElement.addCDATA(this.getDynamicContent(article.getDocument(), elementName));
                    continue;
                }
                if (text == null || !text.startsWith("/image/journal/article?img_id")) continue;
                dynamicContentElement.setText("@cdn_host@@root_path@" + text);
            }
            this.replace(element, articleGroupId);
        }
    }

    protected String replace(String xml, Map<String, String> tokens) {
        block2: {
            try {
                Document document = SAXReaderUtil.read((String)xml);
                this.replace(document, tokens);
                xml = XMLUtil.formatXML((Document)document);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)exception.getMessage());
            }
        }
        return xml;
    }

    protected String wrapEditInPlaceField(String script, String name, String type, String call) {
        String field = StringBundler.concat((String[])new String[]{"$", name, ".", call});
        String wrappedField = StringBundler.concat((String[])new String[]{"<span class=\"journal-content-eip-", type, "\" ", "id=\"journal-content-field-name-", name, "\">", field, "</span>"});
        return StringUtil.replace((String)script, (String)("$editInPlace(" + field + ")"), (String)wrappedField);
    }
}

