/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v3_0_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeJournalArticleImage
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeJournalArticleImage.class);
    private final ImageLocalService _imageLocalService;

    public UpgradeJournalArticleImage(ImageLocalService imageLocalService) {
        this._imageLocalService = imageLocalService;
    }

    protected void doUpgrade() throws Exception {
        if (!this.hasTable("JournalArticleImage")) {
            return;
        }
        try (LoggingTimer loggingTimer = new LoggingTimer();
             Statement statement = this.connection.createStatement();
             ResultSet rs1 = statement.executeQuery("select articleImageId from JournalArticleImage");){
            while (rs1.next()) {
                long articleImageId = rs1.getLong(1);
                this._imageLocalService.deleteImage(articleImageId);
            }
        }
        this.runSQL(this.connection, "drop table JournalArticleImage");
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Deleted table JournalArticleImage");
        }
    }
}

