/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.util;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.util.JournalDefaultTemplateProvider;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.template.TemplateVariableDefinition;
import com.liferay.portal.kernel.template.TemplateVariableGroup;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Collection;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={JournalDefaultTemplateProvider.class})
public class JournalDefaultTemplateProviderImpl
implements JournalDefaultTemplateProvider {
    public String getLanguage() {
        return "ftl";
    }

    public String getScript(long ddmStructureId) throws Exception {
        TemplateHandler templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((String)JournalArticle.class.getName());
        Map templateVariableGroups = templateHandler.getTemplateVariableGroups(ddmStructureId, this.getLanguage(), LocaleUtil.getMostRelevantLocale());
        TemplateVariableGroup templateVariableGroup = (TemplateVariableGroup)templateVariableGroups.get("fields");
        if (templateVariableGroup == null) {
            return "";
        }
        Collection templateVariableDefinitions = templateVariableGroup.getTemplateVariableDefinitions();
        StringBundler sb = new StringBundler(templateVariableDefinitions.size() * 5 + 2);
        sb.append("<dl>");
        for (TemplateVariableDefinition templateVariableDefinition : templateVariableDefinitions) {
            String code = templateVariableDefinition.generateCode(this.getLanguage())[0];
            sb.append("<dt class=\"text-capitalize\">");
            sb.append(templateVariableDefinition.getLabel());
            sb.append("</dt><dd>");
            sb.append(code);
            sb.append("</dd>");
        }
        sb.append("</dl>");
        return sb.toString();
    }

    public boolean isCacheable() {
        return true;
    }
}

