/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.trash;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.journal.internal.security.permission.JournalArticlePermission;
import com.liferay.journal.internal.security.permission.JournalFolderPermission;
import com.liferay.journal.internal.util.JournalHelperUtil;
import com.liferay.journal.internal.util.JournalUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.trash.JournalBaseTrashHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import java.util.List;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Reference;

@Deprecated
public class JournalArticleTrashHandler
extends JournalBaseTrashHandler {
    private DDMStructureLocalService _ddmStructureLocalService;
    private JournalArticleLocalService _journalArticleLocalService;
    private JournalArticleResourceLocalService _journalArticleResourceLocalService;
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference
    private Portal _portal;

    public void checkRestorableEntry(long classPK, long containerModelId, String newName) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        this.checkRestorableEntry(classPK, 0L, containerModelId, article.getArticleId(), newName);
    }

    public void checkRestorableEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException {
        this.checkRestorableEntry(trashEntry.getClassPK(), trashEntry.getEntryId(), containerModelId, trashEntry.getTypeSettingsProperty("title"), newName);
    }

    public void deleteTrashEntry(long classPK) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        this._journalArticleLocalService.deleteArticle(article.getGroupId(), article.getArticleId(), null);
    }

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public Filter getExcludeFilter(SearchContext searchContext) {
        BooleanFilter excludeBooleanFilter = new BooleanFilter();
        excludeBooleanFilter.addRequiredTerm("entryClassName", JournalArticle.class.getName());
        excludeBooleanFilter.addRequiredTerm("head", false);
        return excludeBooleanFilter;
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        long parentFolderId = article.getFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public ContainerModel getParentContainerModel(TrashedModel trashedModel) throws PortalException {
        JournalArticle article = (JournalArticle)trashedModel;
        return this.getContainerModel(article.getFolderId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        return JournalUtil.getJournalControlPanelLink(portletRequest, article.getFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        return JournalHelperUtil.getAbsolutePath(portletRequest, article.getFolderId());
    }

    public TrashEntry getTrashEntry(long classPK) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        return article.getTrashEntry();
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        return (TrashRenderer)assetRendererFactory.getAssetRenderer(article.getId());
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return JournalFolderPermission.contains(permissionChecker, groupId, classPK, "ADD_ARTICLE");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isInTrash(long classPK) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        return article.isInTrash();
    }

    public boolean isInTrashContainer(long classPK) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        return article.isInTrashContainer();
    }

    public boolean isMovable(long classPK) throws PortalException {
        JournalFolder parentFolder;
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        return article.getFolderId() > 0L && ((parentFolder = this._journalFolderLocalService.fetchFolder(article.getFolderId())) == null || parentFolder.isInTrash());
    }

    public boolean isRestorable(long classPK) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        if (article.getFolderId() > 0L && this._journalFolderLocalService.fetchFolder(article.getFolderId()) == null) {
            return false;
        }
        if (!this.hasTrashPermission(PermissionThreadLocal.getPermissionChecker(), article.getGroupId(), classPK, "RESTORE")) {
            return false;
        }
        return !article.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        this._journalArticleLocalService.moveArticle(article.getGroupId(), article.getArticleId(), containerModelId, serviceContext);
    }

    public void moveTrashEntry(long userId, long classPK, long containerId, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        this._journalArticleLocalService.moveArticleFromTrash(userId, article.getGroupId(), article, containerId, serviceContext);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        this._journalArticleLocalService.restoreArticleFromTrash(userId, article);
    }

    public void updateTitle(long classPK, String name) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        article.setArticleId(name);
        this._journalArticleLocalService.updateJournalArticle(article);
        JournalArticleResource articleResource = this._journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
        articleResource.setArticleId(name);
        this._journalArticleResourceLocalService.updateJournalArticleResource(articleResource);
    }

    protected void checkDuplicateEntry(long classPK, long trashEntryId, String originalTitle, String newName) throws PortalException {
        JournalArticleResource originalArticleResource;
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        JournalArticleResource journalArticleResource = article.getArticleResource();
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((originalArticleResource = this._journalArticleResourceLocalService.fetchArticleResource(article.getGroupId(), originalTitle)) != null && journalArticleResource.getPrimaryKey() != originalArticleResource.getPrimaryKey()) {
            RestoreEntryException restoreEntryException = new RestoreEntryException(1);
            JournalArticle duplicateArticle = this._journalArticleLocalService.getArticle(originalArticleResource.getGroupId(), originalTitle);
            restoreEntryException.setDuplicateEntryId(duplicateArticle.getResourcePrimKey());
            restoreEntryException.setOldName(duplicateArticle.getArticleId());
            restoreEntryException.setTrashEntryId(trashEntryId);
            throw restoreEntryException;
        }
    }

    protected void checkRestorableEntry(long classPK, long trashEntryId, long containerModelId, String originalTitle, String newName) throws PortalException {
        this.checkValidContainer(classPK, containerModelId);
        this.checkDuplicateEntry(classPK, trashEntryId, originalTitle, newName);
    }

    protected void checkValidContainer(long classPK, long containerModelId) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(this._portal.getSiteGroupId(article.getGroupId()), this._portal.getClassNameId(JournalArticle.class), article.getDDMStructureKey(), true);
        if (containerModelId == -1L) {
            containerModelId = article.getFolderId();
        }
        List folderDDMStructures = this._journalFolderLocalService.getDDMStructures(this._portal.getCurrentAndAncestorSiteGroupIds(article.getGroupId()), containerModelId, JournalHelperUtil.getRestrictionType(containerModelId));
        for (DDMStructure folderDDMStructure : folderDDMStructures) {
            if (folderDDMStructure.getStructureId() != ddmStructure.getStructureId()) continue;
            return;
        }
        throw new RestoreEntryException(2);
    }

    @Override
    protected long getGroupId(long classPK) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(classPK);
        return article.getGroupId();
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        return JournalArticlePermission.contains(permissionChecker, classPK, actionId);
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleResourceLocalService(JournalArticleResourceLocalService journalArticleResourceLocalService) {
        this._journalArticleResourceLocalService = journalArticleResourceLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalFolderLocalService(JournalFolderLocalService journalFolderLocalService) {
        this._journalFolderLocalService = journalFolderLocalService;
    }
}

