/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.asset.auto.tagger.text.extractor;

import com.liferay.asset.auto.tagger.text.extractor.TextExtractor;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.util.JournalConverter;
import com.liferay.portal.kernel.util.Portal;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TextExtractor.class})
public class JournalArticleTextExtractor
implements TextExtractor<JournalArticle> {
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private Portal _portal;

    public String extract(JournalArticle journalArticle, Locale locale) {
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(this._portal.getSiteGroupId(journalArticle.getGroupId()), this._portal.getClassNameId(JournalArticle.class), journalArticle.getDDMStructureKey(), true);
        if (ddmStructure == null) {
            return "";
        }
        DDMFormValues ddmFormValues = null;
        try {
            Fields fields = this._journalConverter.getDDMFields(ddmStructure, journalArticle.getDocument());
            ddmFormValues = this._fieldsToDDMFormValuesConverter.convert(ddmStructure, fields);
        }
        catch (Exception exception) {
            return "";
        }
        if (ddmFormValues == null) {
            return "";
        }
        return this._ddmIndexer.extractIndexableAttributes(ddmStructure, ddmFormValues, locale);
    }

    public String getClassName() {
        return JournalArticle.class.getName();
    }
}

