/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.asset.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalContentSearch;
import com.liferay.journal.service.JournalContentSearchLocalService;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.layout.util.LayoutClassedModelUsageRecorder;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={LayoutClassedModelUsageRecorder.class})
public class JournalArticleLayoutClassedModelUsageRecorder
implements LayoutClassedModelUsageRecorder {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private JournalContentSearchLocalService _journalContentSearchLocalService;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;

    public void record(long classNameId, long classPK) throws PortalException {
        if (this._layoutClassedModelUsageLocalService.hasDefaultLayoutClassedModelUsage(classNameId, classPK)) {
            return;
        }
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemObjectProvider.class, this._portal.getClassName(classNameId));
        JournalArticle article = (JournalArticle)infoItemObjectProvider.getInfoItem((InfoItemIdentifier)new ClassPKInfoItemIdentifier(classPK));
        AssetEntry assetEntry = this._getAssetEntry(article);
        this._recordJournalContentSearches(article, assetEntry);
        this._recordPortletPreferences(article, assetEntry, true);
        this._recordPortletPreferences(article, assetEntry, false);
        this._layoutClassedModelUsageLocalService.addDefaultLayoutClassedModelUsage(article.getGroupId(), classNameId, classPK, ServiceContextThreadLocal.getServiceContext());
    }

    private AssetEntry _getAssetEntry(JournalArticle journalArticle) throws PortalException {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)JournalArticle.class.getName());
        return assetRendererFactory.getAssetEntry(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
    }

    private void _recordJournalContentSearches(JournalArticle article, AssetEntry assetEntry) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        List contentSearches = this._journalContentSearchLocalService.getArticleContentSearches(article.getArticleId());
        for (JournalContentSearch contentSearch : contentSearches) {
            Layout layout = this._layoutLocalService.fetchLayout(contentSearch.getGroupId(), contentSearch.isPrivateLayout(), contentSearch.getLayoutId());
            LayoutClassedModelUsage layoutClassedModelUsage = this._layoutClassedModelUsageLocalService.fetchLayoutClassedModelUsage(assetEntry.getClassNameId(), article.getResourcePrimKey(), contentSearch.getPortletId(), this._portal.getClassNameId(Portlet.class), layout.getPlid());
            if (layoutClassedModelUsage != null) continue;
            this._layoutClassedModelUsageLocalService.addLayoutClassedModelUsage(contentSearch.getGroupId(), assetEntry.getClassNameId(), article.getResourcePrimKey(), contentSearch.getPortletId(), this._portal.getClassNameId(Portlet.class), layout.getPlid(), serviceContext);
        }
    }

    private void _recordPortletPreferences(JournalArticle article, AssetEntry assetEntry, boolean privateLayout) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(article.getCompanyId(), article.getGroupId(), 0L, 3, "com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet", privateLayout);
        for (com.liferay.portal.kernel.model.PortletPreferences portletPreferences : portletPreferencesList) {
            LayoutClassedModelUsage layoutClassedModelUsage;
            PortletPreferences jxPortletPreferences;
            String selectionStyle;
            String preferencesXML = portletPreferences.getPreferences();
            if (Validator.isNull((String)preferencesXML) || !StringUtil.equals((String)(selectionStyle = (jxPortletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)preferencesXML)).getValue("selectionStyle", "dynamic")), (String)"manual")) continue;
            String assetEntryXml = jxPortletPreferences.getValue("assetEntryXml", "");
            if (assetEntry == null || !assetEntryXml.contains(assetEntry.getClassUuid()) || (layoutClassedModelUsage = this._layoutClassedModelUsageLocalService.fetchLayoutClassedModelUsage(assetEntry.getClassNameId(), article.getResourcePrimKey(), portletPreferences.getPortletId(), this._portal.getClassNameId(Portlet.class), portletPreferences.getPlid())) != null) continue;
            this._layoutClassedModelUsageLocalService.addLayoutClassedModelUsage(article.getGroupId(), assetEntry.getClassNameId(), article.getResourcePrimKey(), portletPreferences.getPortletId(), this._portal.getClassNameId(Portlet.class), portletPreferences.getPlid(), serviceContext);
        }
    }
}

