/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.change.tracking.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.util.comparator.ArticleVersionComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConstraintResolver.class})
public class JournalArticleVersionConstraintResolver
implements ConstraintResolver<JournalArticle> {
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;

    public String getConflictDescriptionKey() {
        return "duplicate-article-version";
    }

    public Class<JournalArticle> getModelClass() {
        return JournalArticle.class;
    }

    public String getResolutionDescriptionKey() {
        return "the-article-version-was-updated-to-latest";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((Locale)locale, (String)"com.liferay.journal.lang");
    }

    public String[] getUniqueIndexColumnNames() {
        return new String[]{"groupId", "articleId", "version"};
    }

    public void resolveConflict(ConstraintResolverContext<JournalArticle> constraintResolverContext) throws PortalException {
        JournalArticle ctArticle = (JournalArticle)constraintResolverContext.getSourceCTModel();
        double latestVersion = (Double)constraintResolverContext.getInTarget(() -> {
            JournalArticle latestProductionArticle = this._journalArticleLocalService.getLatestArticle(ctArticle.getResourcePrimKey(), -1, false);
            return latestProductionArticle.getVersion();
        });
        List articles = this._journalArticleLocalService.getArticles(ctArticle.getGroupId(), ctArticle.getArticleId(), -1, -1, (OrderByComparator)new ArticleVersionComparator());
        for (JournalArticle article : articles) {
            if (article.getCtCollectionId() != ctArticle.getCtCollectionId()) continue;
            latestVersion = MathUtil.format((double)(latestVersion + 0.1), (int)1, (int)1);
            article.setVersion(latestVersion);
            this._journalArticleLocalService.updateJournalArticle(article);
        }
    }
}

