/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.content.processor;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesTransformer;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.internal.exportimport.content.processor.ImageExportDDMFormFieldValueTransformer;
import com.liferay.journal.internal.exportimport.content.processor.ImageImportDDMFormFieldValueTransformer;
import com.liferay.journal.internal.exportimport.content.processor.JournalArticleExportImportProcessorCache;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.util.JournalConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={ExportImportContentProcessor.class, JournalArticleExportImportContentProcessor.class})
public class JournalArticleExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleExportImportContentProcessor.class);
    private static final Pattern _htmlCommentRegexPattern = Pattern.compile("\\<!--([\\s\\S]*)--\\>");
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.storage.DDMFormValues)")
    private ExportImportContentProcessor<DDMFormValues> _ddmFormValuesExportImportContentProcessor;
    @Reference(target="(model.class.name=java.lang.String)")
    private ExportImportContentProcessor<String> _defaultTextExportImportContentProcessor;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleExportImportProcessorCache _journalArticleExportImportCache;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private JSONFactory _jsonFactory;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        JournalArticle article = (JournalArticle)stagedModel;
        DDMStructure ddmStructure = article.getDDMStructure();
        Fields fields = this._getDDMStructureFields(ddmStructure, content);
        if (fields == null) {
            return content;
        }
        StringBundler sb = new StringBundler(3);
        sb.append(stagedModel.getUuid());
        sb.append(exportReferencedContent);
        sb.append(escapeContent);
        String processedContent = this._journalArticleExportImportCache.get(sb.toString());
        String path = ExportImportPathUtil.getModelPath((StagedModel)stagedModel);
        if (Validator.isNotNull((String)processedContent) && portletDataContext.hasPrimaryKey(String.class, path)) {
            Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
            entityElement.addAttribute("cached", "true");
            return processedContent;
        }
        DDMFormValues ddmFormValues = this._journalConverter.getDDMFormValues(ddmStructure, fields);
        ddmFormValues = (DDMFormValues)this._ddmFormValuesExportImportContentProcessor.replaceExportContentReferences(portletDataContext, stagedModel, (Serializable)ddmFormValues, true, true);
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ImageExportDDMFormFieldValueTransformer imageExportDDMFormFieldValueTransformer = new ImageExportDDMFormFieldValueTransformer(this._dlAppService, exportReferencedContent, portletDataContext, stagedModel);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)imageExportDDMFormFieldValueTransformer);
        ddmFormValuesTransformer.transform();
        content = this.replaceExportJournalArticleReferences(portletDataContext, stagedModel, content, ddmStructure, fields, exportReferencedContent);
        content = (String)((Object)this._defaultTextExportImportContentProcessor.replaceExportContentReferences(portletDataContext, stagedModel, (Serializable)((Object)content), exportReferencedContent, escapeContent));
        this._journalArticleExportImportCache.put(sb.toString(), content);
        return content;
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        JournalArticle article = (JournalArticle)stagedModel;
        DDMStructure ddmStructure = this._fetchDDMStructure(portletDataContext, article);
        Fields fields = this._getDDMStructureFields(ddmStructure, content);
        if (fields == null) {
            return content;
        }
        Element entityElement = portletDataContext.getImportDataElement(stagedModel);
        if (GetterUtil.getBoolean((String)entityElement.attributeValue("cached"))) {
            portletDataContext.removePrimaryKey(ExportImportPathUtil.getModelPath((StagedModel)stagedModel));
            return content;
        }
        content = this.replaceImportJournalArticleReferences(ddmStructure, fields, portletDataContext, stagedModel);
        DDMFormValues ddmFormValues = this._journalConverter.getDDMFormValues(ddmStructure, fields);
        List<String> originalContents = this._fetchContentsFromDDMFormValues(ddmFormValues.getDDMFormFieldValues());
        ddmFormValues = (DDMFormValues)this._ddmFormValuesExportImportContentProcessor.replaceImportContentReferences(portletDataContext, stagedModel, (Serializable)ddmFormValues);
        List<String> modifiedContents = this._fetchContentsFromDDMFormValues(ddmFormValues.getDDMFormFieldValues());
        for (int i = 0; i < originalContents.size(); ++i) {
            content = StringUtil.replace((String)content, (String)originalContents.get(i), (String)modifiedContents.get(i));
        }
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ImageImportDDMFormFieldValueTransformer imageImportDDMFormFieldValueTransformer = new ImageImportDDMFormFieldValueTransformer(content, this._dlAppService, portletDataContext, stagedModel);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)imageImportDDMFormFieldValueTransformer);
        ddmFormValuesTransformer.transform();
        content = imageImportDDMFormFieldValueTransformer.getContent();
        return (String)((Object)this._defaultTextExportImportContentProcessor.replaceImportContentReferences(portletDataContext, stagedModel, (Serializable)((Object)content)));
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        content = this._excludeHTMLComments(content);
        this.validateJournalArticleReferences(content);
        try {
            this._defaultTextExportImportContentProcessor.validateContentReferences(groupId, (Serializable)((Object)content));
        }
        catch (NoSuchFileEntryException | ExportImportContentValidationException | NoSuchLayoutException exception) {
            if (ExportImportThreadLocal.isImportInProcess()) {
                if (_log.isDebugEnabled()) {
                    StringBundler sb = new StringBundler(8);
                    sb.append("An invalid ");
                    String type = "page";
                    if (exception instanceof NoSuchFileEntryException || exception.getCause() instanceof NoSuchFileEntryException) {
                        type = "file entry";
                    }
                    sb.append(type);
                    sb.append(" was detected during import when validating ");
                    sb.append("the content below. This is not an error; it ");
                    sb.append("typically means the ");
                    sb.append(type);
                    sb.append(" was deleted.\n");
                    sb.append(content);
                    _log.debug((Object)sb.toString());
                }
                return;
            }
            throw exception;
        }
    }

    protected String replaceExportJournalArticleReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, DDMStructure ddmStructure, Fields fields, boolean exportReferencedContent) throws Exception {
        Group group = this._groupLocalService.fetchGroup(portletDataContext.getGroupId());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isStaged() && !group.isStagedRemotely() && !group.isStagedPortlet("com_liferay_journal_web_portlet_JournalPortlet")) {
            return content;
        }
        for (Field field : fields) {
            if (!Objects.equals(field.getType(), "ddm-journal-article")) continue;
            for (Locale locale : field.getAvailableLocales()) {
                Serializable fieldValue = field.getValue(locale);
                Class<?> fieldValueClass = fieldValue.getClass();
                if (fieldValueClass.isArray()) {
                    ArrayList<String> articleList = new ArrayList<String>();
                    for (String jsonData : (String[])fieldValue) {
                        String journalArticleJsonString = this._extractJournalArticleForExport(jsonData, stagedModel, portletDataContext, exportReferencedContent);
                        if (!Validator.isNotNull((String)journalArticleJsonString)) continue;
                        articleList.add(journalArticleJsonString);
                    }
                    field.setValue(locale, (Serializable)articleList.toArray(new String[0]));
                    continue;
                }
                String journalArticleJsonString = this._extractJournalArticleForExport(String.valueOf(fieldValue), stagedModel, portletDataContext, exportReferencedContent);
                if (!Validator.isNotNull((String)journalArticleJsonString)) continue;
                field.setValue(locale, (Serializable)((Object)journalArticleJsonString));
            }
        }
        return this._journalConverter.getContent(ddmStructure, fields);
    }

    protected String replaceImportJournalArticleReferences(DDMStructure ddmStructure, Fields fields, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        for (Field field : fields) {
            if (!Objects.equals(field.getType(), "ddm-journal-article")) continue;
            for (Locale locale : field.getAvailableLocales()) {
                Serializable serializable = field.getValue(locale);
                Class<?> serializableClass = serializable.getClass();
                if (serializableClass.isArray()) {
                    ArrayList<String> articleList = new ArrayList<String>();
                    for (String jsonData : (String[])serializable) {
                        String journalArticleJsonString = this._extractJournalArticleForImport(jsonData, portletDataContext, stagedModel);
                        if (!Validator.isNotNull((String)journalArticleJsonString)) continue;
                        articleList.add(journalArticleJsonString);
                    }
                    field.setValue(locale, (Serializable)articleList.toArray(new String[0]));
                    continue;
                }
                String journalArticleJsonString = this._extractJournalArticleForImport(String.valueOf(serializable), portletDataContext, stagedModel);
                if (!Validator.isNotNull((String)journalArticleJsonString)) continue;
                field.setValue(locale, (Serializable)((Object)journalArticleJsonString));
            }
        }
        return this._journalConverter.getContent(ddmStructure, fields);
    }

    protected void validateJournalArticleReferences(String content) throws PortalException {
        NoSuchArticleException throwable;
        block9: {
            throwable = null;
            try {
                Document document = SAXReaderUtil.read((String)content);
                XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='ddm-journal-article']");
                List ddmJournalArticleNodes = xPath.selectNodes((Object)document);
                for (Node ddmJournalArticleNode : ddmJournalArticleNodes) {
                    Element ddmJournalArticleElement = (Element)ddmJournalArticleNode;
                    List dynamicContentElements = ddmJournalArticleElement.elements("dynamic-content");
                    for (Element dynamicContentElement : dynamicContentElements) {
                        String json = dynamicContentElement.getStringValue();
                        JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
                        long classPK = GetterUtil.getLong((Object)jsonObject.get("classPK"));
                        if (classPK <= 0L) {
                            if (!_log.isDebugEnabled()) continue;
                            _log.debug((Object)"No journal article reference is specified");
                            continue;
                        }
                        JournalArticle journalArticle = this._journalArticleLocalService.fetchLatestArticle(classPK);
                        if (journalArticle != null) continue;
                        if (ExportImportThreadLocal.isImportInProcess()) {
                            if (_log.isDebugEnabled()) {
                                StringBundler sb = new StringBundler(6);
                                sb.append("An invalid web content article was ");
                                sb.append("detected during import when ");
                                sb.append("validating the content below. This is ");
                                sb.append("not an error; it typically means the ");
                                sb.append("web content article was deleted.\n");
                                sb.append(content);
                                _log.debug((Object)sb.toString());
                            }
                            return;
                        }
                        NoSuchArticleException noSuchArticleException = new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No JournalArticle exists with the key ", "{resourcePrimKey=", classPK, "}"}));
                        if (throwable == null) {
                            throwable = noSuchArticleException;
                            continue;
                        }
                        throwable.addSuppressed(noSuchArticleException);
                    }
                }
            }
            catch (DocumentException documentException) {
                if (!_log.isDebugEnabled()) break block9;
                _log.debug((Object)("Invalid content:\n" + content));
            }
        }
        if (throwable != null) {
            ExportImportContentValidationException exportImportContentValidationException = new ExportImportContentValidationException(JournalArticleExportImportContentProcessor.class.getName(), throwable);
            exportImportContentValidationException.setType(6);
            throw exportImportContentValidationException;
        }
    }

    private String _excludeHTMLComments(String content) {
        Matcher matcher = _htmlCommentRegexPattern.matcher(content);
        while (matcher.find()) {
            content = matcher.replaceAll("");
            matcher = _htmlCommentRegexPattern.matcher(content);
        }
        return content;
    }

    private String _extractJournalArticleForExport(String jsonData, StagedModel stagedModel, PortletDataContext portletDataContext, boolean exportReferencedContent) {
        JSONObject jsonObject = null;
        try {
            jsonObject = this._jsonFactory.createJSONObject(jsonData);
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
            }
            return null;
        }
        long classPK = GetterUtil.getLong((Object)jsonObject.get("classPK"));
        JournalArticle journalArticle = this._journalArticleLocalService.fetchLatestArticle(classPK);
        if (journalArticle == null) {
            if (_log.isInfoEnabled()) {
                StringBundler messageSB = new StringBundler(6);
                String referencMissing = " references missing journal article with class primary key ";
                messageSB.append("Staged model with class name ");
                messageSB.append(stagedModel.getModelClassName());
                messageSB.append(" and primary key ");
                messageSB.append((Object)stagedModel.getPrimaryKeyObj());
                messageSB.append(referencMissing);
                messageSB.append(classPK);
                _log.info((Object)messageSB.toString());
            }
            return null;
        }
        JSONObject newArticleJSONObject = JSONUtil.put((String)"articlePrimaryKey", (Object)journalArticle.getPrimaryKey());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Replacing ", jsonData, " with ", newArticleJSONObject.toJSONString()}));
        }
        if (exportReferencedContent) {
            try {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)journalArticle, (String)"dependency");
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    StringBundler messageSB = new StringBundler(8);
                    messageSB.append("Staged model with class name ");
                    messageSB.append(stagedModel.getModelClassName());
                    messageSB.append(" and primary key ");
                    messageSB.append((Object)stagedModel.getPrimaryKeyObj());
                    messageSB.append(" references journal article with class primary key ");
                    messageSB.append(classPK);
                    messageSB.append(" that could not be exported due to ");
                    messageSB.append((Object)exception);
                    String errorMessage = messageSB.toString();
                    if (Validator.isNotNull((String)exception.getMessage())) {
                        errorMessage = StringBundler.concat((String[])new String[]{errorMessage, ": ", exception.getMessage()});
                    }
                    _log.debug((Object)errorMessage, (Throwable)exception);
                }
            }
        } else {
            Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
            portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)journalArticle, "dependency", true);
        }
        return newArticleJSONObject.toJSONString();
    }

    private String _extractJournalArticleForImport(String jsonData, PortletDataContext portletDataContext, StagedModel stagedModel) {
        JSONObject jsonObject = null;
        try {
            jsonObject = this._jsonFactory.createJSONObject(jsonData);
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
            }
            return null;
        }
        JournalArticle journalArticle = null;
        long articlePrimaryKey = GetterUtil.getLong((Object)portletDataContext.getNewPrimaryKey(JournalArticle.class + ".primaryKey", (Object)jsonObject.getLong("articlePrimaryKey")));
        if (articlePrimaryKey != 0L) {
            journalArticle = this._journalArticleLocalService.fetchJournalArticle(articlePrimaryKey);
        }
        if (journalArticle == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get journal article with primary key " + articlePrimaryKey));
            }
            portletDataContext.removePrimaryKey(ExportImportPathUtil.getModelPath((StagedModel)stagedModel));
            return null;
        }
        JSONObject newArticleJSONObject = JSONUtil.put((String)"className", (Object)JournalArticle.class.getName()).put("classPK", journalArticle.getResourcePrimKey()).put("title", journalArticle.getTitle(journalArticle.getDefaultLanguageId())).put("titleMap", (Object)journalArticle.getTitleMap());
        return newArticleJSONObject.toJSONString();
    }

    private List<String> _fetchContentsFromDDMFormValues(List<DDMFormFieldValue> ddmFormFieldValues) {
        return this._fetchContentsFromDDMFormValues(new ArrayList<String>(), ddmFormFieldValues);
    }

    private List<String> _fetchContentsFromDDMFormValues(List<String> contents, List<DDMFormFieldValue> ddmFormFieldValues) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            contents = this._fetchContentsFromDDMFormValues(contents, ddmFormFieldValue.getNestedDDMFormFieldValues());
            Value value = ddmFormFieldValue.getValue();
            if (value == null) {
                contents.add("");
                continue;
            }
            for (Locale locale : value.getAvailableLocales()) {
                contents.add(value.getString(locale));
            }
        }
        return contents;
    }

    private DDMStructure _fetchDDMStructure(PortletDataContext portletDataContext, JournalArticle article) {
        long formerGroupId = article.getGroupId();
        article.setGroupId(portletDataContext.getScopeGroupId());
        DDMStructure ddmStructure = article.getDDMStructure();
        article.setGroupId(formerGroupId);
        return ddmStructure;
    }

    private Fields _getDDMStructureFields(DDMStructure ddmStructure, String content) {
        if (ddmStructure == null || Validator.isNull((String)content)) {
            return null;
        }
        try {
            return this._journalConverter.getDDMFields(ddmStructure, content);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)exception, (Throwable)exception);
            }
            return null;
        }
    }
}

